/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.sim;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.sim.InterractiveSimulator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class Trace
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected final int HEIGHT = 40;
    private String name;
    private Element element;
    protected InterractiveSimulator.Traces parent;
    private LinkedList<Change> pendingChanges = new LinkedList();
    private LinkedList<Change> changes = new LinkedList();
    protected long now = 0L;
    private int scaleFactor = 1;
    protected int width;
    private int bits;
    private BitSet previousValue = null;
    private Trace me;
    protected int sliderPos = -1;
    private int base = 10;
    private BitSet off;
    private BitSet begin;

    public Trace(String name, Element el, int bits, int width, InterractiveSimulator.Traces parent) {
        this.name = name;
        this.element = el;
        this.bits = bits;
        this.parent = parent;
        this.setMaximumSize(new Dimension(width, 40));
        this.setPreferredSize(new Dimension(width, 40));
        this.setMinimumSize(new Dimension(width, 40));
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.me = this;
        this.off = new BitSet(bits + 1);
        this.off.set(bits);
        this.begin = new BitSet(bits + 1);
        this.begin.set(0, bits + 1);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Element getElement() {
        return this.element;
    }

    public void setScaleFactor(int factor) {
        this.scaleFactor = factor;
    }

    public void addValue(BitSet value, long when) {
        if (value == null) {
            value = this.off;
        }
        if (value.equals(this.previousValue)) {
            return;
        }
        Change ch = new Change();
        if (value == null) {
            ch.value = this.off;
            this.previousValue = this.off;
        } else {
            ch.value = (BitSet)value.clone();
            this.previousValue = (BitSet)value.clone();
        }
        ch.when = when;
        this.pendingChanges.add(0, ch);
        if (when != 0L && this.pendingChanges.size() > this.getWidth()) {
            this.pendingChanges.removeLast();
        }
    }

    public void commit(long time) {
        this.now = time;
        this.changes = new LinkedList<Change>(this.pendingChanges);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.width = this.getWidth() - this.parent.getNameSpace() - 10;
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int height = ascent + descent;
        int baseline = 20 - height / 2 + ascent;
        g.setColor(Color.black);
        g.drawString(this.name, this.width + 5, baseline);
        int top = 10;
        int bottom = 30;
        int middle = (top + bottom) / 2;
        double pos = this.width;
        long when = this.now;
        int ch = 0;
        g.setColor(Color.pink);
        g.drawLine(this.width, 0, this.width, 40);
        int t = 0;
        int m = 1;
        int inc = 0;
        while (t < 50) {
            inc = m * 50;
            t = inc / this.scaleFactor;
            if (t < 50) {
                inc = m * 100;
                t = inc / this.scaleFactor;
            }
            if (t < 50) {
                inc = m * 200;
                t = inc / this.scaleFactor;
            }
            if (t < 50) {
                inc = m * 250;
                t = inc / this.scaleFactor;
            }
            m *= 10;
        }
        double tpos = (long)this.width - this.now / (long)this.scaleFactor;
        int value = 0;
        while (tpos < (double)this.width) {
            g.setColor(Color.lightGray);
            g.drawLine((int)Math.rint(tpos), 0, (int)Math.rint(tpos), 40);
            if (this.changes.isEmpty()) {
                g.drawString(String.valueOf(value), (int)Math.rint(tpos) + 2, height);
            }
            tpos += 1.0 * (double)inc / (double)this.scaleFactor;
            value += inc;
        }
        g.setColor(Color.black);
        BitSet previousVal = null;
        while (pos > 0.0) {
            if (ch >= this.changes.size()) break;
            Change change = this.changes.get(ch);
            double len = (double)(when - change.when) / (double)this.scaleFactor;
            int rpos = (int)Math.round(pos);
            int rlen = (int)Math.round(len);
            if (this.bits > 1) {
                if (change.value.equals(this.off)) {
                    g.drawLine(rpos, middle, rpos - rlen, middle);
                } else {
                    g.drawLine(rpos, top, rpos - rlen, top);
                    g.drawLine(rpos, bottom, rpos - rlen, bottom);
                }
                if (!change.value.equals(previousVal)) {
                    int strlen;
                    String val = "";
                    if (!change.value.equals(this.off)) {
                        val = BitSetUtils.ToString(change.value, this.base);
                    }
                    if ((strlen = fm.stringWidth(val) + 2) <= rlen) {
                        g.drawString(val, rpos - rlen + (rlen - strlen) / 2 + 1, baseline);
                    }
                }
            } else if (change.value.equals(this.off)) {
                g.drawLine(rpos, middle, rpos - rlen, middle);
            } else if (change.value.get(0)) {
                g.drawLine(rpos, top, rpos - rlen, top);
            } else {
                g.drawLine(rpos, bottom, rpos - rlen, bottom);
            }
            if (!change.value.equals(previousVal) && previousVal != null) {
                if (this.bits > 1) {
                    g.drawLine(rpos, top, rpos, bottom);
                } else if (previousVal.equals(this.off)) {
                    if (change.value.length() == 0) {
                        g.drawLine(rpos, middle, rpos, bottom);
                    } else {
                        g.drawLine(rpos, middle, rpos, top);
                    }
                } else if (change.value.equals(this.off)) {
                    if (previousVal.length() == 0) {
                        g.drawLine(rpos, bottom, rpos, middle);
                    } else {
                        g.drawLine(rpos, top, rpos, middle);
                    }
                } else {
                    g.drawLine(rpos, top, rpos, bottom);
                }
            }
            previousVal = change.value;
            pos -= len;
            when = change.when;
            ++ch;
        }
        g.setColor(Color.gray);
        g.drawLine(this.sliderPos, 0, this.sliderPos, 40);
        long stime = this.now - (long)((this.width - this.sliderPos) * this.scaleFactor);
        if (stime >= 0L) {
            Change lastChange = null;
            Iterator rlen = this.changes.iterator();
            while (rlen.hasNext()) {
                Change chg;
                lastChange = chg = (Change)rlen.next();
                if (stime >= chg.when) break;
            }
            if (lastChange != null) {
                String val = "HiZ";
                if (!lastChange.value.equals(this.off)) {
                    val = BitSetUtils.ToString(lastChange.value, this.base);
                }
                int w = fm.stringWidth(val);
                g.setColor(Color.white);
                g.fillRect(this.sliderPos - w - 4, baseline - ascent, w + 3, height);
                g.setColor(Color.magenta);
                g.drawString(val, this.sliderPos - w - 1, baseline);
            }
        }
    }

    public void resize(int width) {
        this.setMaximumSize(new Dimension(width, 40));
        this.setPreferredSize(new Dimension(width, 40));
        this.setMinimumSize(new Dimension(width, 40));
        this.repaint();
    }

    public void mouseMoved(int x) {
        long time = this.now - (long)((this.width - x) * this.scaleFactor);
        this.sliderPos = time > this.now ? this.width : (time < 0L ? this.width - (int)(this.now / (long)this.scaleFactor) : x);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        if (x <= this.width) {
            return;
        }
        JPopupMenu ask = new JPopupMenu();
        final JMenuItem top = new JMenuItem("Move Trace To Top");
        ask.add(top);
        final JMenuItem up = new JMenuItem("Move Trace Up");
        ask.add(up);
        final JMenuItem down = new JMenuItem("Move Trace Down");
        ask.add(down);
        final JMenuItem bottom = new JMenuItem("Move Trace To Bottom");
        ask.add(bottom);
        ask.pack();
        ask.show(this, x, y);
        ActionListener list = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (event.getSource() == top) {
                    Trace.this.parent.move(Trace.this.me, -2);
                } else if (event.getSource() == up) {
                    Trace.this.parent.move(Trace.this.me, -1);
                } else if (event.getSource() == down) {
                    Trace.this.parent.move(Trace.this.me, 1);
                } else if (event.getSource() == bottom) {
                    Trace.this.parent.move(Trace.this.me, 2);
                }
            }
        };
        top.addActionListener(list);
        up.addActionListener(list);
        down.addActionListener(list);
        bottom.addActionListener(list);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.parent.mouseMoved(event);
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
    }

    public void setBase(int base) {
        this.base = base;
        this.repaint();
    }

    private class Change {
        public BitSet value;
        public long when;

        private Change() {
        }
    }
}

