/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.sim;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.sim.SimEvent;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;

public abstract class Simulator {
    protected PriorityQueue<SimEvent> eventQueue = new PriorityQueue();
    protected Set<SimEvent> dupCheck = new HashSet<SimEvent>();
    protected Circuit circuit = null;
    protected long now = 0L;
    protected long maxTime = 100000000L;
    protected boolean stopping = false;
    protected Simulator me = null;
    protected String testFileName = null;

    public void setCircuit(Circuit circ) {
        this.circuit = circ;
    }

    public void setTimeLimit(long limit) {
        this.maxTime = limit;
    }

    public void setTestFile(String name) {
        this.testFileName = name;
    }

    public void initInputs(Circuit circuit) {
        for (Element element : circuit.getElements()) {
            if (!(element instanceof LogicElement)) continue;
            LogicElement el = (LogicElement)element;
            el.initInputs();
        }
    }

    public void post(SimEvent event) {
        if (this.dupCheck.add(event)) {
            this.eventQueue.add(event);
        }
    }

    public abstract void stop();

    public abstract void pause(boolean var1);
}

