/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.sim;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.TextFilter;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.edit.Editor;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Memory;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.elem.TestGen;
import edu.mtu.cs.jls.elem.Text;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.sim.MemTrace;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import edu.mtu.cs.jls.sim.Trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;

public final class InterractiveSimulator
extends Simulator {
    private final int SWIDTH = 1000;
    private final int SHEIGHT = 70;
    private int stepAmount = 1;
    private long stepEnd = -1L;
    private boolean paused = false;
    private Semaphore pauseSem = new Semaphore(0);
    private Thread sim = null;
    private JPanel action = new JPanel(new FlowLayout(0));
    private JButton start = new JButton("  Start   ");
    private JButton step = new JButton("Step");
    private JButton animate = new JButton("Animate");
    private JButton end = new JButton("End");
    private JButton pause = new JButton("Pause");
    private JButton resume = new JButton("Resume");
    private JButton stop = new JButton("Stop");
    private JButton print = new JButton("Print");
    private JButton help = new JButton("Help");
    private JPanel window = new JPanel();
    private JLabel msg = new JLabel("");
    private JLabel showClock = new JLabel("Time: 0");
    private JTextField tlimit = new JTextField(String.valueOf(this.maxTime), 7);
    private JPanel statusBar = new JPanel(new BorderLayout());
    private JLabel statusMsg = new JLabel(" ");
    private JLabel statusClock = new JLabel();
    Timer timer;
    private Traces traces = new Traces();
    private Map<Element, Trace> traceMap = new HashMap<Element, Trace>();
    private Map<Wire, Trace> wireMap = new HashMap<Wire, Trace>();
    private int scaleFactor = 1;
    private Set<MemTrace> memTraces = new HashSet<MemTrace>();
    private Point windowLoc;
    private int displayBase = 10;

    public InterractiveSimulator() {
        this.me = this;
        if (JLSInfo.batch) {
            return;
        }
        this.window.setLayout(new BorderLayout());
        JPanel barInfo = new JPanel(new GridLayout(2, 1));
        JPanel toolBar = new JPanel(new BorderLayout());
        this.start.setBackground(Color.green);
        this.start.setToolTipText("simulate until done, paused or stopped");
        this.action.add(this.start);
        this.step.setBackground(Color.yellow);
        this.step.setToolTipText("run simulator for step amount of time");
        this.action.add(this.step);
        this.animate.setBackground(Color.cyan);
        this.animate.setToolTipText("repeat step every second");
        this.action.add(this.animate);
        this.end.setBackground(Color.pink);
        this.end.setToolTipText("terminate animation");
        this.pause.setBackground(Color.yellow);
        this.pause.setToolTipText("pause running simulation");
        this.resume.setBackground(Color.green);
        this.resume.setToolTipText("resume paused simulation");
        this.stop.setBackground(Color.red);
        this.stop.setToolTipText("stop running simulation");
        this.print.setBackground(Color.white);
        this.print.setToolTipText("print trace window");
        if (!JLSInfo.isApplet) {
            this.action.add(this.print);
        }
        if (JLSInfo.hb != null) {
            JLSInfo.hb.enableHelpOnButton(this.help, "inter.sim", null);
        } else {
            Util.noHelp(this.help);
        }
        this.action.add(this.help);
        toolBar.add((Component)this.action, "West");
        JPanel simParams = new JPanel(new FlowLayout());
        JLabel stepLabel = new JLabel("Step: ");
        simParams.add(stepLabel);
        final JTextField stepField = new JTextField("1", 6);
        AbstractDocument d = (AbstractDocument)stepField.getDocument();
        d.setDocumentFilter(new TextFilter(stepField));
        simParams.add(stepField);
        JLabel timeLimitLabel = new JLabel("Time Limit: ");
        simParams.add(timeLimitLabel);
        d = (AbstractDocument)this.tlimit.getDocument();
        TextFilter tlFilter = new TextFilter(this.tlimit);
        tlFilter.setMax(Integer.MAX_VALUE);
        d.setDocumentFilter(tlFilter);
        simParams.add(this.tlimit);
        toolBar.add((Component)simParams, "East");
        JLabel showTrace = new JLabel("<html>Drag divider up to see signal traces</html>", 0);
        toolBar.add((Component)showTrace, "Center");
        barInfo.add(toolBar);
        JPanel bottom = new JPanel(new BorderLayout());
        bottom.setBackground(Color.yellow);
        bottom.add((Component)this.msg, "West");
        bottom.add((Component)this.showClock, "East");
        barInfo.add(bottom);
        this.window.add((Component)barInfo, "North");
        JPanel params = new JPanel();
        params.setLayout(new BoxLayout(params, 1));
        JLabel sf = new JLabel("Scale Factor");
        sf.setAlignmentX(0.5f);
        params.add(sf);
        final JTextField scaleField = new JTextField("1", 10);
        d = (AbstractDocument)scaleField.getDocument();
        d.setDocumentFilter(new TextFilter(scaleField));
        scaleField.setMaximumSize(scaleField.getPreferredSize());
        params.add(scaleField);
        JButton getScale = new JButton("Apply");
        getScale.setAlignmentX(0.5f);
        params.add(getScale);
        getScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (scaleField.getText().length() == 0) {
                    InterractiveSimulator.this.scaleFactor = 1;
                } else {
                    InterractiveSimulator.this.scaleFactor = Math.max(1, Integer.parseInt(scaleField.getText()));
                }
                scaleField.setText(String.valueOf(InterractiveSimulator.this.scaleFactor));
                InterractiveSimulator.this.traces.setScaleFactor();
                if (InterractiveSimulator.this.now != 0L) {
                    InterractiveSimulator.this.traces.draw();
                }
            }
        });
        scaleField.addActionListener(getScale.getActionListeners()[0]);
        params.add(new JLabel(" "));
        JLabel baseLabel = new JLabel("Display Base");
        baseLabel.setAlignmentX(0.5f);
        params.add(baseLabel);
        JPanel baseButtons = new JPanel(new GridLayout(1, 3));
        final JButton b2 = new JButton("2");
        final JButton b10 = new JButton("10");
        final JButton b16 = new JButton("16");
        baseButtons.add(b2);
        baseButtons.add(b10);
        baseButtons.add(b16);
        b2.setBackground(Color.lightGray);
        b10.setBackground(Color.gray);
        b16.setBackground(Color.lightGray);
        ActionListener blist = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int newBase = 0;
                b2.setBackground(Color.lightGray);
                b10.setBackground(Color.lightGray);
                b16.setBackground(Color.lightGray);
                if (event.getSource() == b2) {
                    newBase = 2;
                    b2.setBackground(Color.GRAY);
                } else if (event.getSource() == b10) {
                    newBase = 10;
                    b10.setBackground(Color.GRAY);
                } else if (event.getSource() == b16) {
                    newBase = 16;
                    b16.setBackground(Color.GRAY);
                }
                InterractiveSimulator.this.displayBase = newBase;
                InterractiveSimulator.this.traces.setBase(newBase);
            }
        };
        b2.addActionListener(blist);
        b10.addActionListener(blist);
        b16.addActionListener(blist);
        baseButtons.setMaximumSize(new Dimension(1000, 25));
        params.add(baseButtons);
        this.window.add((Component)params, "East");
        JScrollPane spane = new JScrollPane(this.traces);
        this.window.add((Component)spane, "Center");
        this.window.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                InterractiveSimulator.this.window.doLayout();
                InterractiveSimulator.this.traces.resize(InterractiveSimulator.this.traces.getWidth());
                InterractiveSimulator.this.windowLoc = InterractiveSimulator.this.window.getLocationOnScreen();
                InterractiveSimulator.this.windowLoc.translate(0, InterractiveSimulator.this.window.getHeight());
            }

            @Override
            public void componentMoved(ComponentEvent event) {
                InterractiveSimulator.this.windowLoc = InterractiveSimulator.this.window.getLocationOnScreen();
                InterractiveSimulator.this.windowLoc.translate(0, InterractiveSimulator.this.window.getHeight());
            }
        });
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.pause);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.stop);
                InterractiveSimulator.this.action.validate();
                if (scaleField.getText().length() == 0) {
                    InterractiveSimulator.this.scaleFactor = 1;
                } else {
                    InterractiveSimulator.this.scaleFactor = Math.max(1, Integer.parseInt(scaleField.getText()));
                }
                scaleField.setText(String.valueOf(InterractiveSimulator.this.scaleFactor));
                InterractiveSimulator.this.traces.setScaleFactor();
                InterractiveSimulator.this.setMaxTime();
                InterractiveSimulator.this.runSim();
            }
        });
        this.step.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.resume);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.step);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.animate);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.stop);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.print);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.help);
                InterractiveSimulator.this.action.validate();
                if (scaleField.getText().length() == 0) {
                    InterractiveSimulator.this.scaleFactor = 1;
                } else {
                    InterractiveSimulator.this.scaleFactor = Math.max(1, Integer.parseInt(scaleField.getText()));
                }
                scaleField.setText(String.valueOf(InterractiveSimulator.this.scaleFactor));
                InterractiveSimulator.this.traces.setScaleFactor();
                if (stepField.getText().length() == 0) {
                    InterractiveSimulator.this.stepAmount = 1;
                } else {
                    InterractiveSimulator.this.stepAmount = Math.max(1, Integer.parseInt(stepField.getText()));
                }
                stepField.setText(String.valueOf(InterractiveSimulator.this.stepAmount));
                InterractiveSimulator.this.setMaxTime();
                if (InterractiveSimulator.this.sim == null) {
                    InterractiveSimulator.this.stepEnd = InterractiveSimulator.this.stepAmount;
                    InterractiveSimulator.this.runSim();
                } else {
                    if (!InterractiveSimulator.this.paused) {
                        return;
                    }
                    InterractiveSimulator.this.paused = false;
                    InterractiveSimulator.this.pauseSem.release();
                    if (InterractiveSimulator.this.stepEnd < 0L) {
                        InterractiveSimulator.this.stepEnd = InterractiveSimulator.this.stepAmount;
                    } else {
                        InterractiveSimulator interractiveSimulator = InterractiveSimulator.this;
                        interractiveSimulator.stepEnd = interractiveSimulator.stepEnd + (long)InterractiveSimulator.this.stepAmount;
                    }
                }
            }
        });
        this.animate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.end);
                InterractiveSimulator.this.action.validate();
                if (scaleField.getText().length() == 0) {
                    InterractiveSimulator.this.scaleFactor = 1;
                } else {
                    InterractiveSimulator.this.scaleFactor = Math.max(1, Integer.parseInt(scaleField.getText()));
                }
                scaleField.setText(String.valueOf(InterractiveSimulator.this.scaleFactor));
                InterractiveSimulator.this.traces.setScaleFactor();
                if (stepField.getText().length() == 0) {
                    InterractiveSimulator.this.stepAmount = 1;
                } else {
                    InterractiveSimulator.this.stepAmount = Math.max(1, Integer.parseInt(stepField.getText()));
                }
                stepField.setText(String.valueOf(InterractiveSimulator.this.stepAmount));
                InterractiveSimulator.this.setMaxTime();
                TimerTask tc = new TimerTask(){

                    @Override
                    public void run() {
                        if ((this).InterractiveSimulator.this.now >= (this).InterractiveSimulator.this.maxTime) {
                            (this).InterractiveSimulator.this.timer.cancel();
                        }
                        if (InterractiveSimulator.this.sim == null) {
                            InterractiveSimulator.this.stepEnd = InterractiveSimulator.this.stepAmount;
                            InterractiveSimulator.this.runSim();
                        } else {
                            if (!InterractiveSimulator.this.paused) {
                                return;
                            }
                            InterractiveSimulator.this.paused = false;
                            InterractiveSimulator.this.pauseSem.release();
                            if (InterractiveSimulator.this.stepEnd < 0L) {
                                InterractiveSimulator.this.stepEnd = InterractiveSimulator.this.stepAmount;
                            } else {
                                InterractiveSimulator interractiveSimulator = InterractiveSimulator.this;
                                interractiveSimulator.stepEnd = interractiveSimulator.stepEnd + (long)InterractiveSimulator.this.stepAmount;
                            }
                        }
                    }
                };
                InterractiveSimulator.this.timer = new Timer();
                InterractiveSimulator.this.timer.scheduleAtFixedRate(tc, 0L, 1000L);
            }
        });
        this.end.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.animate);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.resume);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.stop);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.print);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.help);
                InterractiveSimulator.this.action.validate();
                if (InterractiveSimulator.this.timer != null) {
                    InterractiveSimulator.this.timer.cancel();
                    InterractiveSimulator.this.timer = null;
                }
                InterractiveSimulator.this.step.doClick();
            }
        });
        this.pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.resume);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.animate);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.stop);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.print);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.help);
                InterractiveSimulator.this.action.validate();
                InterractiveSimulator.this.paused = true;
                InterractiveSimulator.this.stepEnd = -1L;
            }
        });
        this.resume.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.pause);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.stop);
                InterractiveSimulator.this.action.validate();
                if (scaleField.getText().length() == 0) {
                    InterractiveSimulator.this.scaleFactor = 1;
                } else {
                    InterractiveSimulator.this.scaleFactor = Math.max(1, Integer.parseInt(scaleField.getText()));
                }
                scaleField.setText(String.valueOf(InterractiveSimulator.this.scaleFactor));
                InterractiveSimulator.this.traces.setScaleFactor();
                InterractiveSimulator.this.paused = false;
                InterractiveSimulator.this.stepEnd = -1L;
                InterractiveSimulator.this.pauseSem.release();
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.stop();
            }
        });
        this.print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InterractiveSimulator.this.printTraces();
            }
        });
        this.window.setMinimumSize(new Dimension(1000, 70));
    }

    public JPanel getWindow() {
        return this.window;
    }

    public void setMaxTime() {
        this.maxTime = this.tlimit.getText().length() == 0 ? 1L : (long)Math.max(1, Integer.parseInt(this.tlimit.getText()));
        this.tlimit.setText(String.valueOf(this.maxTime));
    }

    @Override
    public void post(SimEvent event) {
        if (this.dupCheck.add(event)) {
            this.eventQueue.add(event);
        }
    }

    public void runSim() {
        if (this.circuit == null) {
            return;
        }
        if (this.sim != null) {
            return;
        }
        this.now = 0L;
        this.stopping = false;
        this.paused = false;
        this.eventQueue.clear();
        this.dupCheck.clear();
        TestGen gen = null;
        if (this.testFileName != null) {
            gen = new TestGen(this.circuit);
            gen.setFile(this.testFileName);
        }
        this.initInputs(this.circuit);
        for (Element el : this.circuit.getElements()) {
            if (!(el instanceof LogicElement)) continue;
            LogicElement lel = (LogicElement)el;
            lel.initSim(this.me);
        }
        if (gen != null) {
            gen.initSim(this.me);
        }
        if (!JLSInfo.batch) {
            this.traces.clear();
            this.traceMap.clear();
            this.wireMap.clear();
            for (MemTrace mtr : this.memTraces) {
                mtr.dispose();
            }
            this.memTraces.clear();
            this.findTraces(this.circuit);
            this.traces.setup();
            this.traces.draw();
        }
        this.sim = new Thread("Runner"){

            @Override
            public void run() {
                Editor ed = InterractiveSimulator.this.circuit.getEditor();
                if (ed != null) {
                    ed.enableEditor(false);
                }
                while (!InterractiveSimulator.this.stopping && !InterractiveSimulator.this.eventQueue.isEmpty() && InterractiveSimulator.this.now <= InterractiveSimulator.this.maxTime) {
                    if (InterractiveSimulator.this.paused) {
                        InterractiveSimulator.this.stepEnd = InterractiveSimulator.this.now;
                        InterractiveSimulator.this.traces.draw();
                        for (MemTrace mtr : InterractiveSimulator.this.memTraces) {
                            mtr.update();
                        }
                        InterractiveSimulator.this.msg.setText("Simulation Paused");
                        if (ed != null) {
                            ed.enableEditor(true);
                        }
                        try {
                            InterractiveSimulator.this.pauseSem.acquire();
                        }
                        catch (InterruptedException mtr) {
                            // empty catch block
                        }
                        if (ed == null) continue;
                        ed.enableEditor(false);
                        continue;
                    }
                    SimEvent event = (SimEvent)InterractiveSimulator.this.eventQueue.peek();
                    long when = event.getTime();
                    if (InterractiveSimulator.this.stepEnd != -1L && when > InterractiveSimulator.this.stepEnd) {
                        InterractiveSimulator.this.now = InterractiveSimulator.this.stepEnd;
                        InterractiveSimulator.this.showClock.setText("Time: " + InterractiveSimulator.this.now);
                        InterractiveSimulator.this.traces.draw();
                        for (MemTrace mtr : InterractiveSimulator.this.memTraces) {
                            mtr.update();
                        }
                        if (ed != null) {
                            ed.repaint();
                        }
                        InterractiveSimulator.this.paused = true;
                        continue;
                    }
                    if (!JLSInfo.batch) {
                        InterractiveSimulator.this.msg.setText("Simulation Running");
                    }
                    event = (SimEvent)InterractiveSimulator.this.eventQueue.poll();
                    InterractiveSimulator.this.dupCheck.remove(event);
                    InterractiveSimulator.this.now = event.getTime();
                    if (InterractiveSimulator.this.now > InterractiveSimulator.this.maxTime) {
                        InterractiveSimulator.this.now = InterractiveSimulator.this.maxTime;
                        break;
                    }
                    if (!JLSInfo.batch) {
                        InterractiveSimulator.this.showClock.setText("Time: " + InterractiveSimulator.this.now);
                        InterractiveSimulator.this.window.validate();
                    }
                    event.getCallBack().react(InterractiveSimulator.this.now, InterractiveSimulator.this.me, event.getTodo());
                    if (!JLSInfo.batch) {
                        LogicElement el = (LogicElement)event.getCallBack();
                        Trace tr = (Trace)InterractiveSimulator.this.traceMap.get(el);
                        if (tr != null) {
                            tr.addValue(el.getCurrentValue(), InterractiveSimulator.this.now);
                        }
                        for (Wire wire : InterractiveSimulator.this.wireMap.keySet()) {
                            tr = (Trace)InterractiveSimulator.this.wireMap.get(wire);
                            tr.addValue(wire.getValue(), InterractiveSimulator.this.now);
                        }
                    }
                    InterractiveSimulator.this.updateStatusBar();
                }
                if (InterractiveSimulator.this.timer != null) {
                    InterractiveSimulator.this.timer.cancel();
                }
                if (!JLSInfo.batch) {
                    InterractiveSimulator.this.showClock.setText("Time: " + InterractiveSimulator.this.now);
                    InterractiveSimulator.this.window.validate();
                }
                InterractiveSimulator.this.now += (long)(10 * InterractiveSimulator.this.scaleFactor);
                if (ed != null) {
                    ed.enableEditor(true);
                }
                if (!JLSInfo.batch) {
                    InterractiveSimulator.this.traces.draw();
                    for (MemTrace mtr : InterractiveSimulator.this.memTraces) {
                        mtr.update();
                    }
                }
                if (ed != null) {
                    ed.repaint();
                }
                String reason = InterractiveSimulator.this.stopping ? "Simulation Stopped" : (InterractiveSimulator.this.now >= InterractiveSimulator.this.maxTime ? "Simulation Time Limit" : (InterractiveSimulator.this.eventQueue.size() == 0 ? "Simulation: No More Activity" : "Simulation Complete"));
                InterractiveSimulator.this.stopping = true;
                if (JLSInfo.batch && JLSInfo.frame == null && !JLSInfo.isApplet) {
                    System.out.println(String.valueOf(reason) + " at " + InterractiveSimulator.this.now);
                } else {
                    InterractiveSimulator.this.msg.setText(reason);
                }
                InterractiveSimulator.this.updateStatusBar();
                InterractiveSimulator.this.action.removeAll();
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.start);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.step);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.animate);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.print);
                InterractiveSimulator.this.action.add(InterractiveSimulator.this.help);
                InterractiveSimulator.this.action.validate();
                InterractiveSimulator.this.sim = null;
            }
        };
        if (!JLSInfo.batch || JLSInfo.frame != null || JLSInfo.isApplet) {
            this.msg.setText("Simulation Running");
        }
        this.sim.start();
        if (JLSInfo.batch && JLSInfo.frame == null && !JLSInfo.isApplet) {
            try {
                this.sim.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void pause(boolean which) {
        if (this.sim != null) {
            this.action.removeAll();
            this.action.add(this.resume);
            this.action.add(this.step);
            this.action.add(this.animate);
            this.action.add(this.stop);
            this.action.add(this.print);
            this.action.add(this.help);
            this.action.validate();
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.paused = which;
            this.stepEnd = -1L;
        }
    }

    @Override
    public void stop() {
        if (this.sim != null) {
            this.stopping = true;
            this.stepEnd = -1L;
            this.pauseSem.release();
        }
    }

    private void findTraces(Circuit circ) {
        Point wLoc = new Point(this.windowLoc);
        for (Element element : circ.getElements()) {
            Circuit c;
            SubCircuit sub;
            if (element instanceof Wire) {
                Wire wire = (Wire)element;
                if (!wire.hasProbe()) continue;
                String name = String.valueOf(wire.getEnd().getFullName()) + wire.getProbe();
                Trace tr = new Trace(name, element, wire.getBits(), this.traces.getWidth(), this.traces);
                tr.setBase(this.displayBase);
                this.traces.addTrace(tr);
                tr.addValue(wire.getValue(), this.now);
                this.wireMap.put(wire, tr);
                continue;
            }
            if (element instanceof SubCircuit) {
                sub = (SubCircuit)element;
                c = sub.getSubCircuit();
                this.findTraces(c);
                continue;
            }
            if (element instanceof LogicElement) {
                LogicElement el = (LogicElement)element;
                if (el.isWatched()) {
                    Trace tr = new Trace(el.getFullName(), el, el.getBits(), this.traces.getWidth(), this.traces);
                    tr.setBase(this.displayBase);
                    this.traces.addTrace(tr);
                    tr.addValue(el.getCurrentValue(), this.now);
                    this.traceMap.put(el, tr);
                    if (!(el instanceof Memory)) continue;
                    Memory mem = (Memory)el;
                    MemTrace mtr = new MemTrace(mem);
                    Point loc = new Point(wLoc);
                    loc.translate(0, -mtr.getHeight());
                    mtr.showit(loc);
                    this.memTraces.add(mtr);
                    wLoc.translate(mtr.getWidth(), 0);
                    continue;
                }
                el.setTracePosition(-1);
                continue;
            }
            if (!(element instanceof SubCircuit)) continue;
            sub = (SubCircuit)element;
            c = sub.getSubCircuit();
            this.findTraces(c);
        }
    }

    public JPanel getStatusBar() {
        this.statusBar.add((Component)this.statusMsg, "West");
        this.statusBar.add((Component)this.statusClock, "East");
        this.statusBar.setBackground(Color.yellow);
        return this.statusBar;
    }

    private void updateStatusBar() {
        if (JLSInfo.batch && JLSInfo.frame == null && !JLSInfo.isApplet) {
            return;
        }
        this.statusMsg.setText(this.msg.getText());
        this.statusClock.setText(this.showClock.getText());
    }

    private void printTraces() {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.defaultPage();
        format.setOrientation(0);
        Book book = new Book();
        Printable pr = new Printable(){

            @Override
            public int print(Graphics g, PageFormat format, int pagenum) {
                if (pagenum > 0) {
                    return 1;
                }
                Graphics2D gg = (Graphics2D)g;
                gg.translate(format.getImageableX(), format.getImageableY());
                double width = format.getImageableWidth();
                double height = format.getImageableHeight();
                Dimension d = InterractiveSimulator.this.traces.getSize();
                double scale = 1.0;
                if ((double)d.width > width) {
                    scale = 1.0 * width / (double)d.width;
                }
                if ((double)d.height > height) {
                    scale = Math.min(scale, 1.0 * height / (double)d.height);
                }
                gg.scale(scale, scale);
                InterractiveSimulator.this.traces.paint(gg);
                return 0;
            }
        };
        book.append(pr, format);
        job.setPageable(book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                System.out.println("printing error: " + ex.getMessage());
            }
        }
    }

    private class Header
    extends Trace {
        public Header(int width, Element el, Traces parent) {
            super("", el, 0, width, parent);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int width = this.getWidth() - this.parent.getNameSpace() - 10;
            long time = this.now - (long)((width - this.sliderPos) * InterractiveSimulator.this.scaleFactor);
            if (time >= 0L && time <= this.now) {
                g.setColor(Color.gray);
                g.drawString(String.valueOf(time), this.sliderPos, 26);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
        }
    }

    public class Traces
    extends JPanel
    implements MouseMotionListener {
        private List<Trace> traceList = new LinkedList<Trace>();
        private List<Trace> newList = new LinkedList<Trace>();
        private int nameSpace;

        public Traces() {
            this.setLayout(new BoxLayout(this, 1));
            this.addMouseMotionListener(this);
        }

        public void clear() {
            this.removeAll();
            this.nameSpace = 0;
            this.newList.clear();
            Text t = new Text(null);
            t.setTracePosition(0);
            Header head = new Header(this.getWidth(), t, this);
            this.addTrace(head);
        }

        public void addTrace(Trace tr) {
            this.newList.add(tr);
        }

        public void setup() {
            TreeMap<Integer, Trace> map = new TreeMap<Integer, Trace>();
            LinkedList<Trace> posList = new LinkedList<Trace>();
            for (Trace tr : this.newList) {
                if (tr.getElement().getTracePosition() == -1) continue;
                map.put(tr.getElement().getTracePosition(), tr);
            }
            Iterator<Trace> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                int t = (Integer)((Object)iterator.next());
                Trace tr = (Trace)map.get(t);
                posList.add(tr);
            }
            for (Trace tr : this.newList) {
                if (tr.getElement().getTracePosition() != -1) continue;
                posList.add(tr);
            }
            int pos = 0;
            this.traceList.clear();
            this.removeAll();
            for (Trace tr : posList) {
                this.traceList.add(tr);
                this.add(tr);
                FontMetrics fm = tr.getGraphics().getFontMetrics();
                int nameLength = fm.stringWidth(tr.getName());
                if (nameLength > this.nameSpace) {
                    this.nameSpace = nameLength;
                }
                tr.setScaleFactor(InterractiveSimulator.this.scaleFactor);
                tr.getElement().setTracePosition(pos);
                ++pos;
            }
            this.validate();
        }

        public int getNameSpace() {
            return this.nameSpace;
        }

        private void draw() {
            this.repaint();
            for (Trace tr : this.traceList) {
                tr.commit(InterractiveSimulator.this.now);
                tr.repaint();
            }
        }

        private void setScaleFactor() {
            for (Trace tr : this.traceList) {
                tr.setScaleFactor(InterractiveSimulator.this.scaleFactor);
            }
        }

        private void setBase(int base) {
            for (Trace tr : this.traceList) {
                tr.setBase(base);
            }
        }

        private void resize(int width) {
            for (Trace tr : this.traceList) {
                tr.resize(width);
            }
        }

        public void move(Trace trace, int dir) {
            int pos = this.traceList.indexOf(trace);
            if (dir == -2) {
                this.traceList.remove(pos);
                this.traceList.add(1, trace);
            } else if (dir == 2) {
                this.traceList.remove(pos);
                this.traceList.add(trace);
            } else {
                if (pos + dir < 1 || pos + dir >= this.traceList.size()) {
                    return;
                }
                this.traceList.remove(pos);
                this.traceList.add(pos + dir, trace);
            }
            this.removeAll();
            pos = 0;
            for (Trace tr : this.traceList) {
                this.add(tr);
                tr.getElement().setTracePosition(pos);
                ++pos;
            }
            this.validate();
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!InterractiveSimulator.this.paused && !InterractiveSimulator.this.stopping) {
                return;
            }
            int x = event.getX();
            for (Trace tr : this.traceList) {
                tr.mouseMoved(x);
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
        }
    }
}

