/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.sim;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.SigGen;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.elem.TestGen;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.print.PrintService;

public class BatchSimulator
extends Simulator {
    private Map<LogicElement, LinkedList<TrEvent>> eventTrace = new HashMap<LogicElement, LinkedList<TrEvent>>();

    public BatchSimulator() {
        this.me = this;
    }

    @Override
    public void stop() {
        this.stopping = true;
    }

    @Override
    public void pause(boolean which) {
        this.stopping = true;
    }

    public void runSim() {
        this.stopping = false;
        this.now = 0L;
        this.eventQueue.clear();
        this.dupCheck.clear();
        this.initInputs(this.circuit);
        for (Element el : this.circuit.getElements()) {
            if (!(el instanceof LogicElement)) continue;
            LogicElement lel = (LogicElement)el;
            lel.initSim(this.me);
        }
        this.findWatched(this.circuit);
        while (!this.stopping && !this.eventQueue.isEmpty() && this.now <= this.maxTime) {
            LogicElement el;
            SimEvent event = (SimEvent)this.eventQueue.poll();
            this.dupCheck.remove(event);
            this.now = event.getTime();
            if (this.now > this.maxTime) {
                this.now = this.maxTime;
                break;
            }
            event.getCallBack().react(this.now, this.me, event.getTodo());
            if (!JLSInfo.printTrace || !(el = (LogicElement)event.getCallBack()).isWatched()) continue;
            LinkedList<TrEvent> events = this.eventTrace.get(el);
            BitSet off = new BitSet(el.getBits() + 1);
            off.set(el.getBits());
            TrEvent prev = events.getLast();
            if (prev.value.equals(el.getCurrentValue())) continue;
            TrEvent p = new TrEvent();
            p.time = event.getTime();
            p.value = el.getCurrentValue();
            if (p.value == null) {
                p.value = off;
            }
            events.add(p);
        }
    }

    public void addTestGen() {
        if (this.testFileName != null) {
            TestGen gen = new TestGen(this.circuit);
            this.circuit.addElement(gen);
            gen.setFile(this.testFileName);
            HashSet<Element> gens = new HashSet<Element>();
            for (Element el : this.circuit.getElements()) {
                if (!(el instanceof SigGen)) continue;
                gens.add(el);
            }
            for (Element el : gens) {
                this.circuit.remove(el);
            }
        }
    }

    private void findWatched(Circuit circ) {
        for (Element el : circ.getElements()) {
            if (el instanceof SubCircuit) {
                SubCircuit sub = (SubCircuit)el;
                this.findWatched(sub.getSubCircuit());
                continue;
            }
            if (!el.isWatched()) continue;
            LogicElement lel = (LogicElement)el;
            LinkedList<TrEvent> events = new LinkedList<TrEvent>();
            TrEvent event = new TrEvent();
            event.time = 0L;
            event.value = lel.getCurrentValue();
            if (event.value == null) {
                event.value = new BitSet(lel.getBits() + 1);
                event.value.set(lel.getBits());
            }
            events.add(event);
            this.eventTrace.put(lel, events);
        }
    }

    public void printTrace(String printer) {
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintService[] services = PrinterJob.lookupPrintServices();
        PrintService want = null;
        if (printer == null) {
            System.out.println("no printer specified, use -p");
            return;
        }
        PrintService[] printServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService s = printServiceArray[n2];
            if (s.getName().equals(printer)) {
                want = s;
            }
            ++n2;
        }
        if (want == null) {
            System.out.println(String.valueOf(printer) + " is an invalid printer");
            System.exit(1);
        }
        try {
            job.setPrintService(want);
        }
        catch (PrinterException ex) {
            System.out.println(String.valueOf(printer) + " is an invalid printer");
        }
        PageFormat format = job.defaultPage();
        format.setOrientation(0);
        Printable pr = new Printable(){

            @Override
            public int print(Graphics g, PageFormat format, int pagenum) {
                int HEIGHT = 40;
                if (pagenum > 0) {
                    return 1;
                }
                Graphics2D gg = (Graphics2D)g;
                gg.translate(format.getImageableX(), format.getImageableY());
                double pageWidth = format.getImageableWidth();
                double pageHeight = format.getImageableHeight();
                FontMetrics fm = gg.getFontMetrics();
                int ascent = fm.getAscent();
                int descent = fm.getDescent();
                int width = 0;
                int height = 0;
                long maxTime = 0L;
                TreeMap<String, LogicElement> map = new TreeMap<String, LogicElement>();
                for (LogicElement el : BatchSimulator.this.eventTrace.keySet()) {
                    String name = " " + el.getFullName();
                    width = Math.max(width, fm.stringWidth(name));
                    height += HEIGHT;
                    map.put(name, el);
                    maxTime = Math.max(maxTime, ((TrEvent)((LinkedList)((BatchSimulator)BatchSimulator.this).eventTrace.get((Object)el)).getLast()).time);
                }
                width += 1000;
                height += HEIGHT;
                double timeScaleFactor = 1000.0 / (double)(maxTime + 10L);
                double scale = 1.0;
                if ((double)width > pageWidth) {
                    scale = 1.0 * pageWidth / (double)width;
                }
                if ((double)height > pageHeight) {
                    scale = Math.min(scale, 1.0 * pageHeight / (double)height);
                }
                gg.scale(scale, scale);
                int inc = (int)(maxTime / 10L);
                long time = 0L;
                gg.setColor(Color.gray);
                int i = 0;
                while (i <= 10) {
                    int xpos = (int)((double)time * timeScaleFactor);
                    g.drawLine(xpos, 0, xpos, height - HEIGHT / 2);
                    g.drawString(String.valueOf(time), xpos, height - descent);
                    time += (long)inc;
                    ++i;
                }
                int top = 0;
                int offset = (HEIGHT - (ascent + descent)) / 2 + ascent;
                gg.setColor(Color.black);
                for (String sig : map.keySet()) {
                    BitSet off;
                    LogicElement el = (LogicElement)map.get(sig);
                    LinkedList events = (LinkedList)BatchSimulator.this.eventTrace.get(el);
                    if (el.getBits() == 1) {
                        off = new BitSet(el.getBits() + 1);
                        off.set(el.getBits());
                        long prevValue = BitSetUtils.ToLong(((TrEvent)events.getFirst()).value);
                        if (((TrEvent)events.getFirst()).value.equals(off)) {
                            prevValue = -1L;
                        }
                        int prevXpos = 0;
                        for (TrEvent event : events) {
                            int xpos = (int)((double)event.time * timeScaleFactor + 0.5);
                            int ypos = 0;
                            if (prevValue == 0L) {
                                gg.drawLine(prevXpos, top + 30, xpos, top + 30);
                                ypos = top + 30;
                            } else if (prevValue == 1L) {
                                gg.drawLine(prevXpos, top + 10, xpos, top + 10);
                                ypos = top + 10;
                            } else {
                                gg.drawLine(prevXpos, top + 20, xpos, top + 20);
                                ypos = top + 20;
                            }
                            prevValue = BitSetUtils.ToLong(event.value);
                            if (event.value.equals(off)) {
                                prevValue = -1L;
                            }
                            prevXpos = xpos;
                            if (prevValue == 0L) {
                                gg.drawLine(xpos, ypos, xpos, top + 30);
                                continue;
                            }
                            if (prevValue == 1L) {
                                gg.drawLine(xpos, ypos, xpos, top + 10);
                                continue;
                            }
                            gg.drawLine(xpos, ypos, xpos, top + 20);
                        }
                        if (prevValue == 0L) {
                            gg.drawLine(prevXpos, top + 30, 1000, top + 30);
                        } else if (prevValue == 1L) {
                            gg.drawLine(prevXpos, top + 10, 1000, top + 10);
                        } else {
                            gg.drawLine(prevXpos, top + 20, 1000, top + 20);
                        }
                    } else {
                        String val;
                        int valWidth;
                        off = new BitSet(el.getBits() + 1);
                        off.set(el.getBits());
                        BigInteger prevValue = BitSetUtils.ToBigInteger(((TrEvent)events.getFirst()).value);
                        if (((TrEvent)events.getFirst()).value.equals(off)) {
                            prevValue = null;
                        }
                        int prevXpos = 0;
                        for (TrEvent event : (LinkedList)BatchSimulator.this.eventTrace.get(map.get(sig))) {
                            String val2;
                            int valWidth2;
                            int xpos = (int)((double)event.time * timeScaleFactor + 0.5);
                            if (prevValue != null) {
                                gg.drawLine(prevXpos, top + 30, xpos, top + 30);
                                gg.drawLine(prevXpos, top + 10, xpos, top + 10);
                            } else {
                                gg.drawLine(prevXpos, top + 20, xpos, top + 20);
                            }
                            gg.drawLine(xpos, top + 10, xpos, top + 30);
                            if (prevValue != null && (valWidth2 = fm.stringWidth(val2 = String.format(" %s ", prevValue.toString(16)))) <= xpos - prevXpos) {
                                gg.drawString(val2, prevXpos, top + (HEIGHT - ascent - descent) / 2 + ascent);
                            }
                            prevValue = BitSetUtils.ToBigInteger(event.value);
                            if (event.value.equals(off)) {
                                prevValue = null;
                            }
                            prevXpos = xpos;
                        }
                        if (prevValue != null) {
                            gg.drawLine(prevXpos, top + 30, 1000, top + 30);
                            gg.drawLine(prevXpos, top + 10, 1000, top + 10);
                        } else {
                            gg.drawLine(prevXpos, top + 20, 1000, top + 20);
                        }
                        if (prevValue != null && (valWidth = fm.stringWidth(val = String.format(" %s ", prevValue.toString(16)))) <= 1000 - prevXpos) {
                            gg.drawString(val, prevXpos, top + (HEIGHT - ascent - descent) / 2 + ascent);
                        }
                    }
                    gg.drawString(sig, 1000, top + offset);
                    top += HEIGHT;
                }
                return 0;
            }
        };
        Book book = new Book();
        book.append(pr, format);
        job.setPageable(book);
        try {
            job.print();
        }
        catch (PrinterException ex) {
            System.out.println("printing error: " + ex.getMessage());
        }
    }

    public void displayOutcome() {
        String reason = "Simulation Complete";
        if (this.stopping) {
            reason = "Simulation Stopped";
        } else if (this.now >= this.maxTime) {
            reason = "Simulation Time Limit";
        } else if (this.eventQueue.size() == 0) {
            reason = "Simulation: No More Activity";
        }
        System.out.println(String.valueOf(reason) + " at " + this.now);
    }

    private class TrEvent {
        public long time;
        public BitSet value;

        private TrEvent() {
        }
    }
}

