/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem.sm;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.sm.SMUtil;
import edu.mtu.cs.jls.elem.sm.State;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public final class StateMachine
extends LogicElement
implements Printable {
    private static final int defaultPropDelay = 30;
    private static int defaultTrigger = 1;
    private int propDelay = 30;
    private Set<State> states = new HashSet<State>();
    private int trigger = defaultTrigger;
    private String name = "";
    private LoadState loadState = LoadState.machine;
    private State buildState;
    private boolean canceled;
    private JDialog currentDialog;
    private Rectangle bounds;
    private StateMachine original;
    private int oldClock;
    private boolean busy = false;
    private State currentState;

    public StateMachine(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        new StateEditor(this, true);
        if (this.canceled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        Point win = editWindow.getLocationOnScreen();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        if (g != null && this.width == 0 && this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            String dname = this.name;
            if (this.name.equals("")) {
                dname = "State Machine";
            }
            this.width = fm.stringWidth(" " + dname + " ");
            for (State state : this.states) {
                this.width = Math.max(this.width, state.getWidthInfo(fm));
            }
            this.width = Math.max(this.width, fm.stringWidth("clock"));
            this.width = (this.width + s - 1) / s * s + s;
        }
        TreeSet<String> inputList = new TreeSet<String>();
        TreeSet<String> outputList = new TreeSet<String>();
        for (State state : this.states) {
            inputList.addAll(state.getInputs());
            outputList.addAll(state.getOutputs());
        }
        HashSet saveInputs = new HashSet(inputList);
        Vector<String> pins = new Vector<String>(inputList.size() + outputList.size());
        boolean takeFromInput = true;
        while (inputList.size() + outputList.size() > 0) {
            String pin;
            if (takeFromInput) {
                takeFromInput = false;
                if (inputList.isEmpty()) continue;
                pin = (String)inputList.first();
                pins.add(pin);
                inputList.remove(pin);
                continue;
            }
            takeFromInput = true;
            if (outputList.isEmpty()) continue;
            pin = (String)outputList.first();
            pins.add(pin);
            outputList.remove(pin);
        }
        this.height = s;
        for (String signal : pins) {
            if (saveInputs.contains(signal)) {
                Input in = new Input(signal, this, 0, this.height, this.inputBits(signal));
                this.inputs.add(in);
                this.height += s;
                continue;
            }
            Output out = new Output(signal, this, this.width, this.height, this.outputBits(signal));
            this.outputs.add(out);
            this.height += s;
        }
        this.height += 4 * s;
        this.inputs.add(new Input("clock", this, 0, this.height - s, 1));
    }

    private int inputBits(String signal) {
        for (State state : this.states) {
            int bits = state.inputBits(signal);
            if (bits <= 0) continue;
            return bits;
        }
        return 0;
    }

    private int outputBits(String signal) {
        for (State state : this.states) {
            int bits = state.outputBits(signal);
            if (bits <= 0) continue;
            return bits;
        }
        return 0;
    }

    @Override
    public void draw(Graphics g) {
        int dy;
        int s = 12;
        int d2 = 3;
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int fontHeight = ascent + descent;
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawRoundRect(this.x, this.y, this.width, this.height, 6, 6);
        g.drawLine(this.x, this.y + this.height - 4 * s, this.x + this.width, this.y + this.height - 4 * s);
        g.drawLine(this.x, this.y + this.height - 2 * s, this.x + this.width, this.y + this.height - 2 * s);
        String dname = this.name;
        if (this.name.equals("")) {
            dname = "State Machine";
        }
        int w = fm.stringWidth(dname);
        g.drawString(dname, this.x + (this.width - w) / 2, this.y + this.height - 3 * s - fontHeight / 2 + ascent);
        for (Input input : this.inputs) {
            dy = input.getY();
            g.setColor(Color.black);
            g.drawString(input.getName(), this.x + d2, dy - fontHeight / 2 + ascent);
            input.draw(g);
        }
        for (Output output : this.outputs) {
            dy = output.getY();
            int ow = fm.stringWidth(output.getName());
            g.setColor(Color.black);
            g.drawString(output.getName(), this.x + this.width - ow - d2, dy - fontHeight / 2 + ascent);
            output.draw(g);
        }
    }

    @Override
    public int print(Graphics g, PageFormat format, int pagenum) {
        Graphics2D gg = (Graphics2D)g;
        Circuit c = this.circuit;
        String nm = String.valueOf(this.name) + " in " + this.circuit.getName();
        while (c.isImported()) {
            c = c.getSubElement().getCircuit();
            nm = String.valueOf(nm) + " in " + c.getName();
        }
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int fontHeight = ascent + descent;
        this.bounds = null;
        for (State state : this.states) {
            if (this.bounds == null) {
                this.bounds = state.getBounds(g);
                continue;
            }
            this.bounds.add(state.getBounds(g));
        }
        if (this.bounds == null) {
            this.bounds = new Rectangle(0, 0, 1, 1);
        }
        double width = format.getImageableWidth();
        double height = format.getImageableHeight();
        double scale = 1.0;
        if ((double)this.bounds.width > width) {
            scale = 1.0 * width / (double)this.bounds.width;
        }
        if ((double)this.bounds.height > height) {
            scale = Math.min(scale, 1.0 * height / (double)this.bounds.height);
        }
        gg.translate(format.getImageableX(), format.getImageableY());
        gg.drawString(nm, 0, ascent);
        gg.translate(0, 2 * fontHeight);
        gg.scale(scale, scale);
        gg.translate(-this.bounds.x, -this.bounds.y);
        for (State state : this.states) {
            state.draw(gg);
        }
        return 0;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT StateMachine");
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" int delay " + this.propDelay);
        output.println(" int trig " + this.trigger);
        for (State state : this.states) {
            state.save(output);
        }
        output.println("END");
    }

    @Override
    public void setValue(String name, String value) {
        switch (this.loadState) {
            case machine: {
                if (name.equals("name")) {
                    this.name = value;
                    break;
                }
                if (name.equals("state")) {
                    this.loadState = LoadState.newState;
                    this.buildState = new State(this, value, null);
                    this.states.add(this.buildState);
                    this.buildState.fixTrans();
                    break;
                }
                super.setValue(name, value);
                break;
            }
            case newState: {
                if (name.equals("state")) {
                    this.loadState = LoadState.newState;
                    this.buildState = new State(this, value, null);
                    this.states.add(this.buildState);
                    this.buildState.fixTrans();
                    break;
                }
                if (name.equals("output")) {
                    this.loadState = LoadState.newOutput;
                    this.buildState.setOutputValue(name, value);
                    break;
                }
                if (!name.equals("trans")) break;
                this.loadState = LoadState.newTransition;
                this.buildState.setTransValue(name, value);
                break;
            }
            case newOutput: {
                if (name.equals("state")) {
                    this.loadState = LoadState.newState;
                    this.buildState = new State(this, value, null);
                    this.states.add(this.buildState);
                    this.buildState.fixTrans();
                    break;
                }
                if (name.equals("output")) {
                    this.loadState = LoadState.newOutput;
                    this.buildState.setOutputValue(name, value);
                    break;
                }
                if (!name.equals("trans")) break;
                this.loadState = LoadState.newTransition;
                this.buildState.setTransValue(name, value);
                break;
            }
            case newTransition: {
                if (name.equals("state")) {
                    this.loadState = LoadState.newState;
                    this.buildState = new State(this, value, null);
                    this.states.add(this.buildState);
                    this.buildState.fixTrans();
                    break;
                }
                if (name.equals("output")) {
                    this.loadState = LoadState.newOutput;
                    this.buildState.setOutputValue(name, value);
                    break;
                }
                if (!name.equals("trans") && !name.equals("next")) break;
                this.loadState = LoadState.newTransition;
                this.buildState.setTransValue(name, value);
            }
        }
    }

    @Override
    public void setValue(String name, int value) {
        switch (this.loadState) {
            case machine: {
                if (name.equals("trig")) {
                    this.trigger = value;
                    break;
                }
                if (name.equals("delay")) {
                    this.propDelay = value;
                    break;
                }
                super.setValue(name, value);
                break;
            }
            case newState: {
                this.buildState.setValue(name, value);
                break;
            }
            case newOutput: {
                this.buildState.setOutputValue(name, value);
                break;
            }
            case newTransition: {
                this.buildState.setTransValue(name, value);
            }
        }
    }

    @Override
    public void setValue(String name, long value) {
        switch (this.loadState) {
            case newOutput: {
                this.buildState.setOutputValue(name, value);
            }
        }
    }

    @Override
    public void setPair(int v1, int v2) {
        this.buildState.setTransPair(v1, v2);
    }

    public boolean canCopy() {
        return false;
    }

    @Override
    public Element copy() {
        StateMachine it = new StateMachine(this.circuit);
        it.name = new String(this.name);
        it.propDelay = this.propDelay;
        it.trigger = this.trigger;
        HashMap<String, State> stateMap = new HashMap<String, State>();
        for (State state : this.states) {
            State st = state.copy(it);
            it.states.add(st);
            stateMap.put(state.getName(), st);
        }
        for (State istate : it.states) {
            istate.linkTrans(it, stateMap);
        }
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        for (Output output : this.outputs) {
            it.outputs.add(output.copy(it));
        }
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        String trig = "falling";
        if (this.trigger == 1) {
            trig = "rising";
        }
        String msg = "state machine (" + trig + " edge triggered), ";
        if (this.currentState == null) {
            info.setText(String.valueOf(msg) + "no current state");
        } else {
            info.setText(String.valueOf(msg) + "current state = " + this.currentState.getName());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    Set<State> getStates() {
        return this.states;
    }

    Vector<Input> getInputs() {
        return this.inputs;
    }

    Vector<Output> getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = 30;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        int bits;
        this.original = (StateMachine)this.copy();
        StateEditor ed = new StateEditor(this, false);
        if (this.canceled) {
            this.states = this.original.states;
        }
        if (ed.nameChanged()) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        HashSet<String> oldNames = new HashSet<String>();
        for (Input input : this.inputs) {
            oldNames.add(input.getName());
        }
        HashSet<String> newNames = new HashSet<String>();
        newNames.add("clock");
        for (State state : this.states) {
            newNames.addAll(state.getInputs());
        }
        if (!oldNames.equals(newNames)) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        for (Input input : this.inputs) {
            bits = input.getBits();
            for (State state : this.states) {
                for (String inp : state.getInputs()) {
                    if (!input.getName().equals(inp) || state.inputBits(inp) == bits) continue;
                    this.detach();
                    this.width = 0;
                    this.height = 0;
                    this.init(g);
                    return true;
                }
            }
        }
        oldNames.clear();
        for (Output output : this.outputs) {
            oldNames.add(output.getName());
        }
        newNames.clear();
        for (State state : this.states) {
            newNames.addAll(state.getOutputs());
        }
        if (!oldNames.equals(newNames)) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        for (Output output : this.outputs) {
            bits = output.getBits();
            for (State state : this.states) {
                for (String out : state.getOutputs()) {
                    if (!output.getName().equals(out) || state.outputBits(out) == bits) continue;
                    this.detach();
                    this.width = 0;
                    this.height = 0;
                    this.init(g);
                    return true;
                }
            }
        }
        return false;
    }

    public Printable makeOutSum() {
        int outs = 0;
        for (State state : this.states) {
            outs += state.numOuts();
        }
        if (outs == 0) {
            return null;
        }
        return new Printable(){

            @Override
            public int print(Graphics g, PageFormat format, int pagenum) {
                int pageWidth = (int)format.getImageableWidth();
                g.translate((int)format.getImageableX(), (int)format.getImageableY());
                int x = 0;
                int y = 0;
                TreeMap<String, State> sorted = new TreeMap<String, State>();
                for (State state : StateMachine.this.states) {
                    sorted.put(state.getName(), state);
                }
                int maxHeight = 0;
                TreeSet<Integer> borderX = new TreeSet<Integer>();
                for (String sname : sorted.keySet()) {
                    State state = (State)sorted.get(sname);
                    int stateWidth = state.maxWidth(g);
                    maxHeight = Math.max(maxHeight, state.maxHeight(g));
                    if (x + stateWidth > pageWidth) {
                        g.drawLine(0, y + maxHeight + 5, x - 10, y + maxHeight + 5);
                        int lines = borderX.size() - 1;
                        int i = 0;
                        while (i < lines) {
                            int bx = (Integer)borderX.first();
                            g.drawLine(bx, y, bx, y + maxHeight);
                            borderX.remove(bx);
                            ++i;
                        }
                        x = 0;
                        y += maxHeight + 10;
                        maxHeight = 0;
                        borderX.clear();
                    }
                    borderX.add(x + stateWidth + 5);
                    state.print(g, x, y);
                    x += stateWidth + 10;
                }
                if (borderX.size() > 1) {
                    int lines = borderX.size() - 1;
                    int i = 0;
                    while (i < lines) {
                        int bx = (Integer)borderX.first();
                        g.drawLine(bx, y, bx, y + maxHeight);
                        borderX.remove(bx);
                        ++i;
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public void initSim(Simulator sim) {
        for (Output output : this.outputs) {
            output.setValue(new BitSet());
        }
        this.oldClock = 0;
        for (State state : this.states) {
            if (!state.isInitial()) continue;
            this.currentState = state;
            break;
        }
        this.currentState.sendOutputs(this, 0L, sim);
        this.busy = false;
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            State newState;
            BitSet cval = this.getInput("clock").getValue();
            if (cval == null) {
                cval = new BitSet();
            }
            int newClock = (int)BitSetUtils.ToLong(this.getInput("clock").getValue());
            if (this.busy) {
                this.oldClock = newClock;
                return;
            }
            if (this.trigger == 1) {
                if (this.oldClock != 0 || newClock != 1) {
                    this.oldClock = newClock;
                    return;
                }
            } else if (this.oldClock != 1 || newClock != 0) {
                this.oldClock = newClock;
                return;
            }
            if ((newState = this.currentState.getNextState()) == null) {
                this.busy = true;
                return;
            }
            this.oldClock = newClock;
            this.busy = true;
            sim.post(new SimEvent(now + (long)this.propDelay, this, newState));
        } else {
            this.currentState = (State)todo;
            this.currentState.sendOutputs(this, now, sim);
            this.busy = false;
        }
    }

    private class CreateState
    extends JDialog
    implements ActionListener {
        private String name;
        private JTextField nameField;
        private JButton ok;
        private JButton cancel;
        private boolean stateCancelled;

        public CreateState(int xp, int yp, String title, String currentName) {
            super(JLSInfo.frame, String.valueOf(title) + " State", true);
            this.nameField = new JTextField(10);
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            this.stateCancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BorderLayout());
            JPanel name = new JPanel(new BorderLayout());
            name.add((Component)new JLabel("Name: ", 4), "West");
            name.add((Component)this.nameField, "Center");
            this.nameField.setText(currentName);
            window.add((Component)name, "North");
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.nameField.addActionListener(this);
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            window.add((Component)okCancel, "South");
            this.getRootPane().setDefaultButton(this.ok);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CreateState.this.stateCancelled = true;
                    CreateState.this.dispose();
                }
            });
            this.pack();
            this.setLocation(xp, yp);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField) {
                this.name = this.nameField.getText().trim();
                if (this.name.equals("")) {
                    JOptionPane.showMessageDialog(this, "Missing name", "Error", 0);
                    return;
                }
                for (State state : StateMachine.this.states) {
                    if (!state.getName().equals(this.name)) continue;
                    JOptionPane.showMessageDialog(this, "Duplicate name", "Error", 0);
                    return;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.stateCancelled = true;
                this.dispose();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public boolean wasCancelled() {
            return this.stateCancelled;
        }
    }

    private static enum DrawState {
        idle,
        created,
        placing,
        selecting,
        selected,
        moving,
        newTrans,
        pointMoving;

    }

    private static enum LoadState {
        machine,
        newState,
        newOutput,
        newTransition;

    }

    private class StateEditor
    extends JDialog
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        private JPanel editArea;
        private JLabel msgLabel;
        private JLabel stateLabel;
        private DrawState drawState;
        private int x;
        private int y;
        private Rectangle selrect;
        private Set<State> selected;
        private State on;
        private JRadioButton rising;
        private JRadioButton falling;
        private JButton enlarge;
        private JTextField nameField;
        private JButton ok;
        private JButton cancel;
        private JMenuItem changeName;
        private JMenuItem makeInit;
        private JMenuItem addTrans;
        private JMenuItem deleteAllTrans;
        private JMenuItem editOutputs;
        private JMenuItem showOutputs;
        private JMenuItem delete;
        private JMenuItem alignHor;
        private JMenuItem alignVer;
        private Vector<Point> points;
        private Point movingPoint;
        private boolean nameChange;
        private StateMachine machine;

        private StateEditor(StateMachine machine, boolean creating) {
            super(JLSInfo.frame, "Edit State Machine", true);
            this.msgLabel = new JLabel("");
            this.stateLabel = new JLabel(" ");
            this.drawState = DrawState.idle;
            this.selrect = null;
            this.selected = new HashSet<State>();
            this.rising = new JRadioButton("rising edge");
            this.falling = new JRadioButton("falling edge");
            this.enlarge = new JButton("+");
            this.nameField = new JTextField(30);
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            this.changeName = new JMenuItem("change name");
            this.makeInit = new JMenuItem("make initial state");
            this.addTrans = new JMenuItem("add transition");
            this.deleteAllTrans = new JMenuItem("delete all transitions");
            this.editOutputs = new JMenuItem("edit outputs");
            this.showOutputs = new JMenuItem("view outputs");
            this.delete = new JMenuItem("delete state(s)");
            this.alignHor = new JMenuItem("align states horizontally");
            this.alignVer = new JMenuItem("align states vertically");
            this.points = new Vector();
            StateMachine.this.currentDialog = this;
            this.machine = machine;
            StateMachine.this.canceled = false;
            Container window = this.getContentPane();
            window.setLayout(new BorderLayout());
            JPanel messages = new JPanel(new BorderLayout());
            messages.setBackground(Color.cyan);
            messages.add((Component)this.msgLabel, "Center");
            messages.add((Component)this.stateLabel, "East");
            window.add((Component)messages, "North");
            this.editArea = new JPanel(){

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    if (StateEditor.this.selrect != null) {
                        if (StateEditor.this.drawState == DrawState.selecting) {
                            g.setColor(Color.GRAY);
                            g.drawRect(((StateEditor)StateEditor.this).selrect.x, ((StateEditor)StateEditor.this).selrect.y, ((StateEditor)StateEditor.this).selrect.width, ((StateEditor)StateEditor.this).selrect.height);
                        } else {
                            g.setColor(Color.lightGray);
                            g.fillRect(((StateEditor)StateEditor.this).selrect.x, ((StateEditor)StateEditor.this).selrect.y, ((StateEditor)StateEditor.this).selrect.width, ((StateEditor)StateEditor.this).selrect.height);
                        }
                    }
                    if (StateEditor.this.drawState == DrawState.newTrans) {
                        StateEditor.this.drawTrans(StateEditor.this.on, StateEditor.this.points, g);
                    }
                    for (State state : StateMachine.this.states) {
                        state.draw(g);
                    }
                }
            };
            if (creating) {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                this.editArea.setPreferredSize(new Dimension(screen.width - 100, screen.height - 100));
            } else {
                Rectangle es = null;
                for (State state : StateMachine.this.states) {
                    if (es == null) {
                        es = state.getBounds(null);
                        continue;
                    }
                    es.add(state.getBounds(null));
                }
                if (es != null) {
                    int w = (int)((double)(es.x + es.width) * 1.1);
                    int h = (int)((double)(es.y + es.height) * 1.1);
                    this.editArea.setPreferredSize(new Dimension(w, h));
                } else {
                    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                    this.editArea.setPreferredSize(new Dimension(screen.width - 100, screen.height - 100));
                }
            }
            this.editArea.setBackground(Color.white);
            this.editArea.addMouseListener(this);
            this.editArea.addMouseMotionListener(this);
            JScrollPane pane = new JScrollPane(this.editArea);
            window.add((Component)pane, "Center");
            JPanel bottom = new JPanel(new GridLayout(3, 1));
            JPanel stuff = new JPanel(new BorderLayout());
            JPanel trig = new JPanel(new FlowLayout(1));
            trig.add(new JLabel("Trigger: "));
            trig.add(this.rising);
            trig.add(this.falling);
            ButtonGroup group = new ButtonGroup();
            group.add(this.rising);
            group.add(this.falling);
            if (StateMachine.this.trigger == 1) {
                this.rising.setSelected(true);
            } else {
                this.falling.setSelected(true);
            }
            stuff.add((Component)trig, "Center");
            stuff.add((Component)this.enlarge, "East");
            bottom.add(stuff);
            this.enlarge.setToolTipText("expand drawing area");
            JPanel namePanel = new JPanel(new FlowLayout());
            namePanel.add(new JLabel("Name: "));
            namePanel.add(this.nameField);
            this.nameField.setText(StateMachine.this.name);
            bottom.add(namePanel);
            JPanel okCancel = new JPanel(new GridLayout(1, 3));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "stmach", null);
            }
            okCancel.add(help);
            bottom.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            window.add((Component)bottom, "South");
            this.enlarge.addActionListener(this);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.changeName.addActionListener(this);
            this.makeInit.addActionListener(this);
            this.addTrans.addActionListener(this);
            this.deleteAllTrans.addActionListener(this);
            this.editOutputs.addActionListener(this);
            this.showOutputs.addActionListener(this);
            this.delete.addActionListener(this);
            this.alignHor.addActionListener(this);
            this.alignVer.addActionListener(this);
            AbstractAction newState = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    StateEditor.this.createNewState();
                }
            };
            this.editArea.getInputMap().put(KeyStroke.getKeyStroke(78, 2), "new state");
            this.editArea.getActionMap().put("new state", newState);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    StateEditor.this.cancel();
                }
            });
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialog = this.getPreferredSize();
            int w = Math.min(dialog.width, screen.width - 100);
            int h = Math.min(dialog.height + 100, screen.height - 100);
            this.setSize(w, h);
            this.setLocation(50, 50);
            this.setVisible(true);
        }

        public void setDrawState(DrawState state) {
            this.drawState = state;
            switch (state) {
                case idle: {
                    this.stateLabel.setText(" ");
                    break;
                }
                case created: {
                    this.stateLabel.setText("created new state");
                    break;
                }
                case placing: {
                    this.stateLabel.setText("left click to place, right click to cancel");
                    break;
                }
                case selecting: {
                    this.stateLabel.setText("selecting states");
                    break;
                }
                case selected: {
                    this.stateLabel.setText("selected states");
                    break;
                }
                case moving: {
                    this.stateLabel.setText("moving state(s)");
                    break;
                }
                case newTrans: {
                    this.stateLabel.setText("creating new transition");
                    break;
                }
                case pointMoving: {
                    this.stateLabel.setText("moving a transition corner");
                }
            }
        }

        public void drawTrans(State from, Vector<Point> points, Graphics g) {
            Point last = from.getLocation();
            Point prev = null;
            for (Point p : points) {
                g.setColor(Color.black);
                g.drawLine(last.x, last.y, p.x, p.y);
                prev = last;
                last = p;
            }
            SMUtil.drawArrow(last.x, last.y, SMUtil.getAngle(last.x - prev.x, prev.y - last.y), g);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok) {
                if (this.rising.isSelected()) {
                    StateMachine.this.trigger = 1;
                } else {
                    StateMachine.this.trigger = -1;
                }
                String oldName = StateMachine.this.name;
                StateMachine.this.name = this.nameField.getText().trim();
                this.nameChange = !oldName.equals(StateMachine.this.name);
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.changeName) {
                Point win = this.editArea.getLocationOnScreen();
                CreateState cs = new CreateState(this.x + win.x, this.y + win.y, "Change", this.on.getName());
                if (!cs.wasCancelled()) {
                    boolean bl = this.on.changeName(cs.getName(), this.editArea.getGraphics());
                    if (!bl) {
                        JOptionPane.showMessageDialog(this, "Name won't fit", "Error", 0);
                        return;
                    }
                    this.editArea.repaint();
                }
            } else if (event.getSource() == this.makeInit) {
                for (State state : StateMachine.this.states) {
                    state.setInitial(false);
                }
                this.on.setInitial(true);
                this.setDrawState(DrawState.idle);
                this.editArea.repaint();
            } else if (event.getSource() == this.addTrans) {
                this.points.clear();
                this.points.add(new Point(this.x, this.y));
                this.setDrawState(DrawState.newTrans);
            } else if (event.getSource() == this.deleteAllTrans) {
                this.on.deleteAllTrans();
                this.setDrawState(DrawState.idle);
                this.editArea.repaint();
            } else if (event.getSource() == this.editOutputs) {
                this.on.editOuts(StateMachine.this.currentDialog);
            } else if (event.getSource() == this.showOutputs) {
                this.on.showOuts(this.getMousePosition(), StateMachine.this.currentDialog);
            } else if (event.getSource() == this.delete) {
                if (this.on != null) {
                    for (State state : StateMachine.this.states) {
                        state.removeTrans(this.on);
                    }
                    StateMachine.this.states.remove(this.on);
                    this.selrect = null;
                    this.setDrawState(DrawState.idle);
                    this.editArea.repaint();
                } else {
                    for (State state : this.selected) {
                        for (State state2 : StateMachine.this.states) {
                            state2.removeTrans(state);
                        }
                        StateMachine.this.states.remove(state);
                    }
                    this.selrect = null;
                    this.setDrawState(DrawState.idle);
                    this.editArea.repaint();
                }
            } else if (event.getSource() == this.alignHor) {
                int sum = 0;
                for (State state : this.selected) {
                    sum += state.getX();
                }
                int newx = sum / this.selected.size();
                for (State state : this.selected) {
                    state.savePosition();
                    state.setX(newx);
                }
                if (this.stateOverlap()) {
                    JOptionPane.showMessageDialog(this, "Can't do - states will overlap");
                    for (State state : this.selected) {
                        state.restorePosition();
                    }
                }
                this.selected.clear();
                this.selrect = null;
                this.setDrawState(DrawState.idle);
                this.editArea.repaint();
            } else if (event.getSource() == this.alignVer) {
                int sum = 0;
                for (State state : this.selected) {
                    sum += state.getY();
                }
                int newy = sum / this.selected.size();
                for (State state : this.selected) {
                    state.savePosition();
                    state.setY(newy);
                }
                if (this.stateOverlap()) {
                    JOptionPane.showMessageDialog(this, "Can't do - states overlap");
                    for (State state : this.selected) {
                        state.restorePosition();
                    }
                }
                this.selected.clear();
                this.selrect = null;
                this.setDrawState(DrawState.idle);
                this.editArea.repaint();
            } else if (event.getSource() == this.enlarge) {
                Dimension cs = this.editArea.getPreferredSize();
                int width = (int)((double)cs.width * 1.1);
                int n = (int)((double)cs.height * 1.1);
                this.editArea.setPreferredSize(new Dimension(width, n));
                this.editArea.revalidate();
            }
        }

        private boolean stateOverlap() {
            for (State sel : this.selected) {
                for (State state : StateMachine.this.states) {
                    if (sel == state || !sel.overlaps(state)) continue;
                    return true;
                }
            }
            return false;
        }

        private void cancel() {
            StateMachine.this.canceled = true;
            this.dispose();
        }

        public boolean nameChanged() {
            return this.nameChange;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            JPopupMenu menu;
            boolean rightButton;
            this.x = event.getX();
            this.y = event.getY();
            boolean leftButton = event.getButton() == 1;
            boolean bl = rightButton = event.getButton() == 3;
            if (this.drawState == DrawState.idle) {
                if (leftButton) {
                    for (State state : StateMachine.this.states) {
                        Point p = state.highlightTransPoints(this.x, this.y);
                        if (p == null) continue;
                        this.movingPoint = p;
                        this.setDrawState(DrawState.pointMoving);
                        return;
                    }
                    this.selected.clear();
                    for (State state : StateMachine.this.states) {
                        if (!state.contains(this.x, this.y)) continue;
                        state.setHighlight(true);
                        this.selected.add(state);
                        state.savePosition();
                    }
                    if (this.selected.isEmpty()) {
                        this.selrect = new Rectangle(this.x, this.y, 0, 0);
                        this.setDrawState(DrawState.selecting);
                        this.editArea.repaint();
                        return;
                    }
                    this.setDrawState(DrawState.moving);
                    this.editArea.repaint();
                    return;
                }
                if (rightButton) {
                    for (State state : StateMachine.this.states) {
                        if (!state.highlightTrans(this.x, this.y)) continue;
                        int result = JOptionPane.showConfirmDialog(null, "delete transition?", "option", 0);
                        if (result == 0) {
                            state.deleteLastHighlighted();
                            this.editArea.repaint();
                        }
                        return;
                    }
                    this.on = null;
                    for (State state : StateMachine.this.states) {
                        if (!state.contains(this.x, this.y)) continue;
                        this.on = state;
                        break;
                    }
                    if (this.on != null) {
                        menu = new JPopupMenu();
                        menu.add(this.addTrans);
                        menu.add(this.showOutputs);
                        menu.add(this.editOutputs);
                        menu.add(this.changeName);
                        menu.add(this.makeInit);
                        menu.add(this.deleteAllTrans);
                        menu.add(this.delete);
                        menu.show(this.editArea, this.x, this.y);
                    } else {
                        this.createNewState();
                        return;
                    }
                }
            }
            if (this.drawState == DrawState.created) {
                Point p = this.editArea.getMousePosition();
                if (p != null) {
                    for (State state : this.selected) {
                        state.moveTo(p.x, p.y);
                    }
                }
                this.repaint();
                return;
            }
            if (this.drawState == DrawState.placing) {
                if (rightButton) {
                    this.setDrawState(DrawState.idle);
                    for (State state : this.selected) {
                        StateMachine.this.states.remove(state);
                    }
                    this.selected.clear();
                    this.editArea.repaint();
                    return;
                }
                boolean overlaps = false;
                for (State state : this.selected) {
                    for (State st : StateMachine.this.states) {
                        if (state == st || !state.overlaps(st)) continue;
                        overlaps = true;
                    }
                }
                if (overlaps) {
                    return;
                }
                this.setDrawState(DrawState.idle);
                for (State state : this.selected) {
                    state.setHighlight(false);
                }
                this.selected.clear();
                this.editArea.repaint();
                this.mouseMoved(event);
                return;
            }
            if (this.drawState == DrawState.selected) {
                if (leftButton) {
                    if (this.selrect.contains(this.x, this.y)) {
                        this.setDrawState(DrawState.moving);
                        this.selrect = null;
                        this.repaint();
                    } else {
                        this.setDrawState(DrawState.idle);
                        this.selrect = null;
                        this.mousePressed(event);
                    }
                } else if (this.selrect != null && this.selrect.contains(this.x, this.y)) {
                    menu = new JPopupMenu();
                    menu.add(this.delete);
                    if (this.selected.size() > 1) {
                        menu.add(this.alignHor);
                        menu.add(this.alignVer);
                    }
                    menu.show(this.editArea, this.x, this.y);
                }
            }
            if (this.drawState == DrawState.newTrans) {
                if (rightButton) {
                    this.points.clear();
                    for (State state : StateMachine.this.states) {
                        state.setHighlight(false);
                    }
                    this.setDrawState(DrawState.idle);
                    this.editArea.repaint();
                    return;
                }
                State target = null;
                for (State state : StateMachine.this.states) {
                    if (!state.contains(this.x, this.y)) continue;
                    target = state;
                    break;
                }
                if (target == null) {
                    this.points.add(new Point(this.x, this.y));
                    this.editArea.repaint();
                    return;
                }
                this.on.newTransition(target, this.points, StateMachine.this.currentDialog);
                this.points.clear();
                this.on.setHighlight(false);
                this.setDrawState(DrawState.idle);
                this.editArea.repaint();
                return;
            }
        }

        private void createNewState() {
            Point win = this.editArea.getLocationOnScreen();
            CreateState cs = new CreateState(this.x + win.x, this.y + win.y, "Create", "");
            if (cs.wasCancelled()) {
                return;
            }
            State state = new State(this.machine, cs.getName(), this.editArea.getGraphics());
            Point p = this.editArea.getMousePosition();
            if (p == null) {
                int d = 40;
                state.moveTo(-d, -d);
            } else {
                state.moveTo(p.x, p.y);
            }
            state.setHighlight(true);
            if (StateMachine.this.states.isEmpty()) {
                state.setInitial(true);
            }
            StateMachine.this.states.add(state);
            this.selected.clear();
            this.selected.add(state);
            this.setDrawState(DrawState.created);
            this.editArea.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (this.drawState == DrawState.moving || this.drawState == DrawState.placing) {
                boolean overlaps = false;
                for (State sel : this.selected) {
                    for (State st : StateMachine.this.states) {
                        if (sel == st || !sel.overlaps(st)) continue;
                        overlaps = true;
                    }
                }
                if (overlaps) {
                    if (this.drawState == DrawState.placing) {
                        return;
                    }
                    for (State sel : this.selected) {
                        sel.restorePosition();
                    }
                }
                this.selected.clear();
                this.setDrawState(DrawState.idle);
                this.editArea.repaint();
                return;
            }
            if (this.drawState == DrawState.selecting) {
                if (this.selected.isEmpty()) {
                    this.selrect = null;
                    this.setDrawState(DrawState.idle);
                    this.editArea.repaint();
                    return;
                }
                this.selrect = null;
                for (State state : this.selected) {
                    if (this.selrect == null) {
                        this.selrect = state.getRect();
                        continue;
                    }
                    this.selrect.add(state.getRect());
                }
                this.setDrawState(DrawState.selected);
                this.repaint();
                return;
            }
            if (this.drawState == DrawState.pointMoving) {
                this.setDrawState(DrawState.idle);
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Point p;
            int oldx = this.x;
            int oldy = this.y;
            this.x = event.getX();
            this.y = event.getY();
            if (this.drawState == DrawState.idle) {
                for (State state : StateMachine.this.states) {
                    if (state.contains(this.x, this.y)) {
                        state.setHighlight(true);
                    } else {
                        state.setHighlight(false);
                    }
                    state.highlightTransPoints(this.x, this.y);
                    state.highlightTrans(this.x, this.y);
                }
                this.editArea.repaint();
                return;
            }
            if (this.drawState == DrawState.created) {
                p = this.editArea.getMousePosition();
                if (p == null) {
                    p = new Point(this.x, this.y);
                }
                oldx = p.x;
                oldy = p.y;
                for (State state : this.selected) {
                    state.moveTo(p.x, p.y);
                }
                this.setDrawState(DrawState.placing);
            }
            if (this.drawState == DrawState.placing || this.drawState == DrawState.moving) {
                for (State state : this.selected) {
                    state.move(this.x - oldx, this.y - oldy, this.selected);
                }
                this.editArea.repaint();
            }
            if (this.drawState == DrawState.newTrans) {
                p = this.points.lastElement();
                p.x = this.x;
                p.y = this.y;
                for (State state : StateMachine.this.states) {
                    if (state == this.on) continue;
                    state.setHighlight(false);
                    if (!state.contains(this.x, this.y)) continue;
                    state.setHighlight(true);
                    break;
                }
                this.repaint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (this.drawState == DrawState.moving) {
                int oldx = this.x;
                int oldy = this.y;
                this.x = event.getX();
                this.y = event.getY();
                for (State state : this.selected) {
                    state.move(this.x - oldx, this.y - oldy, this.selected);
                }
                this.editArea.repaint();
                return;
            }
            if (this.drawState == DrawState.selecting) {
                int nx = event.getX();
                int ny = event.getY();
                int rx = Math.min(nx, this.x);
                int ry = Math.min(ny, this.y);
                int rw = Math.abs(nx - this.x);
                int rh = Math.abs(ny - this.y);
                this.selrect.setBounds(rx, ry, rw, rh);
                this.selected.clear();
                for (State state : StateMachine.this.states) {
                    state.setHighlight(false);
                    if (!state.isInside(this.selrect)) continue;
                    this.selected.add(state);
                    state.setHighlight(true);
                    state.savePosition();
                }
                this.editArea.repaint();
                return;
            }
            if (this.drawState == DrawState.pointMoving) {
                this.x = event.getX();
                this.y = event.getY();
                for (State state : StateMachine.this.states) {
                    if (!state.contains(this.x, this.y)) continue;
                    return;
                }
                this.movingPoint.x = this.x;
                this.movingPoint.y = this.y;
                this.editArea.repaint();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }
    }
}

