/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem.sm;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.sm.SMUtil;
import edu.mtu.cs.jls.elem.sm.StateMachine;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class State {
    private StateMachine machine;
    private String name;
    private boolean initial = false;
    private Vector<Out> outs = new Vector();
    private Set<Transition> trans = new HashSet<Transition>();
    private int x;
    private int y;
    private int diameter;
    private Map<String, Check> bitmap = new HashMap<String, Check>();
    private int savex;
    private int savey;
    private boolean highlight;
    private Transition lastHighlighted;
    private Out buildOut;
    private Transition buildTrans;

    public State(StateMachine machine, String name, Graphics g) {
        this.machine = machine;
        this.name = name;
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            this.diameter = Math.max(fm.stringWidth("  " + name + "  "), 40);
        }
    }

    public void draw(Graphics g) {
        int d = this.diameter;
        int r = d / 2;
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int height = ascent + descent;
        for (Transition tr : this.trans) {
            Color color = Color.black;
            if (tr.highlighted) {
                color = JLSInfo.highlightColor;
            }
            if (tr.points.isEmpty()) {
                int w = tr.nextState.x - this.x;
                int h = this.y - tr.nextState.y;
                double dist = Math.sqrt(w * w + h * h);
                int dxf = (int)Math.rint((double)(w * r) / dist);
                int dyf = (int)Math.rint((double)(h * r) / dist);
                int or = tr.nextState.diameter / 2;
                int dxt = (int)Math.rint((double)(w * or) / dist);
                int dyt = (int)Math.rint((double)(h * or) / dist);
                int endx = tr.nextState.x - dxt;
                int endy = tr.nextState.y + dyt;
                g.setColor(color);
                g.drawLine(this.x + dxf, this.y - dyf, endx, endy);
                double angle = SMUtil.getAngle(w, h);
                SMUtil.drawArrow(endx, endy, angle, g);
                int midx = (this.x + dxf + endx) / 2;
                int midy = (this.y - dyf + endy) / 2;
                this.drawCond(tr, midx, midy, angle, g);
                continue;
            }
            int nx = tr.points.get((int)0).x;
            int ny = tr.points.get((int)0).y;
            int w = nx - this.x;
            int h = this.y - ny;
            double dist = Math.sqrt(w * w + h * h);
            int dxf = (int)Math.rint((double)(w * r) / dist);
            int dyf = (int)Math.rint((double)(h * r) / dist);
            g.setColor(color);
            g.drawLine(this.x + dxf, this.y - dyf, nx, ny);
            int midx = (this.x + dxf + nx) / 2;
            int midy = (this.y - dyf + ny) / 2;
            this.drawCond(tr, midx, midy, SMUtil.getAngle(w, h), g);
            int px = nx;
            int py = ny;
            int i = 1;
            while (i < tr.points.size()) {
                nx = tr.points.get((int)i).x;
                ny = tr.points.get((int)i).y;
                g.drawLine(px, py, nx, ny);
                px = nx;
                py = ny;
                ++i;
            }
            w = tr.nextState.x - px;
            h = py - tr.nextState.y;
            dist = Math.sqrt(w * w + h * h);
            int or = tr.nextState.diameter / 2;
            int dxt = (int)Math.rint((double)(w * or) / dist);
            int dyt = (int)Math.rint((double)(h * or) / dist);
            int endx = tr.nextState.x - dxt;
            int endy = tr.nextState.y + dyt;
            g.drawLine(px, py, endx, endy);
            double angle = SMUtil.getAngle(w, h);
            SMUtil.drawArrow(endx, endy, angle, g);
            if (tr.highlight == null) continue;
            int pd = 6;
            g.setColor(JLSInfo.highlightColor);
            g.fillOval(tr.highlight.x - pd / 2, tr.highlight.y - pd / 2, pd, pd);
        }
        if (this.initial) {
            g.setColor(JLSInfo.initialStateColor);
            g.fillOval(this.x - r, this.y - r, d + 1, d + 1);
        }
        if (this.highlight) {
            g.setColor(JLSInfo.highlightColor);
            g.fillOval(this.x - r, this.y - r, d + 1, d + 1);
        }
        g.setColor(Color.BLACK);
        g.drawOval(this.x - r, this.y - r, d, d);
        int width = fm.stringWidth(this.name);
        g.drawString(this.name, this.x - width / 2, this.y - height / 2 + ascent);
    }

    public void drawCond(Transition trans, int x, int y, double angle, Graphics g) {
        String cond = "";
        if (trans.other) {
            cond = "else";
        } else if (!trans.unconditional) {
            String rel = " != ";
            if (trans.equal) {
                rel = " = ";
            }
            cond = String.valueOf(trans.signal) + "[" + trans.bits + "]" + rel + trans.value;
        }
        FontMetrics fm = g.getFontMetrics();
        int descent = fm.getDescent();
        int width = fm.stringWidth(cond);
        if (angle == 0.0 || angle == 180.0) {
            g.drawString(cond, x - width / 2, y - descent - 1);
        } else if (0.0 < angle && angle <= 90.0 || 180.0 < angle && angle < 270.0) {
            g.drawString(cond, x - width, y - descent - 1);
        } else {
            g.drawString(cond, x + 1, y - descent - 1);
        }
    }

    public Rectangle getBounds(Graphics g) {
        int d = this.diameter;
        int r = d / 2;
        Rectangle bounds = new Rectangle(this.x - r, this.y - r, d, d);
        for (Transition tr : this.trans) {
            for (Point p : tr.points) {
                bounds.add(p);
            }
            if (tr.points.isEmpty()) {
                int w = tr.nextState.x - this.x;
                int h = this.y - tr.nextState.y;
                double dist = Math.sqrt(w * w + h * h);
                int dxf = (int)Math.rint((double)(w * r) / dist);
                int dyf = (int)Math.rint((double)(h * r) / dist);
                int or = tr.nextState.diameter / 2;
                int dxt = (int)Math.rint((double)(w * or) / dist);
                int dyt = (int)Math.rint((double)(h * or) / dist);
                int endx = tr.nextState.x - dxt;
                int endy = tr.nextState.y + dyt;
                double angle = SMUtil.getAngle(w, h);
                int midx = (this.x + dxf + endx) / 2;
                int midy = (this.y - dyf + endy) / 2;
                bounds.add(this.boundCond(tr, midx, midy, angle, g));
                continue;
            }
            int nx = tr.points.get((int)0).x;
            int ny = tr.points.get((int)0).y;
            int w = nx - this.x;
            int h = this.y - ny;
            double dist = Math.sqrt(w * w + h * h);
            int dxf = (int)Math.rint((double)(w * r) / dist);
            int dyf = (int)Math.rint((double)(h * r) / dist);
            int midx = (this.x + dxf + nx) / 2;
            int midy = (this.y - dyf + ny) / 2;
            bounds.add(this.boundCond(tr, midx, midy, SMUtil.getAngle(w, h), g));
        }
        return bounds;
    }

    public Rectangle boundCond(Transition trans, int x, int y, double angle, Graphics g) {
        if (g == null) {
            return new Rectangle(x, y, 0, 0);
        }
        String cond = "";
        if (trans.other) {
            cond = "else";
        } else if (!trans.unconditional) {
            String rel = " != ";
            if (trans.equal) {
                rel = " = ";
            }
            cond = String.valueOf(trans.signal) + "[" + trans.bits + "]" + rel + trans.value;
        }
        FontMetrics fm = g.getFontMetrics();
        int descent = fm.getDescent();
        int height = descent + fm.getAscent();
        int width = fm.stringWidth(cond);
        if (angle == 0.0 || angle == 180.0) {
            return new Rectangle(x - width / 2, y, width, height);
        }
        if (0.0 < angle && angle <= 90.0 || 180.0 < angle && angle < 270.0) {
            return new Rectangle(x - width, y, width, height);
        }
        return new Rectangle(x, y, width, height);
    }

    public State copy(StateMachine it) {
        State newState = new State(it, this.name, null);
        newState.x = this.x;
        newState.y = this.y;
        newState.diameter = this.diameter;
        newState.initial = this.initial;
        for (Out out : this.outs) {
            Out newOut = new Out();
            newOut.signal = new String(out.signal);
            newOut.value = out.value;
            newOut.bits = out.bits;
            newState.outs.add(newOut);
        }
        for (Transition tran : this.trans) {
            Transition newTrans = new Transition();
            newTrans.signal = new String(tran.signal);
            newTrans.unconditional = tran.unconditional;
            newTrans.other = tran.other;
            newTrans.equal = tran.equal;
            newTrans.value = tran.value;
            newTrans.bits = tran.bits;
            newTrans.nextStateName = new String(tran.nextState.getName());
            for (Point p : tran.points) {
                newTrans.points.add(new Point(p.x, p.y));
            }
            newState.trans.add(newTrans);
        }
        newState.bitmap = new HashMap<String, Check>();
        for (String sig : this.bitmap.keySet()) {
            Check ch = this.bitmap.get(sig);
            Check newch = new Check();
            newch.bits = ch.bits;
            newch.isInput = ch.isInput;
            newch.refs = ch.refs;
            newState.bitmap.put(sig, newch);
        }
        return newState;
    }

    public void linkTrans(StateMachine it, Map<String, State> stateMap) {
        for (Transition tran : this.trans) {
            if (tran.nextStateName == null) continue;
            tran.nextState = stateMap.get(tran.nextStateName);
        }
    }

    public void save(PrintWriter output) {
        output.println(" String state \"" + this.name + "\"");
        output.println("  int x " + this.x);
        output.println("  int y " + this.y);
        output.println("  int diameter " + this.diameter);
        output.println("  int init " + (this.initial ? 1 : 0));
        for (Out out : this.outs) {
            output.println("  String output \"" + out.signal + "\"");
            output.println("   long value " + out.value);
            output.println("   int bits " + out.bits);
        }
        for (Transition tr : this.trans) {
            if (tr.unconditional) {
                output.println("  String trans \"always\"");
            } else if (tr.other) {
                output.println("  String trans \"else\"");
            } else {
                output.println("  String trans \"" + tr.signal + "\"");
                if (tr.equal) {
                    output.println("   int eq 0");
                } else {
                    output.println("   int eq 1");
                }
                output.println("   int value " + tr.value);
                output.println("   int bits " + tr.bits);
            }
            output.println("   String next \"" + tr.nextState.getName() + "\"");
            for (Point p : tr.points) {
                output.println("    pair " + p.x + " " + p.y);
            }
        }
    }

    public void setValue(String name, int value) {
        if (name.equals("x")) {
            this.x = value;
        } else if (name.equals("y")) {
            this.y = value;
        } else if (name.equals("diameter")) {
            this.diameter = value;
        } else if (name.equals("init")) {
            this.initial = value != 0;
        }
    }

    public void setOutputValue(String name, String value) {
        this.buildOut = new Out();
        this.buildOut.signal = value;
        this.outs.add(this.buildOut);
    }

    public void setOutputValue(String name, int value) {
        if (name.equals("bits")) {
            this.buildOut.bits = value;
            Check ch = this.bitmap.get(this.buildOut.signal);
            if (ch == null) {
                ch = new Check();
                ch.bits = this.buildOut.bits;
                ch.isInput = false;
                ch.refs = 1;
                this.bitmap.put(this.buildOut.signal, ch);
            } else {
                ++ch.refs;
            }
        }
    }

    public void setOutputValue(String name, long value) {
        if (name.equals("value")) {
            this.buildOut.value = value;
        }
    }

    public void setTransValue(String name, String value) {
        if (name.equals("trans")) {
            this.buildTrans = new Transition();
            this.buildTrans.unconditional = false;
            this.buildTrans.other = false;
            if (value.equals("always")) {
                this.buildTrans.unconditional = true;
            } else if (value.equals("else")) {
                this.buildTrans.other = true;
            } else {
                this.buildTrans.signal = value;
            }
            this.trans.add(this.buildTrans);
        } else if (name.equals("next")) {
            for (State state : this.machine.getStates()) {
                if (!state.getName().equals(value)) continue;
                this.buildTrans.nextState = state;
                return;
            }
            this.buildTrans.nextStateName = value;
        }
    }

    public void setTransValue(String name, int value) {
        if (name.equals("eq")) {
            this.buildTrans.equal = value == 0;
        } else if (name.equals("value")) {
            this.buildTrans.value = value;
        } else if (name.equals("bits")) {
            this.buildTrans.bits = value;
            Check ch = this.bitmap.get(this.buildTrans.signal);
            if (ch == null) {
                if (!this.buildTrans.unconditional && !this.buildTrans.other) {
                    ch = new Check();
                    ch.bits = this.buildTrans.bits;
                    ch.isInput = true;
                    ch.refs = 1;
                    this.bitmap.put(this.buildTrans.signal, ch);
                }
            } else {
                ++ch.refs;
            }
        }
    }

    public void setTransPair(int v1, int v2) {
        this.buildTrans.points.add(new Point(v1, v2));
    }

    public void fixTrans() {
        for (State state : this.machine.getStates()) {
            for (Transition tr : state.trans) {
                if (tr == this.buildTrans || tr.nextStateName == null || !tr.nextStateName.equals(this.name)) continue;
                tr.nextState = this;
                tr.nextStateName = null;
            }
        }
    }

    public int inputBits(String signal) {
        for (Transition tran : this.trans) {
            if (!tran.signal.equals(signal)) continue;
            return tran.bits;
        }
        return 0;
    }

    public int outputBits(String signal) {
        for (Out out : this.outs) {
            if (!out.signal.equals(signal)) continue;
            return out.bits;
        }
        return 0;
    }

    public boolean contains(int x, int y) {
        int r = this.diameter / 2;
        return (this.x - x) * (this.x - x) + (this.y - y) * (this.y - y) < r * r;
    }

    public boolean overlaps(State other) {
        int ox = other.x;
        int oy = other.y;
        int d = 40;
        return (this.x - ox) * (this.x - ox) + (this.y - oy) * (this.y - oy) <= d * d;
    }

    public boolean isInside(Rectangle rect) {
        return rect.contains(this.getRect());
    }

    public void setHighlight(boolean which) {
        this.highlight = which;
    }

    public void move(int dx, int dy, Set<State> selected) {
        this.x += dx;
        this.y += dy;
        for (Transition tr : this.trans) {
            if (!selected.contains(tr.nextState)) continue;
            for (Point p : tr.points) {
                p.translate(dx, dy);
            }
        }
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void savePosition() {
        this.savex = this.x;
        this.savey = this.y;
    }

    public void restorePosition() {
        this.x = this.savex;
        this.y = this.savey;
    }

    public Rectangle getRect() {
        int d = this.diameter;
        int r = d / 2;
        return new Rectangle(this.x - r, this.y - r, d, d);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasTransitions() {
        return !this.trans.isEmpty();
    }

    public boolean changeName(String name, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth("  " + name + "  ");
        if (w > this.diameter) {
            return false;
        }
        this.name = name;
        return true;
    }

    public void newTransition(State to, Vector<Point> points, JDialog mainDialog) {
        if (this == to && points.size() < 3) {
            return;
        }
        Transition newTrans = new Transition();
        newTrans.nextState = to;
        newTrans.signal = "";
        newTrans.bits = -1;
        int i = 0;
        while (i < points.size() - 1) {
            newTrans.points.add(points.get(i));
            ++i;
        }
        for (Transition oldTrans : this.trans) {
            if (!oldTrans.signal.equals("")) {
                newTrans.signal = oldTrans.signal;
            }
            if (oldTrans.bits == 0) continue;
            newTrans.bits = oldTrans.bits;
        }
        CreateTrans ct = new CreateTrans(newTrans, this, mainDialog);
        if (!ct.wasCancelled()) {
            boolean hasUnconditional = false;
            boolean hasOther = false;
            String signal = "";
            BitSet tested = new BitSet();
            int bits = 0;
            for (Transition oldTrans : this.trans) {
                if (oldTrans.unconditional) {
                    hasUnconditional = true;
                    continue;
                }
                if (oldTrans.other) {
                    hasOther = true;
                    continue;
                }
                if (oldTrans.equal) {
                    signal = oldTrans.signal;
                    bits = oldTrans.bits;
                    tested.set(oldTrans.value);
                    continue;
                }
                signal = oldTrans.signal;
                bits = oldTrans.bits;
                BitSet temp = new BitSet();
                temp.set(oldTrans.value);
                temp.flip(0, 1 << bits);
                tested.or(temp);
            }
            if (hasUnconditional) {
                JOptionPane.showMessageDialog(mainDialog, "State already has an unconditional transition", "Error", 0);
                return;
            }
            if (newTrans.unconditional && !this.trans.isEmpty()) {
                JOptionPane.showMessageDialog(mainDialog, "Can't add an unconditional transition", "Error", 0);
                return;
            }
            if (newTrans.other) {
                if (this.trans.isEmpty()) {
                    JOptionPane.showMessageDialog(mainDialog, "State can't have just an else transition", "Error", 0);
                    return;
                }
                if (hasOther) {
                    JOptionPane.showMessageDialog(mainDialog, "State already has an else transition", "Error", 0);
                    return;
                }
                if (tested.cardinality() == 1 << bits) {
                    JOptionPane.showMessageDialog(mainDialog, "Existing transitions cover all possible cases", "Error", 0);
                    return;
                }
                this.trans.add(newTrans);
                return;
            }
            if (!signal.equals("") && !signal.equals(newTrans.signal)) {
                JOptionPane.showMessageDialog(mainDialog, "Can't test different signals in same state", "Error", 0);
                return;
            }
            if (bits > 0 && bits != newTrans.bits) {
                JOptionPane.showMessageDialog(mainDialog, "Bits differ", "Error", 0);
                return;
            }
            Check ch = this.bitmap.get(newTrans.signal);
            if (ch == null) {
                if (!newTrans.unconditional && !newTrans.other) {
                    ch = new Check();
                    ch.bits = newTrans.bits;
                    ch.isInput = true;
                    ch.refs = 1;
                    this.bitmap.put(newTrans.signal, ch);
                }
            } else {
                if (!ch.isInput) {
                    JOptionPane.showMessageDialog(mainDialog, "This signal is already an output", "Error", 0);
                    return;
                }
                if (ch.bits != newTrans.bits) {
                    JOptionPane.showMessageDialog(mainDialog, "Bits not consistent with previous use of this signal", "Error", 0);
                    return;
                }
                ++ch.refs;
            }
            if (newTrans.equal) {
                if (tested.get(newTrans.value)) {
                    JOptionPane.showMessageDialog(mainDialog, "This value already tested in an existing transition", "Error", 0);
                    return;
                }
                tested.set(newTrans.value);
                if (hasOther && tested.cardinality() == 1 << bits) {
                    JOptionPane.showMessageDialog(mainDialog, "New transition would make else transition impossible", "Error", 0);
                    return;
                }
                this.trans.add(newTrans);
                return;
            }
            if (!newTrans.equal) {
                if (hasOther) {
                    JOptionPane.showMessageDialog(mainDialog, "New transition would make else transition impossible", "Error", 0);
                    return;
                }
                BitSet temp = new BitSet();
                temp.set(newTrans.value);
                temp.flip(0, 1 << bits);
                if (temp.intersects(tested)) {
                    JOptionPane.showMessageDialog(mainDialog, "These values already tested in existing transition(s)", "Error", 0);
                    return;
                }
                this.trans.add(newTrans);
            }
        }
    }

    public void setInitial(boolean which) {
        this.initial = which;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void removeTrans(State other) {
        HashSet<Transition> removes = new HashSet<Transition>();
        for (Transition tr : this.trans) {
            if (tr.nextState != other) continue;
            removes.add(tr);
            Check ch = this.bitmap.get(tr.signal);
            if (ch == null) continue;
            --ch.refs;
            if (ch.refs != 0) continue;
            this.bitmap.remove(tr.signal);
        }
        this.trans.removeAll(removes);
    }

    public Point highlightTransPoints(int x, int y) {
        int ds = 36;
        for (Transition tr : this.trans) {
            tr.highlight = null;
            for (Point p : tr.points) {
                if ((p.x - x) * (p.x - x) + (p.y - y) * (p.y - y) >= ds) continue;
                tr.highlight = p;
                return p;
            }
        }
        return null;
    }

    public boolean highlightTrans(int xp, int yp) {
        int d = 6;
        for (Transition tran : this.trans) {
            tran.highlighted = false;
            if (tran.points.isEmpty()) {
                double maind = Line2D.ptSegDist(this.x, this.y, tran.nextState.x, tran.nextState.y, xp, yp);
                if (!(maind < (double)d) || this.contains(xp, yp) || tran.nextState.contains(xp, yp)) continue;
                tran.highlighted = true;
                this.lastHighlighted = tran;
                return true;
            }
            Point p = tran.points.get(0);
            double maind = Line2D.ptSegDist(this.x, this.y, p.x, p.y, xp, yp);
            if (maind < (double)d && !this.contains(xp, yp)) {
                tran.highlighted = true;
                this.lastHighlighted = tran;
                return true;
            }
            int i = 1;
            while (i < tran.points.size()) {
                Point p1 = tran.points.get(i - 1);
                Point p2 = tran.points.get(i);
                maind = Line2D.ptSegDist(p1.x, p1.y, p2.x, p2.y, xp, yp);
                if (maind < (double)d) {
                    tran.highlighted = true;
                    this.lastHighlighted = tran;
                    return true;
                }
                ++i;
            }
            p = tran.points.get(tran.points.size() - 1);
            maind = Line2D.ptSegDist(p.x, p.y, tran.nextState.x, tran.nextState.y, xp, yp);
            if (!(maind < (double)d) || tran.nextState.contains(xp, yp)) continue;
            tran.highlighted = true;
            this.lastHighlighted = tran;
            return true;
        }
        return false;
    }

    public void deleteLastHighlighted() {
        Check ch = this.bitmap.get(this.lastHighlighted.signal);
        if (ch != null) {
            --ch.refs;
            if (ch.refs == 0) {
                this.bitmap.remove(this.lastHighlighted.signal);
            }
        }
        this.trans.remove(this.lastHighlighted);
        if (this.trans.size() == 1) {
            for (Transition tran : this.trans) {
                if (!tran.other) continue;
                tran.other = false;
                tran.unconditional = true;
            }
        }
    }

    public void deleteAllTrans() {
        for (Transition tran : this.trans) {
            Check ch = this.bitmap.get(tran.signal);
            if (ch == null) continue;
            --ch.refs;
            if (ch.refs != 0) continue;
            this.bitmap.remove(tran.signal);
        }
        this.trans.clear();
    }

    public int getWidthInfo(FontMetrics fm) {
        int width = 0;
        for (Out out : this.outs) {
            width = Math.max(width, fm.stringWidth(out.signal));
        }
        for (Transition tr : this.trans) {
            width = Math.max(width, fm.stringWidth(tr.signal));
        }
        return width;
    }

    public Set<String> getInputs() {
        HashSet<String> inputs = new HashSet<String>();
        for (Transition tr : this.trans) {
            if (tr.signal.equals("") || tr.signal.equals("else")) continue;
            inputs.add(tr.signal);
        }
        return inputs;
    }

    public Set<String> getOutputs() {
        HashSet<String> outputs = new HashSet<String>();
        for (Out out : this.outs) {
            outputs.add(out.signal);
        }
        return outputs;
    }

    public void showOuts(Point mp, JDialog theDialog) {
        final JDialog show = new JDialog((Dialog)theDialog, false);
        Container window = show.getContentPane();
        this.addOuts(window);
        JButton close = new JButton("close window");
        close.setBackground(Color.green);
        window.add(close);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                show.dispose();
            }
        });
        show.setDefaultCloseOperation(2);
        show.pack();
        Point dp = theDialog.getLocationOnScreen();
        if (mp == null) {
            Dimension md = theDialog.getSize();
            Dimension sd = show.getSize();
            show.setLocation(dp.x + (md.width - sd.width) / 2, dp.y + (md.height - sd.height) / 2);
        } else {
            show.setLocation(mp.x + dp.x, mp.y + dp.y);
        }
        show.setVisible(true);
    }

    public void addOuts(Container window) {
        window.setBackground(Color.WHITE);
        window.setLayout(new GridLayout(this.outs.size() + 2, 1));
        JLabel title = new JLabel("Outputs for state: " + this.name);
        title.setOpaque(true);
        title.setBackground(Color.LIGHT_GRAY);
        window.add(title);
        for (Out out : this.outs) {
            window.add(new JLabel(out.toString(), 0));
        }
    }

    public void editOuts(JDialog theDialog) {
        new EditOutputs(theDialog);
    }

    public int maxWidth(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int max = fm.stringWidth("state: " + this.name);
        for (Out out : this.outs) {
            max = Math.max(max, fm.stringWidth(String.valueOf(out.signal) + "=" + out.value));
        }
        return max;
    }

    public int maxHeight(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int height = fm.getAscent() + fm.getDescent();
        return (this.outs.size() + 1) * height;
    }

    public void print(Graphics g, int x, int y) {
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int height = ascent + fm.getDescent();
        g.drawString("State: " + this.name, x, y + ascent);
        y += height;
        for (Out out : this.outs) {
            g.drawString(String.valueOf(out.signal) + "=" + out.value, x, y + ascent);
            y += height;
        }
    }

    public State getNextState() {
        State newState = null;
        for (Transition tran : this.trans) {
            if (tran.unconditional) {
                return tran.nextState;
            }
            if (tran.other) {
                newState = tran.nextState;
                continue;
            }
            BitSet inp = this.machine.getInput(tran.signal).getValue();
            if (inp == null) {
                inp = new BitSet();
            }
            long inputValue = BitSetUtils.ToLong(inp);
            if (tran.equal && inputValue == (long)tran.value) {
                return tran.nextState;
            }
            if (tran.equal || inputValue == (long)tran.value) continue;
            return tran.nextState;
        }
        return newState;
    }

    public void sendOutputs(StateMachine mach, long now, Simulator sim) {
        HashSet<Output> sent = new HashSet<Output>();
        for (Out out : this.outs) {
            Output output = this.machine.getOutput(out.signal);
            BitSet value = BitSetUtils.Create(out.value);
            output.propagate(value, now, sim);
            sent.add(output);
        }
        for (Output output : this.machine.getOutputs()) {
            if (sent.contains(output)) continue;
            output.propagate(new BitSet(), now, sim);
        }
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    void setX(int newx) {
        this.x = newx;
    }

    void setY(int newy) {
        this.y = newy;
    }

    boolean isInitial() {
        return this.initial;
    }

    int numOuts() {
        return this.outs.size();
    }

    private class Check {
        public int bits;
        public boolean isInput;
        public int refs;

        private Check() {
        }
    }

    private class CreateTrans
    extends JDialog
    implements ActionListener {
        private Transition trans;
        private State myState;
        private JButton ok;
        private JButton cancel;
        private JTextField signalField;
        private JButton equalOrNot;
        private JTextField valueField;
        private KeyPad valuePad;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton conditional;
        private JRadioButton unconditional;
        private JRadioButton otherwise;
        private boolean cancelled;

        public CreateTrans(Transition tr, State st, JDialog theDialog) {
            super(theDialog, "Create Transition", true);
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            this.signalField = new JTextField(10);
            this.equalOrNot = new JButton("=");
            this.valueField = new JTextField(10);
            this.valuePad = new KeyPad(this.valueField, 10, 0L, this);
            this.bitsField = new JTextField(10);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.conditional = new JRadioButton("conditional");
            this.unconditional = new JRadioButton("unconditional");
            this.otherwise = new JRadioButton("if no other condition");
            this.cancelled = false;
            this.trans = tr;
            this.myState = st;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel sigval = new JPanel(new BorderLayout());
            JPanel sig = new JPanel(new GridLayout(3, 1));
            sig.add(new JLabel("signal", 0));
            sig.add(this.signalField);
            sig.add(new JLabel(" "));
            sigval.add((Component)sig, "West");
            JPanel other = new JPanel(new BorderLayout());
            JPanel misc = new JPanel(new GridLayout(3, 1));
            misc.add(new JLabel(" "));
            misc.add(this.equalOrNot);
            misc.add(new JLabel("bits: ", 4));
            other.add((Component)misc, "West");
            JPanel values = new JPanel(new GridLayout(3, 1));
            values.add(new JLabel("value", 0));
            JPanel val = new JPanel(new BorderLayout());
            val.add((Component)this.valueField, "Center");
            val.add((Component)this.valuePad, "East");
            values.add(val);
            JPanel bits = new JPanel(new BorderLayout());
            bits.add((Component)this.bitsField, "Center");
            bits.add((Component)this.bitsPad, "East");
            values.add(bits);
            other.add((Component)values, "Center");
            sigval.add((Component)other, "Center");
            window.add(sigval);
            window.add(new JLabel(" "));
            window.add(this.conditional);
            if (this.trans.signal.equals("")) {
                window.add(this.unconditional);
            }
            window.add(this.otherwise);
            ButtonGroup g = new ButtonGroup();
            g.add(this.conditional);
            g.add(this.unconditional);
            g.add(this.otherwise);
            window.add(new JLabel(" "));
            JPanel okcancel = new JPanel(new GridLayout(1, 2));
            okcancel.add(this.ok);
            this.ok.setBackground(Color.GREEN);
            okcancel.add(this.cancel);
            this.cancel.setBackground(Color.PINK);
            window.add(okcancel);
            this.signalField.setText(tr.signal);
            if (tr.equal) {
                this.equalOrNot.setText("=");
            } else {
                this.equalOrNot.setText("!=");
            }
            this.valueField.setText(String.valueOf(tr.value));
            if (tr.bits == -1) {
                this.bitsField.setText("1");
            } else {
                this.bitsField.setText(String.valueOf(tr.bits));
            }
            if (tr.unconditional) {
                this.unconditional.setSelected(true);
                this.signalField.setEditable(false);
                this.valueField.setEditable(false);
                this.bitsField.setEditable(false);
            } else if (tr.other) {
                this.otherwise.setSelected(true);
                this.signalField.setEditable(false);
                this.valueField.setEditable(false);
                this.bitsField.setEditable(false);
            } else if (!tr.signal.equals("")) {
                this.signalField.setEditable(false);
                this.bitsField.setEditable(false);
            }
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.equalOrNot.addActionListener(this);
            this.conditional.addActionListener(this);
            this.unconditional.addActionListener(this);
            this.otherwise.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CreateTrans.this.cancelled = true;
                    CreateTrans.this.dispose();
                }
            });
            this.pack();
            this.setLocation(100, 100);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok) {
                if (this.unconditional.isSelected()) {
                    this.trans.unconditional = true;
                    this.trans.other = false;
                    this.dispose();
                    return;
                }
                if (this.otherwise.isSelected()) {
                    this.trans.unconditional = false;
                    this.trans.other = true;
                    this.dispose();
                    return;
                }
                if (this.signalField.getText().equals("")) {
                    JOptionPane.showMessageDialog(this, "Missing signal name", "Error", 0);
                    return;
                }
                if (this.signalField.getText().equals("else")) {
                    JOptionPane.showMessageDialog(this, "Invalid signal name", "Error", 0);
                    return;
                }
                if (this.signalField.getText().equals("clock")) {
                    JOptionPane.showMessageDialog(this, "Invalid signal name", "Error", 0);
                    return;
                }
                int hasBits = -1;
                for (State st : State.this.machine.getStates()) {
                    for (Transition tr : st.trans) {
                        if (!tr.signal.equals(this.signalField.getText())) continue;
                        hasBits = tr.bits;
                    }
                }
                int tempValue = 0;
                int tempBits = 0;
                try {
                    tempValue = Integer.parseInt(this.valueField.getText());
                    tempBits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Invalid numeric value", "Error", 0);
                    return;
                }
                if (hasBits > 0 && tempBits != hasBits) {
                    JOptionPane.showMessageDialog(this, "Bits don't match with previous signal specification of " + hasBits + " bits", "Error", 0);
                    return;
                }
                int newbits = Integer.parseInt(this.bitsField.getText());
                if (this.trans.bits != -1 && this.trans.bits != newbits) {
                    JOptionPane.showMessageDialog(this, "Bits don't match with previous signal specification of " + this.trans.bits + " bits", "Error", 0);
                    return;
                }
                if (Math.log(tempValue + 1) / Math.log(2.0) > (double)tempBits) {
                    JOptionPane.showMessageDialog(this, "Value too large for number of bits", "Error", 0);
                    return;
                }
                this.trans.unconditional = false;
                this.trans.other = false;
                this.trans.signal = this.signalField.getText();
                this.trans.equal = this.equalOrNot.getText().equals("=");
                this.trans.value = Integer.parseInt(this.valueField.getText());
                this.trans.bits = newbits;
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancelled = true;
                this.dispose();
            } else if (event.getSource() == this.equalOrNot) {
                if (this.equalOrNot.getText().equals("=")) {
                    this.equalOrNot.setText("!=");
                } else {
                    this.equalOrNot.setText("=");
                }
            } else if (event.getSource() == this.conditional) {
                if (this.trans.signal.equals("")) {
                    this.signalField.setEditable(true);
                    this.valueField.setEditable(true);
                    this.bitsField.setEditable(true);
                } else {
                    this.signalField.setEditable(false);
                    this.valueField.setEditable(true);
                    this.bitsField.setEditable(false);
                    BitSet used = new BitSet();
                    int bits = 0;
                    for (Transition tran : this.myState.trans) {
                        bits = this.trans.bits;
                        used.set(tran.value);
                    }
                    int val = used.nextClearBit(0);
                    if (val < 1 << bits) {
                        this.valueField.setText(String.valueOf(val));
                    }
                }
            } else if (event.getSource() == this.unconditional || event.getSource() == this.otherwise) {
                this.signalField.setEditable(false);
                this.valueField.setEditable(false);
                this.bitsField.setEditable(false);
            }
        }

        public boolean wasCancelled() {
            return this.cancelled;
        }
    }

    private class EditOutputs
    extends JDialog
    implements ActionListener {
        private JButton close;
        private JList outList;
        DefaultListModel model;
        private JButton add;
        private JButton delete;
        private JTextField signalField;
        private JTextField valueField;
        private KeyPad valuePad;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private boolean cancelled;

        public EditOutputs(JDialog theDialog) {
            super(theDialog, "Edit Outputs", true);
            this.close = new JButton("close window");
            this.add = new JButton("add new output");
            this.delete = new JButton("delete selected output");
            this.signalField = new JTextField(10);
            this.valueField = new JTextField("1");
            this.valuePad = new KeyPad(this.valueField, 10, 0L, this);
            this.bitsField = new JTextField("1");
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            this.model = new DefaultListModel();
            for (Out output : State.this.outs) {
                this.model.addElement(output);
            }
            this.outList = new JList(this.model);
            this.outList.setSelectionMode(0);
            JScrollPane pane = new JScrollPane(this.outList);
            pane.setSize(400, 400);
            window.add(pane);
            JPanel addDel = new JPanel(new FlowLayout());
            addDel.add(this.add);
            addDel.add(this.delete);
            window.add(addDel);
            JPanel sigval = new JPanel(new BorderLayout());
            JPanel sig = new JPanel(new GridLayout(3, 1));
            sig.add(new JLabel("signal", 0));
            sig.add(this.signalField);
            sig.add(new JLabel(" "));
            sigval.add((Component)sig, "West");
            JPanel other = new JPanel(new BorderLayout());
            JPanel misc = new JPanel(new GridLayout(3, 1));
            misc.add(new JLabel(" "));
            misc.add(new JLabel("="));
            misc.add(new JLabel("bits: ", 4));
            other.add((Component)misc, "West");
            JPanel values = new JPanel(new GridLayout(3, 1));
            values.add(new JLabel("value", 0));
            JPanel val = new JPanel(new BorderLayout());
            val.add((Component)this.valueField, "Center");
            val.add((Component)this.valuePad, "East");
            values.add(val);
            JPanel bits = new JPanel(new BorderLayout());
            bits.add((Component)this.bitsField, "Center");
            bits.add((Component)this.bitsPad, "East");
            values.add(bits);
            other.add((Component)values, "Center");
            sigval.add((Component)other, "Center");
            window.add(sigval);
            window.add(new JLabel(" "));
            JPanel cl = new JPanel(new GridLayout(1, 1));
            this.close.setBackground(Color.GREEN);
            cl.add(this.close);
            window.add(cl);
            this.close.addActionListener(this);
            this.add.addActionListener(this);
            this.delete.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    EditOutputs.this.dispose();
                }
            });
            this.pack();
            this.setLocation(100, 100);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int pos;
            if (event.getSource() == this.close) {
                this.dispose();
            } else if (event.getSource() == this.add) {
                Out newOut = new Out();
                newOut.signal = this.signalField.getText().trim();
                if (newOut.signal.equals("")) {
                    JOptionPane.showMessageDialog(this, "Missing signal name", "Error", 0);
                    return;
                }
                try {
                    newOut.value = Integer.parseInt(this.valueField.getText());
                    newOut.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value or bits not valid", "Error", 0);
                    return;
                }
                if (Math.log(newOut.value + 1L) / Math.log(2.0) > (double)newOut.bits) {
                    JOptionPane.showMessageDialog(this, "Value too large for number of bits", "Error", 0);
                    return;
                }
                for (Out out : State.this.outs) {
                    if (!out.signal.equals(newOut.signal)) continue;
                    JOptionPane.showMessageDialog(this, "Already an output with this name", "Error", 0);
                    return;
                }
                Check ch = (Check)State.this.bitmap.get(newOut.signal);
                if (ch == null) {
                    ch = new Check();
                    ch.bits = newOut.bits;
                    ch.isInput = false;
                    ch.refs = 1;
                    State.this.bitmap.put(newOut.signal, ch);
                } else {
                    if (ch.isInput) {
                        JOptionPane.showMessageDialog(this, "This signal is already an input", "Error", 0);
                        return;
                    }
                    if (ch.bits != newOut.bits) {
                        JOptionPane.showMessageDialog(this, "Bits not consistent with previous use of this signal", "Error", 0);
                        return;
                    }
                    ++ch.refs;
                }
                State.this.outs.add(newOut);
                this.model.addElement(newOut);
            } else if (event.getSource() == this.delete && (pos = this.outList.getSelectedIndex()) >= 0) {
                Out out = (Out)this.model.getElementAt(pos);
                Check ch = (Check)State.this.bitmap.get(out.signal);
                --ch.refs;
                if (ch.refs == 0) {
                    State.this.bitmap.remove(out.signal);
                }
                State.this.outs.remove(pos);
                this.model.remove(pos);
            }
        }

        public boolean wasCancelled() {
            return this.cancelled;
        }
    }

    private class Out {
        public String signal;
        public int bits;
        public long value;

        private Out() {
        }

        public String toString() {
            return String.valueOf(this.signal) + "[" + this.bits + "] = " + this.value;
        }
    }

    private class Transition {
        public String signal = "";
        public int bits = 1;
        public boolean equal = true;
        public int value = 0;
        public boolean unconditional = true;
        public boolean other = false;
        public State nextState;
        public String nextStateName = null;
        public Vector<Point> points = new Vector();
        public Point highlight = null;
        public boolean highlighted;

        private Transition() {
        }
    }
}

