/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem.bool;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.bool.Display;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class TruthTable
extends LogicElement
implements Printable {
    private static final int defaultDelay = 30;
    private static final int dialogWidth = 300;
    private static final int dialogHeight = 500;
    private String name = "";
    private int propDelay = 30;
    private Vector<String> inputNames = new Vector();
    private Vector<String> outputNames = new Vector();
    private int[][] table = new int[0][0];
    private boolean cancelled;
    private boolean nameChanged;
    private boolean anyChanges;
    TTEditor edit;
    Display disp;
    private int rows;
    private int cols;
    private int irow = 0;
    private int icol = 0;
    private Vector<String> iNCopy = new Vector();
    private Vector<String> oNCopy = new Vector();
    private int[][] tcopy = new int[0][0];
    private int[] toBeValue;

    public TruthTable(Circuit circ) {
        super(circ);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        this.edit = new TTEditor(this);
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        Point win = editWindow.getLocationOnScreen();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        if (g != null && this.width == 0 && this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            String dname = this.name;
            if (this.name.equals("")) {
                dname = "Logic";
            }
            this.width = fm.stringWidth(" " + dname + " ");
            for (String input : this.inputNames) {
                this.width = Math.max(this.width, fm.stringWidth(input));
            }
            for (String output : this.outputNames) {
                this.width = Math.max(this.width, fm.stringWidth(output));
            }
            this.width = (this.width + s - 1) / s * s + s;
        }
        HashSet<String> saveInputs = new HashSet<String>(this.inputNames);
        Vector<String> pins = new Vector<String>(this.inputNames.size() + this.outputNames.size());
        Vector<String> ins = new Vector<String>(this.inputNames);
        Vector<String> outs = new Vector<String>(this.outputNames);
        boolean takeFromInput = true;
        while (ins.size() + outs.size() > 0) {
            String pin;
            if (takeFromInput) {
                takeFromInput = false;
                if (ins.isEmpty()) continue;
                pin = ins.get(0);
                pins.add(pin);
                ins.remove(0);
                continue;
            }
            takeFromInput = true;
            if (outs.isEmpty()) continue;
            pin = outs.get(0);
            pins.add(pin);
            outs.remove(0);
        }
        this.height = s;
        for (String signal : pins) {
            if (saveInputs.contains(signal)) {
                Input in = new Input(signal, this, 0, this.height, 1);
                this.inputs.add(in);
                this.height += s;
                continue;
            }
            Output out = new Output(signal, this, this.width, this.height, 1);
            this.outputs.add(out);
            this.height += s;
        }
        this.height += 2 * s;
    }

    @Override
    public void draw(Graphics g) {
        int dy;
        int s = 12;
        int d2 = 3;
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int fontHeight = ascent + descent;
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.drawLine(this.x, this.y + this.height - 2 * s, this.x + this.width, this.y + this.height - 2 * s);
        String dname = this.name;
        if (this.name.equals("")) {
            dname = "Logic";
        }
        int w = fm.stringWidth(dname);
        g.drawString(dname, this.x + (this.width - w) / 2, this.y + this.height - s - fontHeight / 2 + ascent);
        for (Input input : this.inputs) {
            dy = input.getY();
            g.setColor(Color.black);
            g.drawString(input.getName(), this.x + d2, dy - fontHeight / 2 + ascent);
            input.draw(g);
        }
        for (Output output : this.outputs) {
            dy = output.getY();
            int ow = fm.stringWidth(output.getName());
            g.setColor(Color.black);
            g.drawString(output.getName(), this.x + this.width - ow - d2, dy - fontHeight / 2 + ascent);
            output.draw(g);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT TruthTable");
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" int delay " + this.propDelay);
        output.println(" int rows " + this.rows);
        output.println(" int cols " + this.cols);
        for (String in : this.inputNames) {
            output.println(" String input \"" + in + "\"");
        }
        for (String out : this.outputNames) {
            output.println(" String output \"" + out + "\"");
        }
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                output.println(" pair " + r + " " + this.table[r][c]);
                ++c;
            }
            ++r;
        }
        output.println("END");
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("name")) {
            this.name = value;
            this.circuit.addName(value);
        } else if (name.equals("input")) {
            this.inputNames.add(value);
        } else if (name.equals("output")) {
            this.outputNames.add(value);
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("rows")) {
            this.rows = value;
        } else if (name.equals("cols")) {
            this.cols = value;
            this.table = new int[this.rows][this.cols];
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setPair(int v1, int v2) {
        if (v1 != this.irow) {
            this.irow = v1;
            this.icol = 0;
        }
        this.table[v1][this.icol] = v2;
        ++this.icol;
    }

    @Override
    public Element copy() {
        TruthTable it = new TruthTable(this.circuit);
        it.name = new String(this.name);
        it.inputNames = new Vector<String>(this.inputNames);
        it.outputNames = new Vector<String>(this.outputNames);
        it.rows = this.table.length;
        it.cols = this.table[0].length;
        it.table = new int[this.rows][this.cols];
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                it.table[r][c] = this.table[r][c];
                ++c;
            }
            ++r;
        }
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        for (Output output : this.outputs) {
            it.outputs.add(output.copy(it));
        }
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("circuit determined by truth table");
    }

    @Override
    public void remove(Circuit circ) {
        circ.removeName(this.name);
        super.remove(circ);
    }

    @Override
    public int print(Graphics g, PageFormat format, int pagenum) {
        Graphics2D gg = (Graphics2D)g;
        Circuit c = this.circuit;
        String nm = String.valueOf(this.name) + " in " + this.circuit.getName();
        while (c.isImported()) {
            c = c.getSubElement().getCircuit();
            nm = String.valueOf(nm) + " in " + c.getName();
        }
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int fontHeight = ascent + descent;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, gg);
        Dimension bounds = this.disp.getPreferredSize();
        double width = format.getImageableWidth();
        double height = format.getImageableHeight();
        double scale = 1.0;
        if ((double)bounds.width > width) {
            scale = 1.0 * width / (double)bounds.width;
        }
        if ((double)bounds.height > height) {
            scale = Math.min(scale, 1.0 * height / (double)bounds.height);
        }
        gg.translate(format.getImageableX(), format.getImageableY());
        gg.drawString(nm, 0, ascent);
        gg.translate(0, 2 * fontHeight);
        gg.scale(scale, scale);
        this.disp.print(gg);
        return 0;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Display getDisplay() {
        return this.disp;
    }

    @Override
    public boolean canChange() {
        return true;
    }

    public boolean canCopy() {
        return false;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        this.iNCopy = new Vector<String>(this.inputNames);
        this.oNCopy = new Vector<String>(this.outputNames);
        int rows = this.table.length;
        int cols = this.table[0].length;
        this.tcopy = new int[rows][cols];
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                this.tcopy[r][c] = this.table[r][c];
                ++c;
            }
            ++r;
        }
        this.anyChanges = false;
        new TTEditor(this);
        if (this.cancelled) {
            return false;
        }
        if (this.anyChanges) {
            this.circuit.markChanged();
        }
        if (this.nameChanged || this.anyChanges) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        HashSet<String> oldNames = new HashSet<String>();
        for (Input input : this.inputs) {
            oldNames.add(input.getName());
        }
        HashSet<String> newNames = new HashSet<String>();
        newNames.addAll(this.inputNames);
        if (!oldNames.equals(newNames)) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        oldNames.clear();
        for (Output output : this.outputs) {
            oldNames.add(output.getName());
        }
        newNames.clear();
        newNames.addAll(this.outputNames);
        if (!oldNames.equals(newNames)) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        return false;
    }

    public void addInput(String signal) {
        int r;
        if (signal.equals("")) {
            return;
        }
        for (String name : this.inputNames) {
            if (!signal.equals(name)) continue;
            JOptionPane.showMessageDialog(this.edit, "duplicate signal name", "Error", 0);
            return;
        }
        for (String name : this.outputNames) {
            if (!signal.equals(name)) continue;
            JOptionPane.showMessageDialog(this.edit, "duplicate signal name", "Error", 0);
            return;
        }
        if (this.inputNames.size() == 0) {
            this.inputNames.add(signal);
            this.table = new int[2][1];
            this.table[0][0] = 0;
            this.table[1][0] = 1;
            this.rows = 2;
            this.cols = 1;
            this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
            this.disp.repaint();
            this.anyChanges = true;
            return;
        }
        int ins = this.inputNames.size();
        this.inputNames.add(signal);
        int newRows = this.rows * 2;
        int newCols = this.cols + 1;
        int[][] newTable = new int[newRows][newCols];
        int c = 0;
        while (c < ins) {
            int nr = 0;
            r = 0;
            while (r < this.rows) {
                newTable[nr][c] = this.table[r][c];
                newTable[nr + 1][c] = this.table[r][c];
                nr += 2;
                ++r;
            }
            ++c;
        }
        int nr = 0;
        int r2 = 0;
        while (r2 < this.rows) {
            newTable[nr][ins] = 0;
            newTable[nr + 1][ins] = 1;
            nr += 2;
            ++r2;
        }
        int c2 = ins;
        while (c2 < this.cols) {
            nr = 0;
            r = 0;
            while (r < this.rows) {
                newTable[nr][c2 + 1] = this.table[r][c2];
                newTable[nr + 1][c2 + 1] = this.table[r][c2];
                nr += 2;
                ++r;
            }
            ++c2;
        }
        this.table = newTable;
        this.cols = newCols;
        this.rows = newRows;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void addOutput(String signal) {
        if (signal.equals("")) {
            return;
        }
        for (String name : this.inputNames) {
            if (!signal.equals(name)) continue;
            JOptionPane.showMessageDialog(this.edit, "duplicate signal name", "Error", 0);
            return;
        }
        for (String name : this.outputNames) {
            if (!signal.equals(name)) continue;
            JOptionPane.showMessageDialog(this.edit, "duplicate signal name", "Error", 0);
            return;
        }
        if (this.inputNames.size() == 0) {
            JOptionPane.showMessageDialog(this.edit, "add at least one input first", "Error", 0);
            return;
        }
        int[][] newTable = new int[this.rows][this.cols + 1];
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                newTable[r][c] = this.table[r][c];
                ++c;
            }
            ++r;
        }
        this.outputNames.add(signal);
        r = 0;
        while (r < this.rows) {
            newTable[r][this.cols] = 2;
            ++r;
        }
        this.table = newTable;
        ++this.cols;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void removeInput(String signal) {
        int col = this.inputNames.indexOf(signal);
        TreeSet<Integer> dups = new TreeSet<Integer>();
        int r = 0;
        while (r < this.rows) {
            if (!dups.contains(r) && this.table[r][col] != 2) {
                int matchingRow = this.findMatchingRow(r, col);
                if (matchingRow == -1) {
                    JOptionPane.showMessageDialog(this.edit, "cannot remove: output conflict", "Error", 0);
                    return;
                }
                dups.add(matchingRow);
            }
            ++r;
        }
        int newRows = this.rows - dups.size();
        this.inputNames.remove(col);
        int[][] newTable = new int[newRows][this.cols - 1];
        int nr = 0;
        int r2 = 0;
        while (r2 < this.rows) {
            int nc = 0;
            if (!dups.contains(r2)) {
                int c = 0;
                while (c < this.cols) {
                    if (c != col) {
                        newTable[nr][nc] = this.table[r2][c];
                        ++nc;
                    }
                    ++c;
                }
                ++nr;
            }
            ++r2;
        }
        this.table = newTable;
        this.rows = newRows;
        --this.cols;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void removeOutput(String which) {
        int c;
        int pos = this.outputNames.indexOf(which);
        int col = this.inputNames.size() + pos;
        this.outputNames.remove(which);
        int[][] newTable = new int[this.rows][this.cols - 1];
        int r = 0;
        while (r < this.rows) {
            c = 0;
            while (c < col) {
                newTable[r][c] = this.table[r][c];
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows) {
            c = col;
            while (c < this.cols - 1) {
                newTable[r][c] = this.table[r][c + 1];
                ++c;
            }
            ++r;
        }
        this.table = newTable;
        --this.cols;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void toggleOutput(int row, int col) {
        this.table[row][col] = (this.table[row][col] + 1) % 3;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void makeDontCare(int row, int col) {
        int matchingRow = this.findMatchingRow(row, col);
        if (matchingRow == -1) {
            JOptionPane.showMessageDialog(this.edit, "not possible", "Error", 0);
            return;
        }
        int minRow = Math.min(row, matchingRow);
        int maxRow = Math.max(row, matchingRow);
        this.table[minRow][col] = 2;
        int c = this.inputNames.size();
        while (c < this.cols) {
            if (this.table[minRow][c] == 2) {
                this.table[minRow][c] = this.table[maxRow][c];
            }
            ++c;
        }
        this.removeRow(maxRow);
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public int findMatchingRow(int row, int ignore) {
        int r = 0;
        while (r < this.rows) {
            if (r != row) {
                boolean match = true;
                int c = 0;
                while (c < this.cols) {
                    if (c != ignore) {
                        if (c < this.inputNames.size()) {
                            if (this.table[r][c] != this.table[row][c]) {
                                match = false;
                                break;
                            }
                        } else if (this.table[r][c] != 2 && this.table[row][c] != 2 && this.table[r][c] != this.table[row][c]) {
                            match = false;
                            break;
                        }
                    }
                    ++c;
                }
                if (match) {
                    return r;
                }
            }
            ++r;
        }
        return -1;
    }

    public void removeRow(int row) {
        int[][] newTable = new int[this.rows - 1][this.cols];
        int r = 0;
        while (r < row) {
            newTable[r] = this.table[r];
            ++r;
        }
        r = row;
        while (r < this.rows - 1) {
            newTable[r] = this.table[r + 1];
            ++r;
        }
        this.table = newTable;
        --this.rows;
        this.anyChanges = true;
    }

    public void undoDontCare(int row, int col) {
        this.anyChanges = true;
        this.table[row][col] = 1;
        int newCode = this.makeRowCode(row);
        int ir = row + 1;
        while (ir < this.rows) {
            int thisCode = this.makeRowCode(ir);
            if (newCode < thisCode) {
                int c;
                int[][] newTable = new int[this.rows + 1][this.cols];
                int r = 0;
                while (r < ir) {
                    c = 0;
                    while (c < this.cols) {
                        newTable[r][c] = this.table[r][c];
                        ++c;
                    }
                    ++r;
                }
                int c2 = 0;
                while (c2 < this.cols) {
                    newTable[ir][c2] = this.table[row][c2];
                    ++c2;
                }
                r = this.rows - 1;
                while (r >= ir) {
                    c = 0;
                    while (c < this.cols) {
                        newTable[r + 1][c] = this.table[r][c];
                        ++c;
                    }
                    --r;
                }
                newTable[row][col] = 0;
                this.table = newTable;
                ++this.rows;
                this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
                this.disp.repaint();
                return;
            }
            ++ir;
        }
        int[][] newTable = new int[this.rows + 1][this.cols];
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                newTable[r][c] = this.table[r][c];
                ++c;
            }
            ++r;
        }
        int c = 0;
        while (c < this.cols) {
            newTable[this.rows][c] = this.table[row][c];
            ++c;
        }
        newTable[row][col] = 0;
        this.table = newTable;
        ++this.rows;
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
    }

    public int makeRowCode(int row) {
        int val = 0;
        int pos = 0;
        int c = this.inputNames.size() - 1;
        while (c >= 0) {
            if (this.table[row][c] == 1) {
                val += 1 << pos;
            }
            ++pos;
            --c;
        }
        return val;
    }

    public void renameInput(String signal) {
        String newSignal = this.getNewName(signal);
        if (newSignal == null) {
            return;
        }
        int pos = this.inputNames.indexOf(signal);
        this.inputNames.set(pos, newSignal);
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void renameOutput(String signal) {
        String newSignal = this.getNewName(signal);
        if (newSignal == null) {
            return;
        }
        int pos = this.outputNames.indexOf(signal);
        this.outputNames.set(pos, newSignal);
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    private String getNewName(String signal) {
        String newSignal = JOptionPane.showInputDialog(this.edit, (Object)"Enter new output signal name");
        if (newSignal == null) {
            return null;
        }
        if ((newSignal = newSignal.trim()).equals("")) {
            JOptionPane.showMessageDialog(this.edit, "invalid name", "Error", 0);
            return null;
        }
        for (String name : this.inputNames) {
            if (!newSignal.equals(name)) continue;
            JOptionPane.showMessageDialog(this.edit, "duplicate signal name");
            return null;
        }
        for (String name : this.outputNames) {
            if (!newSignal.equals(name)) continue;
            JOptionPane.showMessageDialog(this.edit, "duplicate signal name");
            return null;
        }
        return newSignal;
    }

    public void moveOutputLeft(String signal) {
        int pos = this.outputNames.indexOf(signal);
        if (pos == 0) {
            return;
        }
        this.outputNames.remove(pos);
        this.outputNames.add(pos - 1, signal);
        int col = this.inputNames.size() + pos;
        int r = 0;
        while (r < this.rows) {
            int temp = this.table[r][col];
            this.table[r][col] = this.table[r][col - 1];
            this.table[r][col - 1] = temp;
            ++r;
        }
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void moveOutputRight(String signal) {
        int pos = this.outputNames.indexOf(signal);
        if (pos == this.outputNames.size() - 1) {
            return;
        }
        this.outputNames.remove(pos);
        this.outputNames.add(pos + 1, signal);
        int col = this.inputNames.size() + pos;
        int r = 0;
        while (r < this.rows) {
            int temp = this.table[r][col];
            this.table[r][col] = this.table[r][col + 1];
            this.table[r][col + 1] = temp;
            ++r;
        }
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void moveInputLeft(String signal) {
        int pos = this.inputNames.indexOf(signal);
        if (pos == 0) {
            return;
        }
        this.inputNames.remove(pos);
        this.inputNames.add(pos - 1, signal);
        int r = 0;
        while (r < this.rows) {
            int temp = this.table[r][pos];
            this.table[r][pos] = this.table[r][pos - 1];
            this.table[r][pos - 1] = temp;
            ++r;
        }
        this.reorderRows();
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    public void moveInputRight(String signal) {
        int pos = this.inputNames.indexOf(signal);
        if (pos == this.inputNames.size() - 1) {
            return;
        }
        this.inputNames.remove(pos);
        this.inputNames.add(pos + 1, signal);
        int r = 0;
        while (r < this.rows) {
            int temp = this.table[r][pos];
            this.table[r][pos] = this.table[r][pos + 1];
            this.table[r][pos + 1] = temp;
            ++r;
        }
        this.reorderRows();
        this.disp.doLayout(this.inputNames, this.outputNames, this.table, null);
        this.disp.repaint();
        this.anyChanges = true;
    }

    private void reorderRows() {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        int r = 0;
        while (r < this.rows) {
            int newRow = this.makeRowCode(r);
            map.put(newRow, r);
            ++r;
        }
        int[][] newTable = new int[this.rows][this.cols];
        int row = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            int oldRow = (Integer)map.get(i);
            int c = 0;
            while (c < this.cols) {
                newTable[row][c] = this.table[oldRow][c];
                ++c;
            }
            ++row;
        }
        this.table = newTable;
        this.anyChanges = true;
    }

    public int getDefaultDelay() {
        return 30;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = this.getDefaultDelay();
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public void initSim(Simulator sim) {
        this.toBeValue = new int[this.outputNames.size()];
        int pos = 0;
        int offset = this.inputNames.size();
        for (Output output : this.outputs) {
            output.setValue(new BitSet());
            int outValue = this.table[0][pos + offset];
            if (outValue == 1) {
                this.toBeValue[pos] = 1;
                BitSet val = new BitSet(1);
                val.set(0);
                Out out = new Out();
                out.position = pos;
                out.value = val;
                sim.post(new SimEvent(this.propDelay, this, out));
            }
            ++pos;
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            int matchingRow = -1;
            int cols = this.inputNames.size();
            int row = 0;
            while (row < this.rows) {
                boolean match = true;
                int col = 0;
                while (col < cols) {
                    if (this.table[row][col] != 2) {
                        int inputValue;
                        BitSet inb = ((Input)this.inputs.get(col)).getValue();
                        if (inb == null) {
                            inb = new BitSet();
                        }
                        int n = inputValue = inb.get(0) ? 1 : 0;
                        if (inputValue != this.table[row][col]) {
                            match = false;
                            break;
                        }
                    }
                    ++col;
                }
                if (match) {
                    matchingRow = row;
                    break;
                }
                ++row;
            }
            int offset = this.inputNames.size();
            int pos = 0;
            for (Output output : this.outputs) {
                int outValue = this.table[matchingRow][pos + offset];
                if (outValue == 2) {
                    outValue = 0;
                }
                if (outValue != this.toBeValue[pos]) {
                    this.toBeValue[pos] = outValue;
                    BitSet val = new BitSet(1);
                    if (outValue == 1) {
                        val.set(0);
                    }
                    Out out = new Out();
                    out.position = pos;
                    out.value = val;
                    sim.post(new SimEvent(now + (long)this.propDelay, this, out));
                }
                ++pos;
            }
        } else {
            Out newOut = (Out)todo;
            Output out = (Output)this.outputs.get(newOut.position);
            BitSet val = newOut.value;
            BitSet newVal = (BitSet)val.clone();
            out.propagate(newVal, now, sim);
        }
    }

    public void printTable() {
        int i = 0;
        while (i < this.table.length) {
            int j = 0;
            while (j < this.table[0].length) {
                System.out.print(String.valueOf(this.table[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    class Out {
        int position;
        BitSet value;

        Out() {
        }
    }

    private class TTEditor
    extends JDialog
    implements ActionListener {
        private JTextField inputField;
        private JTextField outputField;
        private JTextField nameField;
        private JButton ok;
        private JButton cancel;

        public TTEditor(TruthTable ttelem) {
            super(JLSInfo.frame, "Edit Truth Table", true);
            this.inputField = new JTextField(10);
            this.outputField = new JTextField(10);
            this.nameField = new JTextField(10);
            this.ok = new JButton("ok");
            this.cancel = new JButton("cancel");
            TruthTable.this.disp = new Display(ttelem);
            TruthTable.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BorderLayout());
            JScrollPane pane = new JScrollPane(TruthTable.this.disp);
            window.add((Component)pane, "Center");
            JPanel other = new JPanel(new BorderLayout());
            JPanel info = new JPanel(new BorderLayout());
            JPanel labels = new JPanel(new GridLayout(3, 1));
            labels.add(new JLabel("new input: ", 4));
            labels.add(new JLabel("new output: ", 4));
            labels.add(new JLabel("name: ", 4));
            info.add((Component)labels, "West");
            JPanel inputs = new JPanel(new GridLayout(3, 1));
            inputs.add(this.inputField);
            inputs.add(this.outputField);
            inputs.add(this.nameField);
            this.nameField.setText(TruthTable.this.name);
            info.add((Component)inputs, "Center");
            other.add((Component)info, "North");
            JPanel okCancel = new JPanel(new GridLayout(1, 3));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "truth", null);
            }
            okCancel.add(help);
            other.add((Component)okCancel, "South");
            window.add((Component)other, "South");
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.inputField.addActionListener(this);
            this.outputField.addActionListener(this);
            this.nameField.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    TTEditor.this.cancel();
                }

                @Override
                public void windowOpened(WindowEvent event) {
                    ((TTEditor)TTEditor.this).TruthTable.this.disp.doLayout(TruthTable.this.inputNames, TruthTable.this.outputNames, TruthTable.this.table, null);
                    ((TTEditor)TTEditor.this).TruthTable.this.disp.repaint();
                }
            });
            this.setSize(300, 500);
            this.setLocation(100, 100);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField) {
                String tname = this.nameField.getText().trim();
                if (tname.equals("") || !Util.isValidName(tname)) {
                    JOptionPane.showMessageDialog(this, "Missing or invalid element name", "Error", 0);
                    return;
                }
                if (TruthTable.this.inputNames.size() == 0 || TruthTable.this.outputNames.size() == 0) {
                    JOptionPane.showMessageDialog(this, "Must have at least one input signal and one output signal", "Error", 0);
                    return;
                }
                if (tname.equals(TruthTable.this.name)) {
                    TruthTable.this.nameChanged = false;
                } else {
                    if (!TruthTable.this.circuit.addName(tname)) {
                        JOptionPane.showMessageDialog(this, "Duplicate element name", "Error", 0);
                        return;
                    }
                    TruthTable.this.nameChanged = true;
                    TruthTable.this.anyChanges = true;
                }
                TruthTable.this.name = tname;
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.inputField) {
                TruthTable.this.addInput(this.inputField.getText().trim());
                this.inputField.setText("");
            } else if (event.getSource() == this.outputField) {
                TruthTable.this.addOutput(this.outputField.getText().trim());
                this.outputField.setText("");
            }
        }

        private void cancel() {
            TruthTable.this.inputNames = TruthTable.this.iNCopy;
            TruthTable.this.outputNames = TruthTable.this.oNCopy;
            TruthTable.this.table = TruthTable.this.tcopy;
            TruthTable.this.cancelled = true;
            this.dispose();
        }
    }
}

