/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem.bool;

import edu.mtu.cs.jls.elem.bool.Entry;
import edu.mtu.cs.jls.elem.bool.TruthTable;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class OutputSig
extends Entry
implements ActionListener {
    private String signal;
    private JMenuItem remove = new JMenuItem("delete");
    private JMenuItem rename = new JMenuItem("rename");
    private JMenuItem moveLeft = new JMenuItem("move left");
    private JMenuItem moveRight = new JMenuItem("move right");

    public OutputSig(TruthTable ttelem, String signal, Graphics g) {
        super(ttelem);
        this.signal = signal;
        FontMetrics fm = g.getFontMetrics();
        this.minHeight = fm.getAscent() + fm.getDescent();
        this.minWidth = fm.stringWidth(" " + signal + " ");
    }

    @Override
    public void draw(Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int height = ascent + fm.getDescent();
        int width = fm.stringWidth(this.signal);
        g.setColor(Color.BLACK);
        g.drawString(this.signal, this.x + (this.width - width) / 2, this.y + (this.height - height) / 2 + ascent);
    }

    @Override
    public void selected(int row, int col) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.remove);
        menu.add(this.rename);
        menu.add(this.moveLeft);
        menu.add(this.moveRight);
        this.remove.addActionListener(this);
        this.rename.addActionListener(this);
        this.moveLeft.addActionListener(this);
        this.moveRight.addActionListener(this);
        menu.show(this.ttelem.getDisplay(), this.x, this.y);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.remove) {
            this.ttelem.removeOutput(this.signal);
        } else if (event.getSource() == this.rename) {
            this.ttelem.renameOutput(this.signal);
        } else if (event.getSource() == this.moveLeft) {
            this.ttelem.moveOutputLeft(this.signal);
        } else if (event.getSource() == this.moveRight) {
            this.ttelem.moveOutputRight(this.signal);
        }
    }
}

