/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem.bool;

import edu.mtu.cs.jls.elem.bool.Cross;
import edu.mtu.cs.jls.elem.bool.Entry;
import edu.mtu.cs.jls.elem.bool.HLine;
import edu.mtu.cs.jls.elem.bool.InputSig;
import edu.mtu.cs.jls.elem.bool.InputVal;
import edu.mtu.cs.jls.elem.bool.OutputSig;
import edu.mtu.cs.jls.elem.bool.OutputVal;
import edu.mtu.cs.jls.elem.bool.TruthTable;
import edu.mtu.cs.jls.elem.bool.VLine;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;

public final class Display
extends JPanel
implements MouseListener {
    private TruthTable ttelem;
    private Entry[][] dtable;
    private int rows;
    private int cols;

    public Display(TruthTable ttelem) {
        this.ttelem = ttelem;
        this.addMouseListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dtable == null) {
            return;
        }
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                this.dtable[r][c].draw(g);
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void print(Graphics g) {
        if (this.dtable == null) {
            return;
        }
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                this.dtable[r][c].draw(g);
                ++c;
            }
            ++r;
        }
    }

    public void doLayout(Vector<String> ins, Vector<String> outs, int[][] table, Graphics g) {
        int c;
        int r;
        int in = ins.size();
        int out = outs.size();
        this.cols = in + out + 1;
        this.rows = table.length + 2;
        this.dtable = new Entry[this.rows][this.cols];
        if (g == null) {
            g = this.getGraphics();
        }
        int c2 = 0;
        while (c2 < in) {
            this.dtable[0][c2] = new InputSig(this.ttelem, ins.get(c2), g);
            this.dtable[1][c2] = new HLine(this.ttelem);
            r = 2;
            while (r < this.rows) {
                this.dtable[r][c2] = new InputVal(this.ttelem, table[r - 2][c2], g);
                ++r;
            }
            ++c2;
        }
        this.dtable[0][in] = new VLine(this.ttelem);
        this.dtable[1][in] = new Cross(this.ttelem);
        int r2 = 2;
        while (r2 < this.rows) {
            this.dtable[r2][in] = new VLine(this.ttelem);
            ++r2;
        }
        c2 = in + 1;
        while (c2 < this.cols) {
            this.dtable[0][c2] = new OutputSig(this.ttelem, outs.get(c2 - in - 1), g);
            this.dtable[1][c2] = new HLine(this.ttelem);
            r = 2;
            while (r < this.rows) {
                this.dtable[r][c2] = new OutputVal(this.ttelem, table[r - 2][c2 - 1], g);
                ++r;
            }
            ++c2;
        }
        int[] heights = new int[this.rows];
        int totalHeight = 0;
        int r3 = 0;
        while (r3 < this.rows) {
            int maxHeight = 0;
            c = 0;
            while (c < this.cols) {
                maxHeight = Math.max(maxHeight, this.dtable[r3][c].getMinHeight());
                ++c;
            }
            heights[r3] = maxHeight;
            totalHeight += maxHeight;
            ++r3;
        }
        int[] widths = new int[this.cols];
        int totalWidth = 0;
        c = 0;
        while (c < this.cols) {
            int maxWidth = 0;
            int r4 = 0;
            while (r4 < this.rows) {
                maxWidth = Math.max(maxWidth, this.dtable[r4][c].getMinWidth());
                ++r4;
            }
            widths[c] = maxWidth;
            totalWidth += maxWidth;
            ++c;
        }
        int y = 0;
        int r5 = 0;
        while (r5 < this.rows) {
            int x = 0;
            int c3 = 0;
            while (c3 < this.cols) {
                this.dtable[r5][c3].setPosition(x, y);
                this.dtable[r5][c3].setSize(widths[c3], heights[r5]);
                x += widths[c3];
                ++c3;
            }
            y += heights[r5];
            ++r5;
        }
        this.setPreferredSize(new Dimension(totalWidth, totalHeight));
        this.revalidate();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        int r = 0;
        while (r < this.rows) {
            int c = 0;
            while (c < this.cols) {
                if (this.dtable[r][c].contains(x, y)) {
                    this.dtable[r][c].selected(r, c);
                    return;
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

