/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Rectangle;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class WireNet {
    private Set<WireEnd> ends = new HashSet<WireEnd>();
    private Set<Wire> wires = new HashSet<Wire>();
    private int bits = 0;
    private boolean hasinput = false;
    private boolean triState = false;
    private BitSet value = new BitSet(1);

    public Element copy() {
        return null;
    }

    public void add(WireEnd end) {
        this.ends.add(end);
    }

    public void remove(WireEnd end) {
        this.ends.remove(end);
    }

    public void add(Wire wire) {
        this.wires.add(wire);
    }

    public void remove(Wire wire) {
        this.wires.remove(wire);
    }

    public WireNet makeNet(WireEnd end) {
        for (Wire w : this.wires) {
            w.mark(false);
        }
        for (WireEnd e : this.ends) {
            e.mark(false);
        }
        end.traverse();
        WireNet net = new WireNet();
        for (Wire w : this.wires) {
            if (!w.isMarked()) continue;
            net.add(w);
            w.setNet(net);
        }
        for (WireEnd e : this.ends) {
            if (!e.isMarked()) continue;
            net.add(e);
            e.setNet(net);
        }
        this.bits = 0;
        this.hasinput = false;
        for (WireEnd e : net.ends) {
            if (!e.isAttached()) continue;
            Put put = e.getPut();
            net.bits = put.getBits();
            if (!(put instanceof Output)) continue;
            net.hasinput = true;
            Output out = (Output)put;
            if (!out.isTriState()) continue;
            net.setTriState(true);
        }
        if (!net.isTriState()) {
            for (WireEnd e : net.ends) {
                LogicElement el;
                if (!e.isAttached() || !((el = e.getPut().getElement()) instanceof TriProp)) continue;
                TriProp pin = (TriProp)((Object)el);
                pin.setTriState(false);
            }
        }
        return net;
    }

    public boolean isEmpty() {
        return this.ends.isEmpty();
    }

    public boolean hasInput() {
        return this.hasinput;
    }

    public void setInput() {
        this.hasinput = true;
    }

    public boolean contains(int x, int y) {
        return false;
    }

    public boolean intersects(Element other) {
        return false;
    }

    public boolean isInside(Rectangle rect) {
        return false;
    }

    public void setBits(int bits) {
        this.bits = Math.max(this.bits, bits);
    }

    public int getBits() {
        return this.bits;
    }

    public void absorb(WireNet other) {
        for (WireEnd end : other.ends) {
            this.ends.add(end);
            end.setNet(this);
        }
        for (Wire wire : other.wires) {
            this.wires.add(wire);
            wire.setNet(this);
        }
    }

    public void recheck() {
        this.hasinput = false;
        this.bits = 0;
        this.triState = false;
        for (WireEnd end : this.ends) {
            if (end.getPut() != null) {
                this.bits = Math.max(end.getPut().getBits(), this.bits);
            }
            if (!(end.getPut() instanceof Output)) continue;
            this.hasinput = true;
            Output out = (Output)end.getPut();
            if (!out.isTriState()) continue;
            this.triState = true;
        }
        if (!this.triState) {
            for (WireEnd end : this.ends) {
                LogicElement el;
                if (!end.isAttached() || !((el = end.getPut().getElement()) instanceof TriProp)) continue;
                TriProp pin = (TriProp)((Object)el);
                pin.setTriState(false);
            }
        }
    }

    public boolean netOverlap(WireNet other) {
        int overlaps = 0;
        for (WireEnd end1 : this.ends) {
            for (WireEnd end2 : other.ends) {
                if (!end1.intersects(end2)) continue;
                ++overlaps;
            }
        }
        for (Wire wire : this.wires) {
            for (WireEnd end2 : other.ends) {
                if (!wire.contains(end2.getX(), end2.getY())) continue;
                ++overlaps;
            }
        }
        return overlaps > 1;
    }

    public Set<WireEnd> getAllEnds() {
        return this.ends;
    }

    public void loadTriState() {
        this.triState = true;
    }

    public void setTriState(boolean which) {
        if (which) {
            this.value = null;
        }
        this.triState = which;
        for (WireEnd end : this.ends) {
            LogicElement el;
            if (!end.isAttached() || end.getPut() instanceof Output || !((el = end.getPut().getElement()) instanceof TriProp)) continue;
            TriProp tel = (TriProp)((Object)el);
            tel.setTriState(which);
        }
    }

    public boolean isTriState() {
        return this.triState;
    }

    public void setValue(BitSet value) {
        this.value = value == null ? null : (BitSet)value.clone();
    }

    public BitSet getValue() {
        if (this.value == null) {
            return null;
        }
        return (BitSet)this.value.clone();
    }

    public void propagate(BitSet value, long now, Simulator sim) {
        if (this.triState) {
            BitSet actual = null;
            for (WireEnd end : this.ends) {
                Output out;
                Put p;
                if (!end.isAttached() || !((p = end.getPut()) instanceof Output) || (out = (Output)p).getValue() == null) continue;
                actual = out.getValue();
                break;
            }
            value = actual;
        }
        for (WireEnd end : this.ends) {
            Put p;
            if (!end.isAttached() || !((p = end.getPut()) instanceof Input)) continue;
            BitSet newValue = null;
            if (value != null) {
                newValue = (BitSet)value.clone();
            }
            Input inp = (Input)p;
            inp.setValue(newValue);
            LogicElement element = p.getElement();
            sim.post(new SimEvent(now, element, null));
        }
        this.value = value == null ? null : (BitSet)value.clone();
    }
}

