/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.elem.WireNet;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;

public class WireEnd
extends LogicElement {
    private WireNet net;
    private Set<Wire> wires = new HashSet<Wire>();
    private Put put = null;
    private boolean touching = false;
    private boolean marked;
    private WireEnd myCopy;
    private int loadAttach;
    private String loadPut = null;
    private boolean loadTriState = false;
    private Set<Integer> loadWires = new HashSet<Integer>();
    private Map<Integer, String> probeMap = new HashMap<Integer, String>();

    public String toString() {
        return "WireEnd[" + this.net + "]";
    }

    public WireEnd(Circuit circuit) {
        super(circuit);
    }

    @Override
    public void init(Graphics g) {
    }

    public void init(Circuit circ) {
        this.width = 6;
        this.height = 6;
        this.fixPosition();
        block0: for (int elid : this.loadWires) {
            Wire wire2;
            if (this.loadPut != null) {
                Element elem = circ.getElementByID(this.loadAttach);
                Put p = elem.getPut(this.loadPut);
                p.setAttached(this);
                this.setPut(p);
            }
            WireEnd end = (WireEnd)circ.getElementByID(elid);
            for (Wire wire2 : this.wires) {
                WireEnd otherEnd = wire2.getOtherEnd(this);
                if (end == otherEnd) continue block0;
            }
            wire2 = new Wire(this, end);
            this.addWire(wire2);
            end.addWire(wire2);
            circ.addElement(wire2);
            String probeName = this.probeMap.get(elid);
            if (probeName == null) continue;
            wire2.attachProbe(probeName);
        }
    }

    @Override
    public WireEnd copy() {
        WireEnd it = new WireEnd(this.circuit);
        super.copy(it);
        this.myCopy = it;
        return it;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void addWire(Wire wire) {
        this.wires.add(wire);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getRect().contains(x, y);
    }

    @Override
    public boolean isInside(Rectangle rect) {
        return rect.contains(this.x, this.y);
    }

    @Override
    public void draw(Graphics g) {
        Color inside;
        if (this.touching) {
            inside = JLSInfo.touchColor;
        } else if (this.highlight) {
            inside = JLSInfo.highlightColor;
        } else if (this.put != null) {
            if (this.isAttached()) {
                return;
            }
            inside = Color.black;
        } else if (this.wires.size() <= 1) {
            inside = Color.WHITE;
        } else {
            if (this.degree() == 2) {
                return;
            }
            inside = Color.black;
        }
        g.setColor(Color.BLACK);
        int pd = 6;
        int pr = pd / 2;
        g.fillOval(this.x - pr, this.y - pr, pd, pd);
        g.setColor(inside);
        g.fillOval(this.x - pr + 1, this.y - pr + 1, pd - 2, pd - 2);
    }

    @Override
    public void remove(Circuit circ) {
        circ.remove(this);
        for (Wire wire : this.wires) {
            circ.remove(wire);
            wire.getOtherEnd(this).remove(wire, circ);
        }
    }

    public void remove(Wire wire) {
        this.wires.remove(wire);
    }

    public void remove(Wire wire, Circuit circ) {
        this.wires.remove(wire);
        circ.remove(wire);
        if (this.wires.isEmpty()) {
            if (this.isAttached()) {
                if (this.getPut() instanceof Output) {
                    this.put.setAttached(null);
                    this.put = null;
                } else if (this.getNet().isTriState() && this.put.getElement() instanceof TriProp) {
                    TriProp el = (TriProp)((Object)this.put.getElement());
                    this.put.setAttached(null);
                    this.put = null;
                    el.setTriState(false);
                } else {
                    this.put.setAttached(null);
                    this.put = null;
                }
            }
            circ.remove(this);
        } else {
            this.net = this.net.makeNet(this);
        }
    }

    public void setPut(Put put) {
        this.put = put;
    }

    public Put getPut() {
        return this.put;
    }

    public boolean isAttached() {
        return this.put != null;
    }

    @Override
    public boolean isTouching() {
        return this.touching;
    }

    @Override
    public void setTouching(boolean setting) {
        this.touching = setting;
    }

    @Override
    public int getBits() {
        return this.net.getBits();
    }

    public void setBits(int bits) {
        this.net.setBits(bits);
    }

    public void setTriState(boolean which) {
        this.loadTriState = which;
    }

    public boolean isTriState() {
        return this.net.isTriState();
    }

    @Override
    public void showInfo(JLabel info) {
        int bits;
        String inp = "";
        if (!this.net.hasInput()) {
            inp = ", no input";
        }
        if ((bits = this.net.getBits()) <= 0) {
            info.setText("not connected");
        } else if (bits == 1) {
            info.setText("1 bit" + inp);
        } else {
            info.setText(String.valueOf(bits) + " bits" + inp);
        }
    }

    public void mark(boolean which) {
        this.marked = which;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void traverse() {
        if (this.marked) {
            return;
        }
        this.marked = true;
        for (Wire w : this.wires) {
            w.traverse();
        }
    }

    public void setNet(WireNet net) {
        this.net = net;
    }

    public WireNet getNet() {
        return this.net;
    }

    public boolean isDangling() {
        return this.wires.size() <= 1 && !this.isAttached();
    }

    public Set<Wire> getWires() {
        return this.wires;
    }

    public Wire getOnlyWire() {
        if (this.wires.size() == 0) {
            return null;
        }
        return (Wire)this.wires.toArray()[0];
    }

    @Override
    public Rectangle getRect() {
        int d = 6;
        int r = d / 2;
        return new Rectangle(this.x - r, this.y - r, d, d);
    }

    public int degree() {
        return this.wires.size();
    }

    public WireEnd getCopy() {
        return this.myCopy;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT WireEnd");
        super.save(output);
        if (this.getNet().isTriState()) {
            output.println(" int tristate 1");
        }
        if (this.isAttached()) {
            String putname = this.getPut().getName();
            output.println(" String put \"" + putname + "\"");
            int elid = this.getPut().getElement().getID();
            output.println(" ref attach " + elid);
        }
        for (Wire wire : this.wires) {
            int elid = wire.getOtherEnd(this).getID();
            output.println(" ref wire " + elid);
            if (!wire.hasProbe()) continue;
            output.println(" probe " + elid + " \"" + wire.getProbe() + "\"");
        }
        output.println("END");
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("attach")) {
            this.loadAttach = value;
        } else if (name.equals("wire")) {
            this.loadWires.add(value);
        } else if (name.equals("tristate")) {
            this.loadTriState = value != 0;
        } else {
            super.setValue(name, value);
        }
    }

    public boolean isLoadTriState() {
        return this.loadTriState;
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("put")) {
            this.loadPut = value;
        } else {
            super.setValue(name, value);
        }
    }

    public void setProbe(int id, String name) {
        this.probeMap.put(id, name);
    }

    @Override
    public void initSim(Simulator sim) {
    }
}

