/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.elem.WireNet;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Wire
extends Element {
    private WireNet net;
    private WireEnd end1;
    private WireEnd end2;
    private boolean marked;
    private boolean touching;
    private String probeName = null;

    public Wire(WireEnd e1, WireEnd e2) {
        super(null);
        this.end1 = e1;
        this.end2 = e2;
    }

    @Override
    public void init(Graphics g) {
    }

    @Override
    public void move(int dx, int dy) {
    }

    public WireEnd getEnd() {
        return this.end1;
    }

    public WireEnd getOtherEnd(WireEnd end) {
        if (end == this.end1) {
            return this.end2;
        }
        return this.end1;
    }

    public void setEnds(WireEnd e1, WireEnd e2) {
        this.end1 = e1;
        this.end2 = e2;
    }

    @Override
    public void save(PrintWriter output) {
    }

    @Override
    public void draw(Graphics g) {
        if (this.touching) {
            g.setColor(JLSInfo.touchColor);
        } else if (this.highlight) {
            g.setColor(JLSInfo.highlightColor);
        } else if (this.getValue() == null) {
            g.setColor(Color.blue);
        } else if (!this.getValue().isEmpty()) {
            g.setColor(JLSInfo.nonZeroColor);
        } else {
            g.setColor(Color.black);
        }
        int x1 = this.end1.getX();
        int y1 = this.end1.getY();
        int x2 = this.end2.getX();
        int y2 = this.end2.getY();
        g.drawLine(x1, y1, x2, y2);
        if (this.probeName == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int len = fm.stringWidth(this.probeName);
        g.setColor(Color.BLUE);
        if (y1 == y2) {
            int mid = (x1 + x2) / 2;
            g.drawString(this.probeName, mid - len / 2, y1 - fm.getDescent());
        } else if (x1 == x2) {
            int mid = (y1 + y2) / 2;
            g.drawString(this.probeName, x1 + 1, mid);
        } else {
            double slope = (double)(y2 - y1) / (double)(x2 - x1);
            int midx = (x1 + x2) / 2;
            int midy = (y1 + y2) / 2;
            if (slope > 0.0) {
                g.drawString(this.probeName, midx, midy - fm.getDescent());
            } else {
                g.drawString(this.probeName, midx - len, midy - fm.getDescent());
            }
        }
    }

    public void setBits(int bits) {
        this.net.setBits(bits);
    }

    public int getBits() {
        return this.net.getBits();
    }

    @Override
    public boolean contains(int x, int y) {
        int x1 = this.end1.getX();
        int y1 = this.end1.getY();
        int x2 = this.end2.getX();
        int y2 = this.end2.getY();
        int d = 6;
        return Line2D.ptSegDist(x1, y1, x2, y2, x, y) < 6.0 && Point2D.distance(x1, y1, x, y) > (double)d && Point2D.distance(x2, y2, x, y) > (double)d;
    }

    public boolean intersects(Rectangle rect) {
        int y2;
        int x2;
        int y1;
        Rectangle r = rect;
        int x1 = this.end1.getX();
        if (r.intersectsLine(x1, y1 = this.end1.getY(), x2 = this.end2.getX(), y2 = this.end2.getY())) {
            Rectangle rs = new Rectangle(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
            return !rs.contains(x1, y1) && !rs.contains(x2, y2);
        }
        return false;
    }

    public boolean touches(WireEnd end) {
        if (end == this.end1 || end == this.end2) {
            return false;
        }
        int x = end.getX();
        int y = end.getY();
        int x1 = this.end1.getX();
        int y1 = this.end1.getY();
        int x2 = this.end2.getX();
        int y2 = this.end2.getY();
        int d = 6;
        if (Line2D.ptSegDist(x1, y1, x2, y2, x, y) < (double)(d / 2)) {
            if (Point.distance(x, y, x1, y1) < (double)(d / 2)) {
                return false;
            }
            return !(Point.distance(x, y, x2, y2) < (double)(d / 2));
        }
        return false;
    }

    @Override
    public void showInfo(JLabel info) {
        String tri = "";
        if (this.net.isTriState()) {
            tri = "(tri-state) ";
        }
        String inp = "";
        String value = "";
        if (!this.net.hasInput()) {
            inp = ", no input";
        } else {
            value = ", value = " + BitSetUtils.toDisplay(this.getValue(), this.net.getBits());
        }
        int bits = this.net.getBits();
        String probe = "";
        if (this.probeName != null) {
            probe = " (probe: " + this.probeName + ")";
        }
        if (bits <= 0) {
            info.setText(String.valueOf(tri) + "bits unknown" + probe);
        } else if (bits == 1) {
            info.setText(String.valueOf(tri) + "1 bit" + inp + probe + value);
        } else {
            info.setText(String.valueOf(tri) + bits + " bits" + inp + probe + value);
        }
    }

    @Override
    public void remove(Circuit circ) {
        circ.remove(this);
        this.end1.remove(this, circ);
        this.end2.remove(this, circ);
    }

    public void mark(boolean which) {
        this.marked = which;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public void traverse() {
        if (this.marked) {
            return;
        }
        this.marked = true;
        this.end1.traverse();
        this.end2.traverse();
    }

    public void setNet(WireNet net) {
        this.net = net;
    }

    @Override
    public boolean isInside(Rectangle rect) {
        return rect.contains(this.end1.getX(), this.end1.getY()) && rect.contains(this.end2.getX(), this.end2.getY());
    }

    @Override
    public void setTouching(boolean which) {
        this.touching = which;
    }

    public int length() {
        return (int)Point.distance(this.end1.getX(), this.end1.getY(), this.end2.getX(), this.end2.getY());
    }

    /*
     * Unable to fully structure code
     */
    public void attachProbe(String name) {
        if (name != null) {
            this.probeName = name;
            return;
        }
        name = JOptionPane.showInputDialog("Name?");
        if (name != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            name = JOptionPane.showInputDialog("Invalid name, try again");
            if (name != null) continue;
            return;
lbl10:
            // 2 sources

            ** while (name.equals((Object)""))
        }
lbl11:
        // 1 sources

        this.probeName = name;
    }

    public boolean hasProbe() {
        return this.probeName != null;
    }

    public String getProbe() {
        return this.probeName;
    }

    public void removeProbe() {
        this.probeName = null;
    }

    public BitSet getValue() {
        return this.net.getValue();
    }
}

