/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TriState
extends LogicElement {
    private static final int defaultBits = 1;
    private static final int defaultPropDelay = 5;
    private int bits = 1;
    private int propDelay = 5;
    private JLSInfo.Orientation gateOrientation = JLSInfo.Orientation.RIGHT;
    private JLSInfo.Orientation controlOrientation = JLSInfo.Orientation.DOWN;
    private boolean cancelled;

    public TriState(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new TriStateCreate(x + win.x, y + win.y);
        } else {
            new TriStateCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        Output out = null;
        if (this.gateOrientation == JLSInfo.Orientation.RIGHT) {
            this.width = 4 * s;
            this.height = 3 * s;
            if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
                this.inputs.add(new Input("input", this, 0, s, this.bits));
                this.inputs.add(new Input("control", this, 2 * s, 3 * s, 1));
                out = new Output("output", this, 4 * s, s, this.bits);
            } else if (this.controlOrientation == JLSInfo.Orientation.UP) {
                this.inputs.add(new Input("input", this, 0, 2 * s, this.bits));
                this.inputs.add(new Input("control", this, 2 * s, 0, 1));
                out = new Output("output", this, 4 * s, 2 * s, this.bits);
            }
        } else if (this.gateOrientation == JLSInfo.Orientation.LEFT) {
            this.width = 4 * s;
            this.height = 3 * s;
            if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
                this.inputs.add(new Input("input", this, 4 * s, s, this.bits));
                this.inputs.add(new Input("control", this, 2 * s, 3 * s, 1));
                out = new Output("output", this, 0, s, this.bits);
            } else if (this.controlOrientation == JLSInfo.Orientation.UP) {
                this.inputs.add(new Input("input", this, 4 * s, 2 * s, this.bits));
                this.inputs.add(new Input("control", this, 2 * s, 0, 1));
                out = new Output("output", this, 0, 2 * s, this.bits);
            }
        } else if (this.gateOrientation == JLSInfo.Orientation.UP) {
            this.width = 3 * s;
            this.height = 4 * s;
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                this.inputs.add(new Input("input", this, 2 * s, 4 * s, this.bits));
                this.inputs.add(new Input("control", this, 0, 2 * s, 1));
                out = new Output("output", this, 2 * s, 0, this.bits);
            } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
                this.inputs.add(new Input("input", this, s, 4 * s, this.bits));
                this.inputs.add(new Input("control", this, 3 * s, 2 * s, 1));
                out = new Output("output", this, s, 0, this.bits);
            }
        } else if (this.gateOrientation == JLSInfo.Orientation.DOWN) {
            this.width = 3 * s;
            this.height = 4 * s;
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                this.inputs.add(new Input("input", this, 2 * s, 0, this.bits));
                this.inputs.add(new Input("control", this, 0, 2 * s, 1));
                out = new Output("output", this, 2 * s, 4 * s, this.bits);
            } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
                this.inputs.add(new Input("input", this, s, 0, this.bits));
                this.inputs.add(new Input("control", this, 3 * s, 2 * s, 1));
                out = new Output("output", this, s, 4 * s, this.bits);
            }
        }
        this.outputs.add(out);
        out.setTriState(true);
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int s = 12;
        g.setColor(Color.black);
        if (this.gateOrientation == JLSInfo.Orientation.RIGHT) {
            int offset = 0;
            if (this.controlOrientation == JLSInfo.Orientation.UP) {
                offset = s;
            }
            g.drawLine(this.x, this.y + s + offset, this.x + s, this.y + s + offset);
            g.drawLine(this.x + s, this.y + offset, this.x + s, this.y + 2 * s + offset);
            g.drawLine(this.x + s, this.y + offset, this.x + 3 * s, this.y + s + offset);
            g.drawLine(this.x + s, this.y + 2 * s + offset, this.x + 3 * s, this.y + s + offset);
            g.drawLine(this.x + 3 * s, this.y + s + offset, this.x + 4 * s, this.y + s + offset);
            if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
                g.drawLine(this.x + 2 * s, (int)((double)(this.y + 2 * s) - 0.5 * (double)s), this.x + 2 * s, this.y + 3 * s);
            } else {
                g.drawLine(this.x + 2 * s, (int)((double)(this.y + s) + 0.5 * (double)s), this.x + 2 * s, this.y);
            }
        } else if (this.gateOrientation == JLSInfo.Orientation.LEFT) {
            int offset = 0;
            if (this.controlOrientation == JLSInfo.Orientation.UP) {
                offset = s;
            }
            g.drawLine(this.x, this.y + s + offset, this.x + s, this.y + s + offset);
            g.drawLine(this.x + 3 * s, this.y + offset, this.x + 3 * s, this.y + 2 * s + offset);
            g.drawLine(this.x + 3 * s, this.y + offset, this.x + s, this.y + s + offset);
            g.drawLine(this.x + 3 * s, this.y + 2 * s + offset, this.x + s, this.y + s + offset);
            g.drawLine(this.x + 3 * s, this.y + s + offset, this.x + 4 * s, this.y + s + offset);
            if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
                g.drawLine(this.x + 2 * s, (int)((double)(this.y + 2 * s) - 0.5 * (double)s), this.x + 2 * s, this.y + 3 * s);
            } else {
                g.drawLine(this.x + 2 * s, (int)((double)(this.y + s) + 0.5 * (double)s), this.x + 2 * s, this.y);
            }
        } else if (this.gateOrientation == JLSInfo.Orientation.UP) {
            int offset = 0;
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                offset = s;
            }
            g.drawLine(this.x + s + offset, this.y + 3 * s, this.x + s + offset, this.y + 4 * s);
            g.drawLine(this.x + offset, this.y + 3 * s, this.x + 2 * s + offset, this.y + 3 * s);
            g.drawLine(this.x + s + offset, this.y + s, this.x + 2 * s + offset, this.y + 3 * s);
            g.drawLine(this.x + s + offset, this.y + s, this.x + offset, this.y + 3 * s);
            g.drawLine(this.x + s + offset, this.y + s, this.x + s + offset, this.y);
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                g.drawLine(this.x, this.y + 2 * s, (int)((double)(this.x + s) + 0.5 * (double)s), this.y + 2 * s);
            } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
                g.drawLine((int)((double)(this.x + s) + 0.5 * (double)s), this.y + 2 * s, this.x + 3 * s, this.y + 2 * s);
            }
        } else if (this.gateOrientation == JLSInfo.Orientation.DOWN) {
            int offset = 0;
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                offset = s;
            }
            g.drawLine(this.x + s + offset, this.y + 3 * s, this.x + s + offset, this.y + 4 * s);
            g.drawLine(this.x + offset, this.y + s, this.x + 2 * s + offset, this.y + s);
            g.drawLine(this.x + offset, this.y + s, this.x + s + offset, this.y + 3 * s);
            g.drawLine(this.x + s + offset, this.y + 3 * s, this.x + 2 * s + offset, this.y + s);
            g.drawLine(this.x + s + offset, this.y + s, this.x + s + offset, this.y);
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                g.drawLine(this.x, this.y + 2 * s, (int)((double)(this.x + s) + 0.5 * (double)s), this.y + 2 * s);
            } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
                g.drawLine((int)((double)(this.x + s) + 0.5 * (double)s), this.y + 2 * s, this.x + 3 * s, this.y + 2 * s);
            }
        }
        ((Input)this.inputs.get(0)).draw(g);
        ((Input)this.inputs.get(1)).draw(g);
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("delay")) {
            this.propDelay = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT TriState");
        super.save(output);
        output.println(" int bits " + this.bits);
        output.println(" int delay " + this.propDelay);
        output.println(" String Gorient \"" + this.gateOrientation.toString() + "\"");
        output.println(" String Corient \"" + this.controlOrientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("Gorient")) {
            if (value.equals("LEFT")) {
                this.gateOrientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.gateOrientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.gateOrientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.gateOrientation = JLSInfo.Orientation.DOWN;
            }
        } else if (name.equals("Corient")) {
            if (value.equals("LEFT")) {
                this.controlOrientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.controlOrientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.controlOrientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.controlOrientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        TriState it = new TriState(this.circuit);
        it.bits = this.bits;
        it.gateOrientation = this.gateOrientation;
        it.controlOrientation = this.controlOrientation;
        it.propDelay = this.propDelay;
        it.inputs.add(((Input)this.inputs.get(0)).copy(it));
        it.inputs.add(((Input)this.inputs.get(1)).copy(it));
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        ((Output)it.outputs.get(0)).setTriState(true);
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        if (this.bits == 1) {
            info.setText("tri-state gate");
        } else {
            info.setText(String.valueOf(this.bits) + " tri-state gates");
        }
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = 5;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public boolean canFlip() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void flip(Graphics g) {
        if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
            this.controlOrientation = JLSInfo.Orientation.RIGHT;
        } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
            this.controlOrientation = JLSInfo.Orientation.LEFT;
        } else if (this.controlOrientation == JLSInfo.Orientation.UP) {
            this.controlOrientation = JLSInfo.Orientation.DOWN;
        } else if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
            this.controlOrientation = JLSInfo.Orientation.UP;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canRotate() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                this.controlOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
                this.controlOrientation = JLSInfo.Orientation.RIGHT;
            } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
                this.controlOrientation = JLSInfo.Orientation.UP;
            } else if (this.controlOrientation == JLSInfo.Orientation.UP) {
                this.controlOrientation = JLSInfo.Orientation.LEFT;
            }
            if (this.gateOrientation == JLSInfo.Orientation.LEFT) {
                this.gateOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.gateOrientation == JLSInfo.Orientation.DOWN) {
                this.gateOrientation = JLSInfo.Orientation.RIGHT;
            } else if (this.gateOrientation == JLSInfo.Orientation.RIGHT) {
                this.gateOrientation = JLSInfo.Orientation.UP;
            } else if (this.gateOrientation == JLSInfo.Orientation.UP) {
                this.gateOrientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.controlOrientation == JLSInfo.Orientation.LEFT) {
                this.controlOrientation = JLSInfo.Orientation.UP;
            } else if (this.controlOrientation == JLSInfo.Orientation.DOWN) {
                this.controlOrientation = JLSInfo.Orientation.LEFT;
            } else if (this.controlOrientation == JLSInfo.Orientation.RIGHT) {
                this.controlOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.controlOrientation == JLSInfo.Orientation.UP) {
                this.controlOrientation = JLSInfo.Orientation.RIGHT;
            }
            if (this.gateOrientation == JLSInfo.Orientation.LEFT) {
                this.gateOrientation = JLSInfo.Orientation.UP;
            } else if (this.gateOrientation == JLSInfo.Orientation.DOWN) {
                this.gateOrientation = JLSInfo.Orientation.LEFT;
            } else if (this.gateOrientation == JLSInfo.Orientation.RIGHT) {
                this.gateOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.gateOrientation == JLSInfo.Orientation.UP) {
                this.gateOrientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        out.setValue(null);
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet control = ((Input)this.inputs.get(1)).getValue();
            if (control == null) {
                control = new BitSet();
            }
            if (!control.get(0)) {
                sim.post(new SimEvent(now + (long)this.propDelay, this, "off"));
            } else {
                BitSet value = ((Input)this.inputs.get(0)).getValue();
                value = value == null ? new BitSet() : (BitSet)value.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, value));
            }
        } else if (todo instanceof String) {
            Output out = (Output)this.outputs.get(0);
            out.propagate(null, now, sim);
        } else {
            BitSet newValue = (BitSet)todo;
            Output out = (Output)this.outputs.get(0);
            out.propagate(newValue, now, sim);
        }
    }

    private class TriStateCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton oLeft;
        private JRadioButton oRight;
        private JRadioButton oUp;
        private JRadioButton oDown;
        private JRadioButton sLeft;
        private JRadioButton sRight;
        private JRadioButton sUp;
        private JRadioButton sDown;
        private JLabel olbl2;

        private TriStateCreate(int x, int y) {
            super(JLSInfo.frame, "Create TriState", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.bitsField = new JTextField("1", 10);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.oLeft = new JRadioButton("Left");
            this.oRight = new JRadioButton("Right", true);
            this.oUp = new JRadioButton("Up");
            this.oDown = new JRadioButton("Down");
            this.sLeft = new JRadioButton("Left");
            this.sRight = new JRadioButton("Right");
            this.sUp = new JRadioButton("Up");
            this.sDown = new JRadioButton("Down", true);
            this.olbl2 = new JLabel("Control Orientation");
            TriState.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel bits = new JLabel("Gates (bits): ", 4);
            info.add((Component)bits, "West");
            info.add((Component)this.bitsField, "Center");
            info.add((Component)this.bitsPad, "East");
            window.add(info);
            JPanel orient = new JPanel(new GridLayout(3, 3));
            JPanel orient2 = new JPanel(new GridLayout(3, 3));
            ButtonGroup gr = new ButtonGroup();
            ButtonGroup gr2 = new ButtonGroup();
            gr.add(this.oLeft);
            gr.add(this.oRight);
            gr.add(this.oDown);
            gr.add(this.oUp);
            gr2.add(this.sDown);
            gr2.add(this.sUp);
            gr2.add(this.sLeft);
            gr2.add(this.sRight);
            orient.add(new JLabel(""));
            orient.add(this.oUp);
            orient.add(new JLabel(""));
            orient.add(this.oLeft);
            orient.add(new JLabel(""));
            orient.add(this.oRight);
            orient.add(new JLabel(""));
            orient.add(this.oDown);
            orient.add(new JLabel(""));
            orient2.add(new JLabel(""));
            orient2.add(this.sUp);
            orient2.add(new JLabel(""));
            orient2.add(this.sLeft);
            orient2.add(new JLabel(""));
            orient2.add(this.sRight);
            orient2.add(new JLabel(""));
            orient2.add(this.sDown);
            orient2.add(new JLabel(""));
            JLabel olbl = new JLabel("Output Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            window.add(orient);
            this.olbl2.setAlignmentX(0.5f);
            window.add(this.olbl2);
            window.add(orient2);
            this.sLeft.setVisible(false);
            this.sRight.setVisible(false);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "TRISTATE", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.ok.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.oLeft.addActionListener(this);
            this.oRight.addActionListener(this);
            this.oUp.addActionListener(this);
            this.oDown.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TriStateCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.oLeft || event.getSource() == this.oRight) {
                this.olbl2.setVisible(true);
                this.sUp.setVisible(true);
                this.sDown.setVisible(true);
                this.sDown.setSelected(true);
                this.sLeft.setVisible(false);
                this.sRight.setVisible(false);
                return;
            }
            if (event.getSource() == this.oUp || event.getSource() == this.oDown) {
                this.olbl2.setVisible(true);
                this.sLeft.setVisible(true);
                this.sLeft.setSelected(true);
                this.sRight.setVisible(true);
                this.sUp.setVisible(false);
                this.sDown.setVisible(false);
                return;
            }
            if (event.getSource() == this.ok || event.getSource() == this.bitsField) {
                try {
                    TriState.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (TriState.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must be at least 1 bit", "Error", 0);
                    return;
                }
                if (this.oLeft.isSelected()) {
                    TriState.this.gateOrientation = JLSInfo.Orientation.LEFT;
                    if (this.sUp.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.UP;
                    } else if (this.sDown.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.DOWN;
                    }
                } else if (this.oRight.isSelected()) {
                    TriState.this.gateOrientation = JLSInfo.Orientation.RIGHT;
                    if (this.sUp.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.UP;
                    } else if (this.sDown.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.DOWN;
                    }
                } else if (this.oDown.isSelected()) {
                    TriState.this.gateOrientation = JLSInfo.Orientation.DOWN;
                    if (this.sLeft.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.LEFT;
                    } else if (this.sRight.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.RIGHT;
                    }
                } else if (this.oUp.isSelected()) {
                    TriState.this.gateOrientation = JLSInfo.Orientation.UP;
                    if (this.sLeft.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.LEFT;
                    } else if (this.sRight.isSelected()) {
                        TriState.this.controlOrientation = JLSInfo.Orientation.RIGHT;
                    }
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            TriState.this.cancelled = true;
            this.dispose();
        }
    }
}

