/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.DisplayElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Text
extends DisplayElement {
    private final int size = 500;
    private String text = "";
    private String fontName = "";
    private int fontSize = 0;
    private boolean isBold = false;
    private boolean isItalic = false;
    private Color color = Color.black;
    private Vector<String> lines = new Vector();
    private boolean cancelled = false;
    private boolean changed;

    public Text(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        this.cancelled = false;
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        this.text = pos == null ? new TextEdit(x + win.x, y + win.y, true).getText() : new TextEdit(pos.x + win.x, pos.y + win.y, true).getText();
        if (this.cancelled) {
            return false;
        }
        if (this.text.length() == 0) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        this.lines.clear();
        String str = "";
        int p = 0;
        while (p < this.text.length()) {
            char c = this.text.charAt(p);
            if (c == '\n') {
                this.lines.add(str);
                str = "";
            } else {
                str = String.valueOf(str) + c;
            }
            ++p;
        }
        if (!str.equals("")) {
            this.lines.add(str);
        }
        if (g == null) {
            return;
        }
        if (this.fontName.equals("")) {
            this.fontName = g.getFont().getFamily();
        }
        if (this.fontSize == 0) {
            this.fontSize = g.getFont().getSize();
        }
        int bi = 0;
        if (this.isBold) {
            bi |= 1;
        }
        if (this.isItalic) {
            bi |= 2;
        }
        Font f = new Font(this.fontName, bi, this.fontSize);
        Graphics gg = g.create();
        gg.setFont(f);
        FontMetrics fm = gg.getFontMetrics();
        int textHeight = fm.getAscent() + fm.getDescent();
        this.width = 0;
        this.height = 0;
        for (String line : this.lines) {
            if (fm.stringWidth(line) > this.width) {
                this.width = fm.stringWidth(line);
            }
            this.height += textHeight;
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("text")) {
            this.text = value;
        } else if (name.equals("fn")) {
            this.fontName = value;
        }
        super.setValue(name, value);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("fs")) {
            this.fontSize = value;
        } else if (name.equals("bold")) {
            this.isBold = value == 1;
        } else if (name.equals("ital")) {
            this.isItalic = value == 1;
        } else if (name.equals("color")) {
            this.color = new Color(value);
        }
        super.setValue(name, value);
    }

    @Override
    public Text copy() {
        Text it = new Text(this.circuit);
        super.copy(it);
        it.text = this.text;
        it.fontName = this.fontName;
        it.fontSize = this.fontSize;
        it.isBold = this.isBold;
        it.isItalic = this.isItalic;
        it.color = this.color;
        for (String line : this.lines) {
            it.lines.add(line);
        }
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Text");
        super.save(output);
        String str = this.text.replace("\\", "\\\\");
        str = str.replace("\"", "\\\"");
        str = str.replace("\n", "\\n");
        output.println(" String text \"" + str + "\"");
        output.println(" String fn \"" + this.fontName + "\"");
        output.println(" int fs " + this.fontSize);
        output.println(" int bold " + (this.isBold ? 1 : 0));
        output.println(" int ital " + (this.isItalic ? 1 : 0));
        output.println(" int color " + this.color.getRGB());
        output.println("END");
    }

    @Override
    public void draw(Graphics g) {
        Graphics myg = g.create();
        int bi = 0;
        if (this.isBold) {
            bi |= 1;
        }
        if (this.isItalic) {
            bi |= 2;
        }
        myg.setFont(new Font(this.fontName, bi, this.fontSize));
        FontMetrics fm = myg.getFontMetrics();
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int height = ascent + descent;
        this.height = 0;
        this.width = 0;
        for (String str : this.lines) {
            this.height += height;
            this.width = Math.max(this.width, fm.stringWidth(str));
        }
        super.draw(g);
        int y = this.y + ascent;
        myg.setColor(this.color);
        for (String str : this.lines) {
            myg.drawString(str, this.x, y);
            y += height;
        }
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        this.cancelled = false;
        this.changed = false;
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        TextEdit ed = null;
        ed = pos == null ? new TextEdit(x + win.x, y + win.y, false) : new TextEdit(pos.x + win.x, pos.y + win.y, false);
        if (this.cancelled) {
            return false;
        }
        if (this.text.equals(ed.getText()) && !this.changed) {
            return false;
        }
        this.text = ed.getText();
        this.width = 0;
        this.height = 0;
        this.init(g);
        return true;
    }

    private class TextEdit
    extends JDialog
    implements ActionListener {
        private JComboBox fonts;
        private String[] fontSizes;
        private JComboBox fontSz;
        private JRadioButton bold;
        private JRadioButton italic;
        private JButton colorButton;
        private JTextArea textArea;
        private JButton ok;
        private JButton cancel;
        private String result;
        private String fn;
        private int fs;
        private boolean isB;
        private boolean isI;
        private Color col;

        public TextEdit(int x, int y, boolean creating) {
            super(JLSInfo.frame, "Create/Modify Text Element", true);
            this.fontSizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "24", "28", "32", "36", "40", "48", "56", "64", "72"};
            this.fontSz = new JComboBox<String>(this.fontSizes);
            this.bold = new JRadioButton("Bold");
            this.italic = new JRadioButton("Italic");
            this.colorButton = new JButton("Color");
            this.textArea = new JTextArea();
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.result = "";
            this.fn = "";
            this.fs = 0;
            this.isB = false;
            this.isI = false;
            this.col = Color.black;
            Container window = this.getContentPane();
            window.setLayout(new BorderLayout());
            JPanel details = new JPanel(new FlowLayout());
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] names = ge.getAvailableFontFamilyNames();
            if (Text.this.fontName.equals("")) {
                Font f = this.textArea.getFont();
                this.fn = f.getFamily();
            } else {
                this.fn = new String(Text.this.fontName);
            }
            this.fonts = new JComboBox<String>(names);
            this.fonts.setSelectedItem(this.fn);
            details.add(new JLabel("Font:"));
            details.add(this.fonts);
            this.fs = Text.this.fontSize == 0 ? this.textArea.getFont().getSize() : Text.this.fontSize;
            this.fontSz.setSelectedItem(String.valueOf(this.fs));
            this.fontSz.setEditable(true);
            details.add(new JLabel("Size:"));
            details.add(this.fontSz);
            if (Text.this.isBold) {
                this.bold.setSelected(true);
                this.isB = true;
            }
            details.add(this.bold);
            if (Text.this.isItalic) {
                this.italic.setSelected(true);
                this.isI = true;
            }
            details.add(this.italic);
            details.add(this.colorButton);
            this.fonts.addActionListener(this);
            this.fontSz.addActionListener(this);
            this.bold.addActionListener(this);
            this.italic.addActionListener(this);
            this.colorButton.addActionListener(this);
            window.add((Component)details, "North");
            if (!creating) {
                this.textArea.setText(Text.this.text);
                int bi = 0;
                if (Text.this.isBold) {
                    bi |= 1;
                }
                if (Text.this.isItalic) {
                    bi |= 2;
                }
                this.textArea.setFont(new Font(Text.this.fontName, bi, Text.this.fontSize));
                this.textArea.setForeground(Text.this.color);
            }
            JScrollPane pane = new JScrollPane(this.textArea);
            pane.setPreferredSize(new Dimension(500, 500));
            window.add((Component)pane, "Center");
            JPanel buttons = new JPanel();
            buttons.setLayout(new GridLayout(1, 3));
            buttons.add(this.ok);
            buttons.add(this.cancel);
            this.ok.setBackground(Color.green);
            this.cancel.setBackground(Color.pink);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "text", null);
            }
            buttons.add(help);
            window.add((Component)buttons, "South");
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    TextEdit.this.textArea.requestFocusInWindow();
                }
            });
            this.pack();
            this.setLocation(x - 250, y - 250);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.fonts) {
                this.fn = (String)this.fonts.getSelectedItem();
                int bi = 0;
                if (this.isB) {
                    bi |= 1;
                }
                if (this.isI) {
                    bi |= 2;
                }
                this.textArea.setFont(new Font(this.fn, bi, this.fs));
                Text.this.changed = true;
                return;
            }
            if (event.getSource() == this.fontSz) {
                try {
                    this.fs = Integer.parseInt((String)this.fontSz.getSelectedItem());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Invalid Font Size");
                    return;
                }
                if (this.fs < 1) {
                    JOptionPane.showMessageDialog(this, "Invalid Font Size");
                    return;
                }
                int bi = 0;
                if (this.isB) {
                    bi |= 1;
                }
                if (this.isI) {
                    bi |= 2;
                }
                this.textArea.setFont(new Font(this.fn, bi, this.fs));
                Text.this.changed = true;
                return;
            }
            if (event.getSource() == this.bold) {
                this.isB = this.bold.isSelected();
                int bi = 0;
                if (this.isB) {
                    bi |= 1;
                }
                if (this.isI) {
                    bi |= 2;
                }
                this.textArea.setFont(new Font(this.fn, bi, this.fs));
                Text.this.changed = true;
                return;
            }
            if (event.getSource() == this.italic) {
                this.isI = this.italic.isSelected();
                int bi = 0;
                if (this.isB) {
                    bi |= 1;
                }
                if (this.isI) {
                    bi |= 2;
                }
                this.textArea.setFont(new Font(this.fn, bi, this.fs));
                Text.this.changed = true;
                return;
            }
            if (event.getSource() == this.colorButton) {
                final JColorChooser ch = new JColorChooser(Text.this.color);
                ch.setPreviewPanel(new JPanel());
                ActionListener ok = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        TextEdit.this.col = ch.getColor();
                        TextEdit.this.textArea.setForeground(TextEdit.this.col);
                        Text.this.changed = true;
                    }
                };
                JDialog cl = JColorChooser.createDialog(this, "pick", true, ch, ok, null);
                cl.setVisible(true);
                cl.dispose();
                return;
            }
            if (event.getSource() == this.ok) {
                this.result = this.textArea.getText();
                if (Text.this.changed) {
                    Text.this.fontName = new String(this.fn);
                    Text.this.fontSize = this.fs;
                    Text.this.isBold = this.isB;
                    Text.this.isItalic = this.isI;
                    Text.this.color = this.col;
                }
            } else if (event.getSource() == this.cancel) {
                Text.this.cancelled = true;
            }
            this.dispose();
        }

        public String getText() {
            return this.result;
        }
    }
}

