/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.InputPin;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.OutputPin;
import edu.mtu.cs.jls.elem.Pin;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class SubCircuit
extends LogicElement
implements TriProp {
    private Circuit subCircuit;
    private String name;
    private Map<Input, InputPin> inmap = new HashMap<Input, InputPin>();
    private Map<OutputPin, Output> outmap = new HashMap<OutputPin, Output>();
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    protected boolean cancelled;
    private Set<InputPin> pinsChecked = new HashSet<InputPin>();

    public String toString() {
        String result = "SubCircuit[" + this.name + ",";
        switch (this.orientation) {
            case RIGHT: {
                result = String.valueOf(result) + "right";
                break;
            }
            case LEFT: {
                result = String.valueOf(result) + "left";
                break;
            }
            case UP: {
                result = String.valueOf(result) + "up";
                break;
            }
            case DOWN: {
                result = String.valueOf(result) + "down";
                break;
            }
            default: {
                result = String.valueOf(result) + "unknown";
            }
        }
        result = String.valueOf(result) + ",inputs={";
        boolean firstTime = true;
        for (Input input : this.inmap.keySet()) {
            if (!firstTime) {
                result = String.valueOf(result) + ",";
            }
            firstTime = false;
            result = String.valueOf(result) + input.getName();
        }
        result = String.valueOf(result) + "},outputs={";
        firstTime = true;
        for (OutputPin outputPin : this.outmap.keySet()) {
            if (!firstTime) {
                result = String.valueOf(result) + ',';
            }
            firstTime = false;
            result = String.valueOf(result) + outputPin.getName();
        }
        result = String.valueOf(result) + "}]";
        return result;
    }

    public SubCircuit(Circuit circuit) {
        super(circuit);
    }

    public void setSubCircuit(Circuit subCirc) {
        this.subCircuit = subCirc;
    }

    public Circuit getSubCircuit() {
        return this.subCircuit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new SubCreate(x + win.x, y + win.y);
        } else {
            new SubCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        if (g != null && this.width == 0 && this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            this.width = fm.stringWidth(" " + this.name + " ");
            for (Element el : this.subCircuit.getElements()) {
                if (!(el instanceof InputPin) && !(el instanceof OutputPin)) continue;
                Pin p = (Pin)el;
                String name = p.getName();
                this.width = Math.max(this.width, fm.stringWidth(name));
            }
            this.width = (this.width + s - 1) / s * s + s;
        }
        Comparator<Pin> cmp = new Comparator<Pin>(){

            @Override
            public int compare(Pin s1, Pin s2) {
                return s1.getName().compareTo(s2.getName());
            }
        };
        TreeSet<Pin> inputList = new TreeSet<Pin>(cmp);
        TreeSet<Pin> outputList = new TreeSet<Pin>(cmp);
        for (Element el : this.subCircuit.getElements()) {
            if (el instanceof InputPin) {
                InputPin inputPin = (InputPin)el;
                inputList.add(inputPin);
                continue;
            }
            if (!(el instanceof OutputPin)) continue;
            OutputPin outputPin = (OutputPin)el;
            outputList.add(outputPin);
        }
        Vector<Pin> pins = new Vector<Pin>(inputList.size() + outputList.size());
        boolean fromInput = true;
        while (inputList.size() + outputList.size() > 0) {
            if (fromInput) {
                fromInput = false;
                if (inputList.isEmpty()) continue;
                InputPin inputPin = (InputPin)inputList.first();
                pins.add(inputPin);
                inputList.remove(inputPin);
                continue;
            }
            fromInput = true;
            if (outputList.isEmpty()) continue;
            OutputPin outputPin = (OutputPin)outputList.first();
            pins.add(outputPin);
            outputList.remove(outputPin);
        }
        this.height = s;
        for (Pin pin : pins) {
            if (pin instanceof InputPin) {
                InputPin pin2 = (InputPin)pin;
                Input in = this.orientation == JLSInfo.Orientation.RIGHT ? new Input(pin2.getName(), this, 0, this.height, pin2.getBits()) : new Input(pin2.getName(), this, this.width, this.height, pin2.getBits());
                this.inputs.add(in);
                this.height += s;
                this.inmap.put(in, pin2);
                continue;
            }
            if (!(pin instanceof OutputPin)) continue;
            OutputPin pin2 = (OutputPin)pin;
            Output out = this.orientation == JLSInfo.Orientation.RIGHT ? new Output(pin2.getName(), this, this.width, this.height, pin2.getBits()) : new Output(pin2.getName(), this, 0, this.height, pin2.getBits());
            this.outputs.add(out);
            this.height += s;
            this.outmap.put(pin2, out);
            for (Input input : pin2.inputs) {
                if (!input.isAttached()) continue;
                out.setTriState(input.getWireEnd().isTriState());
            }
            if (!pin2.isLoadTriState()) continue;
            out.loadSetTriState();
        }
        this.height += 2 * s;
    }

    @Override
    public void draw(Graphics g) {
        String name;
        super.draw(g);
        int s = 12;
        g.setColor(Color.BLACK);
        g.drawRect(this.x, this.y, this.width, this.height);
        int yy = this.y + this.height - 2 * s;
        g.drawLine(this.x, yy, this.x + this.width, yy);
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        Rectangle2D rect = fm.getStringBounds(this.name, g);
        int dx = (int)Math.round(((double)this.width - rect.getWidth()) / 2.0);
        int dy = (int)Math.round(((double)(2 * s) - rect.getHeight()) / 2.0);
        g.drawString(this.name, this.x + dx, yy + dy + ascent);
        for (Input input : this.inputs) {
            input.draw(g);
            name = input.getName();
            rect = fm.getStringBounds(name, g);
            g.setColor(Color.BLACK);
            if (this.orientation == JLSInfo.Orientation.RIGHT) {
                dx = 4;
                dy = ascent - (int)Math.round(rect.getHeight() / 2.0);
            } else {
                dx = (int)((double)this.width - rect.getWidth() - 4.0);
                dy = ascent - (int)Math.round(rect.getHeight() / 2.0);
            }
            g.drawString(name, this.x + dx, input.getY() + dy);
        }
        for (Output output : this.outputs) {
            output.draw(g);
            name = output.getName();
            rect = fm.getStringBounds(name, g);
            g.setColor(Color.BLACK);
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                dx = 4;
                dy = ascent - (int)Math.round(rect.getHeight() / 2.0);
            } else {
                dx = (int)((double)this.width - rect.getWidth() - 4.0);
                dy = ascent - (int)Math.round(rect.getHeight() / 2.0);
            }
            g.drawString(name, this.x + dx, output.getY() + dy);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT SubCircuit");
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        super.save(output);
        this.subCircuit.save(output);
        output.println("END");
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        Pin pin;
        SubCircuit it = new SubCircuit(this.circuit);
        it.name = new String(this.name);
        it.subCircuit = new Circuit(this.subCircuit.getName());
        it.subCircuit.setImported(it);
        it.orientation = this.orientation;
        HashSet<Element> elements = new HashSet<Element>();
        for (Element el : this.subCircuit.getElements()) {
            WireEnd end;
            if (el instanceof WireEnd && (end = (WireEnd)el).isAttached()) continue;
            elements.add(el);
        }
        Util.copy(elements, it.subCircuit);
        Util.partition(it.subCircuit);
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        for (Output output : this.outputs) {
            it.outputs.add(output.copy(it));
        }
        for (Input input : it.inputs) {
            for (Element el : it.subCircuit.getElements()) {
                if (!(el instanceof InputPin)) continue;
                pin = (InputPin)el;
                if (!input.getName().equals(pin.getName())) continue;
                it.inmap.put(input, (InputPin)pin);
            }
        }
        for (Output output : it.outputs) {
            for (Element el : it.subCircuit.getElements()) {
                if (!(el instanceof OutputPin)) continue;
                pin = (OutputPin)el;
                if (!output.getName().equals(pin.getName())) continue;
                it.outmap.put((OutputPin)pin, output);
            }
        }
        super.copy(it);
        return it;
    }

    @Override
    public void remove(Circuit circ) {
        circ.removeName(this.name);
        super.remove(circ);
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.subCircuit.getName()) + " (a subcircuit)");
    }

    @Override
    public void setWatched(boolean which) {
        for (Element element : this.subCircuit.getElements()) {
            if (!(element instanceof LogicElement)) continue;
            ((LogicElement)element).setWatched(which);
        }
    }

    @Override
    public void resetPropDelay() {
        this.subCircuit.resetAllDelays();
    }

    @Override
    public boolean canChange() {
        return true;
    }

    public void remapPins(Circuit circ) {
        this.inmap.clear();
        this.outmap.clear();
        for (Element el : circ.getElements()) {
            Pin pin;
            if (el instanceof InputPin) {
                pin = (InputPin)el;
                for (Input in : this.inputs) {
                    if (!in.getName().equals(pin.getName())) continue;
                    this.inmap.put(in, (InputPin)pin);
                }
                continue;
            }
            if (!(el instanceof OutputPin)) continue;
            pin = (OutputPin)el;
            for (Output out : this.outputs) {
                if (!out.getName().equals(pin.getName())) continue;
                this.outmap.put((OutputPin)pin, out);
            }
        }
    }

    @Override
    public void setTriState(boolean which) {
        for (Input input : this.inputs) {
            InputPin p = this.inmap.get(input);
            if (this.pinsChecked.contains(p)) continue;
            if (!input.isAttached()) {
                this.pinsChecked.add(p);
                p.setTriState(false);
                this.pinsChecked.remove(p);
                continue;
            }
            WireEnd w = input.getWireEnd();
            boolean is = w.isTriState();
            this.pinsChecked.add(p);
            p.setTriState(is);
            this.pinsChecked.remove(p);
        }
    }

    @Override
    public boolean canFlip() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public void initInputs() {
        super.initInputs();
        for (Element element : this.subCircuit.getElements()) {
            if (!(element instanceof LogicElement)) continue;
            LogicElement el = (LogicElement)element;
            el.initInputs();
        }
    }

    @Override
    public void initSim(Simulator sim) {
        for (Output out : this.outputs) {
            if (out.isTriState()) {
                out.setValue(null);
                continue;
            }
            out.setValue(new BitSet());
        }
        for (Element el : this.subCircuit.getElements()) {
            if (!(el instanceof LogicElement)) continue;
            LogicElement lel = (LogicElement)el;
            lel.initSim(sim);
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        for (Input in : this.inputs) {
            InputPin pin = this.inmap.get(in);
            BitSet copy = null;
            if (in.getValue() != null) {
                copy = (BitSet)in.getValue().clone();
            }
            sim.post(new SimEvent(now, pin, copy));
        }
    }

    public void send(OutputPin pin, BitSet value, long now, Simulator sim) {
        Output out = this.outmap.get(pin);
        out.propagate(value, now, sim);
    }

    private class SubCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField nameField;
        private JRadioButton left;
        private JRadioButton right;

        private SubCreate(int x, int y) {
            super(JLSInfo.frame, "Create Subcircuit", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.nameField = new JTextField("", 12);
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right", true);
            SubCircuit.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel name = new JLabel("Name: ", 4);
            info.add((Component)name, "West");
            info.add((Component)this.nameField, "Center");
            window.add(info);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(new JLabel(""));
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(new JLabel(""));
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 3));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "import", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.nameField.addActionListener(this);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SubCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField) {
                String tname = this.nameField.getText().trim();
                if (tname.length() < 1 || !Util.isValidName(tname)) {
                    JOptionPane.showMessageDialog(this, "Invalid name", "Error", 0);
                    return;
                }
                if (!SubCircuit.this.circuit.addName(tname)) {
                    JOptionPane.showMessageDialog(this, "Name already used", "Error", 0);
                    return;
                }
                if (this.left.isSelected()) {
                    SubCircuit.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    SubCircuit.this.orientation = JLSInfo.Orientation.RIGHT;
                }
                SubCircuit.this.name = tname;
                SubCircuit.this.subCircuit.setName(SubCircuit.this.name);
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            SubCircuit.this.cancelled = true;
            this.dispose();
        }
    }
}

