/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Group;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Splitter
extends Group
implements TriProp {
    public Splitter(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new Group.GroupCreate(x + win.x, y + win.y, "Unbundler");
        } else {
            new Group.GroupCreate(pos.x + win.x, pos.y + win.y, "Unbundler");
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            this.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        super.init(g);
        int s = 12;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("input", this, 0, ((this.ranges.size() - 1) / 2 + 1) * s, this.bits));
            int ypos = s;
            for (Group.Entry e : this.ranges) {
                Output out = new Output(e.toCircuitString(), this, this.width, ypos, e.getSize());
                this.outputs.add(out);
                if (this.loadTriState) {
                    out.loadSetTriState();
                }
                ypos += s;
            }
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("input", this, this.width, ((this.ranges.size() - 1) / 2 + 1) * s, this.bits));
            int ypos = s;
            for (Group.Entry e : this.ranges) {
                Output out = new Output(e.toCircuitString(), this, 0, ypos, e.getSize());
                this.outputs.add(out);
                if (this.loadTriState) {
                    out.loadSetTriState();
                }
                ypos += s;
            }
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            int xpos = s;
            for (Group.Entry e : this.ranges) {
                Output out = new Output(e.toCircuitString(), this, xpos, 0, e.getSize());
                this.outputs.add(out);
                if (this.loadTriState) {
                    out.loadSetTriState();
                }
                xpos += s;
            }
            this.inputs.add(new Input("input", this, ((this.ranges.size() - 1) / 2 + 1) * s, this.height, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            int xpos = s;
            for (Group.Entry e : this.ranges) {
                Output out = new Output(e.toCircuitString(), this, xpos, this.height, e.getSize());
                this.outputs.add(out);
                if (this.loadTriState) {
                    out.loadSetTriState();
                }
                xpos += s;
            }
            this.inputs.add(new Input("input", this, ((this.ranges.size() - 1) / 2 + 1) * s, 0, this.bits));
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int d2 = 3;
        int s = 12;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            Input input = (Input)this.inputs.get(0);
            g.setColor(Color.black);
            int ypos = input.getY();
            g.drawLine(this.x, ypos, this.x + s / 2, ypos);
            input.draw(g);
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s / 2, this.y + s, this.x + s / 2, this.y + this.height - s);
            FontMetrics fm = g.getFontMetrics();
            for (Output output : this.outputs) {
                output.draw(g);
                ypos = output.getY();
                Rectangle2D t = fm.getStringBounds(output.getName(), g);
                g.setColor(Color.BLACK);
                int edge = (int)((double)(this.x + this.width) - t.getWidth() - (double)d2);
                g.drawString(output.getName(), edge, (int)((double)ypos - t.getHeight() / 2.0 + (double)fm.getAscent()));
                g.drawLine(this.x + s / 2, ypos, edge - d2, ypos);
            }
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            Input input = (Input)this.inputs.get(0);
            g.setColor(Color.black);
            int ypos = input.getY();
            g.drawLine(this.x + this.width, ypos, this.x + this.width - s / 2, ypos);
            input.draw(g);
            g.setColor(Color.BLACK);
            g.drawLine(this.x + this.width - s / 2, this.y + s, this.x + this.width - s / 2, this.y + this.height - s);
            FontMetrics fm = g.getFontMetrics();
            for (Output output : this.outputs) {
                output.draw(g);
                ypos = output.getY();
                Rectangle2D t = fm.getStringBounds(output.getName(), g);
                g.setColor(Color.BLACK);
                int edge = this.x + 3;
                g.drawString(output.getName(), edge, (int)((double)ypos - t.getHeight() / 2.0 + (double)fm.getAscent()));
                g.drawLine(this.x + this.width - s / 2, ypos, (int)((double)edge + t.getWidth() + (double)d2), ypos);
            }
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            int inum = 0;
            FontMetrics fm = g.getFontMetrics();
            for (Output output : this.outputs) {
                output.draw(g);
                int xpos = output.getX();
                Rectangle2D t = fm.getStringBounds(output.getName(), g);
                g.setColor(Color.BLACK);
                int edge = this.y + this.height - 3;
                if (inum % 2 == 0) {
                    g.drawString(output.getName(), xpos - (int)t.getWidth() / 2, (int)((double)edge - t.getHeight() / 2.0 + 6.0));
                }
                g.drawLine(xpos, this.y + s, xpos, (int)((double)edge - t.getHeight() + (double)d2));
                ++inum;
            }
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s, this.y + s, this.x + this.width - s, this.y + s);
            Input input = (Input)this.inputs.get(0);
            g.setColor(Color.black);
            int xpos = input.getX();
            g.drawLine(xpos, this.y + s, xpos, this.y);
            input.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            int inum = 0;
            FontMetrics fm = g.getFontMetrics();
            for (Output output : this.outputs) {
                output.draw(g);
                int xpos = output.getX();
                Rectangle2D t = fm.getStringBounds(output.getName(), g);
                g.setColor(Color.BLACK);
                int edge = this.y + 3;
                if (inum % 2 == 0) {
                    g.drawString(output.getName(), xpos - (int)t.getWidth() / 2, (int)((double)edge + t.getHeight() / 2.0 + 6.0));
                }
                g.drawLine(xpos, this.y + this.height - s, xpos, (int)((double)edge + t.getHeight() + (double)d2));
                ++inum;
            }
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s, this.y + this.height - s, this.x + this.width - s, this.y + this.height - s);
            Input input = (Input)this.inputs.get(0);
            g.setColor(Color.black);
            int xpos = input.getX();
            g.drawLine(xpos, this.y + this.height - s, xpos, this.y + this.height);
            input.draw(g);
        }
    }

    @Override
    public Element copy() {
        Splitter it = new Splitter(this.circuit);
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Splitter");
        super.save(output);
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("unbundle " + this.bits + " bits");
    }

    @Override
    public void setTriState(boolean which) {
        this.triState = which;
        for (Output out : this.outputs) {
            out.setTriState(which);
        }
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        super.rotate(direction, g);
        this.init(g);
    }

    @Override
    public void flip(Graphics g) {
        super.flip(g);
        this.init(g);
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        BitSet value = null;
        if (!out.isTriState()) {
            value = new BitSet();
        }
        for (Output output : this.outputs) {
            output.setValue(value);
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        BitSet value = ((Input)this.inputs.get(0)).getValue();
        if (value == null) {
            for (Output output : this.outputs) {
                output.propagate(null, now, sim);
            }
            return;
        }
        int outNum = 0;
        for (Group.Entry e : this.ranges) {
            BitSet newValue = new BitSet(e.getSize());
            int vpos = 0;
            int[] nArray = e.getValues();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                boolean val = value.get(i);
                newValue.set(vpos, val);
                ++vpos;
                ++n2;
            }
            ((Output)this.outputs.get(outNum)).propagate(newValue, now, sim);
            ++outNum;
        }
    }
}

