/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.InputPin;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Pin;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Scanner;

public abstract class SigSim
extends LogicElement {
    public SigSim(Circuit circuit) {
        super(circuit);
    }

    public void initSim(Simulator sim, Scanner input) {
        String newSignals = "";
        while (input.hasNextLine()) {
            String line = input.nextLine();
            String newLine = "";
            Scanner hex = new Scanner(line);
            while (hex.hasNext()) {
                String token = hex.next();
                if (token.matches("-?0[xX][0-9a-fA-F]+")) {
                    BigInteger value;
                    String suffix = token.substring(2);
                    if (token.charAt(0) == '-') {
                        suffix = token.substring(3);
                        value = new BigInteger(suffix, 16).negate();
                    } else {
                        suffix = token.substring(2);
                        value = new BigInteger(suffix, 16);
                    }
                    newLine = String.valueOf(newLine) + " " + value;
                    continue;
                }
                newLine = String.valueOf(newLine) + " " + (String)token;
            }
            newSignals = newLine.contains("#") ? String.valueOf(newSignals) + newLine.substring(0, newLine.indexOf("#")) + " " : String.valueOf(newSignals) + newLine + " ";
        }
        input = new Scanner(newSignals);
        block2: while (input.hasNext()) {
            String signal = input.next();
            Pin pin = null;
            for (Element el : this.circuit.getElements()) {
                if (!(el instanceof InputPin) || !signal.equals(el.getName())) continue;
                pin = (InputPin)el;
            }
            if (pin == null) {
                this.specError("no input pin for signal " + signal + " - signal ignored");
            }
            if (!input.hasNextBigInteger()) {
                this.specError("missing or invalid initial value for signal " + signal);
                return;
            }
            BigInteger value = input.nextBigInteger();
            if (pin != null) {
                int bits = pin.getBits();
                if (value.signum() < 0) {
                    if (value.bitLength() + 1 > bits) {
                        this.specError("value " + value + " will not fit in signal " + signal);
                        return;
                    }
                } else if (value.bitLength() > bits) {
                    this.specError("value " + value + " will not fit in signal " + signal);
                    return;
                }
                if (value.signum() < 0) {
                    BigInteger x = new BigInteger("2").pow(bits);
                    value = value.add(x);
                }
                BitSet bval = BitSetUtils.Create(value);
                sim.post(new SimEvent(0L, pin, bval));
            }
            long time = 0L;
            while (true) {
                long newTime = 0L;
                if (!input.hasNext()) {
                    this.specError("expected for, until or end for signal " + signal);
                    return;
                }
                String type = input.next();
                if (type.equals("end")) continue block2;
                if (type.equals("for")) {
                    if (!input.hasNextLong()) {
                        this.specError("missing or invalid duration for signal " + signal);
                        return;
                    }
                    newTime = time + input.nextLong();
                } else if (type.equals("until")) {
                    if (!input.hasNextLong()) {
                        this.specError("missing or invalid until time for signal " + signal);
                        return;
                    }
                    newTime = input.nextLong();
                    if (newTime <= time) {
                        this.specError("until time not greater than previous time for signal " + signal);
                        return;
                    }
                } else {
                    this.specError("expected for, until or end for signal " + signal);
                    return;
                }
                if (!input.hasNextBigInteger()) {
                    this.specError("expected value for signal " + signal);
                    return;
                }
                value = input.nextBigInteger();
                if (pin != null) {
                    int bits = pin.getBits();
                    if (value.signum() < 0) {
                        if (value.bitLength() + 1 > bits) {
                            this.specError("value " + value + " will not fit in signal " + signal);
                            return;
                        }
                    } else if (value.bitLength() > bits) {
                        this.specError("value " + value + " will not fit in signal " + signal);
                        return;
                    }
                    if (value.signum() < 0) {
                        BigInteger x = new BigInteger("2").pow(bits);
                        value = value.add(x);
                    }
                    BitSet bval = BitSetUtils.Create(value);
                    sim.post(new SimEvent(newTime, pin, bval));
                }
                time = newTime;
            }
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        throw new UnsupportedOperationException("react in SigGen called");
    }

    protected abstract void specError(String var1);
}

