/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.SigSim;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SigGen
extends SigSim {
    private final String title = " Signal Generator ";
    private final int size = 300;
    private String signals = "";
    private boolean cancelled = false;

    public SigGen(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        for (Element el : this.circuit.getElements()) {
            if (!(el instanceof SigGen)) continue;
            JOptionPane.showMessageDialog(JLSInfo.frame, "Only one signal generator per circuit", "Error", 0);
            return false;
        }
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new EditSignals(x + win.x, y + win.y, true);
        } else {
            new EditSignals(pos.x + win.x, pos.y + win.y, true);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.width != 0 || this.height != 0) {
            return;
        }
        int s = 12;
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth(" Signal Generator ");
        this.width = (w + s - 1) / s * s;
        this.height = 2 * s;
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawRect(this.x, this.y, this.width, this.height);
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int hi = ascent + fm.getDescent();
        int w = fm.stringWidth(" Signal Generator ");
        g.drawString(" Signal Generator ", this.x + (this.width - w) / 2, this.y + (this.height - hi) / 2 + ascent);
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT SigGen");
        super.save(output);
        String str = this.signals.replace("\\", "\\\\");
        str = str.replace("\"", "\\\"");
        str = str.replace("\n", "\\n");
        output.println(" String signals \"" + str + "\"");
        output.println("END");
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("signals")) {
            this.signals = value;
        }
        super.setValue(name, value);
    }

    @Override
    public SigGen copy() {
        SigGen it = new SigGen(this.circuit);
        super.copy(it);
        it.signals = this.signals;
        return it;
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new EditSignals(x + win.x, y + win.y, false);
        } else {
            new EditSignals(pos.x + win.x, pos.y + win.y, false);
        }
        if (!this.cancelled) {
            this.circuit.markChanged();
        }
        return false;
    }

    @Override
    public void initSim(Simulator sim) {
        if (this.circuit.isImported()) {
            return;
        }
        Scanner input = new Scanner(this.signals);
        super.initSim(sim, input);
    }

    @Override
    protected void specError(String msg) {
        if (!JLSInfo.batch || JLSInfo.frame != null || JLSInfo.isApplet) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "error in test file: " + msg);
            return;
        }
        System.out.println("error in test file");
        System.out.println(msg);
        System.exit(1);
    }

    private class EditSignals
    extends JDialog
    implements ActionListener {
        private JTextArea textArea;
        private JButton ok;
        private JButton cancel;

        public EditSignals(int x, int y, boolean creating) {
            super(JLSInfo.frame, "Create Signal Specification", true);
            this.textArea = new JTextArea();
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            Container window = this.getContentPane();
            window.setLayout(new BorderLayout());
            if (!creating) {
                this.textArea.setText(SigGen.this.signals);
            }
            JScrollPane pane = new JScrollPane(this.textArea);
            window.add((Component)pane, "Center");
            JPanel buttons = new JPanel();
            buttons.setLayout(new GridLayout(1, 3));
            buttons.add(this.ok);
            buttons.add(this.cancel);
            this.ok.setBackground(Color.green);
            this.cancel.setBackground(Color.pink);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "siggen", null);
            }
            buttons.add(help);
            window.add((Component)buttons, "South");
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setSize(300, 300);
            this.setLocation(x - 150, y - 150);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok) {
                String newSignals = this.textArea.getText();
                if (newSignals.equals(SigGen.this.signals)) {
                    SigGen.this.cancelled = true;
                }
                SigGen.this.signals = newSignals;
            } else if (event.getSource() == this.cancel) {
                SigGen.this.cancelled = true;
            }
            this.dispose();
        }
    }
}

