/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Register
extends LogicElement {
    private static final String defaultName = "";
    private static final Type defaultType = Type.Latch;
    private static final int defaultBits = 1;
    private static final BigInteger defaultInitValue = BigInteger.ZERO;
    private static final int defaultBase = 10;
    private static final int defaultPropDelay = 50;
    private String name = "";
    private Type type = defaultType;
    private int bits = 1;
    private BigInteger initialValue = defaultInitValue;
    private int base = 10;
    private int propDelay = 50;
    private boolean watched = false;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    private boolean cancelled;
    private boolean nameChanged;
    private Graphics saveg;
    private BitSet toBeValue;
    private BitSet currentValue = new BitSet();
    private int currentC;

    public Register(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new RegisterEdit(x + win.x, y + win.y, true);
        } else {
            new RegisterEdit(pos.x + win.x, pos.y + win.y, true);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s;
        if (g != null && this.width == 0 && this.height == 0) {
            s = 12;
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(" " + this.name + " ");
            this.width = Math.max((w + s / 2) / s * s, 2 * s) + 2 * s;
            if (this.width % (2 * s) != 0) {
                this.width += s;
            }
            this.height = this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT ? 5 * s : 6 * s;
        }
        s = 12;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("D", this, 0, s, this.bits));
            this.inputs.add(new Input("C", this, 0, 4 * s, 1));
            this.outputs.add(new Output("Q", this, this.width, s, this.bits));
            this.outputs.add(new Output("notQ", this, this.width, 4 * s, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("D", this, this.width, s, this.bits));
            this.inputs.add(new Input("C", this, this.width, 4 * s, 1));
            this.outputs.add(new Output("Q", this, 0, s, this.bits));
            this.outputs.add(new Output("notQ", this, 0, 4 * s, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.inputs.add(new Input("D", this, s, this.height, this.bits));
            this.inputs.add(new Input("C", this, this.width - s, this.height, 1));
            this.outputs.add(new Output("Q", this, s, 0, this.bits));
            this.outputs.add(new Output("notQ", this, this.width - s, 0, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.inputs.add(new Input("D", this, s, 0, this.bits));
            this.inputs.add(new Input("C", this, this.width - s, 0, 1));
            this.outputs.add(new Output("Q", this, s, this.height, this.bits));
            this.outputs.add(new Output("notQ", this, this.width - s, this.height, this.bits));
        }
    }

    @Override
    public void draw(Graphics g) {
        int s = 12;
        if (this.watched) {
            g.setColor(JLSInfo.watchColor);
            if (this.orientation == JLSInfo.Orientation.RIGHT) {
                g.fillRect(this.x + s, this.y, this.width - s, this.height);
            } else if (this.orientation == JLSInfo.Orientation.LEFT) {
                g.fillRect(this.x, this.y, this.width - s, this.height);
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                g.fillRect(this.x, this.y, this.width, this.height - s);
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                g.fillRect(this.x, this.y + s, this.width, this.height - s);
            }
        }
        super.draw(g);
        g.setColor(Color.BLACK);
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            g.drawRect(this.x + s, this.y, this.width - s, 5 * s);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D t = fm.getStringBounds(this.name, g);
            double tw = t.getWidth();
            double th = t.getHeight();
            int dx = (int)(((double)(this.width - s) - tw) / 2.0) + s;
            int dy = (int)(((double)(5 * s) - th) / 2.0 + (double)fm.getAscent());
            g.drawString(this.name, this.x + dx, this.y + dy);
            Input one = (Input)this.inputs.get(0);
            int lx = one.getX();
            int ly = one.getY();
            g.setColor(Color.black);
            g.drawLine(lx, ly, lx + s, ly);
            int h = fm.getAscent() + fm.getDescent();
            g.drawString("D", lx + s + 1, ly - h / 2 + fm.getAscent());
            one.draw(g);
            Input two = (Input)this.inputs.get(1);
            lx = two.getX();
            ly = two.getY();
            int d = 6;
            g.setColor(Color.black);
            switch (this.type) {
                case Latch: {
                    g.drawLine(lx, ly, lx + s, ly);
                    g.drawString("C", lx + s + 1, ly - h / 2 + fm.getAscent());
                    break;
                }
                case PosFF: {
                    g.drawLine(lx, ly, lx + s, ly);
                    g.drawLine(lx + s, ly - d, lx + s + d, ly);
                    g.drawLine(lx + s, ly + d, lx + s + d, ly);
                    g.drawString("C", lx + s + d + 1, ly - h / 2 + fm.getAscent());
                    break;
                }
                case NegFF: {
                    g.drawLine(lx, ly, lx + s - d, ly);
                    g.drawOval(lx + s - d, ly - d / 2, d, d);
                    g.drawLine(lx + s, ly - d, lx + s + d, ly);
                    g.drawLine(lx + s, ly + d, lx + s + d, ly);
                    g.drawString("C", lx + s + d + 1, ly - h / 2 + fm.getAscent());
                }
            }
            two.draw(g);
            Output three = (Output)this.outputs.get(0);
            lx = three.getX();
            ly = three.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx - fm.stringWidth("Q") - 1, ly - h / 2 + fm.getAscent());
            three.draw(g);
            Output four = (Output)this.outputs.get(1);
            lx = four.getX();
            ly = four.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx - fm.stringWidth("Q") - 1, ly - h / 2 + fm.getAscent());
            g.drawLine(lx - fm.stringWidth("Q") - 1, ly - h / 2, lx - 2, ly - h / 2);
            four.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            g.drawRect(this.x, this.y, this.width - s, 5 * s);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D t = fm.getStringBounds(this.name, g);
            double tw = t.getWidth();
            double th = t.getHeight();
            int dx = (int)(((double)(this.width - s) - tw) / 2.0);
            int dy = (int)(((double)(5 * s) - th) / 2.0 + (double)fm.getAscent());
            g.drawString(this.name, this.x + dx, this.y + dy);
            Input one = (Input)this.inputs.get(0);
            int lx = one.getX();
            int ly = one.getY();
            g.setColor(Color.black);
            g.drawLine(lx, ly, lx - s, ly);
            int h = fm.getAscent() + fm.getDescent();
            g.drawString("D", lx - s - 10, ly - h / 2 + fm.getAscent());
            one.draw(g);
            Input two = (Input)this.inputs.get(1);
            lx = two.getX();
            ly = two.getY();
            int d = 6;
            g.setColor(Color.black);
            switch (this.type) {
                case Latch: {
                    g.drawLine(lx, ly, lx - s, ly);
                    g.drawString("C", lx - s - 10, ly - h / 2 + fm.getAscent());
                    break;
                }
                case PosFF: {
                    g.drawLine(lx, ly, lx - s, ly);
                    g.drawLine(lx - s, ly - d, lx - s - d, ly);
                    g.drawLine(lx - s, ly + d, lx - s - d, ly);
                    g.drawString("C", lx - s - d - 9, ly - h / 2 + fm.getAscent());
                    break;
                }
                case NegFF: {
                    g.drawLine(lx, ly, lx - s + d, ly);
                    g.drawOval(lx - s, ly - d / 2, d, d);
                    g.drawLine(lx - s, ly - d, lx - s - d, ly);
                    g.drawLine(lx - s, ly + d, lx - s - d, ly);
                    g.drawString("C", lx - s - d - 9, ly - h / 2 + fm.getAscent());
                }
            }
            two.draw(g);
            Output three = (Output)this.outputs.get(0);
            lx = three.getX();
            ly = three.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx + 3, ly - h / 2 + fm.getAscent());
            three.draw(g);
            Output four = (Output)this.outputs.get(1);
            lx = four.getX();
            ly = four.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx + 3, ly - h / 2 + fm.getAscent());
            g.drawLine(lx + fm.stringWidth("Q") + 2, ly - h / 2, lx + 2, ly - h / 2);
            four.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            g.drawRect(this.x, this.y, this.width, this.height - s);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D t = fm.getStringBounds(this.name, g);
            double tw = t.getWidth();
            double th = t.getHeight();
            int dx = (int)(((double)this.width - tw) / 2.0);
            int dy = (int)(((double)(5 * s) - th) / 2.0 + (double)fm.getAscent());
            g.drawString(this.name, this.x + dx, this.y + dy);
            Input one = (Input)this.inputs.get(0);
            int lx = one.getX();
            int ly = one.getY();
            g.setColor(Color.black);
            g.drawLine(lx, ly, lx, ly - s);
            int h = fm.getAscent() + fm.getDescent();
            g.drawString("D", lx - fm.stringWidth("D") / 2, ly - s - h + fm.getAscent());
            one.draw(g);
            Input two = (Input)this.inputs.get(1);
            lx = two.getX();
            ly = two.getY();
            int d = 6;
            g.setColor(Color.black);
            switch (this.type) {
                case Latch: {
                    g.drawLine(lx, ly - s, lx, ly);
                    g.drawString("C", lx - fm.stringWidth("C") / 2, ly - s - h + fm.getAscent());
                    break;
                }
                case PosFF: {
                    g.drawLine(lx, ly - s, lx, ly);
                    g.drawLine(lx - d, ly - s, lx, ly - s - d);
                    g.drawLine(lx + d, ly - s, lx, ly - s - d);
                    g.drawString("C", lx - fm.stringWidth("C") / 2, ly - s - d - h + fm.getAscent());
                    break;
                }
                case NegFF: {
                    g.drawLine(lx, ly - s + d, lx, ly);
                    g.drawOval(lx - d / 2, ly - s, d, d);
                    g.drawLine(lx - d, ly - s, lx, ly - s - d);
                    g.drawLine(lx + d, ly - s, lx, ly - s - d);
                    g.drawString("C", lx - fm.stringWidth("C") / 2, ly - s - d - h + fm.getAscent());
                }
            }
            two.draw(g);
            Output three = (Output)this.outputs.get(0);
            lx = three.getX();
            ly = three.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx - fm.stringWidth("Q") / 2, ly + d + fm.getAscent());
            three.draw(g);
            Output four = (Output)this.outputs.get(1);
            lx = four.getX();
            ly = four.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx - fm.stringWidth("Q") / 2, ly + d + fm.getAscent());
            g.drawLine(lx - fm.stringWidth("Q") / 2, ly + d - 1, lx + fm.stringWidth("Q") / 2, ly + d - 1);
            four.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            g.drawRect(this.x, this.y + s, this.width, this.height - s);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D t = fm.getStringBounds(this.name, g);
            double tw = t.getWidth();
            double th = t.getHeight();
            int dx = (int)(((double)this.width - tw) / 2.0);
            int dy = (int)(((double)(5 * s) - th) / 2.0 + (double)fm.getAscent());
            g.drawString(this.name, this.x + dx, this.y + s + dy);
            Input one = (Input)this.inputs.get(0);
            int lx = one.getX();
            int ly = one.getY();
            g.setColor(Color.black);
            g.drawLine(lx, ly + s, lx, ly);
            int h = fm.getAscent() + fm.getDescent();
            g.drawString("D", lx - fm.stringWidth("D") / 2, ly + s + 1 + fm.getAscent());
            one.draw(g);
            Input two = (Input)this.inputs.get(1);
            lx = two.getX();
            ly = two.getY();
            int d = 6;
            g.setColor(Color.black);
            switch (this.type) {
                case Latch: {
                    g.drawLine(lx, ly + s, lx, ly);
                    g.drawString("C", lx - fm.stringWidth("C") / 2, ly + s + 1 + fm.getAscent());
                    break;
                }
                case PosFF: {
                    g.drawLine(lx, ly + s, lx, ly);
                    g.drawLine(lx - d, ly + s, lx, ly + s + d);
                    g.drawLine(lx + d, ly + s, lx, ly + s + d);
                    g.drawString("C", lx - fm.stringWidth("C") / 2, ly + s + d + fm.getAscent());
                    break;
                }
                case NegFF: {
                    g.drawLine(lx, ly + s - d, lx, ly);
                    g.drawOval(lx - d / 2, ly + s - d, d, d);
                    g.drawLine(lx - d, ly + s, lx, ly + s + d);
                    g.drawLine(lx + d, ly + s, lx, ly + s + d);
                    g.drawString("C", lx - fm.stringWidth("C") / 2, ly + s + d + fm.getAscent());
                }
            }
            two.draw(g);
            Output three = (Output)this.outputs.get(0);
            lx = three.getX();
            ly = three.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx - fm.stringWidth("Q") / 2, ly - h + fm.getAscent());
            three.draw(g);
            Output four = (Output)this.outputs.get(1);
            lx = four.getX();
            ly = four.getY();
            g.setColor(Color.black);
            g.drawString("Q", lx - fm.stringWidth("Q") / 2, ly - h + fm.getAscent());
            g.drawLine(lx - fm.stringWidth("Q") / 2, ly - h, lx + fm.stringWidth("Q") / 2, ly - h);
            four.draw(g);
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("delay")) {
            this.propDelay = value;
        } else if (name.equals("watch")) {
            this.watched = value != 0;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, long value) {
        if (name.equals("init")) {
            this.initialValue = BigInteger.valueOf(value);
            this.currentValue = BitSetUtils.Create(value);
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, BigInteger value) {
        if (name.equals("init")) {
            this.initialValue = value.add(BigInteger.ZERO);
            this.currentValue = BitSetUtils.Create(value);
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("name")) {
            this.name = value;
            this.circuit.addName(value);
        } else if (name.equals("type")) {
            if (value.equals("latch")) {
                this.type = Type.Latch;
            } else if (value.equals("pff")) {
                this.type = Type.PosFF;
            } else if (value.equals("nff")) {
                this.type = Type.NegFF;
            }
        } else if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.orientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Register");
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" int bits " + this.bits);
        output.println(" Int init " + this.initialValue.toString());
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println(" int delay " + this.propDelay);
        switch (this.type) {
            case Latch: {
                output.println(" String type \"latch\"");
                break;
            }
            case PosFF: {
                output.println(" String type \"pff\"");
                break;
            }
            case NegFF: {
                output.println(" String type \"nff\"");
            }
        }
        output.println(" int watch " + (this.watched ? 1 : 0));
        output.println("END");
    }

    public boolean canCopy() {
        return false;
    }

    @Override
    public Element copy() {
        Register it = new Register(this.circuit);
        it.name = new String(this.name);
        it.type = this.type;
        it.bits = this.bits;
        it.propDelay = this.propDelay;
        it.initialValue = this.initialValue.add(BigInteger.ZERO);
        it.currentValue = BitSetUtils.Create(this.initialValue);
        it.base = this.base;
        it.orientation = this.orientation;
        it.watched = this.watched;
        it.inputs.add(((Input)this.inputs.get(0)).copy(it));
        it.inputs.add(((Input)this.inputs.get(1)).copy(it));
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        it.outputs.add(((Output)this.outputs.get(1)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        String ty = defaultName;
        switch (this.type) {
            case Latch: {
                ty = "latch";
                break;
            }
            case PosFF: {
                ty = "positive edge triggered flip-flop";
                break;
            }
            case NegFF: {
                ty = "negative edge triggered flip-flop";
            }
        }
        info.setText(String.valueOf(this.bits) + " bit " + ty + ", value = " + BitSetUtils.toDisplay(this.currentValue, this.bits));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void remove(Circuit circ) {
        circ.removeName(this.name);
        super.remove(circ);
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = 50;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    public void setInitialValue(BigInteger value) {
        this.initialValue = value.add(BigInteger.ZERO);
    }

    @Override
    public boolean canRotate() {
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            return false;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            return false;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        this.saveg = g;
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new RegisterEdit(x + win.x, y + win.y, false);
        } else {
            new RegisterEdit(pos.x + win.x, pos.y + win.y, false);
        }
        if (this.nameChanged) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        return false;
    }

    public boolean valueFits(String value) {
        int s = 12;
        FontMetrics fm = this.saveg.getFontMetrics();
        int w = fm.stringWidth(value) + s;
        int rw = Math.max((w + s / 2) / s * s, 2 * s);
        return rw <= this.width - s;
    }

    @Override
    public boolean canWatch() {
        return true;
    }

    @Override
    public boolean isWatched() {
        return this.watched;
    }

    @Override
    public void setWatched(boolean state) {
        this.watched = state;
    }

    public void printValue(String prefix) {
        if (prefix.equals(defaultName)) {
            System.out.printf("Register %s: %s\n", this.name, BitSetUtils.toDisplay(this.currentValue, this.bits));
        } else {
            System.out.printf("Register %s.%s: %s\n", prefix, this.name, BitSetUtils.toDisplay(this.currentValue, this.bits));
        }
    }

    @Override
    public BitSet getCurrentValue() {
        if (this.currentValue == null) {
            return null;
        }
        return (BitSet)this.currentValue.clone();
    }

    @Override
    public void initSim(Simulator sim) {
        BitSet currentValue = BitSetUtils.Create(this.initialValue);
        this.toBeValue = (BitSet)currentValue.clone();
        this.currentC = 0;
        BitSet qOut = (BitSet)currentValue.clone();
        BitSet notQOut = (BitSet)currentValue.clone();
        notQOut.flip(0, this.bits);
        Output q = (Output)this.outputs.get(0);
        q.setValue(new BitSet(1));
        Output notq = (Output)this.outputs.get(1);
        notq.setValue(new BitSet(1));
        sim.post(new SimEvent(0L, this, qOut.clone()));
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet inVal = ((Input)this.inputs.get(1)).getValue();
            if (inVal == null) {
                inVal = new BitSet();
            }
            int c = (int)BitSetUtils.ToLong(inVal);
            BitSet d = ((Input)this.inputs.get(0)).getValue();
            if (d == null) {
                d = new BitSet();
            }
            switch (this.type) {
                case Latch: {
                    if (c == 0 || d.equals(this.toBeValue)) break;
                    this.toBeValue = (BitSet)d.clone();
                    sim.post(new SimEvent(now + (long)this.propDelay, this, d.clone()));
                    break;
                }
                case PosFF: {
                    if (this.currentC == 1 || c == 0 || d.equals(this.toBeValue)) break;
                    this.toBeValue = (BitSet)d.clone();
                    sim.post(new SimEvent(now + (long)this.propDelay, this, d.clone()));
                    break;
                }
                case NegFF: {
                    if (this.currentC == 0 || c == 1 || d.equals(this.toBeValue)) break;
                    this.toBeValue = (BitSet)d.clone();
                    sim.post(new SimEvent(now + (long)this.propDelay, this, d.clone()));
                }
            }
            this.currentC = c;
        } else {
            BitSet newQ = (BitSet)todo;
            this.currentValue = (BitSet)newQ.clone();
            BitSet qOut = (BitSet)newQ.clone();
            BitSet notQOut = (BitSet)newQ.clone();
            notQOut.flip(0, this.bits);
            Output q = (Output)this.outputs.get(0);
            q.propagate(qOut, now, sim);
            Output notq = (Output)this.outputs.get(1);
            notq.propagate(notQOut, now, sim);
        }
    }

    @Override
    public void showCurrentValue(Point where) {
        String hex = BitSetUtils.ToString(this.currentValue, 16);
        String unsigned = BitSetUtils.ToString(this.currentValue, 10);
        String signed = BitSetUtils.ToStringSigned(this.currentValue, this.bits);
        String value = "0x" + hex + " (" + unsigned + " unsigned, " + signed + " signed)";
        JOptionPane.showMessageDialog(JLSInfo.frame, value, "Information", 1);
    }

    private class RegisterEdit
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField nameField;
        private JTextField bitsField;
        private JTextField valueField;
        private KeyPad bitsPad;
        private KeyPad valuePad;
        private JRadioButton base2;
        private JRadioButton base10;
        private JRadioButton base16;
        private JRadioButton latch;
        private JRadioButton posFF;
        private JRadioButton negFF;
        private JRadioButton left;
        private JRadioButton right;
        private JRadioButton up;
        private JRadioButton down;
        private boolean creating;

        private RegisterEdit(int x, int y, boolean creating) {
            super(JLSInfo.frame, "Create Register", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.nameField = new JTextField(Register.this.name);
            this.bitsField = new JTextField(String.valueOf(Register.this.bits));
            this.valueField = new JTextField(Register.defaultName);
            this.bitsPad = new KeyPad(this.bitsField, 10, Register.this.bits, this);
            this.valuePad = new KeyPad(this.valueField, 16, Register.this.initialValue.longValue(), this);
            this.base2 = new JRadioButton("2");
            this.base10 = new JRadioButton("10");
            this.base16 = new JRadioButton("16");
            this.latch = new JRadioButton("Level-Trig");
            this.posFF = new JRadioButton("Pos-Trig");
            this.negFF = new JRadioButton("Neg-Trig");
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right");
            this.up = new JRadioButton("Up");
            this.down = new JRadioButton("Down");
            Register.this.cancelled = false;
            this.creating = creating;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JLabel tlbl = new JLabel("Trigger");
            tlbl.setAlignmentX(0.5f);
            window.add(tlbl);
            JPanel types = new JPanel(new GridLayout(1, 3));
            types.add(this.latch);
            this.latch.setToolTipText("Level-triggered");
            types.add(this.posFF);
            this.posFF.setToolTipText("{positive,leading,rising}-edge-triggered");
            types.add(this.negFF);
            this.negFF.setToolTipText("{negative,trailing,falling}-edge-triggered");
            switch (Register.this.type) {
                case Latch: {
                    this.latch.setSelected(true);
                    break;
                }
                case PosFF: {
                    this.posFF.setSelected(true);
                    break;
                }
                case NegFF: {
                    this.negFF.setSelected(true);
                }
            }
            this.latch.setHorizontalAlignment(0);
            this.posFF.setHorizontalAlignment(0);
            this.negFF.setHorizontalAlignment(0);
            ButtonGroup tgroup = new ButtonGroup();
            tgroup.add(this.latch);
            tgroup.add(this.posFF);
            tgroup.add(this.negFF);
            window.add(types);
            int rows = 2;
            if (creating) {
                rows = 3;
            }
            window.add(new JLabel(" "));
            JPanel info = new JPanel(new BorderLayout());
            JPanel labels = new JPanel(new GridLayout(rows, 1, 1, 5));
            JLabel name = new JLabel("Name: ", 4);
            labels.add(name);
            if (creating) {
                JLabel bits = new JLabel("Bits: ", 4);
                labels.add(bits);
            }
            JLabel init = new JLabel("Initial value: ", 4);
            labels.add(init);
            info.add((Component)labels, "West");
            JPanel fields = new JPanel(new GridLayout(rows, 1, 1, 5));
            fields.add(this.nameField);
            if (creating) {
                JPanel b = new JPanel(new BorderLayout());
                b.add((Component)this.bitsField, "Center");
                b.add((Component)this.bitsPad, "East");
                fields.add(b);
            }
            JPanel i = new JPanel(new BorderLayout());
            this.valueField.setText(Util.convert(Register.this.initialValue, Register.this.base, false));
            i.add((Component)this.valueField, "Center");
            i.add((Component)this.valuePad, "East");
            this.valuePad.setBase(Register.this.base);
            fields.add(i);
            info.add((Component)fields, "Center");
            window.add(info);
            window.add(new JLabel(" "));
            JLabel rlbl = new JLabel("Radix");
            rlbl.setAlignmentX(0.5f);
            window.add(rlbl);
            JPanel bases = new JPanel(new GridLayout(1, 3));
            bases.add(this.base2);
            bases.add(this.base10);
            bases.add(this.base16);
            this.base2.setHorizontalAlignment(0);
            this.base10.setHorizontalAlignment(0);
            this.base16.setHorizontalAlignment(0);
            ButtonGroup group = new ButtonGroup();
            group.add(this.base2);
            group.add(this.base10);
            group.add(this.base16);
            switch (Register.this.base) {
                case 2: {
                    this.base2.setSelected(true);
                    break;
                }
                case 10: {
                    this.base10.setSelected(true);
                    break;
                }
                case 16: {
                    this.base16.setSelected(true);
                }
            }
            window.add(bases);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(Register.defaultName));
            orients.add(this.up);
            orients.add(new JLabel(Register.defaultName));
            orients.add(this.left);
            orients.add(new JLabel(Register.defaultName));
            orients.add(this.right);
            orients.add(new JLabel(Register.defaultName));
            orients.add(this.down);
            orients.add(new JLabel(Register.defaultName));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            gr.add(this.down);
            gr.add(this.up);
            switch (Register.this.orientation) {
                case LEFT: {
                    this.left.setSelected(true);
                    break;
                }
                case RIGHT: {
                    this.right.setSelected(true);
                    break;
                }
                case UP: {
                    this.up.setSelected(true);
                    break;
                }
                case DOWN: {
                    this.down.setSelected(true);
                }
            }
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "register", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.nameField.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.valueField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.base2.addActionListener(this);
            this.base10.addActionListener(this);
            this.base16.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    RegisterEdit.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField || event.getSource() == this.bitsField || event.getSource() == this.valueField) {
                String tname = this.nameField.getText().trim();
                if (tname.equals(Register.defaultName) || !Util.isValidName(tname)) {
                    JOptionPane.showMessageDialog(this, "Missing or invalid name", "Error", 0);
                    return;
                }
                int tbits = Register.this.bits;
                BigInteger tinitialValue = BigInteger.ZERO;
                if (this.left.isSelected()) {
                    Register.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    Register.this.orientation = JLSInfo.Orientation.RIGHT;
                } else if (this.up.isSelected()) {
                    Register.this.orientation = JLSInfo.Orientation.UP;
                } else if (this.down.isSelected()) {
                    Register.this.orientation = JLSInfo.Orientation.DOWN;
                }
                try {
                    if (this.creating) {
                        tbits = Integer.parseInt(this.bitsField.getText());
                    }
                    tinitialValue = new BigInteger(this.valueField.getText(), Register.this.base);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric", "Error", 0);
                    return;
                }
                if (tbits < 1) {
                    JOptionPane.showMessageDialog(this, "Must have at least 1 bit", "Error", 0);
                    return;
                }
                if (tinitialValue.bitLength() > tbits) {
                    JOptionPane.showMessageDialog(this, "Value too large for number of bits", "Error", 0);
                    return;
                }
                if (!this.creating) {
                    Register.this.circuit.removeName(Register.this.name);
                }
                if (!Register.this.circuit.addName(tname)) {
                    JOptionPane.showMessageDialog(this, "Duplicate name", "Error", 0);
                    return;
                }
                Register.this.name = tname;
                Register.this.bits = tbits;
                Register.this.initialValue = tinitialValue.add(BigInteger.ZERO);
                Register.this.currentValue = BitSetUtils.Create(Register.this.initialValue);
                if (this.latch.isSelected()) {
                    Register.this.type = Type.Latch;
                } else if (this.negFF.isSelected()) {
                    Register.this.type = Type.NegFF;
                } else {
                    Register.this.type = Type.PosFF;
                }
                this.bitsPad.close();
                this.valuePad.close();
                Register.this.circuit.markChanged();
                if (!this.creating && !Register.this.valueFits(tname)) {
                    Register.this.nameChanged = true;
                } else {
                    Register.this.nameChanged = false;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.base2) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals(Register.defaultName)) {
                    val = new BigInteger(this.valueField.getText(), Register.this.base);
                }
                Register.this.base = 2;
                this.valuePad.setBase(2);
                this.valueField.setText(val.toString(2));
            } else if (event.getSource() == this.base10) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals(Register.defaultName)) {
                    val = new BigInteger(this.valueField.getText(), Register.this.base);
                }
                Register.this.base = 10;
                this.valuePad.setBase(10);
                this.valueField.setText(val.toString(10));
            } else if (event.getSource() == this.base16) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals(Register.defaultName)) {
                    val = new BigInteger(this.valueField.getText(), Register.this.base);
                }
                Register.this.base = 16;
                this.valuePad.setBase(16);
                this.valueField.setText(val.toString(16));
            }
        }

        private void cancel() {
            Register.this.cancelled = true;
            this.dispose();
        }
    }

    private static enum Type {
        Latch,
        PosFF,
        NegFF;

    }
}

