/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.WireEnd;
import java.awt.Color;
import java.awt.Graphics;
import java.util.BitSet;

public abstract class Put {
    protected String name;
    protected LogicElement element;
    protected int xr;
    protected int yr;
    private int savex;
    private int savey;
    protected int bits;
    private boolean touching = false;
    private WireEnd wireEnd = null;
    protected Put myCopy;
    protected BitSet currentValue;

    public Put(String name, LogicElement element, int xr, int yr, int bits) {
        this.name = name;
        this.element = element;
        this.xr = xr;
        this.yr = yr;
        this.bits = bits;
    }

    public String toString() {
        return String.valueOf(this.name) + ",bits=" + this.bits + ",x=" + this.xr + ",y=" + this.yr;
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.element.getX() + this.xr;
    }

    public int getY() {
        return this.element.getY() + this.yr;
    }

    public int getBits() {
        return this.bits;
    }

    public LogicElement getElement() {
        return this.element;
    }

    public WireEnd getWireEnd() {
        return this.wireEnd;
    }

    public boolean isAttached() {
        return this.wireEnd != null;
    }

    public void setAttached(WireEnd end) {
        this.wireEnd = end;
    }

    public void setTouching(boolean is) {
        this.touching = is;
    }

    public boolean isTouching() {
        return this.touching;
    }

    public void setPosition(int x, int y) {
        this.xr = x;
        this.yr = y;
    }

    public void savePosition() {
        this.savex = this.xr;
        this.savey = this.yr;
    }

    public void restorePosition() {
        this.xr = this.savex;
        this.yr = this.savey;
    }

    public void draw(Graphics g) {
        Color inside;
        if (this.touching) {
            inside = JLSInfo.touchColor;
        } else {
            if (this.isAttached()) {
                Color inside2 = Color.BLACK;
                return;
            }
            inside = Color.WHITE;
        }
        int d = 6;
        int r = d / 2;
        int x = this.element.getX() + this.xr;
        int y = this.element.getY() + this.yr;
        g.setColor(Color.BLACK);
        g.fillOval(x - r, y - r, d, d);
        g.setColor(inside);
        g.fillOval(x - r + 1, y - r + 1, d - 2, d - 2);
    }

    public boolean intersects(Put other) {
        int thisx = this.element.getX() + this.xr;
        int thisy = this.element.getY() + this.yr;
        int otherx = other.element.getX() + other.xr;
        int othery = other.element.getY() + other.yr;
        return this != other && thisx == otherx && thisy == othery;
    }

    public Put getCopy() {
        return this.myCopy;
    }
}

