/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.LogicElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public abstract class Pin
extends LogicElement {
    protected String name;
    protected int bits;
    protected boolean watched = false;
    protected JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    protected boolean cancelled;

    public Pin(Circuit circ) {
        super(circ);
    }

    public String toString() {
        return String.valueOf(this.name) + ",bits=" + this.bits + ",watched=" + this.watched + ",hashCode=" + this.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    public boolean setup(Graphics g, JPanel editWindow, int x, int y, String type) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new PinCreate(x + win.x, y + win.y, type);
        } else {
            new PinCreate(pos.x + win.x, pos.y + win.y, type);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        if (g != null && this.width == 0 && this.height == 0) {
            int s = 12;
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(" " + this.name + " ");
            if (this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT) {
                this.width = Math.max((w + s / 2) / s * s, 2 * s) + s;
                this.height = 2 * s;
            } else {
                this.width = Math.max((w + s / 2) / s * s, 2 * s);
                if (this.width % (2 * s) != 0) {
                    this.width += s;
                }
                this.height = 3 * s;
            }
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("watch")) {
            this.watched = value != 0;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("name")) {
            this.name = value;
            this.circuit.addName(value);
        } else if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.orientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    public boolean canCopy() {
        return false;
    }

    @Override
    public void save(PrintWriter output) {
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" int bits " + this.bits);
        output.println(" int watch " + (this.watched ? 1 : 0));
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.bits) + " bit input pin");
    }

    @Override
    public void remove(Circuit circ) {
        circ.removeName(this.name);
        super.remove(circ);
    }

    @Override
    public boolean canWatch() {
        return true;
    }

    @Override
    public boolean isWatched() {
        return this.watched;
    }

    @Override
    public void setWatched(boolean state) {
        this.watched = state;
    }

    private class PinCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField nameField;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton left;
        private JRadioButton right;
        private JRadioButton up;
        private JRadioButton down;

        private PinCreate(int x, int y, String type) {
            super(JLSInfo.frame, "Create " + type + " Pin", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.nameField = new JTextField("", 12);
            this.bitsField = new JTextField("1", 5);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right", true);
            this.up = new JRadioButton("Up");
            this.down = new JRadioButton("Down");
            Pin.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JPanel labels = new JPanel(new GridLayout(2, 1, 1, 5));
            JLabel name = new JLabel("Name: ", 4);
            labels.add(name);
            JLabel bits = new JLabel("Bits: ", 4);
            labels.add(bits);
            info.add((Component)labels, "West");
            JPanel data = new JPanel(new GridLayout(2, 1, 1, 5));
            data.add(this.nameField);
            JPanel bitsPanel = new JPanel(new BorderLayout());
            bitsPanel.add((Component)this.bitsField, "Center");
            bitsPanel.add((Component)this.bitsPad, "East");
            data.add(bitsPanel);
            info.add((Component)data, "Center");
            window.add(info);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(this.up);
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(this.down);
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            gr.add(this.down);
            gr.add(this.up);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, type, null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.nameField.addActionListener(this);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    PinCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField) {
                try {
                    Pin.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Bits not numeric, try again", "Error", 0);
                    return;
                }
                if (Pin.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must have at least 1 bit", "Error", 0);
                    return;
                }
                String tname = this.nameField.getText().trim();
                if (tname.length() < 1 || !Util.isValidName(tname)) {
                    JOptionPane.showMessageDialog(this, "Missing or invalid name, try again", "Error", 0);
                    return;
                }
                if (!Pin.this.circuit.addName(tname)) {
                    JOptionPane.showMessageDialog(this, "Name already used, try again", "Error", 0);
                    return;
                }
                Pin.this.name = tname;
                if (this.left.isSelected()) {
                    Pin.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    Pin.this.orientation = JLSInfo.Orientation.RIGHT;
                } else if (this.up.isSelected()) {
                    Pin.this.orientation = JLSInfo.Orientation.UP;
                } else if (this.down.isSelected()) {
                    Pin.this.orientation = JLSInfo.Orientation.DOWN;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Pin.this.cancelled = true;
            this.dispose();
        }
    }
}

