/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Pause
extends LogicElement {
    private BitSet currentValue = new BitSet();

    public Pause(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        Point win = editWindow.getLocationOnScreen();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        this.height = this.width = s * 2;
        this.inputs.add(new Input("input0", this, 0, s, 1));
        this.inputs.add(new Input("input1", this, s, 0, 1));
        this.inputs.add(new Input("input2", this, s, 2 * s, 1));
        this.inputs.add(new Input("input3", this, 2 * s, s, 1));
    }

    @Override
    public void draw(Graphics g) {
        int s = 12;
        super.draw(g);
        Vector<Input> detach = new Vector<Input>(4);
        for (Input input : this.inputs) {
            if (input.isAttached()) continue;
            detach.add(input);
        }
        int count = detach.size();
        if (count > 0 && count < 4) {
            this.inputs.removeAll(detach);
            if (this.inputs.size() == 0) {
                this.inputs.add(new Input("input0", this, 0, s, 1));
                this.inputs.add(new Input("input1", this, s, 0, 1));
                this.inputs.add(new Input("input2", this, s, 2 * s, 1));
                this.inputs.add(new Input("input3", this, 2 * s, s, 1));
            }
        }
        g.setColor(Color.black);
        g.drawOval(this.x, this.y, this.width, this.height);
        for (Input input : this.inputs) {
            input.draw(g);
        }
        Font f = g.getFont();
        Font nf = f.deriveFont((float)((double)f.getSize() * 0.55));
        g.setFont(nf);
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth("PAUSE");
        int ascent = fm.getAscent();
        int descent = fm.getDescent();
        int sh = ascent + descent;
        g.setColor(Color.black);
        g.drawString("PAUSE", this.x + (this.width - w) / 2, this.y + s - sh / 2 + ascent);
        g.setFont(f);
    }

    @Override
    public Element copy() {
        Pause it = new Pause(this.circuit);
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Pause");
        super.save(output);
        output.println("END");
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("pause simulation");
    }

    @Override
    public void initSim(Simulator sim) {
        for (Input input : this.inputs) {
            if (!input.isAttached()) continue;
            this.currentValue = input.getWireEnd().getNet().isTriState() ? null : new BitSet();
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        for (Input input : this.inputs) {
            if (!input.isAttached()) continue;
            BitSet in = input.getValue();
            if (in != null && in.cardinality() != 0) {
                sim.pause(true);
            }
            return;
        }
    }
}

