/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.Pin;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class OutputPin
extends Pin
implements TriProp {
    private boolean loadTriState = false;
    private BitSet currentValue = new BitSet();

    public OutputPin(Circuit circ) {
        super(circ);
        this.orientation = JLSInfo.Orientation.RIGHT;
    }

    @Override
    public String toString() {
        return "OutputPin[" + super.toString() + "]";
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        return super.setup(g, editWindow, x, y, "Output");
    }

    @Override
    public void init(Graphics g) {
        super.init(g);
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("input", this, 0, 12, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("input", this, this.width, 12, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.inputs.add(new Input("input", this, this.width / 2, 0, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.inputs.add(new Input("input", this, this.width / 2, this.height, this.bits));
        }
    }

    @Override
    public void draw(Graphics g) {
        int s = 12;
        Polygon p = new Polygon();
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            p.addPoint(this.x, this.y);
            p.addPoint(this.x + this.width - s, this.y);
            p.addPoint(this.x + this.width, this.y + this.height / 2);
            p.addPoint(this.x + this.width - s, this.y + this.height);
            p.addPoint(this.x, this.y + this.height);
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            p.addPoint(this.x + s, this.y);
            p.addPoint(this.x, this.y + this.height / 2);
            p.addPoint(this.x + s, this.y + this.height);
            p.addPoint(this.x + this.width, this.y + this.height);
            p.addPoint(this.x + this.width, this.y);
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            p.addPoint(this.x + this.width / 2, this.y);
            p.addPoint(this.x + this.width, this.y + s);
            p.addPoint(this.x + this.width, this.y + this.height);
            p.addPoint(this.x, this.y + this.height);
            p.addPoint(this.x, this.y + s);
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            p.addPoint(this.x, this.y);
            p.addPoint(this.x + this.width, this.y);
            p.addPoint(this.x + this.width, this.y + this.height - s);
            p.addPoint(this.x + this.width / 2, this.y + this.height);
            p.addPoint(this.x, this.y + this.height - s);
        }
        if (this.watched) {
            g.setColor(JLSInfo.watchColor);
            g.fillPolygon(p);
        }
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D t = fm.getStringBounds(this.name, g);
        double tw = t.getWidth();
        double th = t.getHeight();
        int bx = this.x;
        int by = this.y;
        int bwidth = this.width;
        int bheight = this.height;
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            bx = this.x + s;
            bwidth = this.width - s;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            bwidth = this.width - s;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            by = this.y + s;
            bheight = this.height - s;
        } else {
            bheight = this.height - s;
        }
        int dx = (int)(((double)bwidth - tw) / 2.0);
        int dy = (int)(((double)bheight - th) / 2.0 + (double)fm.getAscent());
        g.drawString(this.name, bx + dx, by + dy);
        ((Input)this.inputs.get(0)).draw(g);
    }

    @Override
    public void save(PrintWriter output) {
        SubCircuit sub;
        output.println("ELEMENT OutputPin");
        if (this.getCircuit().isImported() && (sub = this.getCircuit().getSubElement()).getOutput(this.name).isTriState()) {
            output.println(" int tristate 1");
        }
        super.save(output);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("tristate")) {
            this.loadTriState = true;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        OutputPin it = new OutputPin(this.circuit);
        it.name = this.name;
        it.orientation = this.orientation;
        it.bits = this.bits;
        it.watched = this.watched;
        it.inputs.add(((Input)this.inputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        String value = ", value = " + BitSetUtils.toDisplay(this.currentValue, this.bits);
        String tri = "";
        if (((Input)this.inputs.get(0)).isAttached() && ((Input)this.inputs.get(0)).getWireEnd().getNet().isTriState()) {
            tri = " (tri-state) ";
        }
        info.setText(String.valueOf(this.bits) + " bit output pin" + tri + value);
    }

    public void printValue(String qual) {
        if (qual.equals("")) {
            System.out.printf("Output Pin %s: %s\n", this.name, BitSetUtils.toDisplay(this.currentValue, this.bits));
        } else {
            System.out.printf("Output Pin %s.%s: %s\n", qual, this.name, BitSetUtils.toDisplay(this.currentValue, this.bits));
        }
    }

    @Override
    public void setTriState(boolean which) {
        if (!this.getCircuit().isImported()) {
            return;
        }
        SubCircuit sub = this.getCircuit().getSubElement();
        Output put = (Output)sub.getPut(this.name);
        if (put != null) {
            put.setTriState(which);
        }
    }

    public boolean isLoadTriState() {
        return this.loadTriState;
    }

    @Override
    public void remove(Circuit circ) {
        if (circ.isImported()) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "Can't remove output pin " + this.name + " from a subcircuit");
            return;
        }
        super.remove(circ);
    }

    @Override
    public boolean canRotate() {
        return !((Input)this.inputs.get(0)).isAttached();
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.inputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        return !((Input)this.inputs.get(0)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.inputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public BitSet getCurrentValue() {
        if (this.currentValue == null) {
            return null;
        }
        return (BitSet)this.currentValue.clone();
    }

    @Override
    public void initSim(Simulator sim) {
        WireEnd end;
        Input in = (Input)this.inputs.get(0);
        if (in.isAttached() && (end = in.getWireEnd()).isTriState()) {
            this.currentValue = null;
            return;
        }
        this.currentValue = new BitSet();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        Input in = (Input)this.inputs.get(0);
        BitSet value = in.getValue();
        this.currentValue = value == null ? null : (BitSet)value.clone();
        if (this.circuit.isImported()) {
            SubCircuit sub = this.circuit.getSubElement();
            sub.send(this, value, now, sim);
        }
    }

    @Override
    public void showCurrentValue(Point where) {
        JOptionPane.showMessageDialog(JLSInfo.frame, BitSetUtils.toDisplay(this.currentValue, this.bits), "Information", 1);
    }
}

