/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.WireNet;
import edu.mtu.cs.jls.sim.Simulator;
import java.util.BitSet;

public class Output
extends Put {
    private boolean triState = false;

    public Output(String name, LogicElement element, int xr, int yr, int bits) {
        super(name, element, xr, yr, bits);
    }

    @Override
    public String toString() {
        return "Output[" + super.toString() + ",tristate=" + this.triState + "]";
    }

    public Output copy(LogicElement element) {
        Output p = new Output(this.name, element, this.xr, this.yr, this.bits);
        p.triState = this.triState;
        this.myCopy = p;
        return p;
    }

    public void loadSetTriState() {
        this.triState = true;
    }

    public void setTriState(boolean which) {
        this.triState = which;
        if (this.isAttached()) {
            this.getWireEnd().getNet().setTriState(which);
        }
    }

    public boolean isTriState() {
        return this.triState;
    }

    public void setValue(BitSet value) {
        this.currentValue = value;
        if (this.isAttached()) {
            this.getWireEnd().getNet().setValue(value);
        }
    }

    public BitSet getValue() {
        return this.currentValue;
    }

    public void propagate(BitSet value, long now, Simulator sim) {
        if (this.currentValue == null ? value == null : this.currentValue.equals(value)) {
            return;
        }
        this.currentValue = value == null ? null : (BitSet)value.clone();
        if (!this.isAttached()) {
            return;
        }
        WireNet net = this.getWireEnd().getNet();
        net.propagate(value, now, sim);
    }
}

