/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Gate;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Graphics;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NotGate
extends Gate {
    private static int defaultDelay = 5;
    private static int previousBits = 1;
    private static Gate.Orientation previousOrientation = defaultOrientation;
    private BitSet toBeValue;

    public NotGate(Circuit circuit) {
        super(circuit);
        int s = 12;
        int d = 6;
        Line2D.Double top = new Line2D.Double(0.0, 0.0, 2 * s - d, s);
        Line2D.Double bottom = new Line2D.Double(2 * s - d, s, 0.0, 2 * s);
        Line2D.Double side = new Line2D.Double(0.0, 2 * s, 0.0, 0.0);
        this.gateShape = new GeneralPath(top);
        this.gateShape.append(bottom, true);
        this.gateShape.append(side, true);
        this.gateShape.closePath();
        Ellipse2D.Double bubble = new Ellipse2D.Double(2 * s - d, s - d / 2, d, d);
        this.gateShape.append(bubble, false);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        boolean ok = super.setup(g, editWindow, x, y, "NOT");
        if (ok) {
            this.numInputs = 1;
            previousBits = this.bits;
            previousOrientation = this.orientation;
        }
        return ok;
    }

    @Override
    public Element copy() {
        NotGate it = new NotGate(this.circuit);
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        super.save(output, "NotGate", false);
    }

    @Override
    public void showInfo(JLabel info) {
        super.showInfo(info, "NOT");
    }

    @Override
    public void setToPrevious() {
        this.bits = previousBits;
        this.orientation = previousOrientation;
    }

    @Override
    public int getDefaultDelay() {
        return defaultDelay;
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.toArray()[0];
        BitSet bitval = new BitSet(1);
        out.setValue(bitval);
        BitSet one = new BitSet(1);
        one.set(0, this.bits);
        sim.post(new SimEvent(0L, this, one));
        this.toBeValue = (BitSet)one.clone();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet value = ((Input)this.inputs.toArray()[0]).getValue();
            if (value == null) {
                value = new BitSet();
            }
            value = (BitSet)value.clone();
            value.flip(0, this.bits);
            if (!value.equals(this.toBeValue)) {
                this.toBeValue = (BitSet)value.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, value));
            }
        } else {
            BitSet newValue = (BitSet)todo;
            Output out = (Output)this.outputs.toArray()[0];
            out.propagate(newValue, now, sim);
        }
    }
}

