/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Gate;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Graphics;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NorGate
extends Gate {
    private static int defaultDelay = 5;
    private static int previousInputs = 2;
    private static int previousBits = 1;
    private static Gate.Orientation previousOrientation = defaultOrientation;
    private BitSet toBeValue;

    public NorGate(Circuit circuit) {
        super(circuit);
        int s = 12;
        int d = 6;
        Point2D.Double pright = new Point2D.Double(2 * s - d, s);
        Point2D.Double ptop = new Point2D.Double(0.0, 0.0);
        Point2D.Double pbottom = new Point2D.Double(0.0, 2 * s);
        Point2D.Double c1 = new Point2D.Double();
        Point2D.Double c2 = new Point2D.Double();
        c1.setLocation(pright.x - 1.0, pright.y - 3.0);
        c2.setLocation(ptop.x + (double)s, ptop.y);
        CubicCurve2D.Double top = new CubicCurve2D.Double();
        top.setCurve(pright, c1, c2, ptop);
        c1.setLocation(ptop.x + (double)(s / 4), ptop.y + (double)s);
        c2.setLocation(pbottom.x + (double)(s / 4), pbottom.y - (double)s);
        CubicCurve2D.Double side = new CubicCurve2D.Double();
        side.setCurve(ptop, c1, c2, pbottom);
        c1.setLocation(pbottom.x + (double)s, pbottom.y);
        c2.setLocation(pright.x - 1.0, pright.y + 3.0);
        CubicCurve2D.Double bottom = new CubicCurve2D.Double();
        bottom.setCurve(pbottom, c1, c2, pright);
        this.gateShape = new GeneralPath(top);
        this.gateShape.append(side, true);
        this.gateShape.append(bottom, true);
        this.gateShape.closePath();
        Ellipse2D.Double bubble = new Ellipse2D.Double(2 * s - d, s - d / 2, d, d);
        this.gateShape.append(bubble, false);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        boolean ok = super.setup(g, editWindow, x, y, "NOR");
        if (ok) {
            previousInputs = this.numInputs;
            previousBits = this.bits;
            previousOrientation = this.orientation;
        }
        return ok;
    }

    @Override
    public Element copy() {
        NorGate it = new NorGate(this.circuit);
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        super.save(output, "NorGate", false);
    }

    @Override
    public void showInfo(JLabel info) {
        super.showInfo(info, "NOR");
    }

    @Override
    public void setToPrevious() {
        this.numInputs = previousInputs;
        this.bits = previousBits;
        this.orientation = previousOrientation;
    }

    @Override
    public int getDefaultDelay() {
        return defaultDelay;
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.toArray()[0];
        BitSet bitval = new BitSet(1);
        out.setValue(bitval);
        BitSet one = new BitSet(1);
        one.set(0, this.bits);
        sim.post(new SimEvent(0L, this, one));
        this.toBeValue = (BitSet)one.clone();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet value = new BitSet(this.bits);
            for (Input input : this.inputs) {
                BitSet inVal = input.getValue();
                if (inVal == null) {
                    inVal = new BitSet();
                }
                value.or(inVal);
            }
            value.flip(0, this.bits);
            if (!value.equals(this.toBeValue)) {
                this.toBeValue = (BitSet)value.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, value));
            }
        } else {
            BitSet newValue = (BitSet)todo;
            Output out = (Output)this.outputs.toArray()[0];
            out.propagate(newValue, now, sim);
        }
    }
}

