/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Mux
extends LogicElement {
    private static final int defaultInputs = 2;
    private static final int defaultBits = 1;
    private static final int defaultPropDelay = 25;
    private int numInputs = 2;
    private int bits = 1;
    private int propDelay = 25;
    private JLSInfo.Orientation outputOrientation = JLSInfo.Orientation.RIGHT;
    private JLSInfo.Orientation selectorOrientation = JLSInfo.Orientation.DOWN;
    private boolean cancelled;
    private BitSet toBeValue;

    public Mux(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new MuxCreate(x + win.x, y + win.y);
        } else {
            new MuxCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        if (this.outputOrientation == JLSInfo.Orientation.LEFT || this.outputOrientation == JLSInfo.Orientation.RIGHT) {
            this.height = (this.numInputs + 1) * s;
            this.width = 2 * s;
        } else {
            this.width = (this.numInputs + 1) * s;
            this.height = 2 * s;
        }
        int sbits = 32 - Integer.numberOfLeadingZeros(this.numInputs - 1);
        if (this.selectorOrientation == JLSInfo.Orientation.DOWN) {
            this.inputs.add(new Input("select", this, s, this.height, sbits));
        } else if (this.selectorOrientation == JLSInfo.Orientation.UP) {
            this.inputs.add(new Input("select", this, s, 0, sbits));
        } else if (this.selectorOrientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("select", this, 0, s, sbits));
        } else if (this.selectorOrientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("select", this, this.width, s, sbits));
        }
        int ypos = s;
        if (this.outputOrientation == JLSInfo.Orientation.RIGHT) {
            int i = 0;
            while (i < this.numInputs) {
                this.inputs.add(new Input("input" + i, this, 0, ypos, this.bits));
                ypos += s;
                ++i;
            }
            this.outputs.add(new Output("output", this, this.width, (this.numInputs + 1) / 2 * s, this.bits));
        } else if (this.outputOrientation == JLSInfo.Orientation.LEFT) {
            int i = 0;
            while (i < this.numInputs) {
                this.inputs.add(new Input("input" + i, this, this.width, ypos, this.bits));
                ypos += s;
                ++i;
            }
            this.outputs.add(new Output("output", this, 0, (this.numInputs + 1) / 2 * s, this.bits));
        } else if (this.outputOrientation == JLSInfo.Orientation.DOWN) {
            int i = 0;
            while (i < this.numInputs) {
                this.inputs.add(new Input("input" + i, this, ypos, 0, this.bits));
                ypos += s;
                ++i;
            }
            this.outputs.add(new Output("output", this, (this.numInputs + 1) / 2 * s, this.height, this.bits));
        } else if (this.outputOrientation == JLSInfo.Orientation.UP) {
            int i = 0;
            while (i < this.numInputs) {
                this.inputs.add(new Input("input" + i, this, ypos, this.height, this.bits));
                ypos += s;
                ++i;
            }
            this.outputs.add(new Output("output", this, (this.numInputs + 1) / 2 * s, 0, this.bits));
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int s = 12;
        g.setColor(Color.black);
        if (this.outputOrientation == JLSInfo.Orientation.LEFT || this.outputOrientation == JLSInfo.Orientation.RIGHT) {
            g.drawArc(this.x, this.y, 2 * s, 2 * s, 0, 180);
            g.drawLine(this.x, this.y + s, this.x, this.y + this.height - s);
            g.drawLine(this.x + 2 * s, this.y + s, this.x + 2 * s, this.y + this.height - s);
            g.drawArc(this.x, this.y + this.height - 2 * s, 2 * s, 2 * s, 180, 180);
        } else {
            g.drawArc(this.x, this.y, 2 * s, 2 * s, -90, -180);
            g.drawLine(this.x + s, this.y, this.x + this.width - s, this.y);
            g.drawLine(this.x + s, this.y + 2 * s, this.x + this.width - s, this.y + 2 * s);
            g.drawArc(this.x + this.width - 2 * s, this.y, 2 * s, 2 * s, -90, 180);
        }
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int hi = ascent + fm.getDescent();
        int d2 = 3;
        int inum = -1;
        if (this.outputOrientation == JLSInfo.Orientation.LEFT || this.outputOrientation == JLSInfo.Orientation.RIGHT) {
            for (Input input : this.inputs) {
                input.draw(g);
                if (inum >= 0) {
                    g.setColor(Color.BLACK);
                    if (this.outputOrientation == JLSInfo.Orientation.RIGHT) {
                        g.drawString(String.valueOf(inum), this.x + d2, input.getY() - hi / 2 + ascent);
                    } else if (this.outputOrientation == JLSInfo.Orientation.LEFT) {
                        g.drawString(String.valueOf(inum), this.x + this.width - 5 * d2, input.getY() - hi / 2 + ascent);
                    } else if (this.outputOrientation == JLSInfo.Orientation.UP || this.outputOrientation == JLSInfo.Orientation.DOWN) {
                        g.drawString(String.valueOf(inum), input.getX() - 4, this.y + 5 * d2);
                    }
                }
                ++inum;
            }
        }
        if (this.outputOrientation == JLSInfo.Orientation.UP || this.outputOrientation == JLSInfo.Orientation.DOWN) {
            if (this.inputs.size() == 3) {
                ((Input)this.inputs.get(0)).draw(g);
                ((Input)this.inputs.get(1)).draw(g);
                ((Input)this.inputs.get(2)).draw(g);
                g.setColor(Color.BLACK);
                g.drawString("0", ((Input)this.inputs.get(1)).getX() - 4, this.y + 5 * d2);
                g.drawString("1", ((Input)this.inputs.get(2)).getX() - 4, this.y + 5 * d2);
            } else {
                for (Input input : this.inputs) {
                    input.draw(g);
                    if (inum >= 0 && inum % 2 == 0) {
                        g.setColor(Color.BLACK);
                        if (this.outputOrientation == JLSInfo.Orientation.RIGHT) {
                            g.drawString(String.valueOf(inum), this.x + d2, input.getY() - hi / 2 + ascent);
                        } else if (this.outputOrientation == JLSInfo.Orientation.LEFT) {
                            g.drawString(String.valueOf(inum), this.x + this.width - 5 * d2, input.getY() - hi / 2 + ascent);
                        } else if (this.outputOrientation == JLSInfo.Orientation.UP || this.outputOrientation == JLSInfo.Orientation.DOWN) {
                            g.drawString(String.valueOf(inum), input.getX() - 4, this.y + 5 * d2);
                        }
                    }
                    ++inum;
                }
            }
        }
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("inputs")) {
            this.numInputs = value;
        } else if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("delay")) {
            this.propDelay = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("iOrient")) {
            if (value.equals("LEFT")) {
                this.outputOrientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.outputOrientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.outputOrientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.outputOrientation = JLSInfo.Orientation.DOWN;
            }
        } else if (name.equals("sOrient")) {
            if (value.equals("LEFT")) {
                this.selectorOrientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.selectorOrientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.selectorOrientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.selectorOrientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Mux");
        super.save(output);
        output.println(" int inputs " + this.numInputs);
        output.println(" int bits " + this.bits);
        output.println(" int delay " + this.propDelay);
        output.println(" String iOrient \"" + this.outputOrientation.toString() + "\"");
        output.println(" String sOrient \"" + this.selectorOrientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public Element copy() {
        Mux it = new Mux(this.circuit);
        it.numInputs = this.numInputs;
        it.bits = this.bits;
        it.propDelay = this.propDelay;
        it.outputOrientation = this.outputOrientation;
        it.selectorOrientation = this.selectorOrientation;
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        for (Output output : this.outputs) {
            it.outputs.add(output.copy(it));
        }
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.numInputs) + " input, " + this.bits + " bit multiplexor");
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = 25;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public boolean canFlip() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void flip(Graphics g) {
        if (this.selectorOrientation == JLSInfo.Orientation.LEFT) {
            this.selectorOrientation = JLSInfo.Orientation.RIGHT;
        } else if (this.selectorOrientation == JLSInfo.Orientation.RIGHT) {
            this.selectorOrientation = JLSInfo.Orientation.LEFT;
        } else if (this.selectorOrientation == JLSInfo.Orientation.UP) {
            this.selectorOrientation = JLSInfo.Orientation.DOWN;
        } else if (this.selectorOrientation == JLSInfo.Orientation.DOWN) {
            this.selectorOrientation = JLSInfo.Orientation.UP;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.selectorOrientation == JLSInfo.Orientation.LEFT) {
                this.selectorOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.selectorOrientation == JLSInfo.Orientation.DOWN) {
                this.selectorOrientation = JLSInfo.Orientation.RIGHT;
            } else if (this.selectorOrientation == JLSInfo.Orientation.RIGHT) {
                this.selectorOrientation = JLSInfo.Orientation.UP;
            } else if (this.selectorOrientation == JLSInfo.Orientation.UP) {
                this.selectorOrientation = JLSInfo.Orientation.LEFT;
            }
            if (this.outputOrientation == JLSInfo.Orientation.LEFT) {
                this.outputOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.outputOrientation == JLSInfo.Orientation.DOWN) {
                this.outputOrientation = JLSInfo.Orientation.RIGHT;
            } else if (this.outputOrientation == JLSInfo.Orientation.RIGHT) {
                this.outputOrientation = JLSInfo.Orientation.UP;
            } else if (this.outputOrientation == JLSInfo.Orientation.UP) {
                this.outputOrientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.selectorOrientation == JLSInfo.Orientation.LEFT) {
                this.selectorOrientation = JLSInfo.Orientation.UP;
            } else if (this.selectorOrientation == JLSInfo.Orientation.DOWN) {
                this.selectorOrientation = JLSInfo.Orientation.LEFT;
            } else if (this.selectorOrientation == JLSInfo.Orientation.RIGHT) {
                this.selectorOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.selectorOrientation == JLSInfo.Orientation.UP) {
                this.selectorOrientation = JLSInfo.Orientation.RIGHT;
            }
            if (this.outputOrientation == JLSInfo.Orientation.LEFT) {
                this.outputOrientation = JLSInfo.Orientation.UP;
            } else if (this.outputOrientation == JLSInfo.Orientation.DOWN) {
                this.outputOrientation = JLSInfo.Orientation.LEFT;
            } else if (this.outputOrientation == JLSInfo.Orientation.RIGHT) {
                this.outputOrientation = JLSInfo.Orientation.DOWN;
            } else if (this.outputOrientation == JLSInfo.Orientation.UP) {
                this.outputOrientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canRotate() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void initSim(Simulator sim) {
        BitSet zero = new BitSet(1);
        ((Output)this.outputs.get(0)).setValue(zero);
        this.toBeValue = (BitSet)zero.clone();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet newValue;
            int which;
            BitSet bw = ((Input)this.inputs.get(0)).getValue();
            if (bw == null) {
                bw = new BitSet();
            }
            if ((which = BitSetUtils.ToInt(bw)) >= this.numInputs) {
                newValue = new BitSet(1);
            } else {
                newValue = ((Input)this.inputs.get(which + 1)).getValue();
                if (newValue == null) {
                    newValue = new BitSet();
                }
            }
            if (!newValue.equals(this.toBeValue)) {
                this.toBeValue = (BitSet)newValue.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, newValue));
            }
        } else {
            BitSet value = (BitSet)todo;
            Output sumOut = (Output)this.outputs.get(0);
            sumOut.propagate(value, now, sim);
        }
    }

    protected class MuxCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField inputsField;
        private JTextField bitsField;
        private KeyPad inputsPad;
        private KeyPad bitsPad;
        private JRadioButton oLeft;
        private JRadioButton oRight;
        private JRadioButton oUp;
        private JRadioButton oDown;
        private JRadioButton sLeft;
        private JRadioButton sRight;
        private JRadioButton sUp;
        private JRadioButton sDown;
        private JLabel olbl2;

        protected MuxCreate(int x, int y) {
            super(JLSInfo.frame, "Create Multiplexor", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.inputsField = new JTextField("2", 5);
            this.bitsField = new JTextField("1", 5);
            this.inputsPad = new KeyPad(this.inputsField, 10, 2L, this);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.oLeft = new JRadioButton("Left");
            this.oRight = new JRadioButton("Right", true);
            this.oUp = new JRadioButton("Up");
            this.oDown = new JRadioButton("Down");
            this.sLeft = new JRadioButton("Left");
            this.sRight = new JRadioButton("Right");
            this.sUp = new JRadioButton("Up");
            this.sDown = new JRadioButton("Down", true);
            this.olbl2 = new JLabel("Selector Orientation");
            Mux.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = null;
            info = new JPanel(new GridLayout(2, 2));
            JLabel inputs = new JLabel("Inputs: ", 4);
            info.add(inputs);
            JPanel in = new JPanel(new FlowLayout());
            in.add(this.inputsField);
            in.add(this.inputsPad);
            info.add(in);
            JLabel gates = new JLabel("Bits: ", 4);
            info.add(gates);
            JPanel ga = new JPanel(new FlowLayout());
            ga.add(this.bitsField);
            ga.add(this.bitsPad);
            info.add(ga);
            window.add(info);
            JPanel orient = new JPanel(new GridLayout(3, 3));
            JPanel orient2 = new JPanel(new GridLayout(3, 3));
            ButtonGroup gr = new ButtonGroup();
            ButtonGroup gr2 = new ButtonGroup();
            gr.add(this.oLeft);
            gr.add(this.oRight);
            gr.add(this.oDown);
            gr.add(this.oUp);
            gr2.add(this.sDown);
            gr2.add(this.sUp);
            gr2.add(this.sLeft);
            gr2.add(this.sRight);
            orient.add(new JLabel(""));
            orient.add(this.oUp);
            orient.add(new JLabel(""));
            orient.add(this.oLeft);
            orient.add(new JLabel(""));
            orient.add(this.oRight);
            orient.add(new JLabel(""));
            orient.add(this.oDown);
            orient.add(new JLabel(""));
            orient2.add(new JLabel(""));
            orient2.add(this.sUp);
            orient2.add(new JLabel(""));
            orient2.add(this.sLeft);
            orient2.add(new JLabel(""));
            orient2.add(this.sRight);
            orient2.add(new JLabel(""));
            orient2.add(this.sDown);
            orient2.add(new JLabel(""));
            JLabel olbl = new JLabel("Output Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            window.add(orient);
            this.olbl2.setAlignmentX(0.5f);
            window.add(this.olbl2);
            window.add(orient2);
            this.sLeft.setVisible(false);
            this.sRight.setVisible(false);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "mux", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.inputsField.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.oLeft.addActionListener(this);
            this.oRight.addActionListener(this);
            this.oUp.addActionListener(this);
            this.oDown.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MuxCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.oLeft || event.getSource() == this.oRight) {
                this.olbl2.setVisible(true);
                this.sUp.setVisible(true);
                this.sDown.setVisible(true);
                this.sDown.setSelected(true);
                this.sLeft.setVisible(false);
                this.sRight.setVisible(false);
                return;
            }
            if (event.getSource() == this.oUp || event.getSource() == this.oDown) {
                this.olbl2.setVisible(true);
                this.sLeft.setVisible(true);
                this.sLeft.setSelected(true);
                this.sRight.setVisible(true);
                this.sUp.setVisible(false);
                this.sDown.setVisible(false);
                return;
            }
            if (event.getSource() == this.ok || event.getSource() == this.inputsField || event.getSource() == this.bitsField) {
                try {
                    Mux.this.numInputs = Integer.parseInt(this.inputsField.getText());
                    Mux.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    Mux.this.numInputs = -1;
                    return;
                }
                if (Mux.this.numInputs < 2) {
                    JOptionPane.showMessageDialog(this, "Must have at least 2 inputs", "Error", 0);
                    Mux.this.numInputs = -1;
                    return;
                }
                if (Mux.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must be at least one bit", "Error", 0);
                    Mux.this.numInputs = -1;
                    return;
                }
                if (this.oLeft.isSelected()) {
                    Mux.this.outputOrientation = JLSInfo.Orientation.LEFT;
                    if (this.sUp.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.UP;
                    } else if (this.sDown.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.DOWN;
                    }
                } else if (this.oRight.isSelected()) {
                    Mux.this.outputOrientation = JLSInfo.Orientation.RIGHT;
                    if (this.sUp.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.UP;
                    } else if (this.sDown.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.DOWN;
                    }
                } else if (this.oDown.isSelected()) {
                    Mux.this.outputOrientation = JLSInfo.Orientation.DOWN;
                    if (this.sLeft.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.LEFT;
                    } else if (this.sRight.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.RIGHT;
                    }
                } else if (this.oUp.isSelected()) {
                    Mux.this.outputOrientation = JLSInfo.Orientation.UP;
                    if (this.sLeft.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.LEFT;
                    } else if (this.sRight.isSelected()) {
                        Mux.this.selectorOrientation = JLSInfo.Orientation.RIGHT;
                    }
                }
                this.inputsPad.close();
                this.bitsPad.close();
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Mux.this.cancelled = true;
            this.inputsPad.close();
            this.bitsPad.close();
            this.dispose();
        }
    }
}

