/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Memory
extends LogicElement {
    private static final String defaultName = "";
    private static final Type defaultType = Type.RAM;
    private static final int defaultBits = 1;
    private static final int defaultCapacity = 2;
    private static final String defaultFileName = "";
    private static final int defaultAccessTime = 100;
    private static final String defaultInitialValue = "";
    private String name = "";
    private Type type = defaultType;
    private int bits = 1;
    private int capacity = 2;
    private String fileName = "";
    private int accessTime = 100;
    private String initialValue = "";
    private boolean watched = false;
    private boolean cancelled;
    private boolean changed;
    private String specs;
    private Graphics saveg;
    private Map<Integer, BitSet> mem;
    private Map<Integer, BitSet> initMem;
    private BitSet currentValue;
    private List<WriteRecord> activity = new LinkedList<WriteRecord>();

    public Memory(Circuit circ) {
        super(circ);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new MemoryEdit(x + win.x, y + win.y, true);
        } else {
            new MemoryEdit(pos.x + win.x, pos.y + win.y, true);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        this.specs = this.type == Type.RAM ? " " + this.capacity + "x" + this.bits + " RAM " : " " + this.capacity + "x" + this.bits + " ROM ";
        int s = 12;
        if (g != null && this.width == 0 && this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            int w1 = (fm.stringWidth(" " + this.name + " ") + s / 2) / s * s;
            int minW = 0;
            if (this.type == Type.RAM) {
                this.height = 8 * s;
                minW = 6 * s;
            } else {
                this.height = 7 * s;
                minW = 4 * s;
            }
            int w2 = (fm.stringWidth(this.specs) + s / 2) / s * s;
            int w = Math.max(w1, w2);
            this.width = Math.max(w, minW);
        }
        int abits = 32 - Integer.numberOfLeadingZeros(this.capacity - 1);
        this.inputs.add(new Input("address", this, 0, 4 * s, abits));
        int over = s;
        if (this.type == Type.RAM) {
            this.inputs.add(new Input("input", this, 0, 5 * s, this.bits));
            this.inputs.add(new Input("WE", this, s, this.height, 1));
            over += 2 * s;
        }
        this.inputs.add(new Input("OE", this, over, this.height, 1));
        this.inputs.add(new Input("CS", this, over + 2 * s, this.height, 1));
        Output out = new Output("output", this, this.width, 4 * s, this.bits);
        this.outputs.add(out);
        out.setTriState(true);
    }

    @Override
    public void draw(Graphics g) {
        int w;
        int s = 12;
        int d2 = 3;
        if (this.watched) {
            g.setColor(JLSInfo.watchColor);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawRect(this.x, this.y, this.width, this.height);
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        Rectangle2D t = fm.getStringBounds(this.specs, g);
        double tw = t.getWidth();
        double th = t.getHeight();
        int dx = (int)(((double)this.width - tw) / 2.0);
        int dy = (int)((double)s - th / 2.0 + (double)ascent);
        g.drawString(this.specs, this.x + dx, this.y + dy);
        t = fm.getStringBounds(this.name, g);
        tw = t.getWidth();
        th = t.getHeight();
        dx = (int)(((double)this.width - tw) / 2.0);
        dy = 3 * s;
        g.drawString(this.name, this.x + dx, this.y + dy);
        Input addr = (Input)this.inputs.get(0);
        int lx = addr.getX();
        int ly = addr.getY();
        int h = fm.getAscent() + fm.getDescent();
        g.setColor(Color.black);
        g.drawString("addr", lx + d2, ly - h / 2 + ascent);
        addr.draw(g);
        if (this.type == Type.RAM) {
            Input in = (Input)this.inputs.get(1);
            lx = in.getX();
            ly = in.getY();
            h = fm.getAscent() + fm.getDescent();
            g.setColor(Color.black);
            g.drawString("data", lx + d2, ly - h / 2 + ascent);
            in.draw(g);
        }
        Output out = (Output)this.outputs.get(0);
        lx = out.getX();
        ly = out.getY();
        g.setColor(Color.black);
        g.drawString("out", lx - fm.stringWidth("out") - d2, ly - h / 2 + ascent);
        out.draw(g);
        int inum = 1;
        if (this.type == Type.RAM) {
            Input we = (Input)this.inputs.get(2);
            lx = we.getX();
            ly = we.getY();
            w = fm.stringWidth("WE");
            g.setColor(Color.black);
            g.drawString("WE", lx - w / 2, ly - d2 - fm.getDescent());
            g.drawLine(lx - w / 2, ly - h - 1, lx + w / 2, ly - h - 1);
            we.draw(g);
            inum = 3;
        }
        Input oe = (Input)this.inputs.get(inum);
        lx = oe.getX();
        ly = oe.getY();
        w = fm.stringWidth("OE");
        g.setColor(Color.black);
        g.drawString("OE", lx - w / 2, ly - d2 - fm.getDescent());
        g.drawLine(lx - w / 2, ly - h - 1, lx + w / 2, ly - h - 1);
        oe.draw(g);
        Input cs = (Input)this.inputs.get(inum + 1);
        lx = cs.getX();
        ly = cs.getY();
        w = fm.stringWidth("CS");
        g.setColor(Color.black);
        g.drawString("CS", lx - w / 2, ly - d2 - fm.getDescent());
        g.drawLine(lx - w / 2, ly - h - 1, lx + w / 2, ly - h - 1);
        cs.draw(g);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("cap")) {
            this.capacity = value;
        } else if (name.equals("time")) {
            this.accessTime = value;
        } else if (name.equals("watch")) {
            this.watched = value != 0;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("name")) {
            this.name = value;
            this.circuit.addName(value);
        } else if (name.equals("type")) {
            if (value.equals("RAM")) {
                this.type = Type.RAM;
            } else if (value.equals("ROM")) {
                this.type = Type.ROM;
            }
        } else if (name.equals("file")) {
            this.fileName = value;
        } else if (name.equals("init")) {
            this.initialValue = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Memory");
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" String type \"" + (Object)((Object)this.type) + "\"");
        output.println(" int bits " + this.bits);
        output.println(" int cap " + this.capacity);
        output.println(" int time " + this.accessTime);
        output.println(" int watch " + (this.watched ? 1 : 0));
        output.println(" String file \"" + this.fileName + "\"");
        String str = this.initialValue.replace("\\", "\\\\");
        str = str.replace("\"", "\\\"");
        str = str.replace("\n", "\\n");
        output.println(" String init \"" + str + "\"");
        output.println("END");
    }

    @Override
    public Element copy() {
        Memory it = new Memory(this.circuit);
        it.name = new String(this.name);
        it.type = this.type;
        it.bits = this.bits;
        it.accessTime = this.accessTime;
        it.initialValue = new String(this.initialValue);
        it.capacity = this.capacity;
        it.fileName = new String(this.fileName);
        it.specs = new String(this.specs);
        it.watched = this.watched;
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        if (this.fileName.equals("")) {
            info.setText(String.valueOf(this.specs) + ", built-in initializaion");
        } else {
            info.setText(String.valueOf(this.specs) + ", initialization file = \"" + this.fileName + "\"");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public boolean canWatch() {
        return true;
    }

    @Override
    public boolean isWatched() {
        return this.watched;
    }

    @Override
    public void setWatched(boolean state) {
        this.watched = state;
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.accessTime = 100;
    }

    @Override
    public int getDelay() {
        return this.accessTime;
    }

    @Override
    public void setDelay(int temp) {
        this.accessTime = temp;
    }

    public void setMemFile(String memFile) {
        this.fileName = memFile;
        this.initialValue = "";
    }

    @Override
    public void remove(Circuit circ) {
        circ.removeName(this.name);
        super.remove(circ);
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        this.saveg = g;
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new MemoryEdit(x + win.x, y + win.y, false);
        } else {
            new MemoryEdit(pos.x + win.x, pos.y + win.y, false);
        }
        if (this.changed) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        return false;
    }

    public String initOK(String str, int maxAddr, int bitsPerWord, boolean storing) {
        Scanner scan = new Scanner(str);
        boolean scanning = true;
        int lineNumber = 0;
        String nextLine = "";
        try {
            nextLine = scan.nextLine();
            ++lineNumber;
        }
        catch (NoSuchElementException ex) {
            scanning = false;
        }
        while (scanning) {
            String temp = nextLine.trim();
            if (!temp.equals("") && temp.charAt(0) != '#') {
                Scanner lscan = new Scanner(nextLine);
                lscan.useRadix(16);
                int addr = 0;
                if (!lscan.hasNextInt()) {
                    return "line " + lineNumber + ": missing or invalid address";
                }
                addr = lscan.nextInt();
                if (addr < 0 || addr >= maxAddr) {
                    return "line " + lineNumber + ": invalid address";
                }
                BigInteger data = BigInteger.ZERO;
                if (!lscan.hasNextBigInteger()) {
                    return "line " + lineNumber + ": missing or invalid value";
                }
                data = lscan.nextBigInteger();
                BitSet bval = BitSetUtils.Create(data);
                if (bval.length() > bitsPerWord) {
                    return "line " + lineNumber + ": value has more bits than word size";
                }
                if (storing) {
                    this.initMem.put(addr, bval);
                }
            }
            try {
                nextLine = scan.nextLine();
                ++lineNumber;
            }
            catch (NoSuchElementException ex) {
                scanning = false;
            }
        }
        return null;
    }

    public void printChangedValues(String qual) {
        int addr;
        if (this.type == Type.ROM) {
            return;
        }
        boolean firstTime = true;
        TreeSet<Integer> addrs = new TreeSet<Integer>();
        HashSet<Integer> temp = new HashSet<Integer>(this.mem.keySet());
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            addr = (Integer)iterator.next();
            addrs.add(addr);
        }
        iterator = addrs.iterator();
        while (iterator.hasNext()) {
            addr = (Integer)iterator.next();
            BitSet initial = this.initMem.get(addr) == null ? new BitSet(1) : this.initMem.get(addr);
            if (this.mem.get(addr).equals(initial)) continue;
            if (firstTime) {
                firstTime = false;
                if (qual.equals("")) {
                    System.out.println("Changed locations in memory " + this.name);
                } else {
                    System.out.println("Changed locations in memory " + qual + "." + this.name);
                }
            }
            System.out.printf(" 0x%x: ", addr);
            String oldValue = BitSetUtils.toDisplay(initial, this.bits);
            String newValue = BitSetUtils.toDisplay(this.mem.get(addr), this.bits);
            System.out.println(String.valueOf(oldValue) + " -> " + newValue);
        }
        if (firstTime) {
            if (qual.equals("")) {
                System.out.println("No changes in memory " + this.name);
            } else {
                System.out.println("No changes in memory " + qual + "." + this.name);
            }
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void initSim(Simulator sim) {
        block9: {
            this.initMem = new HashMap<Integer, BitSet>();
            if (!this.fileName.equals("")) {
                try {
                    File file = new File(this.fileName);
                    int length = (int)file.length();
                    FileInputStream in = new FileInputStream(file);
                    InputStreamReader input = new InputStreamReader(in);
                    char[] info = new char[length];
                    input.read(info, 0, length);
                    input.close();
                    String msg = this.initOK(new String(info), this.capacity, this.bits, true);
                    if (msg == null) break block9;
                    if (JLSInfo.batch && JLSInfo.frame == null && !JLSInfo.isApplet) {
                        System.out.println(String.valueOf(msg) + " in memory file " + this.name + ", all zeros assumed");
                        break block9;
                    }
                    JOptionPane.showMessageDialog(JLSInfo.frame, String.valueOf(msg) + "in memory file " + this.name + ", all zeros assumed", "Error", 0);
                }
                catch (IOException ex) {
                    if (JLSInfo.batch && JLSInfo.frame == null && !JLSInfo.isApplet) {
                        System.out.println("Initialization file for memory " + this.name + " cannot be read, all zeros assumed");
                        break block9;
                    }
                    JOptionPane.showMessageDialog(JLSInfo.frame, "Initialization file for memory " + this.name + " cannot be read, all zeros assumed", "Error", 0);
                }
            } else {
                String msg = this.initOK(new String(this.initialValue), this.capacity, this.bits, true);
                if (msg != null) {
                    if (JLSInfo.batch && JLSInfo.frame == null && !JLSInfo.isApplet) {
                        System.out.println(String.valueOf(msg) + " in memory file " + this.name + ", all zeros assumed");
                    } else {
                        JOptionPane.showMessageDialog(JLSInfo.frame, String.valueOf(msg) + " in memory file " + this.name + ", all zeros assumed", "Error", 0);
                    }
                }
            }
        }
        this.mem = new HashMap<Integer, BitSet>(this.initMem);
        this.getOutput("output").setValue(null);
        this.currentValue = null;
        this.activity.clear();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        class MemAction {
            MemoryAction action;
            int addr;
            BitSet data;

            MemAction() {
            }
        }
        if (todo == null) {
            MemAction act;
            BitSet addr;
            BitSet csb = this.getInput("CS").getValue();
            if (csb == null) {
                csb = new BitSet();
            }
            boolean cs = csb.get(0);
            BitSet oeb = this.getInput("OE").getValue();
            if (oeb == null) {
                oeb = new BitSet();
            }
            boolean oe = oeb.get(0);
            boolean we = true;
            if (this.type == Type.RAM) {
                BitSet web = this.getInput("WE").getValue();
                if (web == null) {
                    web = new BitSet();
                }
                we = web.get(0);
            }
            if ((addr = this.getInput("address").getValue()) == null) {
                addr = new BitSet();
            }
            if (this.type == Type.RAM && !cs && !we) {
                act = new MemAction();
                act.action = MemoryAction.WRITE;
                act.addr = BitSetUtils.ToInt(addr);
                BitSet data = this.getInput("input").getValue();
                if (data == null) {
                    data = new BitSet();
                }
                act.data = (BitSet)data.clone();
                sim.post(new SimEvent(now + (long)this.accessTime, this, act));
            }
            if (!cs && !oe) {
                act = new MemAction();
                act.action = MemoryAction.READ;
                act.addr = BitSetUtils.ToInt(addr);
                sim.post(new SimEvent(now + (long)this.accessTime, this, act));
            } else {
                act = new MemAction();
                act.action = MemoryAction.OFF;
                sim.post(new SimEvent(now + (long)this.accessTime, this, act));
            }
        } else {
            MemAction act = (MemAction)todo;
            if (act.action == MemoryAction.WRITE) {
                BitSet value = (BitSet)act.data.clone();
                if (act.addr >= this.capacity) {
                    return;
                }
                WriteRecord rec = new WriteRecord();
                rec.what = (BitSet)act.data.clone();
                rec.where = act.addr;
                rec.when = now;
                this.activity.add(0, rec);
                this.mem.put(act.addr, value);
            } else if (act.action == MemoryAction.READ) {
                if (act.addr >= this.capacity) {
                    this.currentValue = null;
                    this.getOutput("output").propagate(null, now, sim);
                    return;
                }
                BitSet value = this.mem.get(act.addr) == null ? new BitSet() : (BitSet)this.mem.get(act.addr).clone();
                this.getOutput("output").propagate(value, now, sim);
                this.currentValue = (BitSet)value.clone();
            } else {
                this.currentValue = null;
                this.getOutput("output").propagate(null, now, sim);
            }
        }
    }

    public String getActivityTrace() {
        String result = "";
        for (WriteRecord rec : this.activity) {
            result = String.valueOf(result) + "0x" + BitSetUtils.ToString(rec.what, 16) + " written to location 0x" + Integer.toString(rec.where, 16) + " at time " + rec.when + "\n";
        }
        return result;
    }

    @Override
    public BitSet getCurrentValue() {
        return this.currentValue;
    }

    public BitSet getCurrentValue(int loc) {
        return this.mem.get(loc);
    }

    @Override
    public void showCurrentValue(Point where) {
        final JDialog contents = new JDialog(JLSInfo.frame, true);
        Container window = contents.getContentPane();
        window.setLayout(new BorderLayout());
        if (this.mem == null) {
            this.mem = new HashMap<Integer, BitSet>();
        }
        Set<Integer> unsorted = this.mem.keySet();
        TreeSet<Integer> addrs = new TreeSet<Integer>(unsorted);
        JPanel display = new JPanel(new GridLayout(addrs.size(), 2, 10, 3));
        Iterator iterator = addrs.iterator();
        while (iterator.hasNext()) {
            int addr = (Integer)iterator.next();
            String hexAddr = Integer.toHexString(addr);
            String allAddr = "0x" + hexAddr + " (" + addr + "):";
            JLabel addrLabel = new JLabel(allAddr, 4);
            addrLabel.setOpaque(true);
            addrLabel.setBackground(Color.WHITE);
            display.add(addrLabel);
            BitSet temp = new BitSet(1);
            if (this.mem.get(addr) != null) {
                temp = this.mem.get(addr);
            }
            String hex = BitSetUtils.ToString(temp, 16);
            String unsigned = BitSetUtils.ToString(temp, 10);
            String signed = BitSetUtils.ToStringSigned(temp, this.bits);
            String value = "0x" + hex + " (" + unsigned + " unsigned, " + signed + " signed)";
            JLabel dataLabel = new JLabel(value);
            dataLabel.setOpaque(true);
            dataLabel.setBackground(Color.WHITE);
            display.add(dataLabel);
        }
        JScrollPane pane = new JScrollPane(display);
        int width = (int)display.getPreferredSize().getWidth();
        int height = (int)display.getPreferredSize().getHeight();
        pane.setPreferredSize(new Dimension(width + 50, Math.min(height, 400)));
        window.add((Component)pane, "Center");
        JButton ok = new JButton("ok");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                contents.dispose();
            }
        });
        window.add((Component)ok, "South");
        window.add((Component)new JLabel("Non-Zero Words:", 0), "North");
        contents.pack();
        contents.setLocation(10, 10);
        contents.setDefaultCloseOperation(2);
        contents.setVisible(true);
    }

    private static enum MemoryAction {
        WRITE,
        READ,
        OFF;

    }

    private class MemoryEdit
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField nameField;
        private JTextField bitsField;
        private JTextField capacityField;
        private KeyPad bitsPad;
        private KeyPad capacityPad;
        private JRadioButton ram;
        private JRadioButton rom;
        private JButton fromFile;
        private JButton builtIn;
        private boolean create;
        String tempInit;

        private MemoryEdit(int x, int y, boolean create) {
            JPanel info;
            super(JLSInfo.frame, create ? "Create Memory" : "Change Memory", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.nameField = new JTextField(Memory.this.name);
            this.bitsField = new JTextField(String.valueOf(Memory.this.bits), 10);
            this.capacityField = new JTextField("2", 10);
            this.bitsPad = new KeyPad(this.bitsField, 10, Memory.this.bits, this);
            this.capacityPad = new KeyPad(this.capacityField, 10, 2L, this);
            this.ram = new JRadioButton("RAM");
            this.rom = new JRadioButton("ROM");
            this.fromFile = new JButton("from File");
            this.builtIn = new JButton("Built In");
            this.tempInit = Memory.this.initialValue;
            this.create = create;
            Memory.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            if (create) {
                JLabel tlbl = new JLabel("Type");
                tlbl.setAlignmentX(0.5f);
                window.add(tlbl);
                JPanel types = new JPanel(new GridLayout(1, 2));
                types.add(this.ram);
                this.ram.setToolTipText("Random Access Memory");
                this.ram.setHorizontalAlignment(0);
                types.add(this.rom);
                this.rom.setToolTipText("Read Only Memory");
                this.rom.setHorizontalAlignment(0);
                ButtonGroup group = new ButtonGroup();
                group.add(this.ram);
                group.add(this.rom);
                window.add(types);
            }
            if (create) {
                window.add(new JLabel(" "));
                info = new JPanel(new BorderLayout());
                JPanel labels = new JPanel(new GridLayout(3, 1, 1, 5));
                JLabel name = new JLabel("Name: ", 4);
                labels.add(name);
                JLabel bits = new JLabel("Bits/Word: ", 4);
                labels.add(bits);
                JLabel words = new JLabel("Capacity (words): ", 4);
                labels.add(words);
                info.add((Component)labels, "West");
                JPanel fields = new JPanel(new GridLayout(3, 1, 1, 5));
                fields.add(this.nameField);
                JPanel b = new JPanel(new BorderLayout());
                b.add((Component)this.bitsField, "Center");
                b.add((Component)this.bitsPad, "East");
                fields.add(b);
                JPanel i = new JPanel(new BorderLayout());
                i.add((Component)this.capacityField, "Center");
                i.add((Component)this.capacityPad, "East");
                this.capacityPad.setBase(10);
                fields.add(i);
                info.add((Component)fields, "Center");
                window.add(info);
            } else {
                info = new JPanel(new BorderLayout());
                JLabel name = new JLabel("Name: ", 4);
                info.add((Component)name, "West");
                info.add((Component)this.nameField, "Center");
                window.add(info);
            }
            window.add(new JLabel(" "));
            JLabel ilbl = new JLabel("Initial Memory Contents:");
            ilbl.setAlignmentX(0.5f);
            window.add(ilbl);
            JPanel inits = new JPanel(new GridLayout(1, 2));
            inits.add(this.builtIn);
            this.builtIn.setToolTipText("open dialog to set initial values");
            inits.add(this.fromFile);
            this.fromFile.setToolTipText("open dialog to set file name");
            window.add(inits);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "memory", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.nameField.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.capacityField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.ram.addActionListener(this);
            this.rom.addActionListener(this);
            this.fromFile.addActionListener(this);
            this.builtIn.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    MemoryEdit.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField || event.getSource() == this.bitsField || event.getSource() == this.capacityField) {
                String tname = this.nameField.getText().trim();
                if (tname.equals("") || !Util.isValidName(tname)) {
                    JOptionPane.showMessageDialog(this, "Missing or invalid name", "Error", 0);
                    return;
                }
                int tbits = Memory.this.bits;
                int tcapacity = Memory.this.capacity;
                Type ttype = null;
                if (this.create) {
                    try {
                        tbits = Integer.parseInt(this.bitsField.getText());
                        tcapacity = Integer.parseInt(this.capacityField.getText(), 10);
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(this, "Value not numeric", "Error", 0);
                        return;
                    }
                    if (tbits < 1) {
                        JOptionPane.showMessageDialog(this, "Must have at least 1 bit", "Error", 0);
                        return;
                    }
                    if (this.ram.isSelected()) {
                        ttype = Type.RAM;
                    } else if (this.rom.isSelected()) {
                        ttype = Type.ROM;
                    } else {
                        JOptionPane.showMessageDialog(this, "Pick RAM or ROM", "Error", 0);
                        return;
                    }
                }
                if (!tname.equals(Memory.this.name) && Memory.this.circuit.hasName(tname)) {
                    JOptionPane.showMessageDialog(this, "Duplicate name", "Error", 0);
                    return;
                }
                String msg = Memory.this.initOK(this.tempInit, tcapacity, tbits, false);
                if (msg != null) {
                    JOptionPane.showMessageDialog(this.getParent(), String.valueOf(msg) + " in built in initialization", "Error", 0);
                    return;
                }
                if (!Memory.this.name.equals("")) {
                    Memory.this.circuit.removeName(Memory.this.name);
                }
                Memory.this.circuit.addName(tname);
                Memory.this.name = tname;
                Memory.this.initialValue = this.tempInit;
                if (this.create) {
                    Memory.this.type = ttype;
                    Memory.this.bits = tbits;
                    Memory.this.capacity = tcapacity;
                    this.bitsPad.close();
                    this.capacityPad.close();
                }
                Memory.this.circuit.markChanged();
                if (!this.create && !this.nameFits(tname)) {
                    Memory.this.changed = true;
                } else {
                    Memory.this.changed = false;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.fromFile) {
                String file = JOptionPane.showInputDialog(this, "File name?", Memory.this.fileName);
                if (file == null) {
                    return;
                }
                file = file.trim();
                while (!file.equals("") && !Util.isValidName(file)) {
                    JOptionPane.showMessageDialog(this, "Missing or invalid file name, try again", "Error", 0);
                    file = JOptionPane.showInputDialog(this, "File name?", Memory.this.fileName);
                    if (file == null) {
                        return;
                    }
                    file = file.trim();
                }
                Memory.this.fileName = file;
                Memory.this.initialValue = "";
            } else if (event.getSource() == this.builtIn) {
                final JDialog init = new JDialog((Dialog)this, true);
                Container window = init.getContentPane();
                window.setLayout(new BoxLayout(window, 1));
                final JTextArea area = new JTextArea(this.tempInit, 10, 12);
                JScrollPane pane = new JScrollPane(area);
                window.add(pane);
                AbstractAction okAction = new AbstractAction("ok"){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        MemoryEdit.this.tempInit = area.getText();
                        String msg = Memory.this.initOK(MemoryEdit.this.tempInit, Integer.MAX_VALUE, Integer.MAX_VALUE, false);
                        if (msg != null) {
                            JOptionPane.showMessageDialog(MemoryEdit.this.getParent(), msg, "Error", 0);
                            return;
                        }
                        Memory.this.fileName = "";
                        init.dispose();
                    }
                };
                AbstractAction cancelAction = new AbstractAction("cancel"){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        init.dispose();
                    }
                };
                window.add(new JLabel(" "));
                JPanel okCancel = new JPanel(new GridLayout(1, 2));
                okCancel.add(new JButton(okAction));
                okCancel.add(new JButton(cancelAction));
                window.add(okCancel);
                init.pack();
                Point loc = this.getLocation();
                init.setLocation(loc);
                init.setVisible(true);
            }
        }

        private void cancel() {
            Memory.this.cancelled = true;
            this.dispose();
        }

        public boolean nameFits(String name) {
            FontMetrics fm = Memory.this.saveg.getFontMetrics();
            int w = fm.stringWidth(" " + name + " ");
            return w <= Memory.this.width;
        }
    }

    private static enum Type {
        RAM,
        ROM;

    }

    private class WriteRecord {
        BitSet what;
        int where;
        long when;

        private WriteRecord() {
        }
    }
}

