/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.sim.Reacts;
import edu.mtu.cs.jls.sim.Simulator;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public abstract class LogicElement
extends Element
implements Reacts {
    private int lx;
    private int ly;
    private int savex;
    private int savey;
    protected Vector<Input> inputs = new Vector();
    protected Vector<Output> outputs = new Vector();

    public LogicElement(Circuit circuit) {
        super(circuit);
    }

    @Override
    public void setXY(int x, int y) {
        this.lx = x;
        this.ly = y;
        int s = 12;
        int nx = (x + s / 2) / s * s;
        int ny = (y + s / 2) / s * s;
        super.setXY(nx, ny);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("x")) {
            this.lx = value;
        } else if (name.equals("y")) {
            this.ly = value;
        }
        super.setValue(name, value);
    }

    public void copy(LogicElement it) {
        it.lx = this.lx;
        it.ly = this.ly;
        it.savex = this.savex;
        it.savey = this.savey;
        super.copy(it);
    }

    @Override
    public void move(int dx, int dy) {
        WireEnd end;
        this.lx += dx;
        this.ly += dy;
        int s = 12;
        int nx = (this.lx + s / 2) / s * s;
        int ny = (this.ly + s / 2) / s * s;
        super.setXY(nx, ny);
        for (Input input : this.inputs) {
            end = input.getWireEnd();
            if (end == null) continue;
            end.move(dx, dy);
        }
        for (Output output : this.outputs) {
            end = output.getWireEnd();
            if (end == null) continue;
            end.move(dx, dy);
        }
    }

    @Override
    public void savePosition() {
        WireEnd end;
        this.savex = this.lx;
        this.savey = this.ly;
        super.savePosition();
        for (Input input : this.inputs) {
            input.savePosition();
            if (!input.isAttached()) continue;
            end = input.getWireEnd();
            end.savePosition();
        }
        for (Output output : this.outputs) {
            output.savePosition();
            if (!output.isAttached()) continue;
            end = output.getWireEnd();
            end.savePosition();
        }
    }

    @Override
    public void restorePosition() {
        WireEnd end;
        this.lx = this.savex;
        this.ly = this.savey;
        super.restorePosition();
        for (Input input : this.inputs) {
            input.restorePosition();
            if (!input.isAttached()) continue;
            end = input.getWireEnd();
            end.restorePosition();
        }
        for (Output output : this.outputs) {
            output.restorePosition();
            if (!output.isAttached()) continue;
            end = output.getWireEnd();
            end.restorePosition();
        }
    }

    @Override
    public void fixPosition() {
        WireEnd end;
        this.lx = this.x;
        this.ly = this.y;
        for (Input input : this.inputs) {
            if (!input.isAttached()) continue;
            end = input.getWireEnd();
            end.fixPosition();
        }
        for (Output output : this.outputs) {
            if (!output.isAttached()) continue;
            end = output.getWireEnd();
            end.fixPosition();
        }
    }

    @Override
    public void remove(Circuit circ) {
        WireEnd end;
        for (Put put : this.inputs) {
            if (!put.isAttached()) continue;
            end = put.getWireEnd();
            end.setPut(null);
            end.getNet().recheck();
        }
        for (Put put : this.outputs) {
            if (!put.isAttached()) continue;
            end = put.getWireEnd();
            end.setPut(null);
            end.getNet().recheck();
        }
        super.remove(circ);
    }

    @Override
    public Put getPut(int x, int y) {
        for (Input input : this.inputs) {
            if (Math.abs(x - input.getX()) >= 6 || Math.abs(y - input.getY()) >= 6) continue;
            return input;
        }
        for (Output output : this.outputs) {
            if (Math.abs(x - output.getX()) >= 6 || Math.abs(y - output.getY()) >= 6) continue;
            return output;
        }
        return null;
    }

    @Override
    public void setTouching(boolean setting) {
        for (Put put : this.inputs) {
            put.setTouching(setting);
        }
        for (Put put : this.outputs) {
            put.setTouching(setting);
        }
    }

    @Override
    public Set<Put> getAllPuts() {
        HashSet<Put> all = new HashSet<Put>(this.inputs);
        all.addAll(this.outputs);
        return all;
    }

    @Override
    public Put getPut(String name) {
        for (Put put : this.inputs) {
            if (!name.equals(put.getName())) continue;
            return put;
        }
        for (Put put : this.outputs) {
            if (!name.equals(put.getName())) continue;
            return put;
        }
        return null;
    }

    public Input getInput(String name) {
        for (Input p : this.inputs) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public Output getOutput(String name) {
        for (Output p : this.outputs) {
            if (!name.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    protected void detach() {
        WireEnd end;
        for (Input input : this.inputs) {
            if (!input.isAttached()) continue;
            end = input.getWireEnd();
            end.setPut(null);
            end.getNet().recheck();
        }
        for (Output output : this.outputs) {
            if (!output.isAttached()) continue;
            end = output.getWireEnd();
            end.setPut(null);
            end.getNet().recheck();
        }
        this.inputs.clear();
        this.outputs.clear();
    }

    @Override
    public void initSim(Simulator sim) {
        System.out.println("initSim not implemented: " + this.getClass().getName());
    }

    public void initInputs() {
        for (Input in : this.inputs) {
            in.setValue(BitSetUtils.Create(0L));
        }
    }

    public void resetPropDelay() {
    }

    @Override
    public void setDelay(int newDelay) {
    }

    @Override
    public String getName() {
        return "";
    }

    public String getFullName() {
        Circuit circ = this.getCircuit();
        String name = this.getName();
        while (circ.isImported()) {
            name = String.valueOf(circ.getSubElement().getName()) + "." + name;
            circ = circ.getSubElement().getCircuit();
        }
        return name;
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        throw new UnsupportedOperationException("no react");
    }

    public int getBits() {
        throw new UnsupportedOperationException("no getBits");
    }

    public BitSet getCurrentValue() {
        throw new UnsupportedOperationException("no getCurrentValue");
    }
}

