/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.JumpEnd;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class JumpStart
extends LogicElement
implements TriProp {
    private static final int defaultBits = 1;
    private String name;
    private int bits = 1;
    private boolean watched = false;
    private boolean cancelled;
    private JumpStart me;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.LEFT;
    private BitSet currentValue = new BitSet();
    private Set<JumpEnd> jumpEnds = new HashSet<JumpEnd>();

    public JumpStart(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        this.me = this;
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new StartCreate(x + win.x, y + win.y);
        } else {
            new StartCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        if (g != null && this.width == 0 && this.height == 0) {
            int s = 12;
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(" " + this.name + " ") + s;
            this.width = Math.max((w + s / 2) / s * s, 2 * s);
            this.height = 0;
        }
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("input", this, 0, 0, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("input", this, this.width, 0, this.bits));
        }
        this.circuit.addJumpStart(this.name, this);
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        for (Element el : this.circuit.getElements()) {
            JumpEnd jend;
            if (!(el instanceof JumpEnd) || !this.name.equals((jend = (JumpEnd)el).getName()) || !el.highlight) continue;
            g.setColor(Color.orange);
            Graphics2D gg = (Graphics2D)g;
            gg.fill(this.getRect());
        }
        int s = 12;
        int top = this.y - s / 2;
        int bottom = this.y + s / 2;
        if (this.watched) {
            g.setColor(JLSInfo.watchColor);
            g.fillRect(this.x, top, this.width - s, bottom - top);
        }
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            g.setColor(Color.BLACK);
            g.drawLine(this.x, top, this.x, bottom);
            g.drawLine(this.x, top, this.x + this.width - s, top);
            g.drawLine(this.x, bottom, this.x + this.width - s, bottom);
            g.drawArc(this.x + this.width - 3 * s / 2, top, s, s, -90, 180);
            g.drawLine(this.x + this.width - s / 2, this.y, this.x + this.width, this.y);
            g.drawLine(this.x + this.width, this.y, this.x + this.width - s / 4, this.y - s / 4);
            g.drawLine(this.x + this.width, this.y, this.x + this.width - s / 4, this.y + s / 4);
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            g.setColor(Color.BLACK);
            g.drawLine(this.x + this.width, top, this.x + this.width, bottom);
            g.drawLine(this.x + s, top, this.x + this.width, top);
            g.drawLine(this.x + s, bottom, this.x + this.width, bottom);
            g.drawArc(this.x + s / 2, top, s, s, -90, -180);
            g.drawLine(this.x, this.y, this.x + s / 2, this.y);
            g.drawLine(this.x, this.y, this.x + s / 4, this.y - s / 4);
            g.drawLine(this.x, this.y, this.x + s / 4, this.y + s / 4);
        }
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int h = fm.getDescent() + ascent;
        int w = fm.stringWidth(this.name);
        int tx = 0;
        tx = this.orientation == JLSInfo.Orientation.LEFT ? this.x + (this.width - s - w) / 2 + 3 : this.x + (this.width + 0 - w) / 2 + 3;
        g.drawString(this.name, tx, this.y - h / 2 + ascent);
        ((Input)this.inputs.get(0)).draw(g);
    }

    @Override
    public Rectangle getRect() {
        return new Rectangle(this.x, this.y - 6, this.width, this.height + 12);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("watch")) {
            this.watched = value != 0;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("name")) {
            this.name = value;
            this.circuit.addName(value);
        } else if (name.equals("orientation")) {
            this.orientation = JLSInfo.Orientation.valueOf(value);
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT JumpStart");
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" int bits " + this.bits);
        output.println(" int watch " + (this.watched ? 1 : 0));
        output.println(" String orientation \"" + (Object)((Object)this.orientation) + "\"");
        output.println("END");
    }

    @Override
    public Element copy() {
        JumpStart it = new JumpStart(this.circuit);
        it.name = this.name;
        it.bits = this.bits;
        it.watched = this.watched;
        it.orientation = this.orientation;
        it.inputs.add(((Input)this.inputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JLSInfo.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.bits) + " bit wire name, value = " + BitSetUtils.toDisplay(this.currentValue, this.bits));
    }

    @Override
    public void remove(Circuit circ) {
        this.circuit.removeName(this.name);
        circ.removeJumpStart(this.name);
        HashSet<Element> rems = new HashSet<Element>();
        for (Element el : circ.getElements()) {
            JumpEnd end;
            if (!(el instanceof JumpEnd) || !this.name.equals((end = (JumpEnd)el).getName())) continue;
            rems.add(el);
        }
        for (Element el : rems) {
            el.remove(circ);
        }
        super.remove(circ);
    }

    @Override
    public boolean canFlip() {
        return !((Input)this.inputs.get(0)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        }
        this.inputs.clear();
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("input", this, 0, 0, this.bits));
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("input", this, this.width, 0, this.bits));
        }
    }

    @Override
    public boolean canWatch() {
        return true;
    }

    @Override
    public boolean isWatched() {
        return this.watched;
    }

    @Override
    public void setWatched(boolean state) {
        this.watched = state;
    }

    @Override
    public void setTriState(boolean which) {
        for (Element el : this.circuit.getElements()) {
            if (!(el instanceof JumpEnd)) continue;
            JumpEnd jend = (JumpEnd)el;
            if (!this.getName().equals(jend.getName())) continue;
            jend.setTriState(which);
        }
    }

    @Override
    public BitSet getCurrentValue() {
        if (this.currentValue == null) {
            return null;
        }
        return (BitSet)this.currentValue.clone();
    }

    @Override
    public void initSim(Simulator sim) {
        this.jumpEnds.clear();
        for (Element el : this.circuit.getElements()) {
            JumpEnd jend;
            if (!(el instanceof JumpEnd) || !this.name.equals((jend = (JumpEnd)el).getName())) continue;
            this.jumpEnds.add(jend);
        }
        this.currentValue = new BitSet();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        this.currentValue = ((Input)this.inputs.get(0)).getValue();
        if (this.currentValue != null) {
            this.currentValue = (BitSet)this.currentValue.clone();
        }
        for (JumpEnd jend : this.jumpEnds) {
            BitSet newValue = null;
            if (this.currentValue != null) {
                newValue = (BitSet)this.currentValue.clone();
            }
            sim.post(new SimEvent(now, jend, newValue));
        }
    }

    private class StartCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField nameField;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton left;
        private JRadioButton right;

        private StartCreate(int x, int y) {
            super(JLSInfo.frame, "Create Wire Start", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.nameField = new JTextField("", 12);
            this.bitsField = new JTextField("1", 5);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.left = new JRadioButton("left");
            this.right = new JRadioButton("right");
            JumpStart.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JPanel labels = new JPanel(new GridLayout(2, 1, 1, 5));
            JLabel name = new JLabel("Name: ", 4);
            labels.add(name);
            JLabel bits = new JLabel("Bits: ", 4);
            labels.add(bits);
            info.add((Component)labels, "West");
            JPanel data = new JPanel(new GridLayout(2, 1, 1, 5));
            data.add(this.nameField);
            JPanel bitsPanel = new JPanel(new BorderLayout());
            bitsPanel.add((Component)this.bitsField, "Center");
            bitsPanel.add((Component)this.bitsPad, "East");
            data.add(bitsPanel);
            info.add((Component)data, "Center");
            window.add(info);
            window.add(new JLabel(" "));
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(1, 3));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            ButtonGroup group = new ButtonGroup();
            group.add(this.left);
            group.add(this.right);
            this.left.setSelected(true);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "start", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.nameField.addActionListener(this);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    StartCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.nameField) {
                String tname = this.nameField.getText();
                if (!Util.isValidName(tname)) {
                    JOptionPane.showMessageDialog(this, "Invalid name", "Error", 0);
                    return;
                }
                try {
                    JumpStart.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Bits not numeric", "Error", 0);
                    return;
                }
                if (JumpStart.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must have at least 1 bit", "Error", 0);
                    return;
                }
                if (!JumpStart.this.circuit.addName(tname)) {
                    JOptionPane.showMessageDialog(this, "Name already used", "Error", 0);
                    return;
                }
                if (this.right.isSelected()) {
                    JumpStart.this.orientation = JLSInfo.Orientation.RIGHT;
                } else {
                    JumpStart.this.orientation = JLSInfo.Orientation.LEFT;
                }
                JumpStart.this.circuit.addJumpStart(tname, JumpStart.this.me);
                JumpStart.this.name = tname;
                this.bitsPad.close();
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            JumpStart.this.cancelled = true;
            this.dispose();
        }
    }
}

