/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.JumpStart;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class JumpEnd
extends LogicElement {
    private static final int defaultBits = 1;
    private int bits = 1;
    private String name;
    private boolean cancelled;
    private boolean loadTriState = false;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    private BitSet currentValue = new BitSet();

    public JumpEnd(Circuit circuit) {
        super(circuit);
    }

    public JumpEnd(Circuit circuit, String name) {
        super(circuit);
        this.name = name;
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (this.name == null) {
            if (pos == null) {
                new EndCreate(x + win.x, y + win.y);
            } else {
                new EndCreate(pos.x + win.x, pos.y + win.y);
            }
        } else {
            this.bits = this.circuit.getJumpStart(this.name).getBits();
            this.orientation = this.circuit.getJumpStart(this.name).getOrientation() == JLSInfo.Orientation.LEFT ? JLSInfo.Orientation.RIGHT : JLSInfo.Orientation.LEFT;
            this.cancelled = false;
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        JumpStart start = this.circuit.getJumpStart(this.name);
        Input in = start.getInput("input");
        if (in.isAttached() && in.getWireEnd().getNet().isTriState()) {
            for (Output out : this.outputs) {
                out.setTriState(true);
            }
        }
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        if (g != null && this.width == 0 && this.height == 0) {
            int s = 12;
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(" " + this.name + " ") + s;
            this.width = Math.max((w + s / 2) / s * s, 2 * s);
            this.height = 0;
        }
        Output out = this.orientation == JLSInfo.Orientation.RIGHT ? new Output("output", this, this.width, 0, this.bits) : new Output("output", this, 0, 0, this.bits);
        this.outputs.add(out);
        if (this.loadTriState) {
            out.loadSetTriState();
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        for (Element el : this.circuit.getElements()) {
            JumpStart jstart;
            if (!(el instanceof JumpStart) || !this.name.equals((jstart = (JumpStart)el).getName()) || !el.highlight) continue;
            g.setColor(Color.orange);
            Graphics2D gg = (Graphics2D)g;
            gg.fill(this.getRect());
        }
        int s = 12;
        int top = this.y - s / 2;
        int bottom = this.y + s / 2;
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            g.setColor(Color.BLACK);
            g.drawLine(this.x + this.width - s / 2, top, this.x + this.width - s / 2, bottom);
            g.drawLine(this.x + s / 2, top, this.x + this.width - s / 2, top);
            g.drawLine(this.x + s / 2, bottom, this.x + this.width - s / 2, bottom);
            g.drawArc(this.x, top, s, s, -90, -180);
            g.drawLine(this.x + this.width - s / 2, this.y, this.x + this.width, this.y);
            g.drawLine(this.x + this.width - s / 2, this.y, this.x + this.width - s / 4, this.y - s / 4);
            g.drawLine(this.x + this.width - s / 2, this.y, this.x + this.width - s / 4, this.y + s / 4);
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s / 2, top, this.x + s / 2, bottom);
            g.drawLine(this.x + s / 2, top, this.x + this.width - s / 2, top);
            g.drawLine(this.x + s / 2, bottom, this.x + this.width - s / 2, bottom);
            g.drawArc(this.x + this.width - s, top, s, s, -90, 180);
            g.drawLine(this.x, this.y, this.x + s / 2, this.y);
            g.drawLine(this.x + s / 2, this.y, this.x + s / 4, this.y - s / 4);
            g.drawLine(this.x + s / 2, this.y, this.x + s / 4, this.y + s / 4);
        }
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int h = fm.getDescent() + ascent;
        int w = fm.stringWidth(this.name);
        int tx = 0;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            tx = this.x + s / 2 + (this.width - s - w) / 2 + 3;
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            tx = this.x + s / 2 + (this.width - 2 * s - w) / 2 + 3;
        }
        g.drawString(this.name, tx, this.y - h / 2 + ascent);
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public Rectangle getRect() {
        return new Rectangle(this.x, this.y - 6, this.width, this.height + 12);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("tristate")) {
            this.loadTriState = true;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("name")) {
            this.name = value;
            this.circuit.addName(value);
        } else if (name.equals("orientation")) {
            this.orientation = JLSInfo.Orientation.valueOf(value);
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT JumpEnd");
        super.save(output);
        output.println(" String name \"" + this.name + "\"");
        output.println(" int bits " + this.bits);
        output.println(" String orientation \"" + (Object)((Object)this.orientation) + "\"");
        if (((Output)this.outputs.get(0)).isTriState()) {
            output.println(" int tristate 1");
        }
        output.println("END");
    }

    @Override
    public Element copy() {
        JumpEnd it = new JumpEnd(this.circuit);
        it.name = this.name;
        it.bits = this.bits;
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        it.orientation = this.orientation;
        super.copy(it);
        return it;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.bits) + " bit wire connection, value = " + BitSetUtils.toDisplay(this.currentValue, this.bits));
    }

    public void setTriState(boolean which) {
        for (Output out : this.outputs) {
            out.setTriState(which);
        }
    }

    @Override
    public boolean canFlip() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        }
        this.outputs.clear();
        Output out = this.orientation == JLSInfo.Orientation.RIGHT ? new Output("output", this, this.width, 0, this.bits) : new Output("output", this, 0, 0, this.bits);
        this.outputs.add(out);
        if (this.loadTriState) {
            out.loadSetTriState();
        }
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        if (out.isTriState()) {
            this.currentValue = null;
            out.setValue(null);
        } else {
            this.currentValue = new BitSet();
            BitSet bitval = new BitSet(1);
            out.setValue(bitval);
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        BitSet value = (BitSet)todo;
        this.currentValue = null;
        if (value != null) {
            this.currentValue = (BitSet)value.clone();
        }
        Output out = (Output)this.outputs.get(0);
        if (value == null) {
            out.propagate(null, now, sim);
        } else {
            out.propagate((BitSet)value.clone(), now, sim);
        }
    }

    private class EndCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JList starts;
        private JRadioButton left;
        private JRadioButton right;

        private EndCreate(int x, int y) {
            super(JLSInfo.frame, "Create Wire End", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.left = new JRadioButton("left");
            this.right = new JRadioButton("right");
            JumpEnd.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JLabel heading = new JLabel("Select Wire Name", 0);
            heading.setAlignmentX(0.5f);
            window.add(heading);
            this.starts = new JList<Object>(JumpEnd.this.circuit.getJumpStartNames().toArray());
            this.starts.setSelectionMode(0);
            this.starts.setVisibleRowCount(Math.min(JumpEnd.this.circuit.getJumpStartNames().size(), 10));
            JScrollPane pane = new JScrollPane(this.starts);
            window.add(pane);
            if (JumpEnd.this.circuit.getJumpStartNames().size() == 1) {
                this.starts.setSelectedIndex(0);
            }
            window.add(new JLabel(" "));
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(1, 3));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            ButtonGroup group = new ButtonGroup();
            group.add(this.left);
            group.add(this.right);
            this.right.setSelected(true);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "end", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    EndCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok) {
                if (this.starts.getSelectedIndex() < 0) {
                    JOptionPane.showMessageDialog(this, "Nothing selected", "Error", 0);
                    return;
                }
                JumpEnd.this.name = (String)this.starts.getSelectedValue();
                JumpEnd.this.bits = JumpEnd.this.circuit.getJumpStart(JumpEnd.this.name).getBits();
                if (this.right.isSelected()) {
                    JumpEnd.this.orientation = JLSInfo.Orientation.RIGHT;
                } else {
                    JumpEnd.this.orientation = JLSInfo.Orientation.LEFT;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            JumpEnd.this.cancelled = true;
            this.dispose();
        }
    }
}

