/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.Pin;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class InputPin
extends Pin
implements TriProp {
    private boolean loadTriState = false;
    private BitSet currentValue = new BitSet();

    public InputPin(Circuit circ) {
        super(circ);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        return super.setup(g, editWindow, x, y, "Input");
    }

    @Override
    public void init(Graphics g) {
        Output out;
        super.init(g);
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            out = new Output("output", this, this.width, 12, this.bits);
            this.outputs.add(out);
            if (this.loadTriState) {
                out.loadSetTriState();
            }
        }
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            out = new Output("output", this, 0, 12, this.bits);
            this.outputs.add(out);
            if (this.loadTriState) {
                out.loadSetTriState();
            }
        }
        if (this.orientation == JLSInfo.Orientation.DOWN) {
            out = new Output("output", this, this.width / 2, this.height, this.bits);
            this.outputs.add(out);
            if (this.loadTriState) {
                out.loadSetTriState();
            }
        }
        if (this.orientation == JLSInfo.Orientation.UP) {
            out = new Output("output", this, this.width / 2, 0, this.bits);
            this.outputs.add(out);
            if (this.loadTriState) {
                out.loadSetTriState();
            }
        }
    }

    @Override
    public void draw(Graphics g) {
        int s = 12;
        Polygon p = new Polygon();
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            p.addPoint(this.x, this.y);
            p.addPoint(this.x + this.width - s, this.y);
            p.addPoint(this.x + this.width, this.y + this.height / 2);
            p.addPoint(this.x + this.width - s, this.y + this.height);
            p.addPoint(this.x, this.y + this.height);
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            p.addPoint(this.x + s, this.y);
            p.addPoint(this.x, this.y + this.height / 2);
            p.addPoint(this.x + s, this.y + this.height);
            p.addPoint(this.x + this.width, this.y + this.height);
            p.addPoint(this.x + this.width, this.y);
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            p.addPoint(this.x, this.y);
            p.addPoint(this.x + this.width, this.y);
            p.addPoint(this.x + this.width, this.y + this.height - s);
            p.addPoint(this.x + this.width / 2, this.y + this.height);
            p.addPoint(this.x, this.y + this.height - s);
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            p.addPoint(this.x + this.width / 2, this.y);
            p.addPoint(this.x + this.width, this.y + s);
            p.addPoint(this.x + this.width, this.y + this.height);
            p.addPoint(this.x, this.y + this.height);
            p.addPoint(this.x, this.y + s);
        }
        if (this.watched) {
            g.setColor(JLSInfo.watchColor);
            g.fillPolygon(p);
        }
        super.draw(g);
        Rectangle original = this.getRect();
        Rectangle r = new Rectangle(original.x, original.y, original.width - s, original.height);
        g.setColor(Color.BLACK);
        g.drawPolygon(p);
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D t = fm.getStringBounds(this.name, g);
        double tw = t.getWidth();
        double th = t.getHeight();
        int bx = this.x;
        int by = this.y;
        int bwidth = this.width;
        int bheight = this.height;
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            bx = this.x + s;
            bwidth = this.width - s;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            bwidth = this.width - s;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            by = this.y + s;
            bheight = this.height - s;
        } else {
            bheight = this.height - s;
        }
        int dx = (int)(((double)bwidth - tw) / 2.0);
        int dy = (int)(((double)bheight - th) / 2.0 + (double)fm.getAscent());
        g.drawString(this.name, bx + dx, by + dy);
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT InputPin");
        if (((Output)this.outputs.get(0)).isTriState()) {
            output.println(" int tristate 1");
        }
        super.save(output);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("tristate")) {
            this.loadTriState = true;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        InputPin it = new InputPin(this.circuit);
        it.name = this.name;
        it.bits = this.bits;
        it.orientation = this.orientation;
        it.watched = this.watched;
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        String tri = "";
        if (((Output)this.outputs.get(0)).isTriState()) {
            tri = " (tri-state) ";
        }
        info.setText(String.valueOf(this.bits) + " bit input pin" + tri + ", value = " + BitSetUtils.toDisplay(this.currentValue, this.bits));
    }

    public void printValue(String qual) {
        if (qual.equals("")) {
            System.out.printf("Input Pin %s: %s\n", this.name, BitSetUtils.toDisplay(this.currentValue, this.bits));
        } else {
            System.out.printf("Input Pin %s.%s: %s\n", qual, this.name, BitSetUtils.toDisplay(this.currentValue, this.bits));
        }
    }

    @Override
    public void setTriState(boolean which) {
        for (Output output : this.outputs) {
            output.setTriState(which);
        }
    }

    @Override
    public void remove(Circuit circ) {
        if (circ.isImported()) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "Can't remove input pin " + this.name + " from a subcircuit");
            return;
        }
        super.remove(circ);
    }

    @Override
    public boolean canRotate() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public String toString() {
        return "[InputPin " + this.name + "(" + this.bits + " bits)]";
    }

    @Override
    public BitSet getCurrentValue() {
        if (this.currentValue == null) {
            return null;
        }
        return (BitSet)this.currentValue.clone();
    }

    @Override
    public void initSim(Simulator sim) {
        SubCircuit sub;
        Input input;
        this.currentValue = new BitSet();
        if (this.circuit.isImported() && (input = (sub = this.circuit.getSubElement()).getInput(this.name)).isAttached() && input.getWireEnd().isTriState()) {
            this.currentValue = null;
        }
        Output out = (Output)this.outputs.get(0);
        if (this.currentValue == null) {
            out.setValue(null);
        } else {
            out.setValue((BitSet)this.currentValue.clone());
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        Output out = (Output)this.outputs.get(0);
        BitSet value = (BitSet)todo;
        if (value == null) {
            this.currentValue = null;
            out.propagate(value, now, sim);
        } else {
            this.currentValue = (BitSet)value.clone();
            out.propagate((BitSet)value.clone(), now, sim);
        }
    }

    @Override
    public void showCurrentValue(Point where) {
        String value = "off";
        if (this.currentValue != null) {
            String hex = BitSetUtils.ToString(this.currentValue, 16);
            String unsigned = BitSetUtils.ToString(this.currentValue, 10);
            String signed = BitSetUtils.ToStringSigned(this.currentValue, this.bits);
            value = "0x" + hex + " (" + unsigned + " unsigned, " + signed + " signed)";
        }
        JOptionPane.showMessageDialog(JLSInfo.frame, value, "Information", 1);
    }
}

