/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public abstract class Group
extends LogicElement {
    private static final int defaultBits = 2;
    protected int bits = 2;
    protected ArrayList<Entry> ranges;
    protected boolean triState = false;
    protected JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    protected boolean cancelled;
    protected boolean loadTriState = false;
    protected boolean noncontig = false;

    public Group(Circuit circuit) {
        super(circuit);
        this.ranges = new ArrayList();
    }

    @Override
    public void init(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.width != 0 || this.height != 0) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int s = 12;
        int puts = this.ranges.size();
        this.width = 0;
        for (Entry e : this.ranges) {
            this.width = Math.max(this.width, fm.stringWidth(e.toCircuitString()));
        }
        this.width = (this.width + 2 * s) / s * s;
        this.height = (puts + 1) * s;
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        boolean doit = false;
        for (Input input : this.inputs) {
            if (input.isAttached()) continue;
            doit = true;
        }
        for (Output output : this.outputs) {
            if (output.isAttached()) continue;
            doit = true;
        }
        if (doit) {
            g.setColor(Color.gray);
            g.drawRect(this.x, this.y, this.width, this.height);
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("tristate")) {
            if (value == 1) {
                this.loadTriState = true;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        } else if (name.equals("noncontig")) {
            this.noncontig = value.equals("true");
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
    }

    @Override
    public boolean canFlip() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void setPair(int v1, int v2) {
        if (this.noncontig) {
            Entry e = this.ranges.size() <= v1 || this.ranges.get(v1) == null ? new Entry(new int[0]) : this.ranges.get(v1);
            int[] s1 = (int[])e.getValues().clone();
            int[] s2 = new int[s1.length + 1];
            System.arraycopy(s1, 0, s2, 0, s1.length);
            s2[s2.length - 1] = v2;
            e.setValues(s2);
            while (this.ranges.size() <= v1) {
                this.ranges.add(null);
            }
            this.ranges.set(v1, e);
        } else {
            this.ranges.add(new Entry(v1, v2));
        }
    }

    @Override
    public void save(PrintWriter output) {
        super.save(output);
        output.println(" int bits " + this.bits);
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println(" String noncontig \"true\"");
        if (this.triState) {
            output.println(" int tristate 1");
        } else {
            output.println(" int tristate 0");
        }
        int r = 0;
        for (Entry e : this.ranges) {
            int[] nArray = e.getValues();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                output.println(" pair " + r + " " + i);
                ++n2;
            }
            ++r;
        }
        output.println("END");
    }

    public void copy(Group it) {
        it.bits = this.bits;
        it.ranges = new ArrayList<Entry>(this.ranges);
        it.triState = this.triState;
        it.orientation = this.orientation;
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        for (Output output : this.outputs) {
            it.outputs.add(output.copy(it));
        }
        super.copy(it);
    }

    protected class Entry {
        private int[] values;
        private boolean picked;

        public Entry(int[] values) {
            this.values = (int[])values.clone();
        }

        public Entry(int min, int max) {
            this.values = new int[1 + max - min];
            int i = min;
            while (i <= max) {
                this.values[i - min] = i;
                ++i;
            }
        }

        public int getMin() {
            if (this.values != null && this.values.length > 0) {
                return this.values[0];
            }
            return -1;
        }

        public int getMax() {
            if (this.values != null && this.values.length > 0) {
                return this.values[this.values.length - 1];
            }
            return -1;
        }

        public int[] getValues() {
            return (int[])this.values.clone();
        }

        public void setValues(int[] values) {
            this.values = (int[])values.clone();
        }

        public int getSize() {
            return this.values.length;
        }

        public void setPicked(boolean which) {
            this.picked = which;
        }

        public boolean isPicked() {
            return this.picked;
        }

        public String toString() {
            String p = "";
            if (this.picked) {
                p = " (bundled)";
            }
            return String.valueOf(this.toCircuitString()) + p;
        }

        public String toCircuitString() {
            if (this.getMin() == this.getMax()) {
                return String.valueOf(this.getMin());
            }
            if (this.getMax() - this.getMin() + 1 == this.values.length) {
                return String.valueOf(this.getMax()) + "-" + this.getMin();
            }
            String s = "";
            ArrayList<Integer> l = new ArrayList<Integer>();
            int[] v = new int[this.values.length];
            int i = 0;
            while (i < this.values.length) {
                v[this.values.length - i - 1] = this.values[i];
                ++i;
            }
            i = 0;
            while (i < v.length) {
                if (l.isEmpty()) {
                    l.add(v[i]);
                } else if (v[i] == v[i - 1] - 1) {
                    l.add(v[i]);
                } else {
                    if (!s.isEmpty()) {
                        s = String.valueOf(s) + ", ";
                    }
                    if (l.size() > 1) {
                        s = String.valueOf(s) + l.get(0) + "-" + l.get(l.size() - 1);
                    } else if (!l.isEmpty()) {
                        s = String.valueOf(s) + l.get(0);
                    }
                    l.clear();
                    l.add(v[i]);
                }
                ++i;
            }
            if (!s.isEmpty() && !l.isEmpty()) {
                s = String.valueOf(s) + ", ";
            }
            if (l.size() > 1) {
                s = String.valueOf(s) + l.get(0) + "-" + l.get(l.size() - 1);
            } else if (!l.isEmpty()) {
                s = String.valueOf(s) + l.get(0);
            }
            l.clear();
            return s;
        }
    }

    protected class GetRanges
    extends JDialog
    implements ActionListener {
        private DefaultListModel pick;
        private JList choose;
        private DefaultListModel picked;
        private JList chosen;
        private JButton add;
        private JButton remove;
        private JButton upjumper;
        private JButton upshifter;
        private JButton downshifter;
        private JButton downjumper;
        private JButton ok;
        private JButton cancel;
        private String type;

        protected GetRanges() {
            this.pick = new DefaultListModel();
            this.choose = new JList(this.pick);
            this.picked = new DefaultListModel();
            this.chosen = new JList(this.picked);
            this.add = new JButton(">>");
            this.remove = new JButton("<<");
            this.upjumper = new JButton("Move bundle to top");
            this.upshifter = new JButton("Move bundle up");
            this.downshifter = new JButton("Move bundle down");
            this.downjumper = new JButton("Move bundle to bottom");
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
        }

        public GetRanges(Point where, String type) {
            super(JLSInfo.frame, "Pick Bit Groups", true);
            this.pick = new DefaultListModel();
            this.choose = new JList(this.pick);
            this.picked = new DefaultListModel();
            this.chosen = new JList(this.picked);
            this.add = new JButton(">>");
            this.remove = new JButton("<<");
            this.upjumper = new JButton("Move bundle to top");
            this.upshifter = new JButton("Move bundle up");
            this.downshifter = new JButton("Move bundle down");
            this.downjumper = new JButton("Move bundle to bottom");
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.type = type;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            int b = 0;
            while (b < Group.this.bits) {
                this.pick.addElement(new Entry(new int[]{b++}));
            }
            this.choose.setSelectedIndex(0);
            this.choose.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    boolean allow = true;
                    Entry e = (Entry)GetRanges.this.pick.get(index);
                    if (e.isPicked()) {
                        allow = false;
                    }
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected && allow, cellHasFocus && allow);
                    return this;
                }
            });
            JPanel lists = new JPanel(new FlowLayout());
            JPanel leftList = new JPanel(new BorderLayout());
            JLabel left = new JLabel("choose from", 0);
            leftList.add((Component)left, "North");
            JScrollPane chpane = new JScrollPane(this.choose);
            leftList.add((Component)chpane, "Center");
            lists.add(leftList);
            JPanel buttons = new JPanel(new GridLayout(2, 1));
            buttons.add(this.add);
            buttons.add(this.remove);
            lists.add(buttons);
            JPanel rightList = new JPanel(new BorderLayout());
            JLabel right = new JLabel("chosen", 0);
            rightList.add((Component)right, "North");
            this.chosen.setSelectionMode(0);
            JScrollPane rpane = new JScrollPane(this.chosen);
            rightList.add((Component)rpane, "Center");
            lists.add(rightList);
            JPanel shifters = new JPanel(new GridLayout(4, 1));
            shifters.add(this.upjumper);
            shifters.add(this.upshifter);
            shifters.add(this.downshifter);
            shifters.add(this.downjumper);
            lists.add(shifters);
            window.add(lists);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else if (type.equals("unbundle")) {
                JLSInfo.hb.enableHelpOnButton(help, "unbundle", null);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "bundle", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.add.addActionListener(this);
            this.remove.addActionListener(this);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.upjumper.addActionListener(this);
            this.upshifter.addActionListener(this);
            this.downshifter.addActionListener(this);
            this.downjumper.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GetRanges.this.cancel();
                }
            });
            this.pack();
            this.setLocation(where.x, where.y);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int selected;
            if (event.getSource() == this.add) {
                int i;
                Entry ent;
                int[] selected2;
                int[] nArray = selected2 = this.choose.getSelectedIndices();
                int n = selected2.length;
                int n2 = 0;
                while (n2 < n) {
                    int s = nArray[n2];
                    ent = (Entry)this.pick.elementAt(s);
                    if (ent.isPicked()) {
                        this.choose.removeSelectionInterval(s, s);
                    }
                    ++n2;
                }
                selected2 = this.choose.getSelectedIndices();
                if (selected2.length == 0) {
                    return;
                }
                if (this.type.equals("Unbundler")) {
                    Entry check = new Entry(selected2);
                    i = 0;
                    while (i < this.picked.size()) {
                        if (this.picked.elementAt(i).toString().equals(check.toString())) {
                            JOptionPane.showMessageDialog(this, "Cannot group the same bits twice.", "Error", 0);
                            return;
                        }
                        ++i;
                    }
                }
                this.picked.addElement(new Entry(selected2));
                if (this.type.equals("Bundler")) {
                    nArray = selected2;
                    n = selected2.length;
                    i = 0;
                    while (i < n) {
                        int p = nArray[i];
                        ent = (Entry)this.pick.elementAt(p);
                        ent.setPicked(true);
                        this.pick.setElementAt(ent, p);
                        ++i;
                    }
                }
                int first = -1;
                int where = (selected2[selected2.length - 1] + 1) % this.pick.size();
                int i2 = 0;
                while (i2 < this.pick.size()) {
                    Entry ent2 = (Entry)this.pick.elementAt(where);
                    if (!ent2.isPicked()) {
                        first = where;
                        break;
                    }
                    where = (where + 1) % this.pick.size();
                    ++i2;
                }
                if (first != -1) {
                    this.choose.setSelectedIndex(first);
                } else {
                    this.choose.clearSelection();
                }
            } else if (event.getSource() == this.remove) {
                int where = this.chosen.getSelectedIndex();
                if (where < 0) {
                    return;
                }
                Entry ent = (Entry)this.picked.elementAt(where);
                this.picked.removeElement(ent);
                int[] nArray = ent.getValues();
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int i = nArray[n3];
                    Entry e = (Entry)this.pick.elementAt(i);
                    e.setPicked(false);
                    this.pick.setElementAt(e, i);
                    ++n3;
                }
            } else if (event.getSource() == this.ok) {
                if (this.picked.size() == 0) {
                    JOptionPane.showMessageDialog(this, "No groups chosen", "Error", 0);
                    return;
                }
                int i = 0;
                while (i < this.picked.size()) {
                    Entry e = (Entry)this.picked.elementAt(i);
                    Group.this.ranges.add(new Entry(e.getValues()));
                    ++i;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.upjumper) {
                int selected3 = this.chosen.getSelectedIndex();
                if (selected3 >= 0) {
                    Entry a = (Entry)this.picked.getElementAt(selected3);
                    while (selected3 > 0) {
                        Entry b = (Entry)this.picked.getElementAt(selected3 - 1);
                        this.picked.setElementAt(b, selected3);
                        this.picked.setElementAt(a, selected3 - 1);
                        --selected3;
                    }
                    this.chosen.setSelectedIndex(0);
                }
            } else if (event.getSource() == this.upshifter) {
                int selected4 = this.chosen.getSelectedIndex();
                if (selected4 > 0) {
                    Entry a = (Entry)this.picked.getElementAt(selected4);
                    Entry b = (Entry)this.picked.getElementAt(selected4 - 1);
                    this.picked.setElementAt(b, selected4);
                    this.picked.setElementAt(a, selected4 - 1);
                    this.chosen.setSelectedIndex(selected4 - 1);
                }
            } else if (event.getSource() == this.downshifter) {
                int selected5 = this.chosen.getSelectedIndex();
                if (selected5 >= 0 && selected5 < this.picked.getSize() - 1) {
                    Entry a = (Entry)this.picked.getElementAt(selected5);
                    Entry b = (Entry)this.picked.getElementAt(selected5 + 1);
                    this.picked.setElementAt(b, selected5);
                    this.picked.setElementAt(a, selected5 + 1);
                    this.chosen.setSelectedIndex(selected5 + 1);
                }
            } else if (event.getSource() == this.downjumper && (selected = this.chosen.getSelectedIndex()) >= 0) {
                Entry a = (Entry)this.picked.getElementAt(selected);
                while (selected >= 0 && selected < this.picked.getSize() - 1) {
                    Entry b = (Entry)this.picked.getElementAt(selected + 1);
                    this.picked.setElementAt(b, selected);
                    this.picked.setElementAt(a, selected + 1);
                    ++selected;
                }
                this.chosen.setSelectedIndex(this.picked.getSize() - 1);
            }
        }

        private void cancel() {
            Group.this.cancelled = true;
            this.dispose();
        }
    }

    protected class GroupCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton single;
        private JRadioButton group;
        private JRadioButton left;
        private JRadioButton right;
        private String type;

        protected GroupCreate(int x, int y, String type) {
            super(JLSInfo.frame, "Create " + type, true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.bitsField = new JTextField("2", 10);
            this.bitsPad = new KeyPad(this.bitsField, 10, 2L, this);
            this.single = new JRadioButton("Single Bits");
            this.group = new JRadioButton("Group Bits");
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right", true);
            this.type = type;
            Group.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel bits = type.equals("Unbundler") ? new JLabel("Input Bits: ", 4) : new JLabel("Output Bits: ", 4);
            info.add((Component)bits, "West");
            info.add((Component)this.bitsField, "Center");
            info.add((Component)this.bitsPad, "East");
            window.add(info);
            window.add(new JLabel(" "));
            JPanel choice = new JPanel(new GridLayout(1, 2));
            this.single.setSelected(true);
            choice.add(this.single);
            choice.add(this.group);
            window.add(choice);
            ButtonGroup choices = new ButtonGroup();
            choices.add(this.single);
            choices.add(this.group);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(1, 3));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else if (type.equals("Unbundler")) {
                JLSInfo.hb.enableHelpOnButton(help, "unbundle", null);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "bundle", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GroupCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.bitsField) {
                try {
                    Group.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (Group.this.bits < 2) {
                    JOptionPane.showMessageDialog(this, "Must be at least 2 bits", "Error", 0);
                    return;
                }
                if (this.single.isSelected()) {
                    int b = 0;
                    while (b < Group.this.bits) {
                        Group.this.ranges.add(new Entry(b, b));
                        ++b;
                    }
                } else {
                    Point here = this.getLocation();
                    this.dispose();
                    new GetRanges(here, this.type);
                }
                if (this.left.isSelected()) {
                    Group.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    Group.this.orientation = JLSInfo.Orientation.RIGHT;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Group.this.cancelled = true;
            this.dispose();
        }
    }
}

