/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public abstract class Gate
extends LogicElement {
    protected static final int defaultInputs = 2;
    protected static final int defaultBits = 1;
    protected static final Orientation defaultOrientation = Orientation.right;
    protected int numInputs = 2;
    protected int bits = 1;
    protected Orientation orientation = defaultOrientation;
    protected int propDelay;
    protected GeneralPath gateShape;
    protected boolean cancelled;

    public Gate(Circuit circuit) {
        super(circuit);
    }

    public boolean setup(Graphics g, JPanel editWindow, int x, int y, String type) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        GateCreate gate = null;
        gate = pos == null ? new GateCreate(x + win.x, y + win.y, type) : new GateCreate(pos.x + win.x, pos.y + win.y, type);
        if (this.cancelled) {
            return false;
        }
        this.numInputs = type.equals("NOT") || type.equals("DELAY") || type.equals("Extend") ? 1 : gate.getInputs();
        this.bits = gate.getGates();
        this.orientation = gate.getOrientation();
        this.propDelay = this.getDefaultDelay();
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        if (this.orientation == Orientation.left || this.orientation == Orientation.right) {
            this.width = 48;
            this.height = 12 * (Math.max(this.numInputs, 3) - 1);
        } else {
            this.width = 12 * (Math.max(this.numInputs, 3) - 1);
            this.height = 48;
        }
        if (this.orientation == Orientation.left || this.orientation == Orientation.right) {
            int inx = 0;
            int outx = 48;
            if (this.orientation == Orientation.left) {
                inx = 48;
                outx = 0;
            }
            int dist = (Math.max(this.numInputs, 4) - 3) / 2 * 12;
            Output out = new Output("output", this, outx, dist + 12, this.bits);
            this.outputs.add(out);
            if (this.numInputs == 1) {
                this.inputs.add(new Input("input0", this, inx, 12, this.bits));
            } else {
                int yc = 0;
                int i = 0;
                while (i < this.numInputs) {
                    this.inputs.add(new Input("input" + i, this, inx, yc, this.bits));
                    yc = this.numInputs == 2 ? (yc += 24) : (yc += 12);
                    ++i;
                }
            }
        } else {
            int iny = 0;
            int outy = 48;
            if (this.orientation == Orientation.up) {
                iny = 48;
                outy = 0;
            }
            int dist = (Math.max(this.numInputs, 4) - 3) / 2 * 12;
            Output out = new Output("output", this, dist + 12, outy, this.bits);
            this.outputs.add(out);
            if (this.numInputs == 1) {
                this.inputs.add(new Input("input0", this, 12, iny, this.bits));
            } else {
                int xc = 0;
                int i = 0;
                while (i < this.numInputs) {
                    this.inputs.add(new Input("input" + i, this, xc, iny, this.bits));
                    xc = this.numInputs == 2 ? (xc += 24) : (xc += 12);
                    ++i;
                }
            }
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int s = 12;
        int dist = (Math.max(this.numInputs, 4) - 3) / 2 * s;
        int ox = 0;
        int oy = 0;
        AffineTransform trans = new AffineTransform();
        if (this.orientation == Orientation.right) {
            trans.translate(this.x + s, this.y + dist);
            ox = -s;
        } else if (this.orientation == Orientation.left) {
            trans.translate(this.x + s, this.y + dist);
            trans.rotate(Math.toRadians(180.0), s, s);
            ox = s;
        } else if (this.orientation == Orientation.up) {
            trans.translate(this.x + dist, this.y + s);
            trans.rotate(Math.toRadians(-90.0), s, s);
            oy = s;
        } else if (this.orientation == Orientation.down) {
            trans.translate(this.x + dist, this.y + s);
            trans.rotate(Math.toRadians(90.0), s, s);
            oy = -s;
        }
        GeneralPath temp = (GeneralPath)this.gateShape.clone();
        temp.transform(trans);
        g.setColor(Color.black);
        Graphics2D gg = (Graphics2D)g;
        gg.draw(temp);
        Output out = (Output)this.outputs.get(0);
        double inc = 2.0 * (double)s / (double)(2 * this.numInputs);
        if (this.orientation == Orientation.left || this.orientation == Orientation.right) {
            int lx = out.getX();
            g.drawLine(lx, this.y + dist + s, lx + ox, this.y + dist + s);
            out.draw(g);
            double ye = (double)(this.y + dist) + inc;
            int p = 0;
            while (p < this.numInputs) {
                lx = ((Input)this.inputs.get(p)).getX();
                int ly = ((Input)this.inputs.get(p)).getY();
                g.setColor(Color.black);
                g.drawLine(lx, ly, lx - ox, (int)(ye + 0.5));
                ye += inc * 2.0;
                ((Input)this.inputs.get(p)).draw(g);
                ++p;
            }
        } else {
            int ly = out.getY();
            g.drawLine(this.x + dist + s, ly, this.x + dist + s, ly + oy);
            out.draw(g);
            double xe = (double)(this.x + dist) + inc;
            int p = 0;
            while (p < this.numInputs) {
                ly = ((Input)this.inputs.get(p)).getY();
                int lx = ((Input)this.inputs.get(p)).getX();
                g.setColor(Color.black);
                g.drawLine(lx, ly, (int)(xe + 0.5), ly - oy);
                xe += inc * 2.0;
                ((Input)this.inputs.get(p)).draw(g);
                ++p;
            }
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("numInputs")) {
            this.numInputs = value;
        } else if (name.equals("delay")) {
            this.propDelay = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orientation")) {
            if (value.equals("left")) {
                this.orientation = Orientation.left;
            } else if (value.equals("up")) {
                this.orientation = Orientation.up;
            } else if (value.equals("down")) {
                this.orientation = Orientation.down;
            } else if (value.equals("right")) {
                this.orientation = Orientation.right;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public abstract Element copy();

    public void copy(Gate it) {
        it.numInputs = this.numInputs;
        it.bits = this.bits;
        it.orientation = this.orientation;
        it.propDelay = this.propDelay;
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        for (Input in : this.inputs) {
            it.inputs.add(in.copy(it));
        }
        super.copy(it);
    }

    public void save(PrintWriter output, String type, boolean triState) {
        output.println("ELEMENT " + type);
        super.save(output);
        output.println(" int bits " + this.bits);
        output.println(" int numInputs " + this.numInputs);
        output.println(" String orientation \"" + (Object)((Object)this.orientation) + "\"");
        output.println(" int delay " + this.propDelay);
        if (triState) {
            output.println(" int tristate 1");
        }
        output.println("END");
    }

    public void showInfo(JLabel info, String type) {
        if (this.bits == 1) {
            info.setText(String.valueOf(this.numInputs) + "-input " + type + " gate");
        } else {
            info.setText(String.valueOf(this.bits) + " " + this.numInputs + "-input " + type + " gate");
        }
    }

    @Override
    public Rectangle getRect() {
        if (this.orientation == Orientation.left || this.orientation == Orientation.right) {
            return new Rectangle(this.x, this.y - 6, this.width, this.height + 12);
        }
        return new Rectangle(this.x - 6, this.y, this.width + 12, this.height);
    }

    public void setToPrevious() {
    }

    public int getDefaultDelay() {
        return 0;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = this.getDefaultDelay();
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (this.orientation == Orientation.left) {
            this.orientation = direction == JLSInfo.Orientation.LEFT ? Orientation.down : Orientation.up;
        } else if (this.orientation == Orientation.right) {
            this.orientation = direction == JLSInfo.Orientation.LEFT ? Orientation.up : Orientation.down;
        } else if (this.orientation == Orientation.up) {
            this.orientation = direction == JLSInfo.Orientation.LEFT ? Orientation.left : Orientation.right;
        } else if (this.orientation == Orientation.down) {
            this.orientation = direction == JLSInfo.Orientation.LEFT ? Orientation.right : Orientation.left;
        }
        this.width = 0;
        this.height = 0;
        this.inputs.clear();
        this.outputs.clear();
        this.init(g);
    }

    @Override
    public boolean canRotate() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public boolean canFlip() {
        boolean success = true;
        for (Input i : this.inputs) {
            if (!i.isAttached()) continue;
            success = false;
            break;
        }
        for (Output o : this.outputs) {
            if (!o.isAttached()) continue;
            success = false;
            break;
        }
        return success;
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == Orientation.left) {
            this.orientation = Orientation.right;
        } else if (this.orientation == Orientation.right) {
            this.orientation = Orientation.left;
        } else if (this.orientation == Orientation.up) {
            this.orientation = Orientation.down;
        } else if (this.orientation == Orientation.down) {
            this.orientation = Orientation.up;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    protected class GateCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton repeat;
        private JButton cancel;
        private JTextField inputsField;
        private JTextField gatesField;
        private KeyPad inputsPad;
        private KeyPad gatesPad;
        private JRadioButton left;
        private JRadioButton up;
        private JRadioButton down;
        private JRadioButton right;
        private String type;

        protected GateCreate(int x, int y, String type) {
            JLabel gates;
            super(JLSInfo.frame, "Create " + type + " Gate", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.inputsField = new JTextField("2", 5);
            this.gatesField = new JTextField("1", 5);
            this.inputsPad = new KeyPad(this.inputsField, 10, 2L, this);
            this.gatesPad = new KeyPad(this.gatesField, 10, 1L, this);
            this.left = new JRadioButton("left");
            this.up = new JRadioButton("up");
            this.down = new JRadioButton("down");
            this.right = new JRadioButton("right");
            Gate.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            this.type = type;
            JPanel info = null;
            if (type.equals("NOT") || type.equals("XOR") || type == "Extend") {
                info = new JPanel(new GridLayout(1, 2));
            } else {
                info = new JPanel(new GridLayout(2, 2));
                JLabel inputs = new JLabel("Inputs: ", 4);
                info.add(inputs);
                JPanel in = new JPanel(new FlowLayout());
                in.add(this.inputsField);
                in.add(this.inputsPad);
                info.add(in);
            }
            if (type.equals("Extend")) {
                gates = new JLabel("Outputs: ", 4);
                this.gatesField.setText("2");
            } else {
                gates = new JLabel("Gates (bits): ", 4);
            }
            info.add(gates);
            JPanel ga = new JPanel(new FlowLayout());
            ga.add(this.gatesField);
            ga.add(this.gatesPad);
            info.add(ga);
            window.add(info);
            window.add(new JLabel(" "));
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(this.up);
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(this.down);
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup group = new ButtonGroup();
            group.add(this.left);
            group.add(this.up);
            group.add(this.down);
            group.add(this.right);
            this.right.setSelected(true);
            window.add(orients);
            if (!type.equals("Extend")) {
                window.add(new JLabel(" "));
                JPanel rep = new JPanel();
                this.repeat = new JButton("Repeat Previous " + type + " Gate");
                this.repeat.setBackground(Color.yellow);
                rep.add(this.repeat);
                window.add(rep);
                this.repeat.addActionListener(this);
            }
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, type, null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.inputsField.addActionListener(this);
            this.gatesField.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GateCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.inputsField || event.getSource() == this.gatesField) {
                try {
                    Gate.this.numInputs = Integer.parseInt(this.inputsField.getText());
                    Gate.this.bits = Integer.parseInt(this.gatesField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric", "Error", 0);
                    return;
                }
                if (Gate.this.numInputs < 2) {
                    JOptionPane.showMessageDialog(this, "Must have at least 2 inputs", "Error", 0);
                    return;
                }
                if (Gate.this.bits < 1 && this.type != "Extend") {
                    JOptionPane.showMessageDialog(this, "Must have at least 1 gate (bit)", "Error", 0);
                    return;
                }
                Gate.this.orientation = this.left.isSelected() ? Orientation.left : (this.right.isSelected() ? Orientation.right : (this.up.isSelected() ? Orientation.up : Orientation.down));
                this.inputsPad.close();
                this.gatesPad.close();
                this.dispose();
            } else if (event.getSource() == this.repeat) {
                Gate.this.setToPrevious();
                this.inputsField.setText("" + Gate.this.numInputs);
                this.gatesField.setText("" + Gate.this.bits);
                this.left.setSelected(false);
                this.right.setSelected(false);
                this.up.setSelected(false);
                this.down.setSelected(false);
                if (Gate.this.orientation == Orientation.left) {
                    this.left.setSelected(true);
                } else if (Gate.this.orientation == Orientation.right) {
                    this.right.setSelected(true);
                } else if (Gate.this.orientation == Orientation.up) {
                    this.up.setSelected(true);
                } else {
                    this.down.setSelected(true);
                }
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Gate.this.cancelled = true;
            this.inputsPad.close();
            this.gatesPad.close();
            this.dispose();
        }

        public int getGates() {
            return Gate.this.bits;
        }

        public int getInputs() {
            return Gate.this.numInputs;
        }

        public Orientation getOrientation() {
            return Gate.this.orientation;
        }
    }

    protected static enum Orientation {
        up,
        down,
        left,
        right;

    }
}

