/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Gate;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Graphics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class Extend
extends Gate
implements TriProp {
    private boolean loadTriState = false;

    public Extend(Circuit circuit) {
        super(circuit);
        int s = 12;
        int s2 = s / 2;
        int s4 = s / 4;
        Line2D.Double left = new Line2D.Double(0.0, s, s2, s);
        Line2D.Double vert = new Line2D.Double(s2, 0.0, s2, 2 * s);
        Line2D.Double top = new Line2D.Double(s2, 0.0, s, 0.0);
        Line2D.Double mid = new Line2D.Double(s2, s2, s, s2);
        Line2D.Double bottom = new Line2D.Double(s2, 2 * s, s, 2 * s);
        Ellipse2D.Double dot1 = new Ellipse2D.Double(3 * s4 - 1, s - 1, 2.0, 2.0);
        Ellipse2D.Double dot1a = new Ellipse2D.Double(3 * s4, s, 1.0, 1.0);
        Ellipse2D.Double dot2 = new Ellipse2D.Double(3 * s4 - 1, s + s2 - 1, 2.0, 2.0);
        Ellipse2D.Double dot2a = new Ellipse2D.Double(3 * s4, s + s2, 1.0, 1.0);
        Arc2D.Double topArc = new Arc2D.Double(s - s4, -s4, s2, s2, 0.0, 90.0, 0);
        Line2D.Double upper = new Line2D.Double(s + s4, 0.0, s + s4, 3 * s4);
        Arc2D.Double midArc1 = new Arc2D.Double(s + s4, s2, s2, s2, 180.0, 90.0, 0);
        Arc2D.Double midArc2 = new Arc2D.Double(s + s4, s, s2, s2, 90.0, 90.0, 0);
        Line2D.Double lower = new Line2D.Double(s + s4, s + s4, s + s4, 2 * s);
        Arc2D.Double bottomArc = new Arc2D.Double(s - s4, 2 * s - s4, s2, s2, 270.0, 90.0, 0);
        Line2D.Double right = new Line2D.Double(s + s2, s, 2 * s, s);
        this.gateShape = new GeneralPath(left);
        this.gateShape.append(vert, false);
        this.gateShape.append(top, false);
        this.gateShape.append(mid, false);
        this.gateShape.append(bottom, false);
        this.gateShape.append(dot1, false);
        this.gateShape.append(dot1a, false);
        this.gateShape.append(dot2, false);
        this.gateShape.append(dot2a, false);
        this.gateShape.append(topArc, false);
        this.gateShape.append(upper, false);
        this.gateShape.append(midArc1, false);
        this.gateShape.append(midArc2, false);
        this.gateShape.append(lower, false);
        this.gateShape.append(bottomArc, false);
        this.gateShape.append(right, false);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        boolean ok = super.setup(g, editWindow, x, y, "Extend");
        if (ok && this.bits < 2) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "must have at least 2 bits of output");
            return false;
        }
        if (ok) {
            this.numInputs = 1;
        }
        return ok;
    }

    @Override
    public void init(Graphics g) {
        super.init(g);
        this.inputs.clear();
        int s = 12;
        switch (this.orientation) {
            case left: {
                this.inputs.add(new Input("input0", this, 4 * s, s, 1));
                break;
            }
            case right: {
                this.inputs.add(new Input("input0", this, 0, s, 1));
                break;
            }
            case up: {
                this.inputs.add(new Input("input0", this, s, 4 * s, 1));
                break;
            }
            case down: {
                this.inputs.add(new Input("input0", this, s, 0, 1));
            }
        }
        if (this.loadTriState) {
            ((Output)this.outputs.get(0)).loadSetTriState();
        }
    }

    @Override
    public Element copy() {
        Extend it = new Extend(this.circuit);
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        super.save(output, "Extend", ((Output)this.outputs.get(0)).isTriState());
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("tristate")) {
            this.loadTriState = true;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("1 bit to " + this.bits + " bits");
    }

    @Override
    public boolean hasTiming() {
        return false;
    }

    @Override
    public void setTriState(boolean which) {
        for (Output out : this.outputs) {
            out.setTriState(which);
        }
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        if (out.isTriState()) {
            out.setValue(null);
        } else {
            out.setValue(new BitSet(this.bits));
        }
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        BitSet value = ((Input)this.inputs.get(0)).getValue();
        BitSet newValue = null;
        if (value != null) {
            newValue = new BitSet(this.bits);
            if (value.cardinality() != 0) {
                newValue.flip(0, this.bits);
            }
        }
        Output out = (Output)this.outputs.get(0);
        out.propagate(newValue, now, sim);
    }
}

