/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.edit.SimpleEditor;
import edu.mtu.cs.jls.elem.Memory;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.elem.WireEnd;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class Element {
    private int id;
    protected int x;
    protected int y;
    protected int width = 0;
    protected int height = 0;
    private boolean uneditable = false;
    private int tracePosition = -1;
    protected boolean highlight = false;
    private int savex;
    private int savey;
    protected Circuit circuit;

    public Element(Circuit circuit) {
        this.circuit = circuit;
    }

    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        return false;
    }

    public void setXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setCircuit(Circuit circuit) {
        this.circuit = circuit;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public int getID() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getTracePosition() {
        return this.tracePosition;
    }

    public void setTracePosition(int position) {
        this.tracePosition = position;
    }

    public void setValue(String name, int value) {
        if (name.equals("id")) {
            this.id = value;
        } else if (name.equals("x")) {
            this.x = value;
        } else if (name.equals("y")) {
            this.y = value;
        } else if (name.equals("width")) {
            this.width = value;
        } else if (name.equals("height")) {
            this.height = value;
        } else if (name.equals("fixed")) {
            this.uneditable = true;
        } else if (name.equals("trpos")) {
            this.tracePosition = value;
        }
    }

    public void setValue(String name, long value) {
    }

    public void setValue(String name, BigInteger value) {
    }

    public void setValue(String name, String value) {
    }

    public void setPair(int v1, int v2) {
    }

    public abstract void init(Graphics var1);

    public Element copy() {
        return null;
    }

    public void copy(Element it) {
        it.x = this.x;
        it.y = this.y;
        it.width = this.width;
        it.height = this.height;
        it.uneditable = this.uneditable;
        it.tracePosition = this.tracePosition;
    }

    public void savePosition() {
        this.savex = this.x;
        this.savey = this.y;
    }

    public void restorePosition() {
        this.x = this.savex;
        this.y = this.savey;
    }

    public void move(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public void fixPosition() {
    }

    public boolean contains(int x, int y) {
        Rectangle thisRect = this.getRect();
        return thisRect.contains(x, y);
    }

    public boolean intersects(Element other) {
        if (other instanceof Wire) {
            Wire wire = (Wire)other;
            WireEnd end1 = wire.getEnd();
            WireEnd end2 = wire.getOtherEnd(end1);
            if (this instanceof WireEnd && (this == end1 || this == end2)) {
                return false;
            }
            return wire.intersects(this.getRect());
        }
        Rectangle thisRect = this.getRect();
        Rectangle otherRect = other.getRect();
        return thisRect.intersects(otherRect);
    }

    public boolean isInside(Rectangle rect) {
        Rectangle me = this.getRect();
        return rect.contains(me);
    }

    public void setHighlight(boolean light) {
        this.highlight = light;
    }

    public void setID(int id) {
        this.id = id;
    }

    public void save(PrintWriter output) {
        output.println(" int id " + this.id);
        output.println(" int x " + this.x);
        output.println(" int y " + this.y);
        output.println(" int width " + this.width);
        output.println(" int height " + this.height);
        if (this.uneditable) {
            output.println(" int fixed 1");
        }
        if (this.tracePosition != -1) {
            output.println(" int trpos " + this.tracePosition);
        }
    }

    public void draw(Graphics g) {
        if (this.highlight) {
            g.setColor(Color.pink);
            Graphics2D gg = (Graphics2D)g;
            gg.fill(this.getRect());
        }
    }

    public void remove(Circuit circ) {
        circ.remove(this);
    }

    public Put getPut(int x, int y) {
        return null;
    }

    public void showInfo(JLabel info) {
    }

    public boolean isTouching() {
        return false;
    }

    public void untouchPuts() {
    }

    public Set<Put> getAllPuts() {
        return new HashSet<Put>();
    }

    public Rectangle getRect() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setTouching(boolean setting) {
    }

    public Put getPut(String name) {
        return null;
    }

    public boolean canChange() {
        return false;
    }

    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        return false;
    }

    public boolean quickChange() {
        return false;
    }

    public JMenuItem setupQuickMenu(SimpleEditor sed) {
        throw new UnsupportedOperationException("setupQuickMenu");
    }

    public boolean hasTiming() {
        return false;
    }

    public void changeTiming(JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new DelayChange(x + win.x, y + win.y, this instanceof Memory);
        } else {
            new DelayChange(pos.x + win.x, pos.y + win.y, this instanceof Memory);
        }
    }

    public boolean canRotate() {
        return false;
    }

    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        throw new UnsupportedOperationException("Rotate");
    }

    public boolean canFlip() {
        return false;
    }

    public void flip(Graphics g) {
        throw new UnsupportedOperationException("Flip");
    }

    public int getDelay() {
        return 0;
    }

    public void setDelay(int temp) {
    }

    public boolean canWatch() {
        return false;
    }

    public boolean isWatched() {
        return false;
    }

    public void setWatched(boolean state) {
    }

    public void showCurrentValue(Point where) {
    }

    public String getName() {
        return null;
    }

    public boolean isUneditable() {
        return this.uneditable;
    }

    public void makeUneditable() {
        this.uneditable = true;
    }

    private class DelayChange
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField delayField;
        private KeyPad delayPad;

        private DelayChange(int x, int y, boolean isMemory) {
            super(JLSInfo.frame, "Change Timing", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.delayField = new JTextField(10);
            this.delayPad = new KeyPad(this.delayField, 10, 0L, this);
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel delay = isMemory ? new JLabel("Memory access time: ", 4) : new JLabel("Propagation delay: ", 4);
            info.add((Component)delay, "West");
            info.add((Component)this.delayField, "Center");
            this.delayField.setText(String.valueOf(Element.this.getDelay()));
            info.add((Component)this.delayPad, "East");
            window.add(info);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.delayField.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DelayChange.this.dispose();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.delayField) {
                int temp = 0;
                try {
                    temp = Integer.parseInt(this.delayField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (temp <= 0) {
                    JOptionPane.showMessageDialog(this, "Propagation delay must be greater than 0", "Error", 0);
                    return;
                }
                Element.this.setDelay(temp);
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.dispose();
            }
        }
    }
}

