/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Display
extends LogicElement {
    private final int defaultBits = 1;
    private int bits = 1;
    private int base = 10;
    private boolean cancelled = false;
    int orient = -1;
    private BitSet currentValue = new BitSet();

    public Display(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new DispCreate(x + win.x, y + win.y);
        } else {
            new DispCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        if (g != null && this.width == 0 && this.height == 0) {
            this.height = 2 * s;
            FontMetrics fm = g.getFontMetrics();
            BigInteger maxVal = new BigInteger("1").shiftLeft(this.bits).subtract(new BigInteger("1"));
            String longest = maxVal.toString(this.base).replaceAll(".", "0");
            switch (this.base) {
                case 2: {
                    longest = String.valueOf(longest) + "B";
                    break;
                }
                case 16: {
                    longest = "0x" + longest;
                }
            }
            int strLen = fm.stringWidth(" " + longest + " ");
            this.width = (strLen + 2 * s - 1) / (2 * s) * (2 * s);
        }
        if (this.orient < 0) {
            this.inputs.add(new Input("input0", this, 0, s, this.bits));
            this.inputs.add(new Input("input1", this, this.width / 2, 0, this.bits));
            this.inputs.add(new Input("input2", this, this.width / 2, this.height, this.bits));
            this.inputs.add(new Input("input3", this, this.width, s, this.bits));
        } else {
            switch (this.orient) {
                case 0: {
                    this.inputs.add(new Input("input", this, this.width / 2, 0, this.bits));
                    break;
                }
                case 1: {
                    this.inputs.add(new Input("input", this, this.width / 2, this.height, this.bits));
                    break;
                }
                case 2: {
                    this.inputs.add(new Input("input", this, 0, s, this.bits));
                    break;
                }
                case 3: {
                    this.inputs.add(new Input("input", this, this.width, s, this.bits));
                }
            }
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int s = 12;
        g.setColor(Color.black);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.drawRoundRect(this.x, this.y, this.width, this.height, s, s);
        FontMetrics fm = g.getFontMetrics();
        int ascent = fm.getAscent();
        int hi = ascent + fm.getDescent();
        String value = " HiZ ";
        if (this.currentValue != null) {
            value = BitSetUtils.ToString(this.currentValue, this.base);
            switch (this.base) {
                case 2: {
                    while (value.length() < this.bits) {
                        value = "0" + value;
                    }
                    value = String.valueOf(value) + "B";
                    break;
                }
                case 16: {
                    while (value.length() * 4 < this.bits) {
                        value = "0" + value;
                    }
                    value = "0x" + value;
                }
            }
            value = " " + value + " ";
        }
        int sw = fm.stringWidth(value);
        g.drawString(value, this.x + (this.width - sw) / 2, this.y + (this.height - hi) / 2 + ascent);
        Vector<Input> detach = new Vector<Input>(4);
        for (Input input : this.inputs) {
            if (input.isAttached()) continue;
            detach.add(input);
        }
        int count = detach.size();
        if (count > 0 && count < 4) {
            this.inputs.removeAll(detach);
            if (this.inputs.size() == 0) {
                this.inputs.add(new Input("input0", this, 0, s, this.bits));
                this.inputs.add(new Input("input1", this, this.width / 2, 0, this.bits));
                this.inputs.add(new Input("input2", this, this.width / 2, this.height, this.bits));
                this.inputs.add(new Input("input3", this, this.width, s, this.bits));
            }
        }
        for (Input input : this.inputs) {
            input.draw(g);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Display");
        super.save(output);
        output.println(" int bits " + this.bits);
        output.println(" int base " + this.base);
        if (this.orient > 0) {
            output.println(" int orient " + this.orient);
        }
        output.println("END");
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("base")) {
            this.base = value;
        } else if (name.equals("orient")) {
            this.orient = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        Display it = new Display(this.circuit);
        it.bits = this.bits;
        it.base = this.base;
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.bits) + " bit display, value = " + BitSetUtils.toDisplay(this.currentValue, this.bits));
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    @Override
    public boolean canFlip() {
        return false;
    }

    @Override
    public void flip(Graphics g) {
    }

    @Override
    public void initSim(Simulator sim) {
        Input in = (Input)this.inputs.get(0);
        this.currentValue = in.isAttached() && in.getWireEnd().getNet().isTriState() ? null : new BitSet();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        this.currentValue = ((Input)this.inputs.get(0)).getValue();
    }

    protected class DispCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton b2;
        private JRadioButton b10;
        private JRadioButton b16;

        protected DispCreate(int x, int y) {
            super(JLSInfo.frame, "Create Display", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.bitsField = new JTextField("1", 5);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.b2 = new JRadioButton("2");
            this.b10 = new JRadioButton("10");
            this.b16 = new JRadioButton("16");
            Display.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel bits = new JLabel("Bits: ", 4);
            info.add((Component)bits, "West");
            info.add((Component)this.bitsField, "Center");
            info.add((Component)this.bitsPad, "East");
            window.add(info);
            window.add(new JLabel(" "));
            JLabel dlbl = new JLabel("Display Radix");
            dlbl.setAlignmentX(0.5f);
            window.add(dlbl);
            JPanel radix = new JPanel(new GridLayout(1, 3));
            radix.add(this.b2);
            radix.add(this.b10);
            radix.add(this.b16);
            ButtonGroup rgroup = new ButtonGroup();
            rgroup.add(this.b2);
            rgroup.add(this.b10);
            rgroup.add(this.b16);
            this.b10.setSelected(true);
            window.add(radix);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "display", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DispCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.bitsField) {
                try {
                    Display.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (Display.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must be at least one bit", "Error", 0);
                    return;
                }
                if (this.b2.isSelected()) {
                    Display.this.base = 2;
                } else if (this.b10.isSelected()) {
                    Display.this.base = 10;
                } else {
                    Display.this.base = 16;
                }
                this.bitsPad.close();
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Display.this.cancelled = true;
            this.bitsPad.close();
            this.dispose();
        }
    }
}

