/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Gate;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DelayGate
extends Gate {
    private static final int defaultPropDelay = 1;
    private BitSet toBeValue;

    public DelayGate(Circuit circuit) {
        super(circuit);
        int s = 12;
        Line2D.Double top = new Line2D.Double(0.0, 0.0, 2 * s, s);
        Line2D.Double bottom = new Line2D.Double(2 * s, s, 0.0, 2 * s);
        Line2D.Double side = new Line2D.Double(0.0, 2 * s, 0.0, 0.0);
        this.gateShape = new GeneralPath(top);
        this.gateShape.append(bottom, true);
        this.gateShape.append(side, true);
        this.gateShape.closePath();
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new DelayCreate(x + win.x, y + win.y);
        } else {
            new DelayCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.numInputs = 1;
        this.init(g);
        Point p = editWindow.getMousePosition();
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public Element copy() {
        DelayGate it = new DelayGate(this.circuit);
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        super.save(output, "DelayGate", false);
    }

    @Override
    public void showInfo(JLabel info) {
        String pd = ", delay = " + this.propDelay;
        if (this.bits == 1) {
            info.setText("DELAY gate" + pd);
        } else {
            info.setText(String.valueOf(this.bits) + " DELAY gates" + pd);
        }
    }

    @Override
    public void resetPropDelay() {
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.toArray()[0];
        BitSet bitval = new BitSet(1);
        out.setValue(bitval);
        this.toBeValue = new BitSet(1);
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet value = ((Input)this.inputs.toArray()[0]).getValue();
            value = value == null ? new BitSet() : (BitSet)value.clone();
            if (!value.equals(this.toBeValue)) {
                this.toBeValue = (BitSet)value.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, value));
            }
        } else {
            BitSet newValue = (BitSet)todo;
            Output out = (Output)this.outputs.toArray()[0];
            out.propagate(newValue, now, sim);
        }
    }

    private class DelayCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField delayField;
        private JTextField gatesField;
        private KeyPad delayPad;
        private KeyPad gatesPad;
        private JRadioButton left;
        private JRadioButton up;
        private JRadioButton down;
        private JRadioButton right;

        public DelayCreate(int x, int y) {
            super(JLSInfo.frame, "Create DELAY Gate", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.delayField = new JTextField("1", 5);
            this.gatesField = new JTextField("1", 5);
            this.delayPad = new KeyPad(this.delayField, 10, 1L, this);
            this.gatesPad = new KeyPad(this.gatesField, 10, 1L, this);
            this.left = new JRadioButton("left");
            this.up = new JRadioButton("up");
            this.down = new JRadioButton("down");
            this.right = new JRadioButton("right");
            DelayGate.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new GridLayout(2, 2));
            JLabel inputs = new JLabel("Propagation Delay: ", 4);
            info.add(inputs);
            JPanel in = new JPanel(new FlowLayout());
            in.add(this.delayField);
            in.add(this.delayPad);
            info.add(in);
            JLabel gates = new JLabel("Gates (bits): ", 4);
            info.add(gates);
            JPanel ga = new JPanel(new FlowLayout());
            ga.add(this.gatesField);
            ga.add(this.gatesPad);
            info.add(ga);
            window.add(info);
            window.add(new JLabel(" "));
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(this.up);
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(this.down);
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup group = new ButtonGroup();
            group.add(this.left);
            group.add(this.right);
            group.add(this.up);
            group.add(this.down);
            this.right.setSelected(true);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "DELAY", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            this.delayField.addActionListener(this);
            this.gatesField.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DelayCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.delayField || event.getSource() == this.gatesField) {
                try {
                    DelayGate.this.propDelay = Integer.parseInt(this.delayField.getText());
                    DelayGate.this.bits = Integer.parseInt(this.gatesField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    DelayGate.this.propDelay = 0;
                    return;
                }
                if (DelayGate.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must have at least 1 gate", "Error", 0);
                    DelayGate.this.propDelay = 0;
                    return;
                }
                DelayGate.this.orientation = this.left.isSelected() ? Gate.Orientation.left : (this.right.isSelected() ? Gate.Orientation.right : (this.up.isSelected() ? Gate.Orientation.up : Gate.Orientation.down));
                this.delayPad.close();
                this.gatesPad.close();
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            DelayGate.this.cancelled = true;
            this.delayPad.close();
            this.gatesPad.close();
            this.dispose();
        }
    }
}

