/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Decoder
extends LogicElement {
    private static final int defaultBits = 1;
    private static final int defaultPropDelay = 15;
    private int bits = 1;
    private int propDelay = 15;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.LEFT;
    private boolean cancelled;
    private String dec;
    private String inout;
    private BitSet toBeValue;

    public Decoder(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new DecoderCreate(x + win.x, y + win.y);
        } else {
            new DecoderCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        int outs = 1 << this.bits;
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inout = String.valueOf(this.bits) + "-" + outs;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.inout = String.valueOf(this.bits) + "\n | \n" + outs;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.inout = String.valueOf(outs) + "/n | /n" + this.bits;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inout = String.valueOf(outs) + "-" + this.bits;
        }
        this.dec = " decoder ";
        if (g != null && this.width == 0 && this.height == 0) {
            if (this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT) {
                this.width = 5 * s;
                this.height = 2 * s;
            } else {
                this.width = 2 * s;
                this.height = 5 * s;
            }
            FontMetrics fm = g.getFontMetrics();
            int bw = fm.stringWidth(this.inout);
            if (bw > this.width && this.orientation == JLSInfo.Orientation.LEFT) {
                this.inout = "1-n";
            } else if (bw > this.width && this.orientation == JLSInfo.Orientation.RIGHT) {
                this.inout = "n-1";
            }
            int dw = fm.stringWidth(this.dec);
            if (dw > this.width) {
                this.dec = "dec";
            }
        }
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("input", this, 0, s, this.bits));
            this.outputs.add(new Output("output", this, this.width, s, 1 << this.bits));
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("input", this, this.width, s, this.bits));
            this.outputs.add(new Output("output", this, 0, s, 1 << this.bits));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.inputs.add(new Input("input", this, s, this.height, this.bits));
            this.outputs.add(new Output("output", this, s, 0, 1 << this.bits));
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.inputs.add(new Input("input", this, s, 0, this.bits));
            this.outputs.add(new Output("output", this, s, this.height, 1 << this.bits));
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawRect(this.x, this.y, this.width, this.height);
        FontMetrics fm = g.getFontMetrics();
        if (this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT) {
            Rectangle2D t = fm.getStringBounds(this.inout, g);
            g.drawString(this.inout, this.x + (int)((double)this.width - t.getWidth()) / 2, this.y + (int)((double)(this.height / 2) - t.getHeight()) / 2 + fm.getAscent());
            t = fm.getStringBounds(this.dec, g);
            g.drawString(this.dec, this.x + (int)((double)this.width - t.getWidth()) / 2, this.y + 12 + (int)((double)(this.height / 2) - t.getHeight()) / 2 + fm.getAscent());
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            Rectangle2D t = fm.getStringBounds("1", g);
            g.drawString("1", this.x + (this.width - (int)t.getWidth()) / 2, this.y + fm.getHeight() + 5);
            g.drawString("|", this.x + (this.width - (int)t.getWidth()) / 2, this.y + fm.getHeight() + 20);
            g.drawString("n", this.x + (this.width - (int)t.getWidth()) / 2, this.y + fm.getHeight() + 35);
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            Rectangle2D t = fm.getStringBounds("1", g);
            g.drawString("n", this.x + (this.width - (int)t.getWidth()) / 2, this.y + fm.getHeight() + 5);
            g.drawString("|", this.x + (this.width - (int)t.getWidth()) / 2, this.y + fm.getHeight() + 20);
            g.drawString("1", this.x + (this.width - (int)t.getWidth()) / 2, this.y + fm.getHeight() + 35);
        }
        ((Input)this.inputs.get(0)).draw(g);
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("delay")) {
            this.propDelay = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.orientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Decoder");
        super.save(output);
        output.println(" int bits " + this.bits);
        output.println(" int delay " + this.propDelay);
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public Element copy() {
        Decoder it = new Decoder(this.circuit);
        it.bits = this.bits;
        it.propDelay = this.propDelay;
        it.inout = new String(this.inout);
        it.dec = new String(this.dec);
        it.orientation = this.orientation;
        it.inputs.add(((Input)this.inputs.get(0)).copy(it));
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.bits) + " to " + (1 << this.bits) + " decoder");
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = 15;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public boolean canRotate() {
        return !((Input)this.inputs.get(0)).isAttached() && !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.inputs.clear();
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        return !((Input)this.inputs.get(0)).isAttached() && !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        BitSet zero = new BitSet(1);
        out.setValue(zero);
        BitSet one = new BitSet(1);
        one.flip(0);
        sim.post(new SimEvent(0L, this, one));
        this.toBeValue = (BitSet)one.clone();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet value = ((Input)this.inputs.get(0)).getValue();
            if (value == null) {
                value = new BitSet();
            }
            int inval = BitSetUtils.ToInt(value);
            BitSet newValue = new BitSet(inval + 1);
            newValue.set(inval);
            if (!newValue.equals(this.toBeValue)) {
                this.toBeValue = (BitSet)newValue.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, newValue));
            }
        } else {
            BitSet newValue = (BitSet)todo;
            Output out = (Output)this.outputs.get(0);
            out.propagate(newValue, now, sim);
        }
    }

    private class DecoderCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton left;
        private JRadioButton right;
        private JRadioButton up;
        private JRadioButton down;

        private DecoderCreate(int x, int y) {
            super(JLSInfo.frame, "Create Decoder", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.bitsField = new JTextField("1", 10);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.left = new JRadioButton("Left", true);
            this.right = new JRadioButton("Right");
            this.up = new JRadioButton("Up");
            this.down = new JRadioButton("Down");
            Decoder.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel bits = new JLabel("Input Bits: ", 4);
            info.add((Component)bits, "West");
            info.add((Component)this.bitsField, "Center");
            info.add((Component)this.bitsPad, "East");
            JPanel orient = new JPanel(new GridLayout(3, 3));
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            gr.add(this.down);
            gr.add(this.up);
            orient.add(new JLabel(""));
            orient.add(this.up);
            orient.add(new JLabel(""));
            orient.add(this.left);
            orient.add(new JLabel(""));
            orient.add(this.right);
            orient.add(new JLabel(""));
            orient.add(this.down);
            orient.add(new JLabel(""));
            window.add(info);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            window.add(orient);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "decoder", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DecoderCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.bitsField) {
                try {
                    Decoder.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (Decoder.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must be at least 1 bit", "Error", 0);
                    return;
                }
                if (Decoder.this.bits >= 32) {
                    JOptionPane.showMessageDialog(this, "Must be less than 32 bits", "Error", 0);
                    return;
                }
                if (this.left.isSelected()) {
                    Decoder.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    Decoder.this.orientation = JLSInfo.Orientation.RIGHT;
                } else if (this.up.isSelected()) {
                    Decoder.this.orientation = JLSInfo.Orientation.UP;
                } else if (this.down.isSelected()) {
                    Decoder.this.orientation = JLSInfo.Orientation.DOWN;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Decoder.this.cancelled = true;
            this.dispose();
        }
    }
}

