/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.edit.Editor;
import edu.mtu.cs.jls.edit.SimpleEditor;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Constant
extends LogicElement
implements ActionListener {
    private static final BigInteger defaultValue;
    private static final int defaultBase = 10;
    private BigInteger value = defaultValue;
    private int base = 10;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    private static BigInteger previousValue;
    private static int previousBase;
    private static JLSInfo.Orientation previousOrientation;
    private boolean cancelled;
    private boolean changed;
    private Graphics saveg;
    private SimpleEditor sed;
    private JMenu quick = new JMenu("shortcuts");
    private JMenuItem zero = new JMenuItem("0");
    private JMenuItem one = new JMenuItem("1");
    private JMenuItem plus = new JMenuItem("add 1");
    private JMenuItem minus = new JMenuItem("subtract 1");
    private boolean menuMade = false;

    static {
        previousValue = defaultValue = BigInteger.ZERO;
        previousBase = 10;
        previousOrientation = JLSInfo.Orientation.RIGHT;
    }

    public Constant(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new ConstantCreate(x + win.x, y + win.y);
        } else {
            new ConstantCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        previousValue = this.value;
        previousBase = this.base;
        previousOrientation = this.orientation;
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        if (g != null && this.width == 0 && this.height == 0) {
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(Util.convert(this.value, this.base, true)) + s;
            this.width = Math.max((w + s / 2) / s * s, 2 * s);
            this.height = this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT ? 0 : 2 * s;
        }
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.outputs.add(new Output("output", this, 0, 0, 0));
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.outputs.add(new Output("output", this, this.width, 0, 0));
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.outputs.add(new Output("output", this, this.width / 2, 0, 0));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.outputs.add(new Output("output", this, this.width / 2, this.height, 0));
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        Graphics2D gg = (Graphics2D)g;
        Rectangle r = this.getRect();
        gg.setColor(Color.BLACK);
        Rectangle drawn = new Rectangle(r.x, r.y, r.width, r.height);
        gg.draw(drawn);
        FontMetrics fm = g.getFontMetrics();
        String str = Util.convert(this.value, this.base, true);
        Rectangle2D t = fm.getStringBounds(str, g);
        double tw = t.getWidth();
        double th = t.getHeight();
        int dx = (int)(((double)r.width - tw) / 2.0);
        int dy = (int)(((double)r.height - th) / 2.0 + (double)fm.getAscent());
        if (this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT) {
            g.drawString(str, this.x + dx, this.y - 6 + dy);
        } else {
            g.drawString(str, this.x + dx, this.y + dy);
        }
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("base")) {
            this.base = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, long value) {
        if (name.equals("value")) {
            this.value = BigInteger.valueOf(value);
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, BigInteger value) {
        if (name.equals("value")) {
            this.value = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.orientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        Constant it = new Constant(this.circuit);
        it.value = this.value.add(BigInteger.ZERO);
        it.base = this.base;
        it.orientation = this.orientation;
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Constant");
        super.save(output);
        output.println(" Int value " + this.value.toString());
        output.println(" int base " + this.base);
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("a constant value");
    }

    @Override
    public Rectangle getRect() {
        if (this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT) {
            return new Rectangle(this.x, this.y - 6, this.width, this.height + 12);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setToPrevious() {
        this.value = previousValue;
        this.base = previousBase;
        this.orientation = previousOrientation;
    }

    @Override
    public boolean canRotate() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        this.saveg = g;
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new ConstantChange(x + win.x, y + win.y);
        } else {
            new ConstantChange(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.circuit.markChanged();
        if (this.changed) {
            this.detach();
            this.width = 0;
            this.height = 0;
            this.init(g);
            return true;
        }
        return false;
    }

    public boolean valueFits(String value) {
        int s = 12;
        FontMetrics fm = this.saveg.getFontMetrics();
        int w = fm.stringWidth(value) + s;
        int rw = Math.max((w + s / 2) / s * s, 2 * s);
        return rw <= this.width;
    }

    @Override
    public boolean quickChange() {
        return true;
    }

    @Override
    public JMenuItem setupQuickMenu(SimpleEditor sed) {
        if (this.menuMade) {
            return this.quick;
        }
        this.sed = sed;
        this.menuMade = true;
        this.quick.add(this.zero);
        this.quick.add(this.one);
        this.quick.add(this.plus);
        this.quick.add(this.minus);
        this.zero.addActionListener(this);
        this.one.addActionListener(this);
        this.plus.addActionListener(this);
        this.minus.addActionListener(this);
        return this.quick;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.zero) {
            this.value = BigInteger.ZERO;
        } else if (event.getSource() == this.one) {
            this.value = BigInteger.ONE;
        } else if (event.getSource() == this.plus) {
            this.value = this.value.add(BigInteger.ONE);
        } else if (event.getSource() == this.minus) {
            this.value = this.value.subtract(BigInteger.ONE);
            this.value = this.value.max(BigInteger.ZERO);
        }
        Editor ed = this.getCircuit().getEditor();
        if (ed != null) {
            this.sed.quickReset();
            ed.repaint();
        }
    }

    @Override
    public void initSim(Simulator sim) {
        BitSet bitval = BitSetUtils.Create(this.value);
        BitSet opposite = (BitSet)bitval.clone();
        opposite.flip(0);
        Output out = (Output)this.outputs.get(0);
        out.setValue(opposite);
        sim.post(new SimEvent(0L, this, bitval));
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        BitSet newValue = (BitSet)todo;
        Output out = (Output)this.outputs.toArray()[0];
        if (!out.isAttached()) {
            return;
        }
        int bits = out.getWireEnd().getBits();
        BitSet mask = new BitSet(bits);
        mask.set(0, bits);
        newValue.and(mask);
        out.propagate(newValue, now, sim);
    }

    private class ConstantChange
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField valueField;
        private KeyPad valuePad;
        private JRadioButton base2;
        private JRadioButton base10;
        private JRadioButton base16;

        private ConstantChange(int x, int y) {
            super(JLSInfo.frame, "Change Constant", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.valueField = new JTextField(Util.convert(Constant.this.value, Constant.this.base, false), 10);
            this.valuePad = new KeyPad(this.valueField, 16, defaultValue.longValue(), this);
            this.base2 = new JRadioButton("2");
            this.base10 = new JRadioButton("10");
            this.base16 = new JRadioButton("16");
            Constant.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel inputs = new JLabel("Value: ", 4);
            info.add((Component)inputs, "West");
            info.add((Component)this.valueField, "Center");
            this.valueField.setText(Constant.this.value.toString(Constant.this.base));
            this.valuePad.setBase(Constant.this.base);
            info.add((Component)this.valuePad, "East");
            window.add(info);
            window.add(new JLabel(" "));
            JLabel rlbl = new JLabel("Radix");
            rlbl.setAlignmentX(0.5f);
            window.add(rlbl);
            JPanel bases = new JPanel(new GridLayout(1, 3));
            bases.add(this.base2);
            bases.add(this.base10);
            bases.add(this.base16);
            if (Constant.this.base == 2) {
                this.base2.setSelected(true);
            } else if (Constant.this.base == 10) {
                this.base10.setSelected(true);
            } else if (Constant.this.base == 16) {
                this.base16.setSelected(true);
            }
            this.valuePad.setBase(Constant.this.base);
            ButtonGroup group = new ButtonGroup();
            group.add(this.base2);
            group.add(this.base10);
            group.add(this.base16);
            window.add(bases);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "const", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.valueField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.base2.addActionListener(this);
            this.base10.addActionListener(this);
            this.base16.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ConstantChange.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.valueField) {
                if (this.base2.isSelected()) {
                    Constant.this.base = 2;
                } else if (this.base10.isSelected()) {
                    Constant.this.base = 10;
                } else {
                    Constant.this.base = 16;
                }
                BigInteger temp = BigInteger.ZERO;
                try {
                    temp = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (temp == Constant.this.value) {
                    this.cancel();
                }
                Constant.this.value = temp;
                if (!Constant.this.valueFits(Util.convert(temp, Constant.this.base, true))) {
                    Constant.this.changed = true;
                } else {
                    Constant.this.changed = false;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.base2) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals("")) {
                    val = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                Constant.this.base = 2;
                this.valuePad.setBase(2);
                this.valueField.setText(val.toString(2));
            } else if (event.getSource() == this.base10) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals("")) {
                    val = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                Constant.this.base = 10;
                this.valuePad.setBase(10);
                this.valueField.setText(val.toString(10));
            } else if (event.getSource() == this.base16) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals("")) {
                    val = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                Constant.this.base = 16;
                this.valuePad.setBase(16);
                this.valueField.setText(val.toString(16));
            }
        }

        private void cancel() {
            Constant.this.cancelled = true;
            this.dispose();
        }
    }

    private class ConstantCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton repeat;
        private JButton cancel;
        private JTextField valueField;
        private KeyPad valuePad;
        private JRadioButton base2;
        private JRadioButton base10;
        private JRadioButton base16;
        private JRadioButton left;
        private JRadioButton right;
        private JRadioButton up;
        private JRadioButton down;

        private ConstantCreate(int x, int y) {
            super(JLSInfo.frame, "Create Constant", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.valueField = new JTextField("" + defaultValue, 10);
            this.valuePad = new KeyPad(this.valueField, 16, defaultValue.longValue(), this);
            this.base2 = new JRadioButton("2");
            this.base10 = new JRadioButton("10");
            this.base16 = new JRadioButton("16");
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right", true);
            this.up = new JRadioButton("Up");
            this.down = new JRadioButton("Down");
            Constant.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel inputs = new JLabel("Value: ", 4);
            info.add((Component)inputs, "West");
            info.add((Component)this.valueField, "Center");
            info.add((Component)this.valuePad, "East");
            this.valuePad.setBase(10);
            window.add(info);
            window.add(new JLabel(" "));
            JLabel rlbl = new JLabel("Radix");
            rlbl.setAlignmentX(0.5f);
            window.add(rlbl);
            JPanel bases = new JPanel(new GridLayout(1, 3));
            bases.add(this.base2);
            bases.add(this.base10);
            bases.add(this.base16);
            this.base2.setHorizontalAlignment(0);
            this.base10.setHorizontalAlignment(0);
            this.base16.setHorizontalAlignment(0);
            ButtonGroup group = new ButtonGroup();
            group.add(this.base2);
            group.add(this.base10);
            group.add(this.base16);
            this.base10.setSelected(true);
            window.add(bases);
            window.add(new JLabel(" "));
            JPanel rep = new JPanel();
            this.repeat = new JButton("Repeat Previous Value");
            this.repeat.setBackground(Color.yellow);
            rep.add(this.repeat);
            window.add(rep);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(this.up);
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(this.down);
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            gr.add(this.down);
            gr.add(this.up);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "const", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.valueField.addActionListener(this);
            this.repeat.addActionListener(this);
            this.cancel.addActionListener(this);
            this.base2.addActionListener(this);
            this.base10.addActionListener(this);
            this.base16.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ConstantCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.valueField) {
                try {
                    Constant.this.value = new BigInteger(this.valueField.getText(), Constant.this.base);
                    if (this.left.isSelected()) {
                        Constant.this.orientation = JLSInfo.Orientation.LEFT;
                    } else if (this.right.isSelected()) {
                        Constant.this.orientation = JLSInfo.Orientation.RIGHT;
                    } else if (this.up.isSelected()) {
                        Constant.this.orientation = JLSInfo.Orientation.UP;
                    } else if (this.down.isSelected()) {
                        Constant.this.orientation = JLSInfo.Orientation.DOWN;
                    }
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                this.dispose();
            } else if (event.getSource() == this.repeat) {
                Constant.this.setToPrevious();
                this.base2.setSelected(false);
                this.base10.setSelected(false);
                this.base16.setSelected(false);
                if (Constant.this.base == 2) {
                    this.base2.setSelected(true);
                } else if (Constant.this.base == 10) {
                    this.base10.setSelected(true);
                } else {
                    this.base16.setSelected(true);
                }
                this.valueField.setText(Constant.this.value.toString(Constant.this.base));
                this.valuePad.setBase(Constant.this.base);
                this.valuePad.reset();
                System.out.println((Object)Constant.this.orientation);
                if (Constant.this.orientation == JLSInfo.Orientation.LEFT) {
                    this.left.setSelected(true);
                } else if (Constant.this.orientation == JLSInfo.Orientation.RIGHT) {
                    this.right.setSelected(true);
                } else if (Constant.this.orientation == JLSInfo.Orientation.UP) {
                    this.up.setSelected(true);
                } else {
                    this.down.setSelected(true);
                }
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            } else if (event.getSource() == this.base2) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals("")) {
                    val = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                Constant.this.base = 2;
                this.valuePad.setBase(2);
                this.valueField.setText(val.toString(2));
            } else if (event.getSource() == this.base10) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals("")) {
                    val = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                Constant.this.base = 10;
                this.valuePad.setBase(10);
                this.valueField.setText(val.toString(10));
            } else if (event.getSource() == this.base16) {
                BigInteger val = BigInteger.ZERO;
                if (!this.valueField.getText().equals("")) {
                    val = new BigInteger(this.valueField.getText(), Constant.this.base);
                }
                Constant.this.base = 16;
                this.valuePad.setBase(16);
                this.valueField.setText(val.toString(16));
            }
        }

        private void cancel() {
            Constant.this.cancelled = true;
            this.dispose();
        }
    }
}

