/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Clock
extends LogicElement {
    private static int defaultCycleTime = 2;
    private static int defaultOneTime = defaultCycleTime / 2;
    private int cycleTime = defaultCycleTime;
    private int oneTime = defaultOneTime;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    private boolean cancelled;

    public Clock(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new ClockCreate(x + win.x, y + win.y);
        } else {
            new ClockCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        this.width = 2 * s;
        this.height = 2 * s;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.outputs.add(new Output("output", this, this.width, this.height / 2, 1));
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.outputs.add(new Output("output", this, 0, this.height / 2, 1));
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.outputs.add(new Output("output", this, this.width / 2, 0, 1));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.outputs.add(new Output("output", this, s, this.height, 1));
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int s = 12;
        int s2 = s / 2;
        int s4 = s / 4;
        int d = s * 2;
        g.setColor(Color.BLACK);
        g.drawRoundRect(this.x, this.y, d, d, s2, s2);
        int bottom = this.y + s + s2;
        int top = this.y + s2;
        int left = this.x + s4;
        g.drawLine(left, bottom, left + s4, bottom);
        g.drawLine(left += s4, bottom, left, top);
        g.drawLine(left, top, left + s2, top);
        g.drawLine(left += s2, top, left, bottom);
        g.drawLine(left, bottom, left + s2, bottom);
        g.drawLine(left += s2, bottom, left, top);
        g.drawLine(left, top, left + s4, top);
        ((Output)this.outputs.get(0)).draw(g);
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Clock");
        super.save(output);
        output.println(" int cycle " + this.cycleTime);
        output.println(" int one " + this.oneTime);
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.orientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("cycle")) {
            this.cycleTime = value;
        } else if (name.equals("one")) {
            this.oneTime = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public Element copy() {
        Clock it = new Clock(this.circuit);
        it.cycleTime = this.cycleTime;
        it.oneTime = this.oneTime;
        it.orientation = this.orientation;
        it.outputs.add(((Output)this.outputs.get(0)).copy(it));
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("clock, cycle time = " + this.cycleTime + " (zero for " + (this.cycleTime - this.oneTime) + ", one for " + this.oneTime + ")");
    }

    @Override
    public boolean canChange() {
        return true;
    }

    @Override
    public boolean canRotate() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.outputs.remove(0);
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        return !((Output)this.outputs.get(0)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.outputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public boolean change(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new ClockCreate(x + win.x, y + win.y);
        } else {
            new ClockCreate(pos.x + win.x, pos.y + win.y);
        }
        if (!this.cancelled) {
            this.circuit.markChanged();
        }
        return false;
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        BitSet zero = new BitSet(1);
        out.setValue(zero);
        BitSet one = new BitSet();
        one.flip(0);
        sim.post(new SimEvent(this.cycleTime - this.oneTime, this, one));
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        BitSet send = (BitSet)todo;
        Output out = (Output)this.outputs.get(0);
        out.propagate(send, now, sim);
        BitSet next = (BitSet)send.clone();
        next.flip(0);
        int when = this.oneTime;
        if (send.cardinality() == 0) {
            when = this.cycleTime - this.oneTime;
        }
        sim.post(new SimEvent(now + (long)when, this, next));
    }

    private class ClockCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField cycleTimeField;
        private JTextField oneTimeField;
        private KeyPad cycleTimePad;
        private KeyPad oneTimePad;
        private JRadioButton left;
        private JRadioButton right;
        private JRadioButton up;
        private JRadioButton down;

        private ClockCreate(int x, int y) {
            super(JLSInfo.frame, "Create Clock", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.cycleTimeField = new JTextField(String.valueOf(Clock.this.cycleTime), 10);
            this.oneTimeField = new JTextField(String.valueOf(Clock.this.oneTime), 10);
            this.cycleTimePad = new KeyPad(this.cycleTimeField, 10, defaultCycleTime, this);
            this.oneTimePad = new KeyPad(this.oneTimeField, 10, defaultOneTime, this);
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right", true);
            this.up = new JRadioButton("Up");
            this.down = new JRadioButton("Down");
            Clock.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JPanel labels = new JPanel(new GridLayout(3, 1, 1, 5));
            JLabel ctime = new JLabel("Cycle Time: ", 4);
            labels.add(ctime);
            JLabel otime = new JLabel("One Time: ", 4);
            labels.add(otime);
            info.add((Component)labels, "West");
            JPanel fields = new JPanel(new GridLayout(2, 1, 1, 5));
            JPanel ct = new JPanel(new BorderLayout());
            ct.add((Component)this.cycleTimeField, "Center");
            ct.add((Component)this.cycleTimePad, "East");
            fields.add(ct);
            JPanel ot = new JPanel(new BorderLayout());
            ot.add((Component)this.oneTimeField, "Center");
            ot.add((Component)this.oneTimePad, "East");
            fields.add(ot);
            info.add((Component)fields, "Center");
            window.add(info);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(this.up);
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(this.down);
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            gr.add(this.down);
            gr.add(this.up);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 2));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "clock", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.cycleTimeField.addActionListener(this);
            this.oneTimeField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ClockCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.cycleTimeField || event.getSource() == this.oneTimeField) {
                try {
                    int newCycleTime = Integer.parseInt(this.cycleTimeField.getText());
                    int newOneTime = Integer.parseInt(this.oneTimeField.getText());
                    Clock.this.cycleTime = newCycleTime;
                    Clock.this.oneTime = newOneTime;
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (Clock.this.oneTime >= Clock.this.cycleTime) {
                    JOptionPane.showMessageDialog(this, "One time must be less than cycle time", "Error", 0);
                    return;
                }
                if (this.left.isSelected()) {
                    Clock.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    Clock.this.orientation = JLSInfo.Orientation.RIGHT;
                } else if (this.up.isSelected()) {
                    Clock.this.orientation = JLSInfo.Orientation.UP;
                } else if (this.down.isSelected()) {
                    Clock.this.orientation = JLSInfo.Orientation.DOWN;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Clock.this.cancelled = true;
            this.dispose();
        }
    }
}

