/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Group;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Binder
extends Group
implements TriProp {
    public Binder(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new Group.GroupCreate(this, x + win.x, y + win.y, "Bundler");
        } else {
            new Group.GroupCreate(this, pos.x + win.x, pos.y + win.y, "Bundler");
        }
        if (this.cancelled) {
            return false;
        }
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            this.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        return true;
    }

    @Override
    public void init(Graphics g) {
        super.init(g);
        int s = 12;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            int ypos = s;
            for (Group.Entry e : this.ranges) {
                this.inputs.add(new Input(e.toCircuitString(), this, 0, ypos, e.getSize()));
                ypos += s;
            }
            this.outputs.add(new Output("output", this, this.width, ((this.ranges.size() - 1) / 2 + 1) * s, this.bits));
            if (this.loadTriState) {
                ((Output)this.outputs.get(0)).loadSetTriState();
            }
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            int ypos = s;
            for (Group.Entry e : this.ranges) {
                this.inputs.add(new Input(e.toCircuitString(), this, this.width, ypos, e.getSize()));
                ypos += s;
            }
            this.outputs.add(new Output("output", this, 0, ((this.ranges.size() - 1) / 2 + 1) * s, this.bits));
            if (this.loadTriState) {
                ((Output)this.outputs.get(0)).loadSetTriState();
            }
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            int xpos = s;
            for (Group.Entry e : this.ranges) {
                this.inputs.add(new Input(e.toCircuitString(), this, xpos, 0, e.getSize()));
                xpos += s;
            }
            this.outputs.add(new Output("output", this, ((this.ranges.size() - 1) / 2 + 1) * s, this.height, this.bits));
            if (this.loadTriState) {
                ((Output)this.outputs.get(0)).loadSetTriState();
            }
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            int xpos = s;
            for (Group.Entry e : this.ranges) {
                this.inputs.add(new Input(e.toCircuitString(), this, xpos, this.height, e.getSize()));
                xpos += s;
            }
            this.outputs.add(new Output("output", this, ((this.ranges.size() - 1) / 2 + 1) * s, 0, this.bits));
            if (this.loadTriState) {
                ((Output)this.outputs.get(0)).loadSetTriState();
            }
        }
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        int d2 = 3;
        int s = 12;
        FontMetrics fm = g.getFontMetrics();
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            for (Input input : this.inputs) {
                input.draw(g);
                int ypos = input.getY();
                Rectangle2D t = fm.getStringBounds(input.getName(), g);
                g.setColor(Color.BLACK);
                int edge = this.x + 3;
                g.drawString(input.getName(), edge, (int)((double)ypos - t.getHeight() / 2.0 + (double)fm.getAscent()));
                g.drawLine(this.x + this.width - s / 2, ypos, (int)((double)edge + t.getWidth() + (double)d2), ypos);
            }
            g.setColor(Color.BLACK);
            g.drawLine(this.x + this.width - s / 2, this.y + s, this.x + this.width - s / 2, this.y + this.height - s);
            Output output = (Output)this.outputs.get(0);
            g.setColor(Color.black);
            int ypos = output.getY();
            g.drawLine(this.x + this.width, ypos, this.x + this.width - s / 2, ypos);
            output.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            for (Input input : this.inputs) {
                input.draw(g);
                int ypos = input.getY();
                Rectangle2D t = fm.getStringBounds(input.getName(), g);
                g.setColor(Color.BLACK);
                int edge = (int)((double)(this.x + this.width - 3) - t.getWidth());
                g.drawString(input.getName(), edge, (int)((double)ypos - t.getHeight() / 2.0 + (double)fm.getAscent()));
                g.drawLine(this.x + s / 2, ypos, edge - d2, ypos);
            }
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s / 2, this.y + s, this.x + s / 2, this.y + this.height - s);
            Output output = (Output)this.outputs.get(0);
            g.setColor(Color.black);
            int ypos = output.getY();
            g.drawLine(this.x, ypos, this.x + s / 2, ypos);
            output.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            int inum = 0;
            for (Input input : this.inputs) {
                input.draw(g);
                int xpos = input.getX();
                Rectangle2D t = fm.getStringBounds(input.getName(), g);
                g.setColor(Color.BLACK);
                int edge = this.y + 3;
                if (inum % 2 == 0) {
                    g.drawString(input.getName(), xpos - (int)t.getWidth() / 2, (int)((double)edge + t.getHeight() / 2.0 + 6.0));
                }
                g.drawLine(xpos, this.y + this.height - s, xpos, (int)((double)edge + t.getHeight() + (double)d2));
                ++inum;
            }
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s, this.y + this.height - s, this.x + this.width - s, this.y + this.height - s);
            Output output = (Output)this.outputs.get(0);
            g.setColor(Color.black);
            int xpos = output.getX();
            g.drawLine(xpos, this.y + this.height - s, xpos, this.y + this.height);
            output.draw(g);
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            int inum = 0;
            for (Input input : this.inputs) {
                input.draw(g);
                int xpos = input.getX();
                Rectangle2D t = fm.getStringBounds(input.getName(), g);
                g.setColor(Color.BLACK);
                int edge = this.y + this.height - 3;
                if (inum % 2 == 0) {
                    g.drawString(input.getName(), xpos - (int)t.getWidth() / 2, (int)((double)edge - t.getHeight() / 2.0 + 6.0));
                }
                g.drawLine(xpos, this.y + s, xpos, (int)((double)edge - t.getHeight() + (double)d2));
                ++inum;
            }
            g.setColor(Color.BLACK);
            g.drawLine(this.x + s, this.y + s, this.x + this.width - s, this.y + s);
            Output output = (Output)this.outputs.get(0);
            g.setColor(Color.black);
            int xpos = output.getX();
            g.drawLine(xpos, this.y + s, xpos, this.y);
            output.draw(g);
        }
    }

    @Override
    public Element copy() {
        Binder it = new Binder(this.circuit);
        super.copy(it);
        return it;
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Binder");
        super.save(output);
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText("bundle " + this.bits + " bits");
    }

    @Override
    public void setTriState(boolean which) {
        boolean saveState = this.triState;
        int tri = 0;
        for (Input input : this.inputs) {
            if (!input.isAttached() || !input.getWireEnd().isTriState()) continue;
            ++tri;
        }
        int numInputs = this.inputs.size();
        this.triState = numInputs > 0 && numInputs == tri;
        if (this.triState == saveState) {
            return;
        }
        for (Output out : this.outputs) {
            out.setTriState(this.triState);
        }
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        super.rotate(direction, g);
        this.init(g);
    }

    @Override
    public void flip(Graphics g) {
        super.flip(g);
        this.init(g);
    }

    @Override
    public void initSim(Simulator sim) {
        Output out = (Output)this.outputs.get(0);
        BitSet value = null;
        if (!out.isTriState()) {
            value = new BitSet();
        }
        ((Output)this.outputs.get(0)).setValue(value);
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        BitSet newValue = new BitSet(this.bits);
        int inNum = 0;
        boolean allOff = true;
        for (Group.Entry e : this.ranges) {
            BitSet value = ((Input)this.inputs.get(inNum)).getValue();
            if (value == null) {
                value = new BitSet();
            } else {
                allOff = false;
            }
            int inp = 0;
            int[] nArray = e.getValues();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                boolean val = value.get(inp);
                newValue.set(i, val);
                ++inp;
                ++n2;
            }
            ++inNum;
        }
        if (allOff) {
            ((Output)this.outputs.get(0)).propagate(null, now, sim);
        } else {
            ((Output)this.outputs.get(0)).propagate(newValue, now, sim);
        }
    }
}

