/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.elem;

import edu.mtu.cs.jls.BitSetUtils;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.KeyPad;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.sim.SimEvent;
import edu.mtu.cs.jls.sim.Simulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.util.BitSet;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Adder
extends LogicElement {
    private static final int defaultBits = 1;
    private static final int defaultPropDelay = 30;
    private int bits = 1;
    private int propDelay = 30;
    private JLSInfo.Orientation orientation = JLSInfo.Orientation.RIGHT;
    private boolean cancelled;
    private BitSet toBeValue;

    public Adder(Circuit circuit) {
        super(circuit);
    }

    @Override
    public boolean setup(Graphics g, JPanel editWindow, int x, int y) {
        Point pos = editWindow.getMousePosition();
        Point win = editWindow.getLocationOnScreen();
        if (pos == null) {
            new AdderCreate(x + win.x, y + win.y);
        } else {
            new AdderCreate(pos.x + win.x, pos.y + win.y);
        }
        if (this.cancelled) {
            return false;
        }
        this.propDelay = 30 * this.bits;
        this.init(g);
        Point p = MouseInfo.getPointerInfo().getLocation();
        p.x -= win.x;
        p.y -= win.y;
        if (p != null) {
            super.setXY(p.x - this.width / 2, p.y - this.height / 2);
        }
        System.out.println("adder at: " + p);
        return true;
    }

    @Override
    public void init(Graphics g) {
        int s = 12;
        this.height = 4 * s;
        this.width = 4 * s;
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.inputs.add(new Input("A", this, 0, s, this.bits));
            this.inputs.add(new Input("B", this, 0, 3 * s, this.bits));
            this.inputs.add(new Input("Cin", this, this.width / 2, 0, 1));
            this.outputs.add(new Output("S", this, this.width, 2 * s, this.bits));
            this.outputs.add(new Output("Cout", this, this.width / 2, this.height, 1));
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.inputs.add(new Input("A", this, this.width, s, this.bits));
            this.inputs.add(new Input("B", this, this.width, 3 * s, this.bits));
            this.inputs.add(new Input("Cin", this, this.width / 2, 0, 1));
            this.outputs.add(new Output("S", this, 0, 2 * s, this.bits));
            this.outputs.add(new Output("Cout", this, this.width / 2, this.height, 1));
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.inputs.add(new Input("A", this, s, 0, this.bits));
            this.inputs.add(new Input("B", this, 3 * s, 0, this.bits));
            this.inputs.add(new Input("Cin", this, 0, this.height / 2, 1));
            this.outputs.add(new Output("S", this, 2 * s, this.height, this.bits));
            this.outputs.add(new Output("Cout", this, this.width, this.height / 2, 1));
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.inputs.add(new Input("A", this, s, this.height, this.bits));
            this.inputs.add(new Input("B", this, 3 * s, this.height, this.bits));
            this.inputs.add(new Input("Cin", this, 0, this.height / 2, 1));
            this.outputs.add(new Output("S", this, 2 * s, 0, this.bits));
            this.outputs.add(new Output("Cout", this, this.width, this.height / 2, 1));
        }
    }

    @Override
    public void draw(Graphics g) {
        Rectangle2D t;
        Font f;
        int ascent;
        super.draw(g);
        g.setColor(Color.BLACK);
        g.drawRect(this.x, this.y, this.width, this.height);
        int s = 12;
        if (this.orientation == JLSInfo.Orientation.UP || this.orientation == JLSInfo.Orientation.DOWN) {
            g.drawLine(this.x + 2 * s, this.y + s, this.x + 2 * s, this.y + 2 * s);
            g.drawLine(this.x + 3 * s / 2, this.y + 3 * s / 2, this.x + 5 * s / 2, this.y + 3 * s / 2);
        } else if (this.orientation == JLSInfo.Orientation.LEFT || this.orientation == JLSInfo.Orientation.RIGHT) {
            g.drawLine(this.x + 2 * s, this.y + 3 * s / 2, this.x + 2 * s, this.y + 5 * s / 2);
            g.drawLine(this.x + 3 * s / 2, this.y + 2 * s, this.x + 5 * s / 2, this.y + 2 * s);
        }
        int d = 6;
        FontMetrics fm = g.getFontMetrics();
        if (this.orientation == JLSInfo.Orientation.RIGHT) {
            ascent = fm.getAscent();
            Rectangle2D t2 = fm.getStringBounds("A", g);
            g.drawString("A", this.x + d / 2, (int)((double)(this.y + s) - t2.getHeight() / 2.0) + ascent);
            t2 = fm.getStringBounds("B", g);
            g.drawString("B", this.x + d / 2, (int)((double)(this.y + 3 * s) - t2.getHeight() / 2.0) + ascent);
            t2 = fm.getStringBounds("S", g);
            g.drawString("S", (int)((double)(this.x + this.width) - t2.getWidth() - (double)(d / 2)), (int)((double)(this.y + 2 * s) - t2.getHeight() / 2.0) + ascent);
            f = g.getFont();
            float fs = f.getSize2D();
            Font nf = f.deriveFont((float)((double)fs * 0.75));
            g.setFont(nf);
            fm = g.getFontMetrics();
            ascent = fm.getAscent();
            int descent = fm.getDescent();
            t2 = fm.getStringBounds("Cin", g);
            g.drawString("Cin", this.x + (int)((double)this.width - t2.getWidth()) / 2, this.y + ascent);
            t2 = fm.getStringBounds("Cout", g);
            g.drawString("Cout", this.x + (int)((double)this.width - t2.getWidth()) / 2, this.y + this.height - descent);
            g.setFont(f);
        } else if (this.orientation == JLSInfo.Orientation.LEFT) {
            ascent = fm.getAscent();
            Rectangle2D t3 = fm.getStringBounds("A", g);
            g.drawString("A", (int)((double)(this.x + this.width) - t3.getWidth() - (double)(d / 2)), (int)((double)(this.y + s) - t3.getHeight() / 2.0) + ascent);
            t3 = fm.getStringBounds("B", g);
            g.drawString("B", (int)((double)(this.x + this.width) - t3.getWidth() - (double)(d / 2)), (int)((double)(this.y + 3 * s) - t3.getHeight() / 2.0) + ascent);
            t3 = fm.getStringBounds("S", g);
            g.drawString("S", this.x + d / 2, (int)((double)(this.y + 2 * s) - t3.getHeight() / 2.0) + ascent);
            f = g.getFont();
            float fs = f.getSize2D();
            Font nf = f.deriveFont((float)((double)fs * 0.75));
            g.setFont(nf);
            fm = g.getFontMetrics();
            ascent = fm.getAscent();
            int descent = fm.getDescent();
            t3 = fm.getStringBounds("Cin", g);
            g.drawString("Cin", this.x + (int)((double)this.width - t3.getWidth()) / 2, this.y + ascent);
            t3 = fm.getStringBounds("Cout", g);
            g.drawString("Cout", this.x + (int)((double)this.width - t3.getWidth()) / 2, this.y + this.height - descent);
            g.setFont(f);
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            ascent = fm.getAscent();
            int descent = fm.getDescent();
            t = fm.getStringBounds("A", g);
            g.drawString("A", (int)((double)(this.x + s) - t.getWidth() / 2.0), (int)((double)this.y + t.getHeight() / 4.0) + ascent);
            t = fm.getStringBounds("B", g);
            g.drawString("B", (int)((double)(this.x + this.width) - t.getWidth() - (double)(d / 2)), (int)((double)this.y + t.getHeight() / 4.0) + ascent);
            t = fm.getStringBounds("S", g);
            g.drawString("S", this.x + (int)((double)this.width - t.getWidth()) / 2, this.y + this.height - descent);
            Font f2 = g.getFont();
            float fs = f2.getSize2D();
            Font nf = f2.deriveFont((float)((double)fs * 0.7));
            g.setFont(nf);
            fm = g.getFontMetrics();
            ascent = fm.getAscent();
            descent = fm.getDescent();
            t = fm.getStringBounds("Cin", g);
            g.drawString("Cin", this.x + 5, this.y + this.height / 2 + ascent);
            t = fm.getStringBounds("Cout", g);
            g.drawString("Cout", this.x + (int)((double)this.width - t.getWidth() - 5.0), this.y + this.height / 2 + ascent);
            g.setFont(f2);
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            ascent = fm.getAscent();
            int descent = fm.getDescent();
            t = fm.getStringBounds("A", g);
            g.drawString("A", (int)((double)(this.x + s) - t.getWidth() / 2.0), (int)((double)(this.y + this.height) - t.getHeight()) + ascent);
            t = fm.getStringBounds("B", g);
            g.drawString("B", (int)((double)(this.x + this.width) - t.getWidth() - (double)(d / 2)), (int)((double)(this.y + this.height) - t.getHeight()) + ascent);
            t = fm.getStringBounds("S", g);
            g.drawString("S", this.x + (int)((double)this.width - t.getWidth()) / 2, this.y + (int)t.getHeight());
            Font f3 = g.getFont();
            float fs = f3.getSize2D();
            Font nf = f3.deriveFont((float)((double)fs * 0.7));
            g.setFont(nf);
            fm = g.getFontMetrics();
            ascent = fm.getAscent();
            descent = fm.getDescent();
            t = fm.getStringBounds("Cin", g);
            g.drawString("Cin", this.x + 5, this.y + this.height / 2 + ascent);
            t = fm.getStringBounds("Cout", g);
            g.drawString("Cout", this.x + (int)((double)this.width - t.getWidth() - 5.0), this.y + this.height / 2 + ascent);
            g.setFont(f3);
        }
        for (Input input : this.inputs) {
            input.draw(g);
        }
        for (Output output : this.outputs) {
            output.draw(g);
        }
    }

    @Override
    public void setValue(String name, int value) {
        if (name.equals("bits")) {
            this.bits = value;
        } else if (name.equals("delay")) {
            this.propDelay = value;
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        if (name.equals("orient")) {
            if (value.equals("LEFT")) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (value.equals("RIGHT")) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (value.equals("UP")) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (value.equals("DOWN")) {
                this.orientation = JLSInfo.Orientation.DOWN;
            }
        } else {
            super.setValue(name, value);
        }
    }

    @Override
    public void save(PrintWriter output) {
        output.println("ELEMENT Adder");
        super.save(output);
        output.println(" int bits " + this.bits);
        output.println(" int delay " + this.propDelay);
        output.println(" String orient \"" + this.orientation.toString() + "\"");
        output.println("END");
    }

    @Override
    public Element copy() {
        Adder it = new Adder(this.circuit);
        it.bits = this.bits;
        it.propDelay = this.propDelay;
        it.orientation = this.orientation;
        for (Input input : this.inputs) {
            it.inputs.add(input.copy(it));
        }
        for (Output output : this.outputs) {
            it.outputs.add(output.copy(it));
        }
        super.copy(it);
        return it;
    }

    @Override
    public void showInfo(JLabel info) {
        info.setText(String.valueOf(this.bits) + " bit adder");
    }

    @Override
    public boolean hasTiming() {
        return true;
    }

    @Override
    public void resetPropDelay() {
        this.propDelay = this.bits * 30;
    }

    @Override
    public int getDelay() {
        return this.propDelay;
    }

    @Override
    public void setDelay(int temp) {
        this.propDelay = temp;
    }

    @Override
    public boolean canRotate() {
        return !((Input)this.inputs.get(0)).isAttached() && !((Input)this.inputs.get(1)).isAttached() && !((Input)this.inputs.get(2)).isAttached() && !((Output)this.outputs.get(0)).isAttached() && !((Output)this.outputs.get(1)).isAttached();
    }

    @Override
    public void rotate(JLSInfo.Orientation direction, Graphics g) {
        if (direction == JLSInfo.Orientation.LEFT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.LEFT;
            }
        } else if (direction == JLSInfo.Orientation.RIGHT) {
            if (this.orientation == JLSInfo.Orientation.LEFT) {
                this.orientation = JLSInfo.Orientation.UP;
            } else if (this.orientation == JLSInfo.Orientation.DOWN) {
                this.orientation = JLSInfo.Orientation.LEFT;
            } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
                this.orientation = JLSInfo.Orientation.DOWN;
            } else if (this.orientation == JLSInfo.Orientation.UP) {
                this.orientation = JLSInfo.Orientation.RIGHT;
            }
        }
        this.inputs.clear();
        this.outputs.clear();
        this.init(g);
    }

    @Override
    public boolean canFlip() {
        return !((Input)this.inputs.get(0)).isAttached() && !((Input)this.inputs.get(1)).isAttached() && !((Input)this.inputs.get(2)).isAttached() && !((Output)this.outputs.get(0)).isAttached() && !((Output)this.outputs.get(1)).isAttached();
    }

    @Override
    public void flip(Graphics g) {
        if (this.orientation == JLSInfo.Orientation.LEFT) {
            this.orientation = JLSInfo.Orientation.RIGHT;
        } else if (this.orientation == JLSInfo.Orientation.RIGHT) {
            this.orientation = JLSInfo.Orientation.LEFT;
        } else if (this.orientation == JLSInfo.Orientation.UP) {
            this.orientation = JLSInfo.Orientation.DOWN;
        } else if (this.orientation == JLSInfo.Orientation.DOWN) {
            this.orientation = JLSInfo.Orientation.UP;
        }
        this.outputs.clear();
        this.inputs.clear();
        this.width = 0;
        this.height = 0;
        this.init(g);
    }

    @Override
    public void initSim(Simulator sim) {
        BitSet zero = new BitSet(1);
        for (Output output : this.outputs) {
            output.setValue((BitSet)zero.clone());
        }
        this.toBeValue = (BitSet)zero.clone();
    }

    @Override
    public void react(long now, Simulator sim, Object todo) {
        if (todo == null) {
            BitSet allsum;
            BitSet cin;
            BitSet b;
            BitSet a = ((Input)this.inputs.get(0)).getValue();
            if (a == null) {
                a = new BitSet();
            }
            if ((b = ((Input)this.inputs.get(1)).getValue()) == null) {
                b = new BitSet();
            }
            if ((cin = ((Input)this.inputs.get(2)).getValue()) == null) {
                cin = new BitSet();
            }
            boolean c = true;
            if (cin.cardinality() == 0) {
                c = false;
            }
            if (!(allsum = BitSetUtils.SumCarry(c, a, b)).equals(this.toBeValue)) {
                this.toBeValue = (BitSet)allsum.clone();
                sim.post(new SimEvent(now + (long)this.propDelay, this, allsum));
            }
        } else {
            BitSet allsum = (BitSet)todo;
            BitSet sum = (BitSet)allsum.clone();
            BitSet carry = new BitSet(1);
            carry.set(0, sum.get(this.bits));
            sum.clear(this.bits);
            Output sumOut = (Output)this.outputs.get(0);
            sumOut.propagate(sum, now, sim);
            Output carryOut = (Output)this.outputs.get(1);
            carryOut.propagate(carry, now, sim);
        }
    }

    private class AdderCreate
    extends JDialog
    implements ActionListener {
        private JButton ok;
        private JButton cancel;
        private JTextField bitsField;
        private KeyPad bitsPad;
        private JRadioButton left;
        private JRadioButton right;
        private JRadioButton up;
        private JRadioButton down;

        private AdderCreate(int x, int y) {
            super(JLSInfo.frame, "Create Adder", true);
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
            this.bitsField = new JTextField("1", 10);
            this.bitsPad = new KeyPad(this.bitsField, 10, 1L, this);
            this.left = new JRadioButton("Left");
            this.right = new JRadioButton("Right", true);
            this.up = new JRadioButton("Up");
            this.down = new JRadioButton("Down");
            Adder.this.cancelled = false;
            Container window = this.getContentPane();
            window.setLayout(new BoxLayout(window, 1));
            JPanel info = new JPanel(new BorderLayout());
            JLabel bits = new JLabel("Input Bits: ", 4);
            info.add((Component)bits, "West");
            info.add((Component)this.bitsField, "Center");
            info.add((Component)this.bitsPad, "East");
            window.add(info);
            JLabel olbl = new JLabel("Orientation");
            olbl.setAlignmentX(0.5f);
            window.add(olbl);
            JPanel orients = new JPanel(new GridLayout(3, 3));
            orients.add(new JLabel(""));
            orients.add(this.up);
            orients.add(new JLabel(""));
            orients.add(this.left);
            orients.add(new JLabel(""));
            orients.add(this.right);
            orients.add(new JLabel(""));
            orients.add(this.down);
            orients.add(new JLabel(""));
            this.left.setHorizontalAlignment(0);
            this.right.setHorizontalAlignment(0);
            this.up.setHorizontalAlignment(0);
            this.down.setHorizontalAlignment(0);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.left);
            gr.add(this.right);
            gr.add(this.down);
            gr.add(this.up);
            window.add(orients);
            window.add(new JLabel(" "));
            JPanel okCancel = new JPanel(new GridLayout(1, 3));
            this.ok.setBackground(Color.green);
            okCancel.add(this.ok);
            this.cancel.setBackground(Color.pink);
            okCancel.add(this.cancel);
            JButton help = new JButton("Help");
            if (JLSInfo.hb == null) {
                Util.noHelp(help);
            } else {
                JLSInfo.hb.enableHelpOnButton(help, "adder", null);
            }
            okCancel.add(help);
            window.add(okCancel);
            this.getRootPane().setDefaultButton(this.ok);
            this.ok.addActionListener(this);
            this.bitsField.addActionListener(this);
            this.cancel.addActionListener(this);
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    AdderCreate.this.cancel();
                }
            });
            this.pack();
            Dimension d = this.getSize();
            this.setLocation(x - d.width / 2, y - d.height / 2);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == this.ok || event.getSource() == this.bitsField) {
                try {
                    Adder.this.bits = Integer.parseInt(this.bitsField.getText());
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(this, "Value not numeric, try again", "Error", 0);
                    return;
                }
                if (Adder.this.bits < 1) {
                    JOptionPane.showMessageDialog(this, "Must be at least 1 bit", "Error", 0);
                    return;
                }
                if (this.left.isSelected()) {
                    Adder.this.orientation = JLSInfo.Orientation.LEFT;
                } else if (this.right.isSelected()) {
                    Adder.this.orientation = JLSInfo.Orientation.RIGHT;
                } else if (this.up.isSelected()) {
                    Adder.this.orientation = JLSInfo.Orientation.UP;
                } else if (this.down.isSelected()) {
                    Adder.this.orientation = JLSInfo.Orientation.DOWN;
                }
                this.dispose();
            } else if (event.getSource() == this.cancel) {
                this.cancel();
            }
        }

        private void cancel() {
            Adder.this.cancelled = true;
            this.dispose();
        }
    }
}

