/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.edit;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.edit.Editor;
import edu.mtu.cs.jls.elem.Adder;
import edu.mtu.cs.jls.elem.AndGate;
import edu.mtu.cs.jls.elem.Binder;
import edu.mtu.cs.jls.elem.Clock;
import edu.mtu.cs.jls.elem.Constant;
import edu.mtu.cs.jls.elem.Decoder;
import edu.mtu.cs.jls.elem.DelayGate;
import edu.mtu.cs.jls.elem.Display;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Extend;
import edu.mtu.cs.jls.elem.Input;
import edu.mtu.cs.jls.elem.InputPin;
import edu.mtu.cs.jls.elem.JumpEnd;
import edu.mtu.cs.jls.elem.JumpStart;
import edu.mtu.cs.jls.elem.Memory;
import edu.mtu.cs.jls.elem.Mux;
import edu.mtu.cs.jls.elem.NandGate;
import edu.mtu.cs.jls.elem.NorGate;
import edu.mtu.cs.jls.elem.NotGate;
import edu.mtu.cs.jls.elem.OrGate;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.OutputPin;
import edu.mtu.cs.jls.elem.Pause;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.Register;
import edu.mtu.cs.jls.elem.SigGen;
import edu.mtu.cs.jls.elem.Splitter;
import edu.mtu.cs.jls.elem.Stop;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.elem.Text;
import edu.mtu.cs.jls.elem.TriProp;
import edu.mtu.cs.jls.elem.TriState;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.elem.WireNet;
import edu.mtu.cs.jls.elem.XorGate;
import edu.mtu.cs.jls.elem.bool.TruthTable;
import edu.mtu.cs.jls.elem.sm.StateMachine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

public abstract class SimpleEditor
extends JPanel {
    protected Circuit circuit;
    protected EditWindow ew;
    protected boolean enabled = true;
    protected JTabbedPane tabbedParent;
    private JScrollPane pane;
    protected JPanel top;
    protected JLabel editable = new JLabel(" ");
    private JLabel message = new JLabel(" ");
    private JLabel info = new JLabel(" ", 0);
    private Circuit clipboard;
    private JPopupMenu importMenu = new JPopupMenu();
    private SimpleEditor me;
    private Stack<Circuit> undos = new Stack();
    private Stack<Circuit> redos = new Stack();
    private int check = 11;
    private Map<String, JMenuItem> menuMap = new HashMap<String, JMenuItem>();
    private Map<String, Circuit> circMap = new HashMap<String, Circuit>();

    public SimpleEditor(JTabbedPane parent, Circuit circuit, String name, Circuit clipboard) {
        this.circuit = circuit;
        this.clipboard = clipboard;
        this.tabbedParent = parent;
        this.setName(name);
        this.setLayout(new BorderLayout());
        JPanel all = new JPanel(new BorderLayout());
        this.top = new JPanel();
        this.top.setLayout(new BorderLayout());
        this.top.setBackground(Color.CYAN);
        this.top.add((Component)this.editable, "West");
        this.top.add((Component)this.message, "East");
        this.message.setOpaque(true);
        this.message.setBackground(Color.cyan);
        this.top.add((Component)this.info, "Center");
        all.add((Component)this.top, "North");
        this.ew = new EditWindow();
        this.ew.setPreferredSize(new Dimension(1000, 1000));
        this.pane = new JScrollPane(this.ew);
        this.pane.getHorizontalScrollBar().setUnitIncrement(10);
        this.pane.getVerticalScrollBar().setUnitIncrement(10);
        all.add((Component)this.pane, "Center");
        JPanel elements = this.ew.getToolBar();
        this.add((Component)elements, "North");
        this.add(all);
        this.me = this;
        JButton corner = new JButton();
        corner.setToolTipText("expand circuit drawing area by 10%");
        this.pane.setCorner("LOWER_RIGHT_CORNER", corner);
        corner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimpleEditor.this.me.increaseSize();
            }
        });
    }

    public JPanel getTop() {
        return this.top;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public void addToImportMenu(Circuit subCirc) {
        AbstractAction act = new AbstractAction(subCirc.getName()){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimpleEditor.this.ew.doImport((String)this.getValue("Name"));
            }
        };
        JMenuItem imp = new JMenuItem(act);
        this.importMenu.add(imp);
        this.menuMap.put(subCirc.getName(), imp);
        this.circMap.put(subCirc.getName(), subCirc);
    }

    public void removeFromImportMenu(Circuit subCirc) {
        String name = subCirc.getName();
        if (name == null) {
            return;
        }
        JMenuItem item = this.menuMap.get(name);
        if (item != null) {
            this.importMenu.remove(item);
        }
        this.menuMap.remove(name);
        this.circMap.remove(name);
    }

    public void changeInImportMenu(String oldname, String newname) {
        JMenuItem item = this.menuMap.get(oldname);
        item.setText(newname);
        this.menuMap.remove(oldname);
        this.menuMap.put(newname, item);
        AbstractAction act = new AbstractAction(newname){

            @Override
            public void actionPerformed(ActionEvent event) {
                SimpleEditor.this.ew.doImport((String)this.getValue("Name"));
            }
        };
        item.setAction(act);
        Circuit newCircuit = this.circMap.get(oldname);
        this.circMap.remove(oldname);
        this.circMap.put(newname, newCircuit);
    }

    public void setCircuitSize(Dimension size) {
        this.ew.setPreferredSize(size);
        this.ew.revalidate();
    }

    public void changeBackgroundColor() {
        this.ew.setBackground(JLSInfo.backgroundColor);
    }

    public void increaseSize() {
        Dimension size = this.ew.getSize();
        Dimension newSize = new Dimension((int)((double)size.width * 1.1), (int)((double)size.height * 1.1));
        this.setCircuitSize(newSize);
    }

    public void finishImport(Circuit impCirc) {
        SubCircuit sub = new SubCircuit(this.circuit);
        sub.setSubCircuit(impCirc);
        impCirc.setImported(sub);
        this.ew.setup(sub, true);
        HashSet<Element> sigGens = new HashSet<Element>();
        for (Element el : impCirc.getElements()) {
            if (!(el instanceof SigGen)) continue;
            sigGens.add(el);
        }
        for (Element el : sigGens) {
            impCirc.remove(el);
        }
    }

    public void enableEditor(boolean which) {
        this.enabled = which;
    }

    public void quickReset() {
        this.ew.markChanged();
        this.ew.clearSelected();
        this.ew.setState(State.idle);
    }

    public void close() {
        throw new UnsupportedOperationException();
    }

    private class EditWindow
    extends JPanel
    implements ActionListener,
    MouseListener,
    MouseMotionListener {
        private JPopupMenu optionMenu = new JPopupMenu();
        private JMenuItem probe = new JMenuItem("");
        private JMenuItem watch = new JMenuItem("");
        private JMenuItem modify = new JMenuItem("Modify");
        private JMenuItem timing = new JMenuItem("Change Timing");
        private JMenuItem view = new JMenuItem("View Contents");
        private JMenuItem undo = new JMenuItem("Undo");
        private JMenuItem redo = new JMenuItem("Redo");
        private JMenuItem cut = new JMenuItem("Cut");
        private JMenuItem copy = new JMenuItem("Copy");
        private JMenuItem delete = new JMenuItem("Delete");
        private JMenuItem lock = new JMenuItem("Lock");
        private JPopupMenu newMenu = new JPopupMenu();
        private JMenuItem connect = new JMenuItem("Wire(s)");
        private JMenuItem paste = new JMenuItem("Paste");
        private JMenuItem selAll = new JMenuItem("Select All");
        private JMenuItem close = new JMenuItem("Close");
        private JMenuItem Crotate = new JMenuItem("Rotate Clockwise");
        private JMenuItem CCrotate = new JMenuItem("Rotate Counter-Clockwise");
        private JMenuItem flip = new JMenuItem("Flip");
        private JMenuItem matchJump = new JMenuItem("Create Matching End");
        private JPanel toolbar;
        private JMenu elements;
        private State currentState = State.idle;
        private boolean firstDraw = true;
        private Graphics graphics;
        private int x;
        private int y;
        private Rectangle selRect = null;
        private Set<Element> selected = new HashSet<Element>();
        private WireEnd wireEnd;
        private Wire wire;
        private WireNet net;
        private WireEnd prev = null;
        private Set<Element> adds = new HashSet<Element>();
        private Set<Element> subs = new HashSet<Element>();
        private String overlapMessage = "";

        public EditWindow() {
            this.setBackground(JLSInfo.backgroundColor);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.probe.setToolTipText("watch activity on this wire during simulation");
            this.probe.setAccelerator(KeyStroke.getKeyStroke(80, 2));
            this.watch.setToolTipText("watch activity on this element during simulation");
            this.watch.setAccelerator(KeyStroke.getKeyStroke(87, 2));
            this.modify.setToolTipText("view/modify element details");
            this.modify.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            this.timing.setToolTipText("change propagation delay or access time");
            this.timing.setAccelerator(KeyStroke.getKeyStroke(84, 2));
            this.view.setToolTipText("view current simulated value");
            this.view.setAccelerator(KeyStroke.getKeyStroke(83, 2));
            this.cut.setToolTipText("cut all selected elements to clipboard");
            this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
            this.copy.setToolTipText("copy all selected elements to clipboard");
            this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.delete.setToolTipText("delete all selected elements");
            this.delete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.lock.setToolTipText("make selected elements uneditable (cannot be undone)");
            this.lock.setAccelerator(KeyStroke.getKeyStroke(76, 2));
            this.connect.setToolTipText("create a new wire");
            this.connect.setAccelerator(KeyStroke.getKeyStroke(87, 2));
            this.newMenu.add(this.connect);
            this.paste.setToolTipText("paste contents of clipboard");
            this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.newMenu.add(this.paste);
            this.selAll.setToolTipText("select all elements");
            this.selAll.setAccelerator(KeyStroke.getKeyStroke(65, 2));
            this.newMenu.add(this.selAll);
            this.close.setToolTipText("close this circuit");
            this.close.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            this.newMenu.add(this.close);
            this.undo.setToolTipText("undo last modification");
            this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
            this.newMenu.add(this.undo);
            this.redo.setToolTipText("redo last undo");
            this.redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
            this.newMenu.add(this.redo);
            this.makeElements();
            this.newMenu.add(this.elements);
            this.probe.addActionListener(this);
            this.watch.addActionListener(this);
            this.modify.addActionListener(this);
            this.timing.addActionListener(this);
            this.view.addActionListener(this);
            this.cut.addActionListener(this);
            this.copy.addActionListener(this);
            this.delete.addActionListener(this);
            this.lock.addActionListener(this);
            this.undo.addActionListener(this);
            this.redo.addActionListener(this);
            this.paste.addActionListener(this);
            this.selAll.addActionListener(this);
            this.close.addActionListener(this);
            this.connect.addActionListener(this);
            this.Crotate.addActionListener(this);
            this.CCrotate.addActionListener(this);
            this.flip.addActionListener(this);
            this.matchJump.addActionListener(this);
            AbstractAction ctrlw = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    if (EditWindow.this.selected.size() == 0 && EditWindow.this.currentState == State.idle) {
                        Point p = EditWindow.this.getMousePosition();
                        if (p == null) {
                            return;
                        }
                        EditWindow.this.setState(State.startwire);
                        EditWindow.this.wireEnd = new WireEnd(((EditWindow)EditWindow.this).SimpleEditor.this.circuit);
                        EditWindow.this.x = p.x;
                        EditWindow.this.y = p.y;
                        EditWindow.this.wireEnd.setXY(EditWindow.this.x, EditWindow.this.y);
                        EditWindow.this.wireEnd.init(((EditWindow)EditWindow.this).SimpleEditor.this.circuit);
                        ((EditWindow)EditWindow.this).SimpleEditor.this.circuit.addElement(EditWindow.this.wireEnd);
                        EditWindow.this.selected.add(EditWindow.this.wireEnd);
                        EditWindow.this.wire = null;
                        EditWindow.this.net = new WireNet();
                        EditWindow.this.net.add(EditWindow.this.wireEnd);
                        EditWindow.this.wireEnd.setNet(EditWindow.this.net);
                        EditWindow.this.repaint();
                    } else if (EditWindow.this.selected.size() == 1) {
                        Element el = (Element)EditWindow.this.selected.toArray()[0];
                        if (el.isUneditable()) {
                            return;
                        }
                        if (!el.canWatch()) {
                            return;
                        }
                        if (el.isWatched()) {
                            el.setWatched(false);
                        } else {
                            el.setWatched(true);
                        }
                        EditWindow.this.markChanged();
                        EditWindow.this.clearSelected();
                        EditWindow.this.setState(State.idle);
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(87, 2), "ctrlw");
            this.getActionMap().put("ctrlw", ctrlw);
            AbstractAction endWire = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    if (EditWindow.this.currentState == State.startwire || EditWindow.this.currentState == State.drawire) {
                        ((EditWindow)EditWindow.this).SimpleEditor.this.circuit.remove(EditWindow.this.wireEnd);
                        if (EditWindow.this.wire != null) {
                            ((EditWindow)EditWindow.this).SimpleEditor.this.circuit.remove(EditWindow.this.wire);
                            EditWindow.this.wire.getOtherEnd(EditWindow.this.wireEnd).remove(EditWindow.this.wire, ((EditWindow)EditWindow.this).SimpleEditor.this.circuit);
                            EditWindow.this.markChanged();
                        }
                        EditWindow.this.net.remove(EditWindow.this.wireEnd);
                        EditWindow.this.net.remove(EditWindow.this.wire);
                        EditWindow.this.removeCoLinear();
                        EditWindow.this.wireEnd = null;
                        EditWindow.this.wire = null;
                        EditWindow.this.prev = null;
                        EditWindow.this.clearSelected();
                        EditWindow.this.untouchAll();
                        EditWindow.this.setState(State.idle);
                        EditWindow.this.repaint();
                        return;
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "Escape");
            this.getActionMap().put("Escape", endWire);
            AbstractAction see = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    if (EditWindow.this.selected.size() != 1) {
                        return;
                    }
                    Element el = (Element)EditWindow.this.selected.toArray()[0];
                    el.showCurrentValue(new Point(EditWindow.this.x, EditWindow.this.y));
                    EditWindow.this.clearSelected();
                    EditWindow.this.setState(State.idle);
                    EditWindow.this.repaint();
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(83, 2), "view");
            this.getActionMap().put("view", see);
            AbstractAction modify = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    if (EditWindow.this.selected.size() != 1) {
                        return;
                    }
                    EditWindow.this.doModify();
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(77, 2), "modify");
            this.getActionMap().put("modify", modify);
            AbstractAction probe = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    if (EditWindow.this.selected.size() != 1) {
                        return;
                    }
                    Element el = (Element)EditWindow.this.selected.toArray()[0];
                    if (!(el instanceof Wire)) {
                        return;
                    }
                    EditWindow.this.doProbe();
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(80, 2), "probe");
            this.getActionMap().put("probe", probe);
            AbstractAction timing = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    if (EditWindow.this.selected.size() != 1) {
                        return;
                    }
                    Element el = (Element)EditWindow.this.selected.toArray()[0];
                    if (!el.hasTiming()) {
                        return;
                    }
                    EditWindow.this.doTiming();
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(84, 2), "timing");
            this.getActionMap().put("timing", timing);
            AbstractAction selectAll = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!this.enabled) {
                        return;
                    }
                    EditWindow.this.doSelectAll();
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(65, 2), "select all");
            this.getActionMap().put("select all", selectAll);
            AbstractAction closeWin = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    SimpleEditor.this.close();
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(69, 2), "close window");
            this.getActionMap().put("close window", closeWin);
            AbstractAction deleteKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        EditWindow.this.remove();
                        EditWindow.this.removeCoLinear();
                        EditWindow.this.clearSelected();
                        EditWindow.this.setState(State.idle);
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "do delete");
            this.getActionMap().put("do delete", deleteKey);
            AbstractAction cutKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        EditWindow.this.copy();
                        EditWindow.this.remove();
                        EditWindow.this.removeCoLinear();
                        EditWindow.this.clearSelected();
                        EditWindow.this.setState(State.idle);
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(88, 2), "do cut");
            this.getActionMap().put("do cut", cutKey);
            AbstractAction copyKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        EditWindow.this.copy();
                        EditWindow.this.clearSelected();
                        EditWindow.this.setState(State.idle);
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(67, 2), "do copy");
            this.getActionMap().put("do copy", copyKey);
            AbstractAction pasteKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        if (SimpleEditor.this.clipboard.getElements().size() == 0) {
                            return;
                        }
                        if (EditWindow.this.paste(SimpleEditor.this.clipboard)) {
                            EditWindow.this.setState(State.placing);
                        }
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(86, 2), "do paste");
            this.getActionMap().put("do paste", pasteKey);
            AbstractAction undoKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        EditWindow.this.undo();
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(90, 2), "do undo");
            this.getActionMap().put("do undo", undoKey);
            AbstractAction redoKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        EditWindow.this.redo();
                        EditWindow.this.repaint();
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(89, 2), "do redo");
            this.getActionMap().put("do redo", redoKey);
            AbstractAction lockKey = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (this.enabled) {
                        int opt = JOptionPane.showConfirmDialog(JLSInfo.frame, "Making elements uneditable cannot be undone.  Are you sure you want to do this?", "WARNING", 0, 2);
                        if (opt == 0) {
                            for (Element el : EditWindow.this.selected) {
                                el.makeUneditable();
                            }
                        }
                        EditWindow.this.clearSelected();
                        EditWindow.this.setState(State.idle);
                        EditWindow.this.repaint();
                        return;
                    }
                }
            };
            this.getInputMap().put(KeyStroke.getKeyStroke(76, 2), "do lock");
            this.getActionMap().put("do lock", lockKey);
        }

        public void makeElements() {
            this.toolbar = new JPanel();
            this.toolbar.setLayout(new BoxLayout(this.toolbar, 0));
            this.elements = new JMenu("elements");
            JPanel gates = new JPanel(new GridLayout(2, 4));
            ImageIcon image = this.getImage("and");
            String text = image == null ? "AND" : "";
            AbstractAction act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new AndGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "AND gate"));
            image = this.getImage("or");
            text = image == null ? "OR" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new OrGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "OR gate"));
            image = this.getImage("not");
            text = image == null ? "NOT" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new NotGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "NOT gate"));
            image = this.getImage("xor");
            text = image == null ? "XOR" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new XorGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "exclusive OR gate"));
            image = this.getImage("nand");
            text = image == null ? "NAND" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new NandGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "NAND gate"));
            image = this.getImage("nor");
            text = image == null ? "NOR" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new NorGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "NOR gate"));
            image = this.getImage("delay");
            text = image == null ? "DELAY" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new DelayGate(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "user defined signal delay"));
            image = this.getImage("tristate");
            text = image == null ? "TriState" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new TriState(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            gates.add(this.makeElement(act, "tri-state gate"));
            this.toolbar.add(gates);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel wireWorks = new JPanel(new GridLayout(2, 4));
            image = this.getImage("jumpstart");
            text = image == null ? "START" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new JumpStart(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "name a wire"));
            image = this.getImage("jumpend");
            text = image == null ? "END" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new JumpEnd(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "connect to a named wire"));
            image = this.getImage("ipin");
            text = image == null ? "I-PIN" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new InputPin(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "input pin"));
            image = this.getImage("opin");
            text = image == null ? "O-PIN" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new OutputPin(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "output pin"));
            image = this.getImage("split");
            text = image == null ? "SPLIT" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Splitter(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "unbundle wires"));
            image = this.getImage("bind");
            text = image == null ? "BIND" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Binder(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "bundle wires"));
            image = this.getImage("const");
            text = image == null ? "CONST" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Constant(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "constant value"));
            image = this.getImage("extend");
            text = image == null ? "1-to-N" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Extend(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            wireWorks.add(this.makeElement(act, "make N copies of the input"));
            this.toolbar.add(wireWorks);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel mem = new JPanel(new GridLayout(2, 1));
            image = this.getImage("register");
            text = image == null ? "REG" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Register(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            mem.add(this.makeElement(act, "register (various triggering)"));
            image = this.getImage("memory");
            text = image == null ? "MEMORY" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Memory(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            mem.add(this.makeElement(act, "memory, various types"));
            this.toolbar.add(mem);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel comb = new JPanel(new GridLayout(2, 2));
            image = this.getImage("mux");
            text = image == null ? "MUX" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Mux(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            comb.add(this.makeElement(act, "multiplexor"));
            image = this.getImage("decoder");
            text = image == null ? "DEC" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Decoder(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            comb.add(this.makeElement(act, "decoder"));
            image = this.getImage("adder");
            text = image == null ? "ADDER" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Adder(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            comb.add(this.makeElement(act, "adder"));
            image = this.getImage("clock");
            text = image == null ? "CLOCK" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Clock(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            comb.add(this.makeElement(act, "clock"));
            this.toolbar.add(comb);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel time = new JPanel(new GridLayout(2, 1));
            image = this.getImage("pause");
            text = image == null ? "PAUSE" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Pause(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            time.add(this.makeElement(act, "pause simulator when asserted"));
            image = this.getImage("stop");
            text = image == null ? "STOP" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Stop(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            time.add(this.makeElement(act, "stop simulator when asserted"));
            this.toolbar.add(time);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel test = new JPanel(new GridLayout(2, 1));
            image = this.getImage("siggen");
            text = image == null ? "SIGGEN" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new SigGen(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            test.add(this.makeElement(act, "generate test signals"));
            image = this.getImage("display");
            text = image == null ? "DISPLAY" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Display(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            test.add(this.makeElement(act, "display circuit value"));
            this.toolbar.add(test);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            JPanel complex = new JPanel(new GridLayout(2, 1));
            image = this.getImage("statemachine");
            text = image == null ? "ST. MAC." : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new StateMachine(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            complex.add(this.makeElement(act, "state machine"));
            image = this.getImage("truth");
            text = image == null ? "Truth Table" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new TruthTable(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            complex.add(this.makeElement(act, "truth table"));
            this.toolbar.add(complex);
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            image = this.getImage("text");
            text = image == null ? "TEXT" : "";
            act = new AbstractAction(text, image){

                @Override
                public void actionPerformed(ActionEvent event) {
                    EditWindow.this.setup(new Text(((EditWindow)EditWindow.this).SimpleEditor.this.circuit), event.getSource() instanceof JButton);
                }
            };
            this.toolbar.add(this.makeElement(act, "text (for annotations)"));
            this.toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
            final JButton imp = new JButton("Import", this.getImage("down"));
            imp.setToolTipText("import an open subcircuit");
            imp.setBackground(Color.WHITE);
            imp.setHorizontalTextPosition(10);
            this.toolbar.add(imp);
            imp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (SimpleEditor.this.importMenu.getComponentCount() > 0) {
                        Dimension d = imp.getSize();
                        SimpleEditor.this.importMenu.show(imp, 0, d.height);
                        SimpleEditor.this.importMenu.setVisible(true);
                    }
                }
            });
        }

        public ImageIcon getImage(String name) {
            URL image = this.getClass().getResource("images/" + name + ".gif");
            return new ImageIcon(image);
        }

        public JButton makeElement(Action action, String tip) {
            JButton button = new JButton(action);
            button.setMinimumSize(new Dimension(32, 232));
            button.setPreferredSize(new Dimension(32, 32));
            JMenuItem item = new JMenuItem(action);
            button.setToolTipText(tip);
            button.setBackground(Color.WHITE);
            item.setToolTipText(tip);
            this.elements.add(item);
            return button;
        }

        public JPanel getToolBar() {
            return this.toolbar;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D gg = (Graphics2D)g;
            gg.setColor(JLSInfo.gridColor);
            Dimension size = this.getSize();
            int r = 0;
            while (r < size.height) {
                gg.drawLine(0, r, size.width, r);
                r += 12;
            }
            int c = 0;
            while (c < size.width) {
                gg.drawLine(c, 0, c, size.height);
                c += 12;
            }
            if (this.currentState == State.selected) {
                gg.setColor(JLSInfo.selectionColor);
                gg.fill(this.selRect);
            }
            SimpleEditor.this.circuit.draw(g, this.selected, SimpleEditor.this.me);
            if (this.currentState == State.selecting) {
                gg.setColor(Color.lightGray);
                if (this.selRect != null) {
                    gg.draw(this.selRect);
                }
            }
            if (this.firstDraw) {
                this.pushCopy();
                this.firstDraw = false;
                this.graphics = g;
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Element el;
            SimpleEditor.this.info.setForeground(Color.BLACK);
            SimpleEditor.this.info.setText("");
            if (event.getSource() == this.probe) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.doProbe();
            }
            if (event.getSource() == this.watch) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                Element el2 = (Element)this.selected.toArray()[0];
                if (el2.isUneditable()) {
                    return;
                }
                if (el2.isWatched()) {
                    el2.setWatched(false);
                } else {
                    el2.setWatched(true);
                }
                this.markChanged();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (event.getSource() == this.modify) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.doModify();
            }
            if (event.getSource() == this.timing) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.doTiming();
            }
            if (event.getSource() == this.view) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                Element el3 = (Element)this.selected.toArray()[0];
                el3.showCurrentValue(new Point(this.x, this.y));
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (event.getSource() == this.cut) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.copy();
                this.remove();
                this.removeCoLinear();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (event.getSource() == this.copy) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.copy();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (event.getSource() == this.delete) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.remove();
                this.removeCoLinear();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (event.getSource() == this.lock) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                int opt = JOptionPane.showConfirmDialog(JLSInfo.frame, "Making elements uneditable cannot be undone.  Are you sure you want to do this?", "WARNING", 0, 2);
                if (opt == 0) {
                    for (Element el4 : this.selected) {
                        el4.makeUneditable();
                    }
                }
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (event.getSource() == this.paste) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                if (SimpleEditor.this.clipboard.getElements().size() == 0) {
                    return;
                }
                if (this.paste(SimpleEditor.this.clipboard)) {
                    this.setState(State.placing);
                }
                this.repaint();
                return;
            }
            if (event.getSource() == this.selAll) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.doSelectAll();
            }
            if (event.getSource() == this.close) {
                SimpleEditor.this.close();
            }
            if (event.getSource() == this.undo) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.undo();
                this.repaint();
            }
            if (event.getSource() == this.redo) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.redo();
            }
            if (event.getSource() == this.Crotate) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                el = (Element)this.selected.toArray()[0];
                el.rotate(JLSInfo.Orientation.RIGHT, this.getGraphics());
                this.markChanged();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
            }
            if (event.getSource() == this.CCrotate) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                el = (Element)this.selected.toArray()[0];
                el.rotate(JLSInfo.Orientation.LEFT, this.getGraphics());
                this.markChanged();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
            }
            if (event.getSource() == this.matchJump) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                el = (JumpStart)this.selected.toArray()[0];
                JumpEnd nel = new JumpEnd(SimpleEditor.this.circuit, ((JumpStart)el).getName());
                Point p = this.getMousePosition();
                if (p == null) {
                    p = MouseInfo.getPointerInfo().getLocation();
                    p.x -= this.getLocationOnScreen().x;
                    p.y -= this.getLocationOnScreen().y;
                }
                this.x = p.x;
                this.y = p.y;
                nel.setup(this.graphics, this, p.x, p.y);
                this.clearSelected();
                SimpleEditor.this.circuit.addElement(nel);
                nel.setHighlight(true);
                this.selected.add(nel);
                this.setState(State.chosen);
                this.markChanged();
                this.repaint();
            }
            if (event.getSource() == this.flip) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                el = (Element)this.selected.toArray()[0];
                el.flip(this.getGraphics());
                this.markChanged();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
            } else if (event.getSource() == this.connect) {
                if (!SimpleEditor.this.enabled) {
                    return;
                }
                this.setState(State.startwire);
                this.wireEnd = new WireEnd(SimpleEditor.this.circuit);
                this.wireEnd.setXY(this.x, this.y);
                this.wireEnd.init(SimpleEditor.this.circuit);
                SimpleEditor.this.circuit.addElement(this.wireEnd);
                this.selected.add(this.wireEnd);
                this.wire = null;
                this.net = new WireNet();
                this.net.add(this.wireEnd);
                this.wireEnd.setNet(this.net);
                this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            boolean rightButton;
            if (!SimpleEditor.this.enabled) {
                return;
            }
            SimpleEditor.this.info.setForeground(Color.BLACK);
            SimpleEditor.this.info.setText("");
            this.x = event.getX();
            this.y = event.getY();
            boolean leftButton = event.getButton() == 1;
            boolean bl = rightButton = event.getButton() == 3 || event.isPopupTrigger();
            if (this.currentState == State.idle) {
                if (leftButton) {
                    for (Element el : SimpleEditor.this.circuit.getElements()) {
                        if (!el.contains(this.x, this.y)) continue;
                        if (!SimpleEditor.this.enabled) {
                            return;
                        }
                        if (el instanceof Wire) {
                            WireEnd end2;
                            Wire wire = (Wire)el;
                            WireEnd end1 = wire.getEnd();
                            if (end1.isAttached() || (end2 = wire.getOtherEnd(end1)).isAttached()) continue;
                            this.selected.add(end1);
                            this.selected.add(end2);
                            end1.setHighlight(true);
                            end2.setHighlight(true);
                            end1.savePosition();
                            end2.savePosition();
                            this.setState(State.moving);
                            return;
                        }
                        if (el instanceof WireEnd && ((WireEnd)el).isAttached()) continue;
                        this.selected.add(el);
                        el.setHighlight(true);
                        el.savePosition();
                        this.setState(State.moving);
                        return;
                    }
                    this.selRect = new Rectangle(this.x, this.y, 0, 0);
                    this.clearSelected();
                    this.setState(State.selecting);
                } else if (rightButton) {
                    for (Element el : SimpleEditor.this.circuit.getElements()) {
                        if (!el.contains(this.x, this.y) || el instanceof WireEnd && ((WireEnd)el).isAttached()) continue;
                        this.makeOptionMenu(el);
                        if (!el.isUneditable()) {
                            this.optionMenu.add(this.cut);
                            this.optionMenu.add(this.copy);
                            this.optionMenu.add(this.delete);
                            this.optionMenu.add(this.lock);
                        }
                        if (this.optionMenu.getComponentCount() > 0) {
                            this.setState(State.option);
                            this.selected.add(el);
                            el.setHighlight(true);
                            this.optionMenu.show(this, this.x, this.y);
                        }
                        return;
                    }
                    this.newMenu.show(this, this.x, this.y);
                }
                return;
            }
            if (this.currentState == State.option) {
                this.setState(State.idle);
                for (Element el : this.selected) {
                    el.setHighlight(false);
                }
                this.clearSelected();
                this.repaint();
                this.mousePressed(event);
                return;
            }
            if (this.currentState == State.selected) {
                if (this.selRect.contains(this.x, this.y)) {
                    if (leftButton) {
                        if (!SimpleEditor.this.enabled) {
                            return;
                        }
                        for (Element sel : this.selected) {
                            sel.savePosition();
                        }
                        this.setState(State.moving);
                    } else if (rightButton) {
                        this.optionMenu.removeAll();
                        if (this.selected.size() == 1) {
                            Element el = (Element)this.selected.toArray()[0];
                            this.makeOptionMenu(el);
                        }
                        boolean canEdit = true;
                        for (Element el : this.selected) {
                            if (!el.isUneditable()) continue;
                            canEdit = false;
                        }
                        if (canEdit) {
                            this.optionMenu.add(this.cut);
                            this.optionMenu.add(this.copy);
                            this.optionMenu.add(this.delete);
                            this.optionMenu.add(this.lock);
                        }
                        if (this.optionMenu.getComponentCount() > 0) {
                            this.setState(State.option);
                            this.selRect = null;
                            this.repaint();
                            this.optionMenu.show(this, this.x, this.y);
                        }
                    }
                    return;
                }
                this.setState(State.idle);
                for (Element el : this.selected) {
                    el.setHighlight(false);
                }
                this.clearSelected();
                this.selRect = null;
                this.repaint();
                return;
            }
            if (this.currentState == State.placing) {
                if (rightButton) {
                    for (Element el : this.selected) {
                        el.remove(SimpleEditor.this.circuit);
                    }
                    this.setState(State.idle);
                    this.clearSelected();
                    this.untouchAll();
                    this.repaint();
                    return;
                }
                if (this.overlap()) {
                    return;
                }
                for (Element el : this.selected) {
                    el.fixPosition();
                }
                this.connect();
                this.markChanged();
                this.setState(State.idle);
                this.clearSelected();
                this.repaint();
                return;
            }
            if (this.currentState == State.startwire || this.currentState == State.drawire) {
                if (rightButton) {
                    SimpleEditor.this.circuit.remove(this.wireEnd);
                    if (this.wire != null) {
                        SimpleEditor.this.circuit.remove(this.wire);
                        this.wire.getOtherEnd(this.wireEnd).remove(this.wire, SimpleEditor.this.circuit);
                        this.markChanged();
                    }
                    this.net.remove(this.wireEnd);
                    this.net.remove(this.wire);
                    this.removeCoLinear();
                    this.wireEnd = null;
                    this.wire = null;
                    this.prev = null;
                    this.clearSelected();
                    this.untouchAll();
                    this.setState(State.idle);
                    this.repaint();
                    return;
                }
                if (this.overlap()) {
                    return;
                }
                this.wireEnd.fixPosition();
                this.connect();
                if (this.currentState == State.drawire && this.wireEnd.isAttached()) {
                    if (this.wireEnd.getPut().getElement() == null) {
                        this.wireEnd.setPut(null);
                    }
                    this.wireEnd = null;
                    this.wire = null;
                    this.prev = null;
                    this.clearSelected();
                    this.setState(State.idle);
                    this.markChanged();
                    this.repaint();
                    return;
                }
                if (this.currentState == State.startwire && this.wireEnd.isAttached() && this.wireEnd.getPut().getElement() == null) {
                    this.wireEnd.setPut(null);
                }
                this.prev = this.wireEnd;
                WireEnd save = this.wireEnd;
                this.wireEnd = new WireEnd(SimpleEditor.this.circuit);
                this.wireEnd.setXY(this.x, this.y);
                this.wireEnd.init(SimpleEditor.this.circuit);
                SimpleEditor.this.circuit.addElement(this.wireEnd);
                this.wire = new Wire(save, this.wireEnd);
                save.addWire(this.wire);
                this.wireEnd.addWire(this.wire);
                SimpleEditor.this.circuit.addElement(this.wire);
                this.net.add(this.wireEnd);
                this.wireEnd.setNet(this.net);
                this.net.add(this.wire);
                this.wire.setNet(this.net);
                this.clearSelected();
                this.selected.add(this.wireEnd);
                this.selected.add(this.wire);
                this.setState(State.drawire);
                this.repaint();
                return;
            }
        }

        private void makeOptionMenu(Element el) {
            this.optionMenu.removeAll();
            if (el.quickChange() && !el.isUneditable()) {
                this.optionMenu.add(el.setupQuickMenu(SimpleEditor.this.me));
            }
            if (el.canChange() && !el.isUneditable()) {
                this.optionMenu.add(this.modify);
            }
            if (el.hasTiming() && !el.isUneditable()) {
                this.optionMenu.add(this.timing);
            }
            if (el.canWatch()) {
                if (!el.isUneditable()) {
                    if (el.isWatched()) {
                        this.watch.setText("Un-watch Element");
                    } else {
                        this.watch.setText("Watch Element");
                    }
                    this.optionMenu.add(this.watch);
                }
                this.optionMenu.add(this.view);
            }
            if (el.canRotate() && !el.isUneditable()) {
                this.optionMenu.add(this.Crotate);
                this.optionMenu.add(this.CCrotate);
            }
            if (el.canFlip() && !el.isUneditable()) {
                this.optionMenu.add(this.flip);
            }
            if (el instanceof JumpStart && !el.isUneditable()) {
                this.optionMenu.add(this.matchJump);
            }
            if (el instanceof Wire) {
                Wire wire = (Wire)el;
                if (wire.hasProbe()) {
                    this.probe.setText("Remove Probe");
                } else {
                    this.probe.setText("Attach Probe");
                }
                this.optionMenu.add(this.probe);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            boolean rightButton;
            if (!SimpleEditor.this.enabled) {
                return;
            }
            boolean bl = rightButton = event.getButton() == 3 || event.isPopupTrigger();
            if (this.currentState == State.idle && rightButton) {
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    if (!el.contains(this.x, this.y) || el instanceof WireEnd && ((WireEnd)el).isAttached()) continue;
                    this.makeOptionMenu(el);
                    if (!el.isUneditable()) {
                        this.optionMenu.add(this.cut);
                        this.optionMenu.add(this.copy);
                        this.optionMenu.add(this.delete);
                        this.optionMenu.add(this.lock);
                    }
                    if (this.optionMenu.getComponentCount() > 0) {
                        this.setState(State.option);
                        this.selected.add(el);
                        el.setHighlight(true);
                        this.optionMenu.show(this, this.x, this.y);
                    }
                    return;
                }
                this.newMenu.show(this, this.x, this.y);
                return;
            }
            SimpleEditor.this.info.setForeground(Color.BLACK);
            SimpleEditor.this.info.setText("");
            if (this.currentState == State.moving) {
                if (this.overlap()) {
                    for (Element sel : this.selected) {
                        sel.restorePosition();
                    }
                } else {
                    for (Element el : this.selected) {
                        el.fixPosition();
                    }
                    this.connect();
                    for (Element el : this.selected) {
                        WireEnd end;
                        if (!(el instanceof WireEnd) || !(end = (WireEnd)el).isAttached() || end.getPut().getElement() != null) continue;
                        end.setPut(null);
                    }
                    this.markChanged();
                }
                for (Element el : this.selected) {
                    el.setHighlight(false);
                }
                this.removeCoLinear();
                this.clearSelected();
                this.setState(State.idle);
                this.repaint();
                return;
            }
            if (this.currentState == State.selecting) {
                if (this.selected.size() > 0) {
                    this.selRect = null;
                    for (Element el : this.selected) {
                        if (el.getRect().equals(new Rectangle())) continue;
                        if (this.selRect == null) {
                            this.selRect = new Rectangle(el.getRect());
                            continue;
                        }
                        this.selRect.add(el.getRect());
                    }
                    if (this.selRect != null) {
                        this.setState(State.selected);
                    } else {
                        this.setState(State.idle);
                    }
                } else {
                    this.clearSelected();
                    this.setState(State.idle);
                    this.selRect = null;
                }
                this.repaint();
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (!SimpleEditor.this.enabled) {
                return;
            }
            SimpleEditor.this.info.setForeground(Color.BLACK);
            SimpleEditor.this.info.setText("");
            int nx = event.getX();
            int ny = event.getY();
            if (this.currentState == State.moving) {
                for (Element el : this.selected) {
                    el.move(nx - this.x, ny - this.y);
                }
                this.x = nx;
                this.y = ny;
                if (this.overlap()) {
                    SimpleEditor.this.info.setText(this.overlapMessage);
                    SimpleEditor.this.info.setForeground(Color.red);
                } else {
                    SimpleEditor.this.info.setText("");
                    SimpleEditor.this.info.setForeground(Color.black);
                }
                this.repaint();
                return;
            }
            if (this.currentState == State.selecting) {
                int xc = Math.min(this.x, nx);
                int yc = Math.min(this.y, ny);
                int width = Math.abs(nx - this.x);
                int height = Math.abs(ny - this.y);
                this.selRect = new Rectangle(xc, yc, width, height);
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    if (el.isInside(this.selRect)) {
                        if (el instanceof WireEnd && ((WireEnd)el).isAttached()) continue;
                        el.setHighlight(true);
                        this.selected.add(el);
                        continue;
                    }
                    el.setHighlight(false);
                    this.selected.remove(el);
                }
                this.repaint();
                return;
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!SimpleEditor.this.enabled) {
                return;
            }
            SimpleEditor.this.info.setForeground(Color.BLACK);
            SimpleEditor.this.info.setText("");
            int nx = event.getX();
            int ny = event.getY();
            SimpleEditor.this.info.setText(" ");
            if (this.currentState == State.idle) {
                this.selected.clear();
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    if (el.contains(nx, ny)) {
                        if (el instanceof WireEnd && ((WireEnd)el).isAttached()) continue;
                        this.selected.add(el);
                        el.setHighlight(true);
                        el.showInfo(SimpleEditor.this.info);
                        continue;
                    }
                    el.setHighlight(false);
                }
                this.repaint();
                return;
            }
            if (this.currentState == State.chosen) {
                Element item = (Element)this.selected.toArray()[0];
                Point p = this.getMousePosition();
                if (p == null) {
                    p = MouseInfo.getPointerInfo().getLocation();
                    p.x -= this.getLocationOnScreen().x;
                    p.y -= this.getLocationOnScreen().y;
                }
                this.x = p.x;
                this.y = p.y;
                item.setXY(p.x, p.y);
                item.savePosition();
                this.setState(State.placing);
                this.repaint();
                return;
            }
            if (this.currentState == State.placing || this.currentState == State.startwire || this.currentState == State.drawire) {
                for (Element el : this.selected) {
                    if (this.x == 0) continue;
                    el.move(nx - this.x, ny - this.y);
                }
                this.x = nx;
                this.y = ny;
                if (this.overlap()) {
                    if (this.currentState != State.drawire || this.prev == null || this.prev.getX() != this.wireEnd.getX() || this.prev.getY() != this.wireEnd.getY()) {
                        SimpleEditor.this.info.setText(this.overlapMessage);
                        SimpleEditor.this.info.setForeground(Color.red);
                    }
                } else {
                    this.prev = null;
                    SimpleEditor.this.info.setText("");
                    SimpleEditor.this.info.setForeground(Color.black);
                }
                this.repaint();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            this.requestFocusInWindow(true);
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (this.currentState == State.idle) {
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    el.setHighlight(false);
                    this.repaint();
                }
            }
        }

        private void setState(State newState) {
            this.currentState = newState;
            switch (this.currentState) {
                case idle: {
                    SimpleEditor.this.message.setText(" ");
                    SimpleEditor.this.message.setBackground(Color.CYAN);
                    break;
                }
                case chosen: 
                case placing: {
                    SimpleEditor.this.message.setText("left click to place, right click to cancel");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                    break;
                }
                case moving: {
                    SimpleEditor.this.message.setText("moving element(s)");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                    break;
                }
                case selecting: {
                    SimpleEditor.this.message.setText("selecting element(s)");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                    break;
                }
                case selected: {
                    SimpleEditor.this.message.setText("element(s) selected");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                    break;
                }
                case option: {
                    SimpleEditor.this.message.setText("pick option for selected element(s)");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                    break;
                }
                case startwire: {
                    SimpleEditor.this.message.setText("pick start end of wire");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                    break;
                }
                case drawire: {
                    SimpleEditor.this.message.setText("pick next end of wire, right click to end");
                    SimpleEditor.this.message.setBackground(Color.yellow);
                }
            }
        }

        private boolean canConnect(WireEnd end1, WireEnd end2) {
            if (!end1.isDangling() && !end2.isDangling()) {
                this.overlapMessage = "One end must dangle";
                return false;
            }
            if (end1.getNet() == end2.getNet()) {
                this.overlapMessage = "Can't make a wire loop";
                return false;
            }
            if (end1.getNet().netOverlap(end2.getNet())) {
                this.overlapMessage = "Can't make a wire loop";
                return false;
            }
            int bits1 = end1.getBits();
            int bits2 = end2.getBits();
            if (bits1 > 0 && bits2 > 0 && bits1 != bits2) {
                this.overlapMessage = "Bits don't match";
                return false;
            }
            if (end1.getNet().hasInput() && end2.getNet().hasInput()) {
                if (end1.isTriState() && end2.isTriState()) {
                    return true;
                }
                this.overlapMessage = "Both wires have inputs";
                return false;
            }
            return true;
        }

        private WireEnd connect(WireEnd end1, WireEnd end2) {
            WireNet net1 = end1.getNet();
            WireNet net2 = end2.getNet();
            int bits = Math.max(end1.getBits(), end2.getBits());
            net1.setBits(bits);
            net2.setBits(bits);
            if (net1.hasInput() || net2.hasInput()) {
                net1.setInput();
                net2.setInput();
            }
            if (net1.isTriState() || net2.isTriState()) {
                net1.setTriState(true);
                net2.setTriState(true);
            }
            if (end1.isDangling()) {
                WireEnd tempe = end1;
                end1 = end2;
                end2 = tempe;
                WireNet tempn = net1;
                net1 = net2;
                net2 = tempn;
            }
            this.subs.add(end2);
            net2.remove(end2);
            Wire wire = end2.getOnlyWire();
            if (wire == null) {
                return end1;
            }
            WireEnd otherEnd = wire.getOtherEnd(end2);
            wire.setEnds(end1, otherEnd);
            end1.addWire(wire);
            net1.absorb(net2);
            end2.setPut(new Input(null, null, 0, 0, 0));
            return end1;
        }

        public boolean canConnect(WireEnd end1, Wire wire) {
            WireEnd end2 = wire.getEnd();
            if (!end1.isDangling()) {
                this.overlapMessage = "Wire end must dangle";
                return false;
            }
            if (end2.getNet().netOverlap(end1.getNet())) {
                this.overlapMessage = "Can't make a wire loop";
                return false;
            }
            int count = 0;
            for (Element el : this.selected) {
                WireEnd end;
                if (!(el instanceof WireEnd) || !wire.contains((end = (WireEnd)el).getX(), end.getY())) continue;
                ++count;
            }
            if (count > 1) {
                this.overlapMessage = "Multiple connects to same wire not implemented";
                return false;
            }
            int bits1 = end1.getBits();
            int bits2 = end2.getBits();
            if (bits1 > 0 && bits2 > 0 && bits1 != bits2) {
                this.overlapMessage = "Bits don't match";
                return false;
            }
            if (end1.getNet().hasInput() && end2.getNet().hasInput()) {
                if (end1.isTriState() && end2.isTriState()) {
                    return true;
                }
                this.overlapMessage = "Both wires have inputs";
                return false;
            }
            return true;
        }

        public WireEnd connect(WireEnd end, Wire wire) {
            WireEnd end1 = wire.getEnd();
            WireEnd end2 = wire.getOtherEnd(end1);
            WireNet net1 = end.getNet();
            WireNet net2 = end1.getNet();
            int bits = Math.max(end.getBits(), end1.getBits());
            net1.setBits(bits);
            if (net1.hasInput() || net2.hasInput()) {
                net1.setInput();
            }
            if (net1.isTriState() || net2.isTriState()) {
                net1.setTriState(true);
            }
            Wire wire1 = new Wire(end1, end);
            end1.addWire(wire1);
            end.addWire(wire1);
            wire1.setNet(net1);
            net1.add(wire1);
            this.adds.add(wire1);
            Wire wire2 = new Wire(end2, end);
            end2.addWire(wire2);
            end.addWire(wire2);
            wire2.setNet(net1);
            net1.add(wire2);
            this.adds.add(wire2);
            end1.remove(wire);
            end2.remove(wire);
            net2.remove(wire);
            this.subs.add(wire);
            net1.absorb(net2);
            end.setPut(new Input(null, null, 0, 0, 0));
            return end;
        }

        private boolean canConnect(WireEnd end, Put put) {
            Output out;
            if (!end.isDangling()) {
                this.overlapMessage = "Must be a wire end";
                return false;
            }
            if (put.isAttached()) {
                this.overlapMessage = "Input/output already attached";
                return false;
            }
            int wireBits = end.getBits();
            int putBits = put.getBits();
            if (wireBits > 0 && putBits > 0 && wireBits != putBits) {
                this.overlapMessage = "Bits don't match";
                return false;
            }
            if (put instanceof Output && end.getNet().hasInput() && (!(out = (Output)put).isTriState() || !end.isTriState())) {
                this.overlapMessage = "Wire already has an input";
                return false;
            }
            if (put.getElement() instanceof Binder && put instanceof Input) {
                boolean tri = false;
                boolean norm = false;
                for (Put p : put.getElement().getAllPuts()) {
                    if (!(p instanceof Input) || !p.isAttached()) continue;
                    if (p.getWireEnd().isTriState()) {
                        tri = true;
                        continue;
                    }
                    norm = true;
                }
                if (end.isTriState()) {
                    tri = true;
                } else {
                    norm = true;
                }
                if (tri && norm) {
                    this.overlapMessage = "Cannot connect both tri-state and normal wires to a bundle";
                    return false;
                }
            }
            int regCount = 0;
            int triCount = 0;
            for (WireEnd otherEnd : end.getNet().getAllEnds()) {
                if (end == otherEnd) continue;
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    Put p = el.getPut(otherEnd.getX(), otherEnd.getY());
                    if (p == null || !(p instanceof Output)) continue;
                    Output out2 = (Output)p;
                    if (out2.isTriState()) {
                        ++triCount;
                        continue;
                    }
                    ++regCount;
                }
            }
            if (regCount != 0 && (regCount != 1 || triCount != 0)) {
                this.overlapMessage = "Wire will have multiple inputs";
                return false;
            }
            return true;
        }

        private void connect(WireEnd end, Put put) {
            put.setAttached(end);
            end.setPut(put);
            WireNet net = end.getNet();
            if (net.getBits() == 0) {
                net.setBits(put.getBits());
            }
            if (put instanceof Output) {
                net.setInput();
                Output out = (Output)put;
                if (out.isTriState()) {
                    net.setTriState(true);
                }
            } else if (put instanceof Input && net.isTriState() && put.getElement() instanceof TriProp) {
                TriProp pin = (TriProp)((Object)put.getElement());
                pin.setTriState(true);
            }
        }

        private boolean canConnect(Put p1, Put p2) {
            if (p1.isAttached() || p2.isAttached()) {
                this.overlapMessage = "Input/output already attached";
                return false;
            }
            int b1 = p1.getBits();
            int b2 = p2.getBits();
            if (b1 > 0 && b2 > 0 && b1 != b2) {
                this.overlapMessage = "Bits don't match";
                return false;
            }
            if (p1 instanceof Output && p2 instanceof Output) {
                Output out1 = (Output)p1;
                Output out2 = (Output)p2;
                if (!out1.isTriState() || !out2.isTriState()) {
                    this.overlapMessage = "Can't connect output to output";
                    return false;
                }
            }
            return true;
        }

        private void connect(Put p1, Put p2) {
            int x = p1.getX();
            int y = p1.getY();
            WireNet net = new WireNet();
            net.setBits(Math.max(p1.getBits(), p2.getBits()));
            net.setInput();
            WireEnd end1 = new WireEnd(SimpleEditor.this.circuit);
            end1.setXY(x, y);
            end1.init(SimpleEditor.this.circuit);
            end1.setPut(p1);
            end1.setNet(net);
            net.add(end1);
            WireEnd end2 = new WireEnd(SimpleEditor.this.circuit);
            end2.setXY(x, y);
            end1.init(SimpleEditor.this.circuit);
            end2.setPut(p2);
            end2.setNet(net);
            net.add(end2);
            Wire wire = new Wire(end1, end2);
            end1.addWire(wire);
            end2.addWire(wire);
            net.add(wire);
            wire.setNet(net);
            this.adds.add(wire);
            this.adds.add(end1);
            this.adds.add(end2);
            p1.setAttached(end1);
            p2.setAttached(end2);
            p1.getElement().fixPosition();
            p2.getElement().fixPosition();
            if (p1 instanceof Output && ((Output)p1).isTriState()) {
                net.setTriState(true);
            } else if (p2 instanceof Output && ((Output)p2).isTriState()) {
                net.setTriState(true);
            }
            if (net.isTriState() && p1.getElement() instanceof TriProp) {
                TriProp pin = (TriProp)((Object)p1.getElement());
                pin.setTriState(true);
            } else if (net.isTriState() && p2.getElement() instanceof TriProp) {
                TriProp pin = (TriProp)((Object)p2.getElement());
                pin.setTriState(true);
            }
        }

        private boolean overlap() {
            this.overlapMessage = "";
            this.untouchAll();
            for (Element sel : this.selected) {
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    WireEnd otherEnd;
                    Wire wire;
                    if (this.selected.contains(el)) continue;
                    if (sel.intersects(el)) {
                        boolean ok = false;
                        if (sel instanceof WireEnd) {
                            WireEnd end = (WireEnd)sel;
                            if (el instanceof WireEnd) {
                                WireEnd otherEnd2 = (WireEnd)el;
                                if (!this.canConnect(end, otherEnd2)) {
                                    this.untouchAll();
                                    return true;
                                }
                                end.setTouching(true);
                                otherEnd2.setTouching(true);
                                ok = true;
                            } else if (el instanceof Wire) {
                                wire = (Wire)el;
                                if (!this.canConnect(end, wire)) {
                                    this.untouchAll();
                                    return true;
                                }
                                end.setTouching(true);
                                wire.setTouching(true);
                                ok = true;
                            } else {
                                Wire onlyWire;
                                Put put = el.getPut(end.getX(), end.getY());
                                if (put == null) {
                                    this.overlapMessage = "overlap";
                                    this.untouchAll();
                                    return true;
                                }
                                WireEnd putEnd = put.getWireEnd();
                                if (end == putEnd) {
                                    ok = true;
                                    continue;
                                }
                                if (putEnd != null && (onlyWire = putEnd.getOnlyWire()).getOtherEnd(putEnd) == end) {
                                    ok = true;
                                    continue;
                                }
                                if (!this.canConnect(end, put)) {
                                    this.untouchAll();
                                    return true;
                                }
                                end.setTouching(true);
                                put.setTouching(true);
                                ok = true;
                            }
                        } else {
                            for (Put put : sel.getAllPuts()) {
                                if (!(el instanceof WireEnd)) continue;
                                WireEnd end = (WireEnd)el;
                                if (put.getX() != end.getX() || put.getY() != end.getY()) continue;
                                if (end == put.getWireEnd()) {
                                    ok = true;
                                    continue;
                                }
                                WireEnd putEnd = put.getWireEnd();
                                if (putEnd != null && putEnd.getOnlyWire().getOtherEnd(putEnd) == end) {
                                    ok = true;
                                    continue;
                                }
                                if (!this.canConnect(end, put)) {
                                    this.untouchAll();
                                    return true;
                                }
                                end.setTouching(true);
                                put.setTouching(true);
                                ok = true;
                            }
                        }
                        if (ok) continue;
                        this.overlapMessage = "overlap";
                        this.untouchAll();
                        return true;
                    }
                    if (sel instanceof WireEnd) {
                        WireEnd end = (WireEnd)sel;
                        for (Wire wire2 : end.getWires()) {
                            for (Element elm : SimpleEditor.this.circuit.getElements()) {
                                if (sel == elm || !(elm instanceof WireEnd) || !wire2.touches(otherEnd = (WireEnd)elm)) continue;
                                this.overlapMessage = "overlap";
                                this.untouchAll();
                                return true;
                            }
                        }
                    }
                    for (Put p : sel.getAllPuts()) {
                        if (!p.isAttached()) continue;
                        wire = p.getWireEnd().getOnlyWire();
                        for (Element elm : SimpleEditor.this.circuit.getElements()) {
                            if (sel == elm || !(elm instanceof WireEnd) || !wire.touches(otherEnd = (WireEnd)elm)) continue;
                            this.overlapMessage = "overlap";
                            this.untouchAll();
                            return true;
                        }
                    }
                    for (Put p1 : sel.getAllPuts()) {
                        for (Put p2 : el.getAllPuts()) {
                            if (p1.getX() != p2.getX() || p1.getY() != p2.getY()) continue;
                            WireEnd end1 = p1.getWireEnd();
                            WireEnd end2 = p2.getWireEnd();
                            if (end1 != null && end2 != null && end1.getOnlyWire().getOtherEnd(end1) == end2) continue;
                            if (!this.canConnect(p1, p2)) {
                                this.untouchAll();
                                return true;
                            }
                            p1.setTouching(true);
                            p2.setTouching(true);
                        }
                    }
                }
            }
            this.repaint();
            return false;
        }

        public void connect() {
            this.untouchAll();
            this.adds.clear();
            this.subs.clear();
            for (Element sel : this.selected) {
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    if (this.selected.contains(el)) continue;
                    if (sel.intersects(el)) {
                        boolean ok = false;
                        if (sel instanceof WireEnd) {
                            WireEnd end = (WireEnd)sel;
                            if (el instanceof WireEnd) {
                                WireEnd otherEnd = (WireEnd)el;
                                WireEnd endLeft = this.connect(end, otherEnd);
                                if (this.currentState == State.startwire) {
                                    this.wireEnd = endLeft;
                                    this.net = endLeft.getNet();
                                }
                                ok = true;
                            } else if (el instanceof Wire) {
                                Wire wire = (Wire)el;
                                WireEnd it = this.connect(end, wire);
                                if (this.currentState == State.startwire) {
                                    this.wireEnd = it;
                                    this.net = it.getNet();
                                }
                                ok = true;
                            } else {
                                Put put = el.getPut(end.getX(), end.getY());
                                if (end == put.getWireEnd()) {
                                    ok = true;
                                    continue;
                                }
                                WireEnd putEnd = put.getWireEnd();
                                if (putEnd != null && putEnd.getOnlyWire().getOtherEnd(putEnd) == end) {
                                    ok = true;
                                    continue;
                                }
                                this.connect(end, put);
                                ok = true;
                            }
                        } else {
                            for (Put put : sel.getAllPuts()) {
                                if (!(el instanceof WireEnd)) continue;
                                WireEnd end = (WireEnd)el;
                                if (put.getX() != end.getX() || put.getY() != end.getY()) continue;
                                if (end == put.getWireEnd()) {
                                    ok = true;
                                    continue;
                                }
                                WireEnd putEnd = put.getWireEnd();
                                if (putEnd != null && putEnd.getOnlyWire().getOtherEnd(putEnd) == end) {
                                    ok = true;
                                    continue;
                                }
                                this.connect(end, put);
                                ok = true;
                            }
                        }
                        if (ok) continue;
                        return;
                    }
                    for (Put p1 : sel.getAllPuts()) {
                        for (Put p2 : el.getAllPuts()) {
                            if (p1.getX() != p2.getX() || p1.getY() != p2.getY()) continue;
                            WireEnd end1 = p1.getWireEnd();
                            WireEnd end2 = p2.getWireEnd();
                            if (end1 != null && end2 != null && end1.getOnlyWire().getOtherEnd(end1) == end2) continue;
                            this.connect(p1, p2);
                        }
                    }
                }
            }
            for (Element el : this.adds) {
                SimpleEditor.this.circuit.addElement(el);
            }
            for (Element el : this.subs) {
                SimpleEditor.this.circuit.remove(el);
            }
        }

        private void untouchAll() {
            for (Element el : SimpleEditor.this.circuit.getElements()) {
                el.setTouching(false);
            }
        }

        private void copy() {
            SimpleEditor.this.clipboard.clear();
            Point min = Util.copy(this.selected, SimpleEditor.this.clipboard);
            for (Element el : SimpleEditor.this.clipboard.getElements()) {
                WireEnd end;
                el.setCircuit(SimpleEditor.this.clipboard);
                if (el instanceof Wire || el instanceof WireEnd && (end = (WireEnd)el).isAttached()) continue;
                el.move(-min.x, -min.y);
            }
        }

        private void remove() {
            for (Element el : this.selected) {
                if (!el.isUneditable()) continue;
                JOptionPane.showMessageDialog(JLSInfo.frame, "can't delete uneditable element");
                return;
            }
            for (Element el : this.selected) {
                el.remove(SimpleEditor.this.circuit);
            }
            this.markChanged();
        }

        private boolean paste(Circuit from) {
            Object name;
            for (Element el : from.getElements()) {
                Iterator<Element> name2;
                if (el instanceof JumpEnd || (name2 = el.getName()) == null || ((String)((Object)name2)).equals("") || !SimpleEditor.this.circuit.hasName((String)((Object)name2))) continue;
                SimpleEditor.this.info.setForeground(Color.red);
                SimpleEditor.this.info.setText("Paste will result in elements with duplicate names");
                return false;
            }
            HashSet<String> jsnames = new HashSet<String>();
            for (Element el : from.getElements()) {
                if (!(el instanceof JumpStart)) continue;
                name = el.getName();
                jsnames.add((String)name);
                if (SimpleEditor.this.circuit.getJumpStart((String)name) == null) continue;
                SimpleEditor.this.info.setForeground(Color.red);
                SimpleEditor.this.info.setText("Paste will result in duplicate named wires");
                return false;
            }
            for (Element el : from.getElements()) {
                if (!(el instanceof JumpEnd) || jsnames.contains(name = el.getName()) || SimpleEditor.this.circuit.getJumpStart((String)name) != null) continue;
                SimpleEditor.this.info.setForeground(Color.red);
                SimpleEditor.this.info.setText("Paste will result in wire end(s) with no source");
                return false;
            }
            for (Element el : from.getElements()) {
                name = el.getName();
                if (name == null || ((String)name).equals("")) continue;
                SimpleEditor.this.circuit.addName((String)name);
            }
            this.clearSelected();
            Point pos = this.getMousePosition();
            if (pos == null) {
                return false;
            }
            this.x = pos.x;
            this.y = pos.y;
            for (Element el : from.getElements()) {
                if (el instanceof Wire || el instanceof WireEnd) continue;
                Element cel = el.copy();
                cel.fixPosition();
                cel.move(this.x, this.y);
                SimpleEditor.this.circuit.addElement(cel);
                this.selected.add(cel);
                cel.setHighlight(true);
                if (!(cel instanceof JumpStart)) continue;
                JumpStart j = (JumpStart)cel;
                SimpleEditor.this.circuit.addJumpStart(j.getName(), j);
            }
            LinkedList<WireEnd> ends = new LinkedList<WireEnd>();
            for (Element el : from.getElements()) {
                if (!(el instanceof WireEnd)) continue;
                WireEnd oldEnd = (WireEnd)el;
                WireEnd newEnd = (WireEnd)el.copy();
                newEnd.fixPosition();
                newEnd.move(this.x, this.y);
                SimpleEditor.this.circuit.addElement(newEnd);
                ends.add(newEnd);
                if (oldEnd.isAttached()) {
                    Put newPut = oldEnd.getPut().getCopy();
                    newEnd.setPut(newPut);
                    newPut.setAttached(newEnd);
                    continue;
                }
                this.selected.add(newEnd);
                newEnd.setHighlight(true);
            }
            for (Element el : from.getElements()) {
                if (!(el instanceof Wire)) continue;
                Wire wire = (Wire)el;
                WireEnd end1 = wire.getEnd();
                WireEnd end2 = wire.getOtherEnd(end1);
                Wire newWire = new Wire(end1.getCopy(), end2.getCopy());
                end1.getCopy().addWire(newWire);
                end2.getCopy().addWire(newWire);
                SimpleEditor.this.circuit.addElement(newWire);
                this.selected.add(newWire);
            }
            Util.partition(SimpleEditor.this.circuit);
            for (Element el : SimpleEditor.this.circuit.getElements()) {
                el.setCircuit(SimpleEditor.this.circuit);
            }
            this.markChanged();
            return true;
        }

        private void clearSelected() {
            for (Element el : this.selected) {
                el.setHighlight(false);
            }
            this.selected.clear();
        }

        private void doSelectAll() {
            if (SimpleEditor.this.circuit.getElements().size() == 0) {
                return;
            }
            this.clearSelected();
            this.selRect = null;
            for (Element el : SimpleEditor.this.circuit.getElements()) {
                WireEnd end;
                if (el instanceof WireEnd && (end = (WireEnd)el).isAttached()) continue;
                this.selected.add(el);
                el.setHighlight(true);
                if (el instanceof Wire) continue;
                if (this.selRect == null) {
                    this.selRect = new Rectangle(el.getRect());
                    continue;
                }
                this.selRect.add(el.getRect());
            }
            if (this.selRect != null) {
                this.setState(State.selected);
            }
            this.repaint();
        }

        private void doModify() {
            Element el = (Element)this.selected.toArray()[0];
            if (el instanceof SubCircuit) {
                SubCircuit sub = (SubCircuit)el;
                Circuit subcirc = sub.getSubCircuit();
                String tabName = String.valueOf(sub.getName()) + " in " + SimpleEditor.this.circuit.getName();
                int e = 0;
                while (e < SimpleEditor.this.tabbedParent.getTabCount()) {
                    if (tabName.equals(SimpleEditor.this.tabbedParent.getTitleAt(e))) {
                        JOptionPane.showMessageDialog(this.getTopLevelAncestor(), String.valueOf(tabName) + " is already being editted", "Error", 0);
                        this.clearSelected();
                        this.setState(State.idle);
                        this.repaint();
                        return;
                    }
                    ++e;
                }
                subcirc.setImported(sub);
                Editor ed = new Editor(SimpleEditor.this.tabbedParent, subcirc, sub.getName(), SimpleEditor.this.clipboard);
                Dimension all = subcirc.getBounds().getSize();
                ed.setCircuitSize(all);
                subcirc.setEditor(ed);
                Component[] componentArray = SimpleEditor.this.tabbedParent.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Editor otherEditor;
                    Component edit = componentArray[n2];
                    if (edit instanceof Editor && !(otherEditor = (Editor)edit).getCircuit().isImported()) {
                        ed.addToImportMenu(otherEditor.getCircuit());
                    }
                    ++n2;
                }
                SimpleEditor.this.tabbedParent.add(tabName, ed);
                SimpleEditor.this.tabbedParent.setSelectedComponent(ed);
                SimpleEditor.this.enabled = false;
                SimpleEditor.this.editable.setText("editting is disabled while a subcircuit is being modified");
            } else {
                boolean mustReplace = el.change(this.getGraphics(), this, this.x, this.y);
                if (mustReplace) {
                    this.clearSelected();
                    this.selected.add(el);
                    el.setHighlight(true);
                    this.setState(State.placing);
                    this.repaint();
                    return;
                }
            }
            this.clearSelected();
            this.setState(State.idle);
            this.repaint();
        }

        private void doProbe() {
            Wire wire = (Wire)this.selected.toArray()[0];
            if (wire.hasProbe()) {
                wire.removeProbe();
            } else {
                wire.attachProbe(null);
            }
            this.markChanged();
            this.clearSelected();
            this.setState(State.idle);
            this.repaint();
        }

        private void doTiming() {
            Element el = (Element)this.selected.toArray()[0];
            el.changeTiming(this, this.x, this.y);
            this.clearSelected();
            this.setState(State.idle);
            this.repaint();
        }

        private void removeCoLinear() {
            HashSet<WireEnd> ends = new HashSet<WireEnd>();
            for (Element el : SimpleEditor.this.circuit.getElements()) {
                if (!(el instanceof WireEnd) || el.isUneditable()) continue;
                ends.add((WireEnd)el);
            }
            for (WireEnd end : ends) {
                if (end.degree() == 1) {
                    Object[] wires = end.getWires().toArray();
                    Wire wire = (Wire)wires[0];
                    WireEnd otherEnd = wire.getOtherEnd(end);
                    if (end.isAttached() || !otherEnd.isAttached() || !end.intersects(otherEnd)) continue;
                    wire.remove(SimpleEditor.this.circuit);
                    continue;
                }
                if (end.degree() != 2) continue;
                boolean colinear = false;
                Object[] wires = end.getWires().toArray();
                Wire wire0 = (Wire)wires[0];
                Wire wire1 = (Wire)wires[1];
                int x0 = wire0.getOtherEnd(end).getX();
                int x1 = end.getX();
                int x2 = wire1.getOtherEnd(end).getX();
                if (x0 == x1 && x1 == x2) {
                    colinear = true;
                }
                int y0 = wire0.getOtherEnd(end).getY();
                int y1 = end.getY();
                int y2 = wire1.getOtherEnd(end).getY();
                if (y0 == y1 && y1 == y2) {
                    colinear = true;
                }
                if (!colinear) continue;
                WireNet net = end.getNet();
                WireEnd end0 = wire0.getOtherEnd(end);
                WireEnd end1 = wire1.getOtherEnd(end);
                Wire newWire = new Wire(end0, end1);
                end0.addWire(newWire);
                end1.addWire(newWire);
                net.add(newWire);
                newWire.setNet(net);
                SimpleEditor.this.circuit.addElement(newWire);
                net.remove(end);
                net.remove(wire0);
                net.remove(wire1);
                end.remove(SimpleEditor.this.circuit);
            }
        }

        private void setup(Element item, boolean fromToolBar) {
            if (!SimpleEditor.this.enabled) {
                return;
            }
            if (this.currentState != State.idle) {
                return;
            }
            if (SimpleEditor.this.circuit.isImported()) {
                if (item instanceof InputPin) {
                    JOptionPane.showMessageDialog(JLSInfo.frame, "Can't add an input pin to a subcircuit");
                    return;
                }
                if (item instanceof OutputPin) {
                    JOptionPane.showMessageDialog(JLSInfo.frame, "Can't add an output pin to a subcircuit");
                    return;
                }
            }
            for (Element el : this.selected) {
                el.setHighlight(false);
            }
            this.selected.clear();
            int dx = this.x;
            int dy = this.y;
            dx = SimpleEditor.this.tabbedParent.getSize().width / 2;
            dy = SimpleEditor.this.tabbedParent.getSize().height / 4;
            Point view = SimpleEditor.this.pane.getViewport().getViewPosition();
            if (item.setup(this.graphics, this, dx + view.x, dy + view.y)) {
                Point pos = this.getMousePosition();
                if (pos == null) {
                    this.x = 0;
                    this.y = 0;
                } else {
                    this.x = pos.x;
                    this.y = pos.y;
                }
                item.savePosition();
                SimpleEditor.this.circuit.addElement(item);
                this.selected.add(item);
                item.setHighlight(true);
                this.setState(State.placing);
                this.repaint();
            }
        }

        public void doImport(String name) {
            Circuit source = (Circuit)SimpleEditor.this.circMap.get(name);
            HashSet<Element> elements = new HashSet<Element>();
            for (Element el : source.getElements()) {
                WireEnd end;
                if (el instanceof WireEnd && (end = (WireEnd)el).isAttached()) continue;
                elements.add(el);
            }
            Circuit newCopy = new Circuit(name);
            Util.copy(elements, newCopy);
            Util.partition(newCopy);
            for (Element el : newCopy.getElements()) {
                el.setCircuit(newCopy);
            }
            this.updateJumpStarts(newCopy);
            SimpleEditor.this.finishImport(newCopy);
        }

        public void markChanged() {
            SimpleEditor.this.circuit.markChanged();
            this.pushCopy();
            SimpleEditor.this.redos.clear();
            SimpleEditor simpleEditor = SimpleEditor.this;
            simpleEditor.check = simpleEditor.check + 1;
            if (SimpleEditor.this.check > 10) {
                SimpleEditor.this.check = 1;
                Circuit circ = SimpleEditor.this.circuit;
                while (circ.isImported()) {
                    circ = circ.getSubElement().getCircuit();
                }
                String fileName = String.valueOf(circ.getDirectory()) + "/" + circ.getName() + ".jls~";
                ZipOutputStream out = null;
                try {
                    out = new ZipOutputStream(new FileOutputStream(fileName));
                    out.putNextEntry(new ZipEntry("JLSCheckpoint"));
                }
                catch (IOException ex) {
                    return;
                }
                PrintWriter output = new PrintWriter(out);
                boolean changed = SimpleEditor.this.circuit.hasChanged();
                SimpleEditor.this.circuit.save(output);
                output.close();
                if (changed) {
                    SimpleEditor.this.circuit.markChanged();
                }
            }
        }

        public void pushCopy() {
            if (SimpleEditor.this.undos.size() > 10) {
                SimpleEditor.this.undos.remove(0);
            }
            HashSet<Element> elements = new HashSet<Element>();
            for (Element el : SimpleEditor.this.circuit.getElements()) {
                WireEnd end;
                if (el instanceof WireEnd && (end = (WireEnd)el).isAttached()) continue;
                elements.add(el);
            }
            Circuit newCopy = new Circuit(SimpleEditor.this.circuit.getName());
            Util.copy(elements, newCopy);
            newCopy.setDirectory(SimpleEditor.this.circuit.getDirectory());
            SimpleEditor.this.undos.push(newCopy);
        }

        public void undo() {
            if (SimpleEditor.this.undos.size() == 1) {
                return;
            }
            Circuit temp = (Circuit)SimpleEditor.this.undos.pop();
            SimpleEditor.this.redos.push(temp);
            if (SimpleEditor.this.undos.isEmpty()) {
                return;
            }
            Editor ed = SimpleEditor.this.circuit.getEditor();
            temp = (Circuit)SimpleEditor.this.undos.peek();
            this.finishDo(temp);
            SimpleEditor.this.circuit.setEditor(ed);
        }

        public void redo() {
            if (SimpleEditor.this.redos.isEmpty()) {
                return;
            }
            Circuit temp = (Circuit)SimpleEditor.this.redos.pop();
            SimpleEditor.this.undos.push(temp);
            Editor ed = SimpleEditor.this.circuit.getEditor();
            this.finishDo(temp);
            SimpleEditor.this.circuit.setEditor(ed);
        }

        private void finishDo(Circuit temp) {
            Circuit newCopy = new Circuit(SimpleEditor.this.circuit.getName());
            HashSet<Element> elements = new HashSet<Element>();
            for (Element el : temp.getElements()) {
                WireEnd end;
                if (el instanceof WireEnd && (end = (WireEnd)el).isAttached()) continue;
                elements.add(el);
            }
            Util.copy(elements, newCopy);
            Util.partition(newCopy);
            for (Element el : newCopy.getElements()) {
                el.setCircuit(newCopy);
            }
            SubCircuit sub = SimpleEditor.this.circuit.getSubElement();
            newCopy.setImported(sub);
            if (sub != null) {
                sub.setSubCircuit(newCopy);
                sub.remapPins(newCopy);
            }
            SimpleEditor.this.circuit = newCopy;
            SimpleEditor.this.circuit.setDirectory(temp.getDirectory());
            SimpleEditor.this.circuit.markChanged();
            this.updateJumpStarts(SimpleEditor.this.circuit);
            this.updateNamesUsed(SimpleEditor.this.circuit);
            if (!SimpleEditor.this.circuit.isImported()) {
                JLSInfo.sim.setCircuit(SimpleEditor.this.circuit);
            } else {
                for (Element el : SimpleEditor.this.circuit.getElements()) {
                    if (!(el instanceof OutputPin)) continue;
                    OutputPin pin = (OutputPin)el;
                    SubCircuit subc = pin.getCircuit().getSubElement();
                    Output put = (Output)subc.getPut(pin.getName());
                    Input input = pin.getInput("input");
                    if (!input.isAttached()) {
                        put.setTriState(false);
                        continue;
                    }
                    put.setTriState(input.getWireEnd().isTriState());
                }
            }
        }

        private void updateJumpStarts(Circuit circ) {
            for (Element el : circ.getElements()) {
                if (el instanceof JumpStart) {
                    JumpStart j = (JumpStart)el;
                    circ.addJumpStart(j.getName(), j);
                    continue;
                }
                if (!(el instanceof SubCircuit)) continue;
                SubCircuit sc = (SubCircuit)el;
                this.updateJumpStarts(sc.getSubCircuit());
            }
        }

        private void updateNamesUsed(Circuit circ) {
            for (Element el : circ.getElements()) {
                if (el.getName() != null) {
                    String name = el.getName();
                    circ.addName(name);
                    continue;
                }
                if (!(el instanceof SubCircuit)) continue;
                SubCircuit sc = (SubCircuit)el;
                this.updateNamesUsed(sc.getSubCircuit());
            }
        }
    }

    private static enum State {
        idle,
        chosen,
        placing,
        moving,
        selecting,
        selected,
        option,
        startwire,
        drawire;

    }
}

