/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls.edit;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.edit.SimpleEditor;
import edu.mtu.cs.jls.elem.SubCircuit;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public final class Editor
extends SimpleEditor {
    public Editor(JTabbedPane pane, Circuit circuit, String name, Circuit clipboard) {
        super(pane, circuit, name, clipboard);
    }

    public boolean save() {
        if (this.circuit.isImported()) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't save an imported circuit", "Error", 0);
            return false;
        }
        String dir = String.valueOf(this.circuit.getDirectory()) + "/";
        String fileName = String.valueOf(dir) + this.circuit.getName() + ".jls";
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(fileName));
            out.putNextEntry(new ZipEntry("JLSCircuit"));
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't write to " + fileName, "Error", 0);
            return false;
        }
        PrintWriter output = new PrintWriter(out);
        this.circuit.save(output);
        output.close();
        new File(String.valueOf(fileName) + "~").delete();
        return true;
    }

    public void saveAs() {
        if (this.circuit.isImported()) {
            JOptionPane.showMessageDialog(null, "Can't save an imported circuit", "Error", 0);
            return;
        }
        String oldName = String.valueOf(this.circuit.getDirectory()) + "/" + this.circuit.getName() + ".jls~";
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jls") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "JLS Circuit Files";
            }
        };
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getName().trim();
        if (fileName == null || fileName.equals("")) {
            return;
        }
        String tempName = fileName.replaceAll("\\.jls$", "");
        if (!Util.isValidName(tempName)) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "Invalid file name - must have only letters, digits & _");
            return;
        }
        if (!fileName.endsWith(".jls")) {
            fileName = String.valueOf(fileName) + ".jls";
        }
        String name = fileName.replaceAll("\\.jls$", "");
        Component[] componentArray = this.tabbedParent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Editor otherEditor;
            Component edit = componentArray[n2];
            if (edit instanceof Editor && !(otherEditor = (Editor)edit).getCircuit().isImported() && name.equals(otherEditor.getCircuit().getName())) {
                JOptionPane.showMessageDialog(JLSInfo.frame, "Circuit with this name already being edited");
                return;
            }
            ++n2;
        }
        int pos = this.tabbedParent.indexOfComponent(this);
        this.tabbedParent.setTitleAt(pos, name);
        Component[] componentArray2 = this.tabbedParent.getComponents();
        int n3 = componentArray2.length;
        n = 0;
        while (n < n3) {
            Editor otherEditor;
            Component edit = componentArray2[n];
            if (edit instanceof Editor && (otherEditor = (Editor)edit) != this) {
                otherEditor.changeInImportMenu(this.circuit.getName(), name);
            }
            ++n;
        }
        this.circuit.setName(name);
        this.circuit.setDirectory(chooser.getCurrentDirectory().toString());
        if (this.save()) {
            new File(oldName).delete();
        }
    }

    @Override
    public void close() {
        int result;
        SubCircuit s;
        Circuit c;
        Editor ed;
        Editor otherEditor;
        Component[] componentArray = this.tabbedParent.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component edit = componentArray[n2];
            if (edit instanceof Editor && (otherEditor = (Editor)edit) != this && otherEditor.getCircuit().isImported()) {
                Circuit circ = otherEditor.getCircuit();
                while (circ.isImported() && circ != this.circuit) {
                    SubCircuit sub = circ.getSubElement();
                    circ = sub.getCircuit();
                }
                if (this.circuit == circ) {
                    otherEditor.circuit = null;
                    this.tabbedParent.remove(edit);
                }
            }
            ++n2;
        }
        if (this.circuit.isImported() && (ed = (c = (s = this.circuit.getSubElement()).getCircuit()).getEditor()) != null) {
            ed.enableEdits();
        }
        if (!this.circuit.isImported() && this.circuit.hasChanged() && ((result = JOptionPane.showConfirmDialog(this, "Save this circuit?", "Option", 1)) == 0 ? !this.save() : result == 2)) {
            return;
        }
        if (!this.circuit.isImported()) {
            componentArray = this.tabbedParent.getComponents();
            n = componentArray.length;
            int n3 = 0;
            while (n3 < n) {
                Component edit = componentArray[n3];
                if (edit instanceof Editor) {
                    otherEditor = (Editor)edit;
                    otherEditor.removeFromImportMenu(this.circuit);
                }
                ++n3;
            }
        }
        this.circuit.setEditor(null);
        this.tabbedParent.remove(this);
    }

    public boolean shutdown() {
        if (this.circuit.isImported()) {
            return true;
        }
        if (this.circuit.hasChanged()) {
            int options = 1;
            int result = JOptionPane.showConfirmDialog(null, "Save " + this.circuit.getName() + "?", "Save circuit?", options);
            if (result == 0) {
                if (!this.save()) {
                    return false;
                }
            } else {
                if (result == 2) {
                    return false;
                }
                String fileName = String.valueOf(this.circuit.getDirectory()) + "/" + this.circuit.getName() + ".jls";
                new File(String.valueOf(fileName) + "~").delete();
            }
        }
        return true;
    }

    public void enableEdits() {
        this.editable.setText(" ");
        this.enabled = true;
    }
}

