/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.Output;
import edu.mtu.cs.jls.elem.Put;
import edu.mtu.cs.jls.elem.Wire;
import edu.mtu.cs.jls.elem.WireEnd;
import edu.mtu.cs.jls.elem.WireNet;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public final class Util {
    private Util() {
    }

    public static void noHelp(JButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showMessageDialog(JLSInfo.frame, "No help available - perhaps jh.jar is not in the right place.");
            }
        });
    }

    public static Point copy(Set<Element> from, Circuit to) {
        HashSet<WireEnd> ends = new HashSet<WireEnd>();
        int minx = 0;
        int miny = 0;
        boolean firstTime = true;
        for (Element el : from) {
            if (el instanceof Wire || el instanceof WireEnd) continue;
            int x = el.getX();
            int y = el.getY();
            if (firstTime) {
                firstTime = false;
                minx = x;
                miny = y;
            }
            if (x < minx) {
                minx = x;
            }
            if (y < miny) {
                miny = y;
            }
            Element copy = el.copy();
            to.addElement(copy);
            for (Put p : el.getAllPuts()) {
                if (!p.isAttached()) continue;
                WireEnd oldEnd = p.getWireEnd();
                WireEnd newEnd = oldEnd.copy();
                to.addElement(newEnd);
                newEnd.setPut(p.getCopy());
                p.getCopy().setAttached(newEnd);
                ends.add(oldEnd);
            }
        }
        for (Element el : from) {
            if (!(el instanceof WireEnd)) continue;
            WireEnd end = (WireEnd)el;
            int x = end.getX();
            int y = end.getY();
            if (firstTime) {
                firstTime = false;
                minx = x;
                miny = y;
            }
            if (x < minx) {
                minx = x;
            }
            if (y < miny) {
                miny = y;
            }
            to.addElement(end.copy());
            ends.add(end);
        }
        for (Element el : from) {
            if (!(el instanceof Wire)) continue;
            Wire wire = (Wire)el;
            WireEnd end1 = wire.getEnd();
            WireEnd end2 = wire.getOtherEnd(end1);
            if (!ends.contains(end1) || !ends.contains(end2)) continue;
            Wire newWire = new Wire(end1.getCopy(), end2.getCopy());
            String probe = wire.getProbe();
            if (probe != null) {
                newWire.attachProbe(probe);
            }
            end1.getCopy().addWire(newWire);
            end2.getCopy().addWire(newWire);
            to.addElement(newWire);
        }
        HashSet<Element> temp = new HashSet<Element>();
        temp.addAll(to.getElements());
        for (Element el : temp) {
            WireEnd end;
            if (!(el instanceof WireEnd) || (end = (WireEnd)el).degree() != 0) continue;
            to.remove(end);
        }
        return new Point(minx, miny);
    }

    public static void partition(Circuit circ) {
        WireEnd end;
        LinkedList<WireEnd> ends = new LinkedList<WireEnd>();
        for (Element el : circ.getElements()) {
            if (!(el instanceof WireEnd)) continue;
            end = (WireEnd)el;
            ends.add(end);
        }
        HashSet<WireNet> nets = new HashSet<WireNet>();
        while (!ends.isEmpty()) {
            LinkedList<WireEnd> visit = new LinkedList<WireEnd>();
            end = (WireEnd)ends.remove();
            visit.add(end);
            WireNet net = new WireNet();
            nets.add(net);
            HashSet<WireEnd> visited = new HashSet<WireEnd>();
            while (!visit.isEmpty()) {
                WireEnd vend = (WireEnd)visit.remove();
                ends.remove(vend);
                visited.add(vend);
                net.add(vend);
                vend.setNet(net);
                if (vend.isAttached()) {
                    net.setBits(vend.getPut().getBits());
                    if (vend.getPut() instanceof Output) {
                        net.setInput();
                    }
                }
                for (Wire wire : vend.getWires()) {
                    WireEnd otherEnd = wire.getOtherEnd(vend);
                    if (visited.contains(otherEnd)) continue;
                    visit.add(otherEnd);
                    net.add(wire);
                    wire.setNet(net);
                }
            }
        }
        for (WireNet net : nets) {
            for (WireEnd end2 : net.getAllEnds()) {
                Output out;
                if (!end2.isAttached() || !(end2.getPut() instanceof Output) || !(out = (Output)end2.getPut()).isTriState()) continue;
                net.setTriState(true);
            }
        }
    }

    public static boolean isValidName(String str) {
        if (str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (!(Character.isLetter(c) || Character.isDigit(c) && i > 0 || c == '_' && i > 0)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String isValidFileName(String str) {
        String slash = System.getProperty("file.separator");
        int last = str.lastIndexOf(slash);
        String circuitName = str;
        if (last != -1) {
            circuitName = str.substring(last + 1);
        }
        if (Util.isValidName(circuitName)) {
            return circuitName;
        }
        return null;
    }

    public static String convert(BigInteger value, int base, boolean extra) {
        if (base == 2) {
            if (extra) {
                return String.valueOf(value.toString(2)) + "B";
            }
            return value.toString(2);
        }
        if (base == 10) {
            return value.toString();
        }
        if (base == 16) {
            if (extra) {
                return "0x" + value.toString(16);
            }
            return value.toString(16);
        }
        return "";
    }
}

