/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.TextFilter;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.text.AbstractDocument;

public final class KeyPad
extends JButton
implements ActionListener {
    private JButton[] digits = new JButton[16];
    private JButton reset = new JButton("C");
    private JButton hide = new JButton();
    private JTextField target;
    private int base;
    private long defaultValue;
    private boolean firstChange = true;
    private JWindow win;
    private boolean winVisible = false;
    TextFilter filter;

    public KeyPad(JTextField target, int digitKeys, long defaultValue, final Window f) {
        URL down = this.getClass().getResource("images/down.gif");
        this.setIcon(new ImageIcon(down));
        this.setBackground(Color.WHITE);
        URL up = this.getClass().getResource("images/up.gif");
        this.hide.setIcon(new ImageIcon(up));
        this.target = target;
        this.base = digitKeys;
        this.defaultValue = defaultValue;
        int i = 0;
        while (i <= 9) {
            this.digits[i] = new JButton(String.valueOf(i));
            ++i;
        }
        this.digits[10] = new JButton("a");
        this.digits[11] = new JButton("b");
        this.digits[12] = new JButton("c");
        this.digits[13] = new JButton("d");
        this.digits[14] = new JButton("e");
        this.digits[15] = new JButton("f");
        this.win = new JWindow(f);
        Container window = this.win.getContentPane();
        if (this.base == 16) {
            window.setLayout(new GridLayout(6, 3));
        } else if (this.base == 10) {
            window.setLayout(new GridLayout(4, 3));
        }
        if (this.base == 16) {
            window.add(this.digits[13]);
            window.add(this.digits[14]);
            window.add(this.digits[15]);
            window.add(this.digits[10]);
            window.add(this.digits[11]);
            window.add(this.digits[12]);
        }
        window.add(this.digits[7]);
        window.add(this.digits[8]);
        window.add(this.digits[9]);
        window.add(this.digits[4]);
        window.add(this.digits[5]);
        window.add(this.digits[6]);
        window.add(this.digits[1]);
        window.add(this.digits[2]);
        window.add(this.digits[3]);
        window.add(this.reset);
        window.add(this.digits[0]);
        window.add(this.hide);
        int i2 = 0;
        while (i2 < this.base) {
            this.digits[i2].addActionListener(this);
            ++i2;
        }
        this.reset.addActionListener(this);
        this.hide.addActionListener(this);
        AbstractDocument doc = (AbstractDocument)target.getDocument();
        this.filter = new TextFilter(target);
        doc.setDocumentFilter(this.filter);
        this.win.pack();
        this.addActionListener(this);
        ComponentAdapter list = new ComponentAdapter(){
            private Point then = null;

            @Override
            public void componentMoved(ComponentEvent event) {
                if (this.then == null) {
                    this.then = f.getLocation();
                } else {
                    Point now = f.getLocation();
                    int dx = now.x - this.then.x;
                    int dy = now.y - this.then.y;
                    Point winloc = KeyPad.this.win.getLocation();
                    winloc.translate(dx, dy);
                    KeyPad.this.win.setLocation(winloc);
                    this.then = now;
                }
            }
        };
        f.addComponentListener(list);
        MouseAdapter hide = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.getButton() == 3) {
                    KeyPad.this.win.setVisible(false);
                    KeyPad.this.winVisible = false;
                }
            }
        };
        int i3 = 0;
        while (i3 < this.base) {
            this.digits[i3].addMouseListener(hide);
            ++i3;
        }
        this.reset.addMouseListener(hide);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this) {
            Point p = this.getLocationOnScreen();
            Dimension d = this.getSize();
            this.win.setLocation(p.x, p.y + d.height);
            this.winVisible = !this.winVisible;
            this.win.setVisible(this.winVisible);
            return;
        }
        if (event.getSource() == this.hide) {
            this.win.setVisible(false);
            this.winVisible = false;
        }
        if (event.getSource() == this.reset) {
            this.target.setText(Long.toString(this.defaultValue, this.base));
            this.firstChange = true;
            return;
        }
        int i = 0;
        while (i < this.base) {
            if (event.getSource() == this.digits[i]) {
                if (this.firstChange) {
                    this.target.setText(Integer.toString(i, this.base));
                    this.firstChange = false;
                } else {
                    this.target.setText(String.valueOf(this.target.getText()) + Integer.toString(i, this.base));
                }
                return;
            }
            ++i;
        }
    }

    public void setBase(int base) {
        this.base = base;
        this.filter.setBase(base);
    }

    public void reset() {
        this.firstChange = true;
    }

    public void close() {
        this.win.setVisible(false);
        this.win.dispose();
    }
}

