/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.About;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.DefaultExceptionHandler;
import edu.mtu.cs.jls.JLS;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Tutorial;
import edu.mtu.cs.jls.Util;
import edu.mtu.cs.jls.edit.Editor;
import edu.mtu.cs.jls.elem.Element;
import edu.mtu.cs.jls.elem.LogicElement;
import edu.mtu.cs.jls.elem.Memory;
import edu.mtu.cs.jls.elem.OutputPin;
import edu.mtu.cs.jls.elem.Register;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.sim.BatchSimulator;
import edu.mtu.cs.jls.sim.InterractiveSimulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.InputMismatchException;
import java.util.Scanner;
import java.util.Vector;
import java.util.zip.ZipInputStream;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.print.PrintService;
import javax.swing.Box;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class JLSStart
extends JFrame
implements ChangeListener {
    private static long timeLimit = 100000000L;
    private static String paramFile = null;
    private static String testFile = null;
    private static String startFile = null;
    private static boolean printCircuit = false;
    private static boolean printCircuitTop;
    private static String printer;
    private InterractiveSimulator interSim;
    private static DefaultExceptionHandler exHandler;
    private Container window;
    private JSplitPane both;
    private JTabbedPane edits;
    private Circuit clipboard = new Circuit("clipboard");
    private String prevOpenDir = "";

    static {
        printer = null;
        exHandler = null;
    }

    public static void start(String[] args, DefaultExceptionHandler exh) {
        exHandler = exh;
        if (printCircuit && startFile != null) {
            JLSStart.printCirc(printCircuitTop);
            return;
        }
        if (JLSInfo.batch || JLSInfo.imgexport) {
            System.setProperty("java.awt.headless", "true");
            if (startFile == null) {
                System.err.println("batch or image mode requires circuit file");
                System.exit(1);
            }
            String name = "";
            name = startFile.endsWith(".jls~") ? startFile.replaceAll("\\.jls~$", "") : startFile.replaceAll("\\.jls$", "");
            String cname = Util.isValidFileName(name);
            if (cname == null) {
                System.out.println(String.valueOf(startFile) + " is not a valid circuit file name");
                System.exit(1);
            }
            InputStream in = null;
            try {
                FileInputStream temp = new FileInputStream(startFile);
                ZipInputStream inz = new ZipInputStream(temp);
                if (inz.getNextEntry() == null) {
                    temp.close();
                    in = new FileInputStream(startFile);
                } else {
                    in = inz;
                }
            }
            catch (IOException ex) {
                System.out.println("Can't read from " + startFile);
                System.exit(1);
            }
            Scanner input = new Scanner(in);
            Circuit circ = new Circuit(cname);
            boolean loadOK = circ.load(input);
            if (input.hasNext()) {
                loadOK = false;
            }
            input.close();
            if (!loadOK) {
                System.out.println(String.valueOf(startFile) + " is not a valid circuit file");
                System.out.println("    reason: " + JLSInfo.loadError);
                JOptionPane.showMessageDialog(null, "invalid circuit file: " + JLSInfo.loadError);
                System.exit(1);
            }
            input.close();
            if (!circ.finishLoad(null)) {
                System.out.println(String.valueOf(startFile) + " is not a valid circuit file");
                System.out.println("    reason: " + JLSInfo.loadError);
                JOptionPane.showMessageDialog(null, "invalid circuit file: " + JLSInfo.loadError);
                System.exit(1);
            }
            if (JLSInfo.imgexport) {
                circ.exportImage(String.valueOf(name) + ".jpg");
                System.exit(0);
            }
            exHandler.setCircuit(circ);
            if (paramFile != null) {
                JLSStart.processParamFile(paramFile, circ);
            }
            BatchSimulator batchSim = new BatchSimulator();
            JLSInfo.sim = batchSim;
            batchSim.setCircuit(circ);
            batchSim.setTimeLimit(timeLimit);
            batchSim.setTestFile(testFile);
            batchSim.addTestGen();
            batchSim.runSim();
            batchSim.displayOutcome();
            JLSStart.displayResults(circ, "");
            if (JLSInfo.printTrace) {
                batchSim.printTrace(printer);
            }
        } else {
            Runnable mainwindow = new Runnable(){

                @Override
                public void run() {
                    try {
                        new JLSStart();
                    }
                    catch (HeadlessException e) {
                        System.out.println("No usable display device found!");
                        System.out.println("Are you using a headless remote session?");
                        System.exit(1);
                    }
                }
            };
            EventQueue.invokeLater(mainwindow);
        }
    }

    public static void displayResults(Circuit circ, String qual) {
        for (Element el : circ.getElements()) {
            if (el.isWatched()) {
                if (el instanceof Register) {
                    Register reg = (Register)el;
                    reg.printValue(qual);
                    continue;
                }
                if (el instanceof Memory) {
                    Memory mem = (Memory)el;
                    mem.printChangedValues(qual);
                    continue;
                }
                if (!(el instanceof OutputPin)) continue;
                OutputPin pin = (OutputPin)el;
                pin.printValue(qual);
                continue;
            }
            if (!(el instanceof SubCircuit)) continue;
            SubCircuit sel = (SubCircuit)el;
            Circuit subCirc = sel.getSubCircuit();
            String subQual = "";
            subQual = qual.equals("") ? subCirc.getName() : String.valueOf(qual) + "." + subCirc.getName();
            JLSStart.displayResults(subCirc, subQual);
        }
    }

    public static void parseCommandLine(String[] args) {
        int pos = 0;
        while (pos < args.length) {
            String arg = args[pos];
            if (arg.charAt(0) == '-') {
                char flag = arg.charAt(1);
                if (flag == 'h') {
                    JLSStart.usage();
                    System.exit(0);
                } else if (flag == 'b') {
                    if (arg.length() > 2) {
                        JLSStart.usage();
                        System.exit(1);
                    } else {
                        JLSInfo.batch = true;
                    }
                } else if (flag == 'i') {
                    JLSInfo.imgexport = true;
                } else if (flag == 'r') {
                    if (arg.length() > 2) {
                        printer = arg.substring(2);
                        JLSInfo.printTrace = true;
                    } else if (args[pos + 1].charAt(0) != '-') {
                        printer = args[++pos];
                        JLSInfo.printTrace = true;
                    } else {
                        System.out.println("invalid or missing printer name");
                        System.exit(1);
                    }
                } else if (flag == 'p') {
                    if (arg.length() > 2) {
                        printer = arg.substring(2);
                        printCircuit = true;
                        printCircuitTop = false;
                    } else if (args[pos + 1].charAt(0) != '-') {
                        printer = args[++pos];
                        printCircuit = true;
                        printCircuitTop = false;
                    } else {
                        System.out.println("invalid or missing printer name");
                        System.exit(1);
                    }
                } else if (flag == 'v') {
                    if (arg.length() > 2) {
                        printer = arg.substring(2);
                        printCircuit = true;
                        printCircuitTop = true;
                    } else if (args[pos + 1].charAt(0) != '-') {
                        printer = args[++pos];
                        printCircuit = true;
                        printCircuitTop = true;
                    } else {
                        System.out.println("invalid or missing printer name");
                        System.exit(1);
                    }
                } else if (flag == 's') {
                    if (arg.length() > 2) {
                        paramFile = arg.substring(2);
                    } else if (args[pos + 1].charAt(0) != '-') {
                        paramFile = args[++pos];
                    } else {
                        System.out.println("missing or invalid startup file");
                        System.exit(1);
                    }
                } else if (flag == 'd') {
                    String tmp = null;
                    if (arg.length() > 2) {
                        tmp = arg.substring(2);
                    } else if (args[pos + 1].charAt(0) != '-') {
                        tmp = args[++pos];
                    } else {
                        System.out.println("missing or invalid time limit");
                        System.exit(1);
                    }
                    try {
                        timeLimit = Long.parseLong(tmp);
                    }
                    catch (NumberFormatException ex) {
                        System.out.println("time limit not an integer");
                        System.exit(1);
                    }
                } else if (flag == 't') {
                    if (arg.length() > 2) {
                        testFile = arg.substring(2);
                    } else if (args[pos + 1].charAt(0) != '-') {
                        testFile = args[++pos];
                    } else {
                        System.out.println("missing or invalid test file");
                        System.exit(1);
                    }
                } else {
                    System.out.println("invalid flag");
                    JLSStart.usage();
                    System.exit(1);
                }
            } else if (startFile == null) {
                startFile = arg;
            } else {
                System.out.println("arguments after circuit file not allowed");
                JLSStart.usage();
                System.exit(1);
            }
            ++pos;
        }
    }

    private static void usage() {
        System.err.println("usage: jls [ flags ] [ circuit_name ]");
        System.err.println("  -h : print this message");
        System.err.println("  -b : run in batch mode");
        System.err.println("  -sname : startup parameter file");
        System.err.println("  -tname : test input file");
        System.err.println("  -dtime : set simulation time limit (a positive integer)");
        System.err.println("  -pprinter : print circuit to named printer (all other flags ignored");
        System.err.println("  -rprinter : print signal trace to named printer (all other flags ignored)");
        System.err.println("example: jls -b -sstartup -d10000 counter");
    }

    public JLSStart() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Can't set cross platform look and feel");
            System.exit(1);
        }
        exHandler.setJLS(this);
        JLSInfo.frame = this;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JLSStart.this.shutdown();
            }
        });
        JMenuBar bar = new JMenuBar();
        bar.add(this.fileMenu());
        bar.add(this.simMenu());
        bar.add(this.globalMenu());
        bar.add(Box.createHorizontalGlue());
        bar.add(this.helpMenu());
        this.setJMenuBar(bar);
        this.window = this.getContentPane();
        this.window.setLayout(new BorderLayout());
        this.both = new JSplitPane(0, true);
        this.edits = new JTabbedPane(1, 1);
        this.edits.setMinimumSize(new Dimension(1, 1));
        this.both.setTopComponent(this.edits);
        this.window.add((Component)this.both, "Center");
        this.edits.addChangeListener(this);
        this.setTitle("JLS 4.1 (Michigan Technological University)");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = 970;
        int height = 600;
        this.setSize(width, height);
        int left = (screenSize.width - width) / 2;
        int top = (screenSize.height - height) / 2;
        this.setLocation(left, top);
        this.setVisible(true);
        this.interSim = new InterractiveSimulator();
        JLSInfo.sim = this.interSim;
        this.interSim.setTestFile(testFile);
        if (startFile != null) {
            this.open(startFile);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Editor ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            this.interSim.setCircuit(null);
            this.both.remove(this.interSim.getWindow());
            return;
        }
        Circuit circ = ed.getCircuit();
        while (circ.isImported()) {
            SubCircuit sub = circ.getSubElement();
            circ = sub.getCircuit();
        }
        this.interSim.setCircuit(circ);
    }

    private void shutdown() {
        boolean cancel = false;
        Component[] componentArray = this.edits.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp instanceof Editor) {
                Editor editor = (Editor)comp;
                if (!editor.shutdown()) {
                    cancel = true;
                    break;
                }
                this.edits.remove(editor);
            }
            ++n2;
        }
        if (!cancel) {
            System.exit(0);
        }
    }

    public Editor getVisibleEditor() {
        return (Editor)this.edits.getSelectedComponent();
    }

    public JMenu fileMenu() {
        JMenu menu = new JMenu("File");
        JMenuItem newc = new JMenuItem("New");
        newc.setToolTipText("create a new circuit");
        menu.add(newc);
        newc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.newCircuit();
            }
        });
        JMenuItem open = new JMenuItem("Open");
        open.setToolTipText("open an existing circuit file");
        menu.add(open);
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.open(null);
            }
        });
        JMenuItem saveItem = new JMenuItem("Save");
        saveItem.setToolTipText("save the currently visible circuit");
        menu.add(saveItem);
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSStart.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.save();
                }
            }
        });
        JMenuItem saveAs = new JMenuItem("Save As");
        saveAs.setToolTipText("save the currently visible circuit under a new name");
        menu.add(saveAs);
        saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSStart.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.saveAs();
                }
            }
        });
        JMenu print = new JMenu("Print...");
        JMenuItem printAll = new JMenuItem("Entire circuit");
        printAll.setToolTipText("print the circuit and all subcircuits");
        JMenuItem justThis = new JMenuItem("Just visible window");
        justThis.setToolTipText("print only the currently visible window");
        menu.add(print);
        print.add(printAll);
        print.add(justThis);
        printAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.print(true);
            }
        });
        justThis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.print(false);
            }
        });
        JMenuItem importItem = new JMenuItem("Import");
        importItem.setToolTipText("create a subcircuit from a circuit file");
        menu.add(importItem);
        importItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.fileImport();
            }
        });
        JMenuItem exportItem = new JMenuItem("Export Image");
        exportItem.setToolTipText("create a JPEG image file of the circuit");
        menu.add(exportItem);
        exportItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.exportImage();
            }
        });
        JMenuItem close = new JMenuItem("Close");
        close.setToolTipText("close the currently visible circuit");
        menu.add(close);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.closeVisibleEditor();
            }
        });
        JMenuItem exit = new JMenuItem("Exit");
        exit.setToolTipText("terminate JLS");
        menu.add(exit);
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.shutdown();
            }
        });
        return menu;
    }

    public JMenu simMenu() {
        JMenu menu = new JMenu("Simulator");
        JMenuItem show = new JMenuItem("Show Simulator Window");
        show.setToolTipText("make simulator window appear");
        menu.add(show);
        JMenuItem hide = new JMenuItem("Hide Simulator Window");
        hide.setToolTipText("make simulator window disappear");
        menu.add(hide);
        JMenuItem run = new JMenuItem("Run (in background)");
        run.setToolTipText("run simulator, don't show window");
        run.setAccelerator(KeyStroke.getKeyStroke("F5"));
        menu.add(run);
        JMenuItem stop = new JMenuItem("Stop (background simulator)");
        stop.setToolTipText("stop runaway simulator");
        stop.setAccelerator(KeyStroke.getKeyStroke("F7"));
        menu.add(stop);
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.both.setBottomComponent(JLSStart.this.interSim.getStatusBar());
                JLSStart.this.both.setDividerLocation(0.9);
                JLSInfo.batch = true;
                JLSStart.this.interSim.setMaxTime();
                JLSStart.this.interSim.runSim();
                JLSInfo.batch = false;
            }
        });
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.interSim.stop();
            }
        });
        show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.both.setDividerLocation(0.7);
                JLSStart.this.both.setBottomComponent(JLSStart.this.interSim.getWindow());
            }
        });
        hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSStart.this.both.remove(JLSStart.this.interSim.getWindow());
                JLSStart.this.both.setDividerLocation(1.0);
            }
        });
        return menu;
    }

    public JMenu globalMenu() {
        JMenu menu = new JMenu("Global");
        JMenuItem resetDelays = new JMenuItem("Reset all propagation delays");
        menu.add(resetDelays);
        resetDelays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSStart.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.getCircuit().resetAllDelays();
                    ed.repaint();
                }
            }
        });
        JMenuItem removeProbes = new JMenuItem("Remove all probes");
        menu.add(removeProbes);
        removeProbes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSStart.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.getCircuit().removeAllProbes();
                    ed.repaint();
                }
            }
        });
        JMenuItem clearWatches = new JMenuItem("Unwatch all elements");
        menu.add(clearWatches);
        clearWatches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSStart.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.getCircuit().clearAllWatches();
                    ed.repaint();
                }
            }
        });
        JMenuItem expand = new JMenuItem("Expand circuit drawing area by 10%");
        menu.add(expand);
        expand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSStart.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.increaseSize();
                }
            }
        });
        JMenuItem gridCol = new JMenuItem("Change editor window grid color");
        menu.add(gridCol);
        gridCol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed;
                Color newColor = JColorChooser.showDialog(null, "Select Grid Color", JLSInfo.gridColor);
                if (newColor != null) {
                    JLSInfo.gridColor = newColor;
                }
                if ((ed = (Editor)JLSStart.this.edits.getSelectedComponent()) != null) {
                    ed.repaint();
                }
            }
        });
        JMenuItem editBkg = new JMenuItem("Change editor window background color");
        menu.add(editBkg);
        editBkg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed;
                Color newColor = JColorChooser.showDialog(null, "Select Background Color", JLSInfo.backgroundColor);
                if (newColor != null) {
                    JLSInfo.backgroundColor = newColor;
                }
                if ((ed = (Editor)JLSStart.this.edits.getSelectedComponent()) != null) {
                    ed.changeBackgroundColor();
                    ed.repaint();
                }
            }
        });
        return menu;
    }

    public JMenu helpMenu() {
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem("About");
        help.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new About();
            }
        });
        JMenu tutorial = new JMenu("Tutorial");
        help.add(tutorial);
        JMenuItem tutorial1 = new JMenuItem("Introduction");
        String tip1 = "<html>This tutorial demonstrates the basic drawing capabilities<br>using simple gates and wires, and how to use the simulator&nbsp;&nbsp;<br>to watch the circuit in action.</html>";
        tutorial1.setToolTipText(tip1);
        tutorial.add(tutorial1);
        tutorial1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial1.html", false);
            }
        });
        JMenuItem tutorial2 = new JMenuItem("4-Bit Counter");
        String tip2 = "<html>Demonstrates the use of more complex&nbsp;&nbsp;<br>elements and multi-wire connections.</html>";
        tutorial2.setToolTipText(tip2);
        tutorial.add(tutorial2);
        tutorial2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial2.html", false);
            }
        });
        JMenuItem tutorial3 = new JMenuItem("Full Adder");
        String tip3 = "<html>Demonstrates how to define and use subcircuits.";
        tutorial3.setToolTipText(tip3);
        tutorial.add(tutorial3);
        tutorial3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial3.html", false);
            }
        });
        JMenuItem tutorial4 = new JMenuItem("Sign Extension");
        String tip4 = "<html>Demonstrates how to bundle/unbundle&nbsp;&nbsp;<br>and to use the signal copy element.";
        tutorial4.setToolTipText(tip4);
        tutorial.add(tutorial4);
        tutorial4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial4.html", false);
            }
        });
        JMenuItem contents = new JMenuItem("Contents");
        help.add(contents);
        String helpHS = "help/JLSHelp.hs";
        ClassLoader cl = JLS.class.getClassLoader();
        HelpSet mainHS = null;
        try {
            URL url = HelpSet.findHelpSet(cl, helpHS);
            mainHS = new HelpSet(cl, url);
        }
        catch (Exception ex) {
            contents.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JOptionPane.showMessageDialog(null, "No help - something bad happened during initialization.");
                }
            });
            return help;
        }
        catch (NoClassDefFoundError er) {
            contents.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JOptionPane.showMessageDialog(null, "No help - jh.jar appears to be missing");
                }
            });
            return help;
        }
        JLSInfo.hb = mainHS.createHelpBroker();
        contents.addActionListener(new CSH.DisplayHelpFromSource(JLSInfo.hb));
        return help;
    }

    private void newCircuit() {
        String name = JOptionPane.showInputDialog("Enter circuit name (without .jls)");
        if (name == null || name.equals("")) {
            return;
        }
        if (!Util.isValidName(name)) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "Invalid circuit name - must have only letters, digits & _");
            return;
        }
        if (this.duplicateName(name = name.replaceAll("\\.jls$", ""))) {
            return;
        }
        Circuit circ = new Circuit(name);
        circ.setDirectory(System.getProperty("user.dir"));
        exHandler.setCircuit(circ);
        this.setupEditor(circ, name);
    }

    private void open(String fileName) {
        File file = null;
        String dir = "";
        if (fileName == null) {
            JFileChooser chooser = null;
            chooser = this.prevOpenDir.equals("") ? new JFileChooser(System.getProperty("user.dir")) : new JFileChooser(this.prevOpenDir);
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".jls") || f.getName().endsWith(".jls~") || f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "JLS Circuit Files";
                }
            };
            chooser.setFileFilter(filter);
            if (chooser.showOpenDialog(this) != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            fileName = file.getName().trim();
            if (fileName == null || fileName.equals("")) {
                return;
            }
            dir = chooser.getCurrentDirectory().toString();
        } else {
            file = new File(fileName);
            dir = file.getParent();
            if (dir == null) {
                dir = System.getProperty("user.dir");
            }
        }
        String name = "";
        name = fileName.endsWith(".jls~") ? fileName.replaceAll("\\.jls~$", "") : fileName.replaceAll("\\.jls$", "");
        String cname = Util.isValidFileName(name);
        if (cname == null) {
            JOptionPane.showMessageDialog(this, String.valueOf(name) + " is not a valid circuit file name.\n It must start with a letter and contain letters, digits and underscores.", "Error", 0);
            return;
        }
        if (this.duplicateName(cname)) {
            return;
        }
        InputStream in = null;
        try {
            FileInputStream temp = new FileInputStream(file);
            ZipInputStream inz = new ZipInputStream(temp);
            if (inz.getNextEntry() == null) {
                temp.close();
                in = new FileInputStream(file);
            } else {
                in = inz;
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't read from " + fileName, "Error", 0);
            return;
        }
        Scanner input = new Scanner(in);
        Circuit circ = new Circuit(cname);
        circ.setDirectory(dir);
        this.prevOpenDir = new String(dir);
        boolean loadOK = circ.load(input);
        if (input.hasNext()) {
            loadOK = false;
        }
        input.close();
        if (!loadOK) {
            JOptionPane.showMessageDialog(this, String.valueOf(fileName) + " is not a valid circuit file (line " + circ.getLineNumber() + "): " + JLSInfo.loadError, "Error", 0);
            return;
        }
        new File(String.valueOf(cname) + ".jls~").delete();
        exHandler.setCircuit(circ);
        this.setupEditor(circ, cname);
    }

    public void setupEditor(Circuit circ, String name) {
        Editor ed = new Editor(this.edits, circ, name, this.clipboard);
        circ.setEditor(ed);
        Component[] componentArray = this.edits.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component edit = componentArray[n2];
            if (edit instanceof Editor) {
                Editor otherEditor = (Editor)edit;
                otherEditor.addToImportMenu(circ);
                if (!otherEditor.getCircuit().isImported()) {
                    ed.addToImportMenu(otherEditor.getCircuit());
                }
            }
            ++n2;
        }
        this.edits.add(ed);
        this.edits.setSelectedComponent(ed);
    }

    private void closeVisibleEditor() {
        Editor ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            return;
        }
        ed.close();
        ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            exHandler.setCircuit(null);
        } else {
            Circuit c = ed.getCircuit();
            while (c.isImported()) {
                c = c.getSubElement().getCircuit();
            }
            exHandler.setCircuit(c);
        }
    }

    public void print(boolean all) {
        Editor ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.defaultPage();
        format.setOrientation(0);
        Book book = new Book();
        if (all) {
            ed.getCircuit().addToBook(book, format);
        } else {
            book.append(ed.getCircuit(), format);
        }
        job.setPageable(book);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (PrinterException ex) {
                System.out.println("printing error: " + ex.getMessage());
            }
        }
    }

    public boolean duplicateName(String name) {
        int e = 0;
        while (e < this.edits.getTabCount()) {
            if (name.equals(this.edits.getTitleAt(e))) {
                JOptionPane.showMessageDialog(this, String.valueOf(name) + " is already being editted", "Error", 0);
                return true;
            }
            ++e;
        }
        return false;
    }

    public void fileImport() {
        Editor ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            JOptionPane.showMessageDialog(this, "no circuit to import into", "Error", 0);
            return;
        }
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jls") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "JLS Circuit Files";
            }
        };
        chooser.setFileFilter(filter);
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getName().trim();
        if (fileName == null || fileName.equals("")) {
            return;
        }
        if (!fileName.endsWith(".jls")) {
            fileName = String.valueOf(fileName) + ".jls";
        }
        String name = fileName.replaceAll("\\.jls$", "");
        fileName = String.valueOf(chooser.getCurrentDirectory().toString()) + "/" + fileName;
        InputStream in = null;
        try {
            FileInputStream temp = new FileInputStream(fileName);
            ZipInputStream inz = new ZipInputStream(temp);
            if (inz.getNextEntry() == null) {
                temp.close();
                in = new FileInputStream(fileName);
            } else {
                in = inz;
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't read from " + fileName, "Error", 0);
            return;
        }
        Scanner input = new Scanner(in);
        Circuit circ = new Circuit(name);
        boolean loadOK = circ.load(input);
        if (input.hasNext()) {
            loadOK = false;
        }
        input.close();
        if (!loadOK) {
            JOptionPane.showMessageDialog(this, String.valueOf(fileName) + " is not a valid circuit file", "Error", 0);
            return;
        }
        circ.finishLoad(null);
        ed.finishImport(circ);
    }

    public static void processParamFile(String paramFile, Circuit circuit) {
        try {
            FileInputStream input = new FileInputStream(paramFile);
            Scanner scan = new Scanner(input);
            while (scan.hasNext()) {
                String word;
                String key = scan.next();
                if (key.equals("TYPE")) {
                    int delay;
                    String word2;
                    Class<?> cl = null;
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected element type,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    String type = scan.next();
                    try {
                        cl = Class.forName("edu.mtu.cs.jls.elem." + type);
                    }
                    catch (ClassNotFoundException ex) {
                        System.out.print(String.valueOf(paramFile) + ": expected element type,");
                        System.out.println(" got \"" + type + "\"");
                        System.exit(1);
                    }
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected PROPDELAY,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    if (!(word2 = scan.next()).equals("PROPDELAY")) {
                        System.out.print(String.valueOf(paramFile) + ": expected PROPDELAY,");
                        System.out.println(" got \"" + word2 + "\"");
                        System.exit(1);
                    }
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected propagation delay,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    if (!scan.hasNextInt()) {
                        System.out.print(String.valueOf(paramFile) + ": expected propagation delay,");
                        System.out.println(" got \"" + scan.next() + "\"");
                        System.exit(1);
                    }
                    if ((delay = scan.nextInt()) < 1) {
                        System.out.print(String.valueOf(paramFile) + ": expected propagation delay > 0,");
                        System.out.println(" got \"" + delay + "\"");
                        System.exit(1);
                    }
                    JLSStart.setPropDelays(circuit, cl, delay);
                    continue;
                }
                if (key.equals("ELEMENT")) {
                    String prop;
                    String name;
                    Vector<String> qualifiedName;
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected element name,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    if ((qualifiedName = JLSStart.parseName(name = scan.next())) == null) {
                        System.out.println(String.valueOf(paramFile) + ": invalid element name " + name);
                        System.exit(1);
                    }
                    String elementName = qualifiedName.remove(qualifiedName.size() - 1);
                    Object circ = circuit;
                    if (qualifiedName.size() > 0) {
                        for (String sub : qualifiedName) {
                            Object next = null;
                            for (Element el : ((Circuit)circ).getElements()) {
                                SubCircuit lel;
                                if (!(el instanceof SubCircuit) || !sub.equals((lel = (SubCircuit)el).getName())) continue;
                                next = lel.getSubCircuit();
                                break;
                            }
                            if (next == null) {
                                System.out.println(String.valueOf(paramFile) + ": no such element name " + name);
                                System.exit(1);
                            }
                            circ = next;
                        }
                    }
                    LogicElement element = null;
                    for (Element el : ((Circuit)circ).getElements()) {
                        LogicElement lel;
                        if (!(el instanceof LogicElement) || !elementName.equals((lel = (LogicElement)el).getName())) continue;
                        element = lel;
                        break;
                    }
                    if (element == null) {
                        System.out.print(String.valueOf(paramFile) + ": no such element named");
                        System.out.println(" \"" + name + "\"");
                        System.exit(1);
                    }
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected element property,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    if ((prop = scan.next()).equals("WATCHED")) {
                        String tf;
                        if (!scan.hasNext()) {
                            System.out.print(String.valueOf(paramFile) + ": expected true or false,");
                            System.out.println(" got end of file");
                            System.exit(1);
                        }
                        if ((tf = scan.next()).equals("true")) {
                            element.setWatched(true);
                            continue;
                        }
                        if (tf.equals("false")) {
                            element.setWatched(false);
                            continue;
                        }
                        System.out.print(String.valueOf(paramFile) + ": expected true or false,");
                        System.out.println(" got \"" + tf + "\"");
                        System.exit(1);
                        continue;
                    }
                    if (prop.equals("PROPDELAY")) {
                        int delay;
                        if (!scan.hasNext()) {
                            System.out.print(String.valueOf(paramFile) + ": expected prop delay value,");
                            System.out.println(" got end of file");
                            System.exit(1);
                        }
                        if (!scan.hasNextInt()) {
                            System.out.print(String.valueOf(paramFile) + ": expected prop delay value,");
                            System.out.println(" got \"" + scan.next() + "\"");
                            System.exit(1);
                        }
                        if ((delay = scan.nextInt()) < 1) {
                            System.out.print(String.valueOf(paramFile) + ": expected prop delay > 0,");
                            System.out.println(" got \"" + delay + "\"");
                            System.exit(1);
                        }
                        element.setDelay(delay);
                        continue;
                    }
                    if (prop.equals("INITIALLY")) {
                        if (!(element instanceof Register)) {
                            System.out.println(String.valueOf(name) + " is not a Register element");
                            System.exit(1);
                        }
                        if (!scan.hasNextBigInteger()) {
                            System.out.print(String.valueOf(paramFile) + ": expected initial value,");
                            System.out.println(" got end of file");
                            System.exit(1);
                        }
                        BigInteger init = scan.nextBigInteger();
                        Register reg = (Register)element;
                        reg.setInitialValue(init);
                        continue;
                    }
                    if (prop.equals("FILENAME")) {
                        if (!(element instanceof Memory)) {
                            System.out.println(String.valueOf(name) + " is not a Memory element");
                            System.exit(1);
                        }
                        if (!scan.hasNext()) {
                            System.out.print(String.valueOf(paramFile) + ": expected memory file name,");
                            System.out.println(" got end of file");
                            System.exit(1);
                        }
                        String file = scan.next();
                        Memory mem = (Memory)element;
                        mem.setMemFile(file);
                        continue;
                    }
                    System.out.print(String.valueOf(paramFile) + ": expected element property,");
                    System.out.println(" got \"" + prop + "\"");
                    System.exit(1);
                    continue;
                }
                if (key.equals("CLEAR")) {
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected WATCHES or PROBES,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    if (!(word = scan.next()).equals("WATCHES") && !word.equals("PROBES")) {
                        System.out.print(String.valueOf(paramFile) + ": expected WATCHES or PROBES,");
                        System.out.println(" got \"" + word + "\"");
                        System.exit(1);
                    }
                    if (word.equals("WATCHES")) {
                        circuit.clearAllWatches();
                        continue;
                    }
                    circuit.removeAllProbes();
                    continue;
                }
                if (key.equals("RESET")) {
                    if (!scan.hasNext()) {
                        System.out.print(String.valueOf(paramFile) + ": expected PROPDELAYS,");
                        System.out.println(" got end of file");
                        System.exit(1);
                    }
                    if ((word = scan.next()).equals("PROPDELAYS")) {
                        circuit.resetAllDelays();
                        continue;
                    }
                    System.out.print(String.valueOf(paramFile) + ": expected PROPDELAYS,");
                    System.out.println(" got " + word);
                    System.exit(1);
                    continue;
                }
                System.out.println(String.valueOf(paramFile) + ": invalid command [" + key + "]");
                System.exit(1);
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println("warning: can't open parameter file " + paramFile + ", file ignored");
        }
        catch (InputMismatchException inputMismatchException) {
            // empty catch block
        }
    }

    public static void setPropDelays(Circuit circ, Class<?> cl, int delay) {
        for (Element el : circ.getElements()) {
            if (el instanceof SubCircuit) {
                SubCircuit sub = (SubCircuit)el;
                Circuit c = sub.getSubCircuit();
                JLSStart.setPropDelays(c, cl, delay);
                continue;
            }
            if (el.getClass() != cl) continue;
            LogicElement lel = (LogicElement)el;
            lel.setDelay(delay);
        }
    }

    private static void printCirc(boolean justTop) {
        String name = startFile.replaceAll("\\.jls$", "");
        InputStream in = null;
        try {
            FileInputStream temp = new FileInputStream(startFile);
            ZipInputStream inz = new ZipInputStream(temp);
            if (inz.getNextEntry() == null) {
                temp.close();
                in = new FileInputStream(startFile);
            } else {
                in = inz;
            }
        }
        catch (IOException ex) {
            System.out.println("Can't read circuit file: " + startFile);
            System.exit(1);
        }
        Scanner input = new Scanner(in);
        Circuit circ = new Circuit(name);
        boolean loadOK = circ.load(input);
        if (input.hasNext()) {
            loadOK = false;
        }
        input.close();
        if (!loadOK) {
            System.out.println(String.valueOf(startFile) + " is not a valid circuit file");
            return;
        }
        circ.finishLoad(null);
        PrinterJob job = PrinterJob.getPrinterJob();
        PrintService[] services = PrinterJob.lookupPrintServices();
        PrintService want = null;
        PrintService[] printServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService s = printServiceArray[n2];
            if (s.getName().equals(printer)) {
                want = s;
            }
            ++n2;
        }
        if (want == null) {
            System.out.println(String.valueOf(printer) + " is an invalid printer");
            System.exit(1);
        }
        try {
            job.setPrintService(want);
        }
        catch (PrinterException ex) {
            System.out.println(String.valueOf(printer) + " is an invalid printer");
        }
        PageFormat format = job.defaultPage();
        format.setOrientation(0);
        Book book = new Book();
        if (justTop) {
            book.append(circ, format);
        } else {
            circ.addToBook(book, format);
        }
        job.setPageable(book);
        try {
            job.print();
        }
        catch (PrinterException ex) {
            System.out.println("printing error: " + ex.getMessage());
        }
    }

    public void exportImage() {
        Editor ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(System.getProperty("user.dir"));
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".jpg") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "JLS Circuit Images";
            }
        };
        chooser.setFileFilter(filter);
        if (chooser.showSaveDialog(this) != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getName().trim();
        if (fileName == null || fileName.equals("")) {
            return;
        }
        String tempName = fileName.replaceAll("\\.jpg$", "");
        if (!Util.isValidName(tempName)) {
            JOptionPane.showMessageDialog(JLSInfo.frame, "Invalid file name - must contain only letters, digits & _");
            return;
        }
        if (!fileName.endsWith(".jpg")) {
            fileName = String.valueOf(fileName) + ".jpg";
        }
        fileName = chooser.getCurrentDirectory() + "/" + fileName;
        Circuit circ = ed.getCircuit();
        circ.exportImage(fileName);
    }

    public static Vector<String> parseName(String name) {
        Vector<String> comp = new Vector<String>();
        int first = 0;
        int p = 0;
        while (p < name.length()) {
            if (name.charAt(p) == '.') {
                String component = name.substring(first, p);
                if (!Util.isValidName(component)) {
                    return null;
                }
                if (component.equals("")) {
                    return null;
                }
                comp.add(component);
                first = p + 1;
            }
            ++p;
        }
        if (name.charAt(name.length() - 1) == '.') {
            return null;
        }
        String component = name.substring(first, name.length());
        if (!Util.isValidName(component)) {
            return null;
        }
        comp.add(component);
        return comp;
    }
}

