/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.About;
import edu.mtu.cs.jls.Circuit;
import edu.mtu.cs.jls.JLSInfo;
import edu.mtu.cs.jls.Tutorial;
import edu.mtu.cs.jls.edit.Editor;
import edu.mtu.cs.jls.elem.SubCircuit;
import edu.mtu.cs.jls.sim.InterractiveSimulator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.swing.Box;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class JLSApplet
extends JApplet
implements ActionListener,
ChangeListener {
    private JMenuItem newc = new JMenuItem("New");
    private JMenuItem open = new JMenuItem("Open");
    private JMenuItem save = new JMenuItem("Save");
    private JMenuItem saveAs = new JMenuItem("Save As");
    private JMenuItem print = new JMenuItem("Print");
    private JMenuItem imp = new JMenuItem("Import");
    private JMenuItem exp = new JMenuItem("Export Image");
    private JMenuItem close = new JMenuItem("Close");
    private JMenuItem exit = new JMenuItem("Exit");
    private JSplitPane both;
    private JTabbedPane edits;
    private Circuit clipboard = new Circuit("clipboard");
    private InterractiveSimulator sim;

    @Override
    public void init() {
        JLSInfo.isApplet = true;
        JMenuBar bar = new JMenuBar();
        bar.add(this.fileMenu());
        bar.add(this.simMenu());
        bar.add(this.globalMenu());
        bar.add(Box.createHorizontalGlue());
        bar.add(this.helpMenu());
        this.setJMenuBar(bar);
        Container window = this.getContentPane();
        window.setLayout(new BorderLayout());
        this.both = new JSplitPane(0, true);
        this.both.setResizeWeight(1.0);
        this.edits = new JTabbedPane(1, 1);
        this.edits.setMinimumSize(new Dimension(100, 100));
        this.both.setTopComponent(this.edits);
        window.add((Component)this.both, "Center");
        this.edits.addChangeListener(this);
        this.sim = new InterractiveSimulator();
        JLSInfo.sim = this.sim;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.newc) {
            String name = JOptionPane.showInputDialog(this, (Object)"Circuit name?");
            if (name == null || name.equals("")) {
                return;
            }
            int e = 0;
            while (e < this.edits.getTabCount()) {
                if (name.equals(this.edits.getTitleAt(e))) {
                    JOptionPane.showMessageDialog(this, String.valueOf(name) + " is already being editted", "Error", 0);
                    return;
                }
                ++e;
            }
            Circuit circ = new Circuit(name);
            this.setupEditor(circ, name);
        } else if (event.getSource() == this.open) {
            String name = JOptionPane.showInputDialog(this, (Object)"Circuit URL?");
            if (name == null || name.equals("")) {
                return;
            }
        } else if (event.getSource() == this.close) {
            this.edits.remove(this.edits.getSelectedComponent());
        } else {
            JOptionPane.showMessageDialog(this, "Not implemented in applet version.", "Error", 0);
        }
    }

    public void setupEditor(Circuit circ, String name) {
        Editor ed = new Editor(this.edits, circ, name, this.clipboard);
        circ.setEditor(ed);
        Component[] componentArray = this.edits.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Editor otherEditor;
            Component edit = componentArray[n2];
            if (edit instanceof Editor && !(otherEditor = (Editor)edit).getCircuit().isImported()) {
                otherEditor.addToImportMenu(circ);
                ed.addToImportMenu(otherEditor.getCircuit());
            }
            ++n2;
        }
        this.edits.add(ed);
        this.edits.setSelectedComponent(ed);
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Editor ed = (Editor)this.edits.getSelectedComponent();
        if (ed == null) {
            this.sim.setCircuit(null);
            this.both.remove(this.sim.getWindow());
            return;
        }
        Circuit circ = ed.getCircuit();
        while (circ.isImported()) {
            SubCircuit sub = circ.getSubElement();
            circ = sub.getCircuit();
        }
        this.sim.setCircuit(circ);
    }

    public JMenu fileMenu() {
        JMenu file = new JMenu("File");
        file.add(this.newc);
        this.newc.setToolTipText("create new circuit");
        this.newc.addActionListener(this);
        file.add(this.open);
        this.open.setToolTipText("not implemented");
        this.open.setForeground(Color.lightGray);
        this.open.addActionListener(this);
        file.add(this.save);
        this.save.setToolTipText("not implemented");
        this.save.setForeground(Color.lightGray);
        this.save.addActionListener(this);
        file.add(this.saveAs);
        this.saveAs.setToolTipText("not implemented");
        this.saveAs.setForeground(Color.lightGray);
        this.saveAs.addActionListener(this);
        file.add(this.print);
        this.print.setToolTipText("not implemented");
        this.print.setForeground(Color.lightGray);
        this.print.addActionListener(this);
        file.add(this.imp);
        this.imp.setToolTipText("not implemented");
        this.imp.setForeground(Color.lightGray);
        this.imp.addActionListener(this);
        file.add(this.exp);
        this.exp.setToolTipText("not implemented");
        this.exp.setForeground(Color.lightGray);
        this.exp.addActionListener(this);
        file.add(this.close);
        this.close.setToolTipText("close visible circuit");
        this.close.addActionListener(this);
        file.add(this.exit);
        this.exit.setToolTipText("not implemented");
        this.exit.setForeground(Color.lightGray);
        this.exit.addActionListener(this);
        return file;
    }

    public JMenu simMenu() {
        JMenu menu = new JMenu("Simulator");
        JMenuItem show = new JMenuItem("Show Simulator Window");
        show.setToolTipText("make simulator window appear");
        menu.add(show);
        JMenuItem hide = new JMenuItem("Hide Simulator Window");
        hide.setToolTipText("make simulator window disappear");
        menu.add(hide);
        JMenuItem run = new JMenuItem("Run (in background)");
        run.setToolTipText("run simulator");
        run.setAccelerator(KeyStroke.getKeyStroke("F5"));
        menu.add(run);
        JMenuItem stop = new JMenuItem("Stop (background simulator)");
        run.setToolTipText("stop simulator");
        stop.setAccelerator(KeyStroke.getKeyStroke("F7"));
        menu.add(stop);
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSApplet.this.both.setBottomComponent(JLSApplet.this.sim.getStatusBar());
                JLSInfo.batch = true;
                JLSApplet.this.sim.runSim();
                JLSInfo.batch = false;
            }
        });
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSApplet.this.sim.stop();
            }
        });
        show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSApplet.this.both.setBottomComponent(JLSApplet.this.sim.getWindow());
            }
        });
        hide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JLSApplet.this.both.remove(JLSApplet.this.sim.getWindow());
            }
        });
        return menu;
    }

    public JMenu globalMenu() {
        JMenu menu = new JMenu("Global");
        JMenuItem resetDelays = new JMenuItem("Reset all propagation delays");
        menu.add(resetDelays);
        resetDelays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSApplet.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.getCircuit().resetAllDelays();
                    ed.repaint();
                }
            }
        });
        JMenuItem removeProbes = new JMenuItem("Remove all probes");
        menu.add(removeProbes);
        removeProbes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSApplet.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.getCircuit().removeAllProbes();
                    ed.repaint();
                }
            }
        });
        JMenuItem clearWatches = new JMenuItem("Unwatch all elements");
        menu.add(clearWatches);
        clearWatches.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSApplet.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.getCircuit().clearAllWatches();
                    ed.repaint();
                }
            }
        });
        JMenuItem expand = new JMenuItem("Expand circuit drawing area");
        menu.add(expand);
        expand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Editor ed = (Editor)JLSApplet.this.edits.getSelectedComponent();
                if (ed != null) {
                    ed.increaseSize();
                }
            }
        });
        return menu;
    }

    public JMenu helpMenu() {
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem("About");
        help.add(about);
        about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new About();
            }
        });
        JMenu tutorial = new JMenu("Tutorial");
        help.add(tutorial);
        JMenuItem tutorial1 = new JMenuItem("Introduction");
        String tip1 = "<html>This tutorial demonstrates the basic drawing capabilities<br>using simple gates and wires, and how to use the simulator&nbsp;&nbsp;<br>to watch the circuit in action.</html>";
        tutorial1.setToolTipText(tip1);
        tutorial.add(tutorial1);
        tutorial1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial1.html", false);
            }
        });
        JMenuItem tutorial2 = new JMenuItem("4-Bit Counter");
        String tip2 = "<html>This demonstrates the use of more complex&nbsp;&nbsp;<br>elements and multi-wire connections.</html>";
        tutorial2.setToolTipText(tip2);
        tutorial.add(tutorial2);
        tutorial2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial2.html", false);
            }
        });
        JMenuItem tutorial3 = new JMenuItem("Full Adder");
        String tip3 = "<html>This demonstrates how to define and use subcircuits.";
        tutorial3.setToolTipText(tip3);
        tutorial.add(tutorial3);
        tutorial3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial3.html", false);
            }
        });
        JMenuItem tutorial4 = new JMenuItem("Sign Extension");
        String tip4 = "<html>This demonstrates how to bundle/unbundle&nbsp;&nbsp;<br>and to use the signal copy element.";
        tutorial4.setToolTipText(tip4);
        tutorial.add(tutorial4);
        tutorial4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                new Tutorial(JLSInfo.frame, "tutorial4.html", false);
            }
        });
        String helpHS = "help/JLSHelp.hs";
        ClassLoader cl = JLSApplet.class.getClassLoader();
        HelpSet mainHS = null;
        try {
            URL url = HelpSet.findHelpSet(cl, helpHS);
            mainHS = new HelpSet(cl, url);
        }
        catch (Exception ex) {
            System.out.println("Help problem: " + ex.getMessage());
            return help;
        }
        JLSInfo.hb = mainHS.createHelpBroker();
        JMenuItem contents = new JMenuItem("Contents");
        help.add(contents);
        contents.addActionListener(new CSH.DisplayHelpFromSource(JLSInfo.hb));
        return help;
    }
}

