/*
 * Decompiled with CFR 0.152.
 */
package edu.mtu.cs.jls;

import edu.mtu.cs.jls.DefaultExceptionHandler;
import edu.mtu.cs.jls.Eula;
import edu.mtu.cs.jls.JLSStart;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JLS {
    public static void main(String[] args) {
        DefaultExceptionHandler exHandler = new DefaultExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(exHandler);
        JLSStart.parseCommandLine(args);
        if (!Eula.accepted()) {
            System.exit(1);
        }
        String fsep = System.getProperty("file.separator");
        String d = System.getProperty("java.class.path");
        String psep = System.getProperty("path.separator");
        Vector<String> paths = new Vector<String>();
        int from = 0;
        int pos = d.indexOf(psep, from);
        while (pos != -1) {
            paths.add(d.substring(from, pos));
            from = pos + 1;
            pos = d.indexOf(psep, from);
        }
        paths.add(d.substring(from));
        String base = "." + fsep;
        boolean jlsFound = false;
        for (String p : paths) {
            if (p.equals("JLS.jar")) {
                jlsFound = true;
                break;
            }
            if (!p.endsWith("/JLS.jar") && !p.endsWith("\\JLS.jar")) continue;
            base = p.replace("JLS.jar", "");
            base = fsep.equals("/") ? base.replaceAll("\\\\", "/") : base.replaceAll("/", "\\\\");
            jlsFound = true;
            break;
        }
        if (!jlsFound) {
            JLSStart.start(args, exHandler);
            return;
        }
        File dirFile = new File(base);
        String urlName = null;
        String cl = null;
        String[] stringArray = dirFile.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String fullEntry = String.valueOf(base) + entry;
            if (entry.endsWith(".xml") && new File(fullEntry).isFile()) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                Document doc = null;
                try {
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    doc = db.parse(entry);
                }
                catch (Exception ex) {
                    System.out.println(ex);
                    System.exit(1);
                }
                Element docEle = doc.getDocumentElement();
                String author = JLS.get(docEle, "Author");
                String affil = JLS.get(docEle, "Affiliation");
                String contact = JLS.get(docEle, "ContactInfo");
                cl = JLS.get(docEle, "Class");
                if (author == null || affil == null || contact == null || cl == null) break;
                cl = cl.trim();
                String jar = String.valueOf(fullEntry.replaceFirst("\\.xml$", "")) + ".jar";
                if (new File(jar).exists()) {
                    urlName = new File(jar).getAbsolutePath();
                    break;
                }
                urlName = String.valueOf(new File(base).getAbsolutePath()) + "/";
                break;
            }
            ++n2;
        }
        if (urlName == null) {
            JLSStart.start(args, exHandler);
        } else {
            try {
                Method[] methods;
                URL[] url = new URL[]{new URL("file:" + urlName)};
                Class<?> c = new URLClassLoader(url).loadClass(cl);
                Method[] methodArray = methods = c.getMethods();
                int n3 = methods.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method m = methodArray[n4];
                    if (m.getName().equals("config")) {
                        m.invoke(null, args, exHandler);
                        break;
                    }
                    ++n4;
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
                System.exit(1);
            }
        }
    }

    private static String get(Element docEle, String name) {
        NodeList nl = docEle.getElementsByTagName(name);
        if (nl != null && nl.getLength() == 1) {
            return ((Element)nl.item(0)).getTextContent();
        }
        return null;
    }
}

